/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.inspector.types;

import com.mathworks.util.DebugUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;

public final class ColorArray {
    private final List<Color> colors = new ArrayList<Color>();

    private ColorArray() {
    }

    public ColorArray(List<Color> list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument colors must not be null");
        }
        for (Color color : list) {
            if (color != null) {
                this.colors.add(color);
                continue;
            }
            throw new IllegalArgumentException("Color array element must not be null");
        }
    }

    public ColorArray(ColorArray colorArray) {
        this(colorArray.colors);
    }

    public List<Color> getColors() {
        return Collections.unmodifiableList(this.colors);
    }

    private static ColorArray newInstance(Color[] colorArray) {
        if (colorArray == null || colorArray.length == 0) {
            return new ColorArray();
        }
        ArrayList<Color> arrayList = new ArrayList<Color>();
        for (int i = 0; i < colorArray.length; ++i) {
            Color color = colorArray[i];
            if (color == null) {
                assert (DebugUtils.warning((String)("One of the color array components is null: " + i)));
                continue;
            }
            arrayList.add(color);
        }
        return new ColorArray(arrayList);
    }

    private Color[] getColorArray() {
        if (this.colors.isEmpty()) {
            return new Color[0];
        }
        Color[] colorArray = new Color[this.colors.size()];
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray[i] = this.colors.get(i);
        }
        return colorArray;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ColorArray)) {
            return false;
        }
        ColorArray colorArray = (ColorArray)object;
        return this.colors.equals(colorArray.colors);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

