/*
 * Decompiled with CFR 0.152.
 */
package org.openxml4j.document.wordprocessing;

import java.util.ArrayList;
import java.util.List;
import org.openxml4j.document.wordprocessing.Paragraph;
import org.openxml4j.document.wordprocessing.ParagraphAlignment;
import org.openxml4j.document.wordprocessing.ParagraphReadOnlyManager;
import org.openxml4j.document.wordprocessing.ParagraphSpacing;
import org.openxml4j.document.wordprocessing.ParagraphSpacingPredefined;
import org.openxml4j.document.wordprocessing.UnderlineStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParagraphBuilder {
    private static final int DEFAULT_FONT_SIZE = 22;
    public static final int PARAGRAPH_NUMBERING_NONE = -1;
    public static final String DEFAULT_PARAGRAPH_STYLE = "Normal";
    protected ParagraphAlignment alignment = ParagraphAlignment.LEFT;
    protected boolean allowEditionInReadOnlyDoc = false;
    protected boolean bold = false;
    protected boolean italic = false;
    protected UnderlineStyle underline = UnderlineStyle.NONE;
    protected int fontSize = 22;
    protected int paragraphRefInNumberingXml = -1;
    protected int paragraphNumberShift;
    protected String paragraphStyleName = "Normal";
    protected ParagraphSpacing spacing = new ParagraphSpacing();

    public int getParagraphNumberShift() {
        return this.paragraphNumberShift;
    }

    public void setParagraphNumberShift(int paragraphNumberShift) {
        this.paragraphNumberShift = paragraphNumberShift;
    }

    public int getParagraphRefInNumberingXml() {
        return this.paragraphRefInNumberingXml;
    }

    public void setParagraphRefInNumberingXml(int paragraphRefInNumberingXml) {
        this.paragraphRefInNumberingXml = paragraphRefInNumberingXml;
    }

    public ParagraphAlignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(ParagraphAlignment alignment) {
        this.alignment = alignment;
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public UnderlineStyle isUnderline() {
        return this.underline;
    }

    public void setUnderline(UnderlineStyle underline) {
        this.underline = underline;
    }

    public void setSpacing(ParagraphSpacing spacing) {
        this.spacing = spacing;
    }

    public void setSpacing(ParagraphSpacingPredefined spacing) {
        this.spacing = new ParagraphSpacing(spacing);
    }

    public Paragraph newParagraph() {
        Paragraph retPar = new Paragraph();
        retPar.setAlignment(this.alignment);
        retPar.setBold(this.bold);
        retPar.setItalic(this.italic);
        retPar.setUnderline(this.underline);
        retPar.setFontSize(this.fontSize);
        retPar.setParagraphNumberShift(this.paragraphNumberShift);
        retPar.setParagraphRefInNumberingXml(this.paragraphRefInNumberingXml);
        retPar.setSpacing(this.spacing);
        retPar.setParagraphStyleName(this.paragraphStyleName);
        if (this.allowEditionInReadOnlyDoc) {
            retPar.setReadOnlyPermission(new ParagraphReadOnlyManager());
        }
        return retPar;
    }

    public List<Paragraph> newParagraphs(String text) {
        ArrayList<Paragraph> listPara = new ArrayList<Paragraph>();
        if (text == null) {
            return listPara;
        }
        String[] str = text.split("\n");
        for (int i = 0; i < str.length; ++i) {
            Paragraph para = this.newParagraph();
            para.addTextAsRunWithParagraphSetting(str[i]);
            listPara.add(para);
        }
        return listPara;
    }

    public boolean isAllowEditionInReadOnlyDoc() {
        return this.allowEditionInReadOnlyDoc;
    }

    public void setAllowEditionInReadOnlyDoc(boolean allowEditionInReadOnlyDoc) {
        this.allowEditionInReadOnlyDoc = allowEditionInReadOnlyDoc;
    }

    public String getParagraphStyleName() {
        return this.paragraphStyleName;
    }

    public void setParagraphStyleName(String paragraphStyleName) {
        this.paragraphStyleName = paragraphStyleName;
    }
}

