/*
 * Decompiled with CFR 0.152.
 */
package org.openxml4j.document.wordprocessing.model.table;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.QName;
import org.openxml4j.document.wordprocessing.ParagraphAlignment;
import org.openxml4j.document.wordprocessing.WordDocument;
import org.openxml4j.document.wordprocessing.model.table.CellWidth;
import org.openxml4j.document.wordprocessing.model.table.TableCell;
import org.openxml4j.exceptions.OpenXML4JException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableLine {
    private static Logger logger = Logger.getLogger((String)"org.openxml4j");
    protected List<TableCell> cells;

    public TableLine(List<String> listOfCells, ParagraphAlignment alignment) {
        this.cells = new ArrayList<TableCell>();
        for (String cellElement : listOfCells) {
            this.cells.add(new TableCell(cellElement, alignment));
        }
    }

    public TableLine() {
        this.cells = null;
    }

    public void createLine(List<CellWidth> listOfCells) {
        if (this.cells != null) {
            logger.warn((Object)"erasing the contents of a line");
        }
        this.cells = new ArrayList<TableCell>();
        for (CellWidth cellWidth : listOfCells) {
            this.cells.add(new TableCell(cellWidth));
        }
    }

    public void setBackgroundColor(String color) {
        for (TableCell cellElement : this.cells) {
            cellElement.setCellBackgroundColor(color);
        }
    }

    public void setBold() {
        for (TableCell cellElement : this.cells) {
            cellElement.setBold(true);
        }
    }

    public void setAlignment(ParagraphAlignment alignment) {
        for (TableCell cellElement : this.cells) {
            cellElement.setAlignment(alignment);
        }
    }

    public Element build() {
        DocumentFactory factory = DocumentFactory.getInstance();
        Element lineAsXml = factory.createElement(new QName("tr", WordDocument.namespaceWord));
        for (TableCell element : this.cells) {
            lineAsXml.add(element.build());
        }
        return lineAsXml;
    }

    public TableCell getCell(int col) throws OpenXML4JException {
        if (col >= this.cells.size()) {
            String msg = "col should be <" + this.cells.size() + " col=" + col;
            logger.error((Object)msg);
            throw new OpenXML4JException(msg);
        }
        return this.cells.get(col);
    }
}

