/*
 * Decompiled with CFR 0.152.
 */
package org.openxml4j.opc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.openxml4j.exceptions.InvalidFormatException;
import org.openxml4j.exceptions.InvalidOperationException;
import org.openxml4j.exceptions.OpenXML4JException;
import org.openxml4j.opc.Package;
import org.openxml4j.opc.PackageAccess;
import org.openxml4j.opc.PackagePart;
import org.openxml4j.opc.PackagePartCollection;
import org.openxml4j.opc.PackagePartName;
import org.openxml4j.opc.PackagingURIHelper;
import org.openxml4j.opc.TargetMode;
import org.openxml4j.opc.ZipPackagePart;
import org.openxml4j.opc.internal.FileHelper;
import org.openxml4j.opc.internal.MemoryPackagePart;
import org.openxml4j.opc.internal.PartMarshaller;
import org.openxml4j.opc.internal.ZipContentTypeManager;
import org.openxml4j.opc.internal.ZipHelper;
import org.openxml4j.opc.internal.marshallers.ZipPackagePropertiesMarshaller;
import org.openxml4j.opc.internal.marshallers.ZipPartMarshaller;
import org.openxml4j.util.ZipEntrySource;
import org.openxml4j.util.ZipFileZipEntrySource;
import org.openxml4j.util.ZipInputStreamZipEntrySource;

public final class ZipPackage
extends Package {
    private static Logger logger = Logger.getLogger((String)"org.openxml4j");
    private final ZipEntrySource zipArchive;

    public ZipPackage() {
        super(defaultPackageAccess);
        this.zipArchive = null;
    }

    ZipPackage(InputStream in, PackageAccess access) throws IOException {
        super(access);
        this.zipArchive = new ZipInputStreamZipEntrySource(new ZipInputStream(in));
    }

    ZipPackage(String path, PackageAccess access) throws InvalidFormatException {
        super(access);
        ZipFile zipFile = ZipHelper.openZipFile(path);
        if (zipFile == null) {
            throw new InvalidOperationException("Can't open the specified file: '" + path + "'");
        }
        this.zipArchive = new ZipFileZipEntrySource(zipFile);
    }

    protected PackagePart[] getPartsImpl() throws InvalidFormatException {
        String contentType;
        PackagePartName partName;
        ZipEntry entry;
        if (this.partList == null) {
            this.partList = new PackagePartCollection();
        }
        if (this.zipArchive == null) {
            return this.partList.values().toArray(new PackagePart[this.partList.values().size()]);
        }
        Enumeration<? extends ZipEntry> entries = this.zipArchive.getEntries();
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            if (!entry.getName().equals("[Content_Types].xml")) continue;
            try {
                this.contentTypeManager = new ZipContentTypeManager(this.getZipArchive().getInputStream(entry), this);
                break;
            }
            catch (IOException e) {
                throw new InvalidFormatException(e.getMessage());
            }
        }
        if (this.contentTypeManager == null) {
            throw new InvalidFormatException("Package should contain a content type part [M1.13]");
        }
        entries = this.zipArchive.getEntries();
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            partName = this.buildPartName(entry);
            if (partName == null || (contentType = this.contentTypeManager.getContentType(partName)) == null || !contentType.equals("application/vnd.openxmlformats-package.relationships+xml")) continue;
            try {
                this.partList.put(partName, new ZipPackagePart((Package)this, entry, partName, contentType));
            }
            catch (InvalidOperationException e) {
                throw new InvalidFormatException(e.getMessage());
            }
        }
        entries = this.zipArchive.getEntries();
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            partName = this.buildPartName(entry);
            if (partName == null || (contentType = this.contentTypeManager.getContentType(partName)) != null && contentType.equals("application/vnd.openxmlformats-package.relationships+xml")) continue;
            if (contentType != null) {
                try {
                    this.partList.put(partName, new ZipPackagePart((Package)this, entry, partName, contentType));
                    continue;
                }
                catch (InvalidOperationException e) {
                    throw new InvalidFormatException(e.getMessage());
                }
            }
            throw new InvalidFormatException("The part " + partName.getURI().getPath() + " does not have any content type ! Rule: Package require content types when retrieving a part from a package. [M.1.14]");
        }
        return this.partList.values().toArray(new ZipPackagePart[this.partList.size()]);
    }

    private PackagePartName buildPartName(ZipEntry entry) {
        try {
            if (entry.getName().equals("[Content_Types].xml")) {
                return null;
            }
            return PackagingURIHelper.createPartName(ZipHelper.getOPCNameFromZipItemName(entry.getName()));
        }
        catch (Exception e) {
            logger.warn((Object)("Entry " + entry.getName() + " is not valid, so this part won't be add to the package."));
            return null;
        }
    }

    protected PackagePart createPartImpl(PackagePartName partName, String contentType, boolean loadRelationships) {
        if (contentType == null) {
            throw new IllegalArgumentException("contentType");
        }
        if (partName == null) {
            throw new IllegalArgumentException("partName");
        }
        try {
            return new MemoryPackagePart((Package)this, partName, contentType, loadRelationships);
        }
        catch (InvalidFormatException e) {
            return null;
        }
    }

    protected void removePartImpl(PackagePartName partName) {
        if (partName == null) {
            throw new IllegalArgumentException("partUri");
        }
    }

    protected void flushImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeImpl() throws IOException {
        this.flush();
        if (this.originalPackagePath != null && !"".equals(this.originalPackagePath)) {
            File targetFile = new File(this.originalPackagePath);
            if (targetFile.exists()) {
                File tempFile = File.createTempFile(this.generateTempFileName(FileHelper.getDirectory(targetFile)), ".tmp");
                try {
                    this.save(tempFile);
                    this.zipArchive.close();
                    FileHelper.copyFile(tempFile, targetFile);
                }
                finally {
                    if (!tempFile.delete()) {
                        logger.warn((Object)("The temporary file: '" + targetFile.getAbsolutePath() + "' cannot be deleted ! Make sure that no other application use it."));
                    }
                }
            } else {
                throw new InvalidOperationException("Can't close a package not previously open with the open() method !");
            }
        }
    }

    private synchronized String generateTempFileName(File directory) {
        File tmpFilename;
        while ((tmpFilename = new File(directory.getAbsoluteFile() + File.separator + "OpenXML4J" + System.nanoTime())).exists()) {
        }
        return FileHelper.getFilename(tmpFilename.getAbsoluteFile());
    }

    protected void revertImpl() {
        try {
            if (this.zipArchive != null) {
                this.zipArchive.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected PackagePart getPartImpl(PackagePartName partName) {
        if (this.partList.containsKey(partName)) {
            return (PackagePart)this.partList.get(partName);
        }
        return null;
    }

    public void saveImpl(OutputStream outputStream) {
        this.throwExceptionIfReadOnly();
        ZipOutputStream zos = null;
        try {
            zos = !(outputStream instanceof ZipOutputStream) ? new ZipOutputStream(outputStream) : (ZipOutputStream)outputStream;
            if (this.getPartsByRelationshipType("http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties").size() == 0) {
                logger.debug((Object)"Save core properties part");
                new ZipPackagePropertiesMarshaller().marshall(this.packageProperties, zos);
                this.relationships.addRelationship(this.packageProperties.getPartName().getURI(), TargetMode.INTERNAL, "http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties", null);
                if (!this.contentTypeManager.isContentTypeRegister("application/vnd.openxmlformats-package.core-properties+xml")) {
                    this.contentTypeManager.addContentType(this.packageProperties.getPartName(), "application/vnd.openxmlformats-package.core-properties+xml");
                }
            }
            logger.debug((Object)"Save package relationships");
            ZipPartMarshaller.marshallRelationshipPart(this.getRelationships(), PackagingURIHelper.PACKAGE_RELATIONSHIPS_ROOT_PART_NAME, zos);
            logger.debug((Object)"Save content types part");
            this.contentTypeManager.save(zos);
            for (PackagePart part : this.getParts()) {
                if (part.isRelationshipPart()) continue;
                logger.debug((Object)("Save part '" + ZipHelper.getZipItemNameFromOPCName(part.getPartName().getName()) + "'"));
                PartMarshaller marshaller = (PartMarshaller)this.partMarshallers.get(part.contentType);
                if (marshaller != null) {
                    if (marshaller.marshall(part, zos)) continue;
                    throw new OpenXML4JException("The part " + part.getPartName().getURI() + " fail to be saved in the stream with marshaller " + marshaller);
                }
                if (this.defaultPartMarshaller.marshall(part, zos)) continue;
                throw new OpenXML4JException("The part " + part.getPartName().getURI() + " fail to be saved in the stream with marshaller " + this.defaultPartMarshaller);
            }
            zos.close();
        }
        catch (Exception e) {
            logger.error((Object)("Fail to save: an error occurs while saving the package : " + e.getMessage()));
        }
    }

    public ZipEntrySource getZipArchive() {
        return this.zipArchive;
    }
}

