/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.debug.Debug;
import ice.net.HttpMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLConnection;

public class HttpRequest
extends HttpMessage
implements Cloneable,
Serializable {
    public static final String CONNECT = "CONNECT";
    public static final String DELETE = "DELETE";
    public static final String GET = "GET";
    public static final String HEAD = "HEAD";
    public static final String OPTIONS = "OPTIONS";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String TRACE = "TRACE";
    public static final String ACCEPT = "Accept";
    public static final String ACCEPT_CHARSET = "Accept-Charset";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    public static final String AUTHORIZATION = "Authorization";
    public static final String EXPECT = "Expect";
    public static final String FROM = "From";
    public static final String HOST = "Host";
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String IF_MATCH = "If-Match";
    public static final String IF_NONE_MATCH = "If-None-Match";
    public static final String IF_RANGE = "If-Range";
    public static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    public static final String MAX_FORWARDS = "Max-Forwards";
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String RANGE = "Range";
    public static final String REFERER = "Referer";
    public static final String TE = "TE";
    public static final String USER_AGENT = "User-Agent";
    public static final String COOKIE = "Cookie";
    public static final String COOKIE2 = "Cookie2";
    public static final String NO_CACHE = "no-cache";
    public static final String NO_STORE = "no-store";
    public static final String MAX_AGE = "max-age";
    public static final String MAX_STALE = "max-stale";
    public static final String MIN_FRESH = "min-fresh";
    public static final String NO_TRANSFORM = "no-transform";
    public static final String ONLY_IF_CACHED = "only-if-cached";
    private String method;
    private String requestUri;

    public HttpRequest(String string, String string2, String string3) throws IllegalArgumentException {
        super(string3);
        this.setMethod(string);
        this.setRequestUri(string2);
    }

    public Object clone() {
        HttpRequest httpRequest = (HttpRequest)super.clone();
        return httpRequest;
    }

    public boolean equals(Object object) {
        return object instanceof HttpRequest && ((HttpRequest)object).method.equalsIgnoreCase(this.method) && ((HttpRequest)object).requestUri.equalsIgnoreCase(this.requestUri) && super.equals(object);
    }

    public String getMessage(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getRequestLine() + "\r\n");
        int n = this.headerMap.getSize();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(this.headerMap.getFieldName(n2) + ":" + " " + this.headerMap.getFieldValue(n2) + "\r\n");
            ++n2;
        }
        stringBuffer.append("\r\n");
        if (bl && this.entityBody != null) {
            stringBuffer.append(this.entityBody.toString());
        }
        return stringBuffer.toString();
    }

    public String getMethod() {
        return this.method;
    }

    public String getRequestLine() {
        return this.method + " " + this.requestUri + " " + this.httpVersion;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public void setEntityBody(HttpMessage.EntityBody entityBody) {
        super.setEntityBody(entityBody);
        if (this.entityBody.bytes != null) {
            this.putHeader("Content-Length", Integer.toString(this.entityBody.bytes.length));
        }
        if (!this.containsHeader("Content-Type")) {
            try {
                String string = URLConnection.guessContentTypeFromStream(new ByteArrayInputStream(this.entityBody.bytes));
                if (string != null) {
                    this.putHeader("Content-Type", string);
                }
            }
            catch (IOException iOException) {
                Debug.ex((Throwable)iOException);
            }
        }
    }

    public void setMethod(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("method is null");
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("method is empty");
        }
        this.method = string;
    }

    public void setRequestUri(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("requestUri is null");
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("requestUri is empty");
        }
        this.requestUri = string;
    }

    public String toString() {
        return "HttpRequest [" + this.getRequestLine() + "]";
    }
}

