/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.collection.impl;

import com.mathworks.comparisons.collection.impl.ComparisonCollectionFileImpl;
import com.mathworks.comparisons.collection.impl.NameAsFileComparator;
import com.mathworks.comparisons.source.impl.LocalFileSource;
import com.mathworks.comparisons.source.info.CSPInfoIncludeRelativeFrom;
import com.mathworks.comparisons.source.info.CSPInfoIncludeSubFolders;
import com.mathworks.comparisons.util.ExceptionHandler;
import com.mathworks.comparisons.util.ResourceManager;
import java.io.File;
import java.io.FileNotFoundException;

public class LocalFolderCollection
extends ComparisonCollectionFileImpl {
    public LocalFolderCollection(String string, File file, CSPInfoIncludeSubFolders cSPInfoIncludeSubFolders, CSPInfoIncludeRelativeFrom cSPInfoIncludeRelativeFrom) throws FileNotFoundException, IllegalArgumentException {
        super(string, ResourceManager.getString("collectiontype.localfolder"), file, new NameAsFileComparator());
        this.checkArgument(file);
        boolean bl = cSPInfoIncludeSubFolders.getValue();
        String string2 = cSPInfoIncludeRelativeFrom.getValue();
        File file2 = this.getStartFolder(string2);
        String string3 = string2 == null ? "" : string2;
        this.doLoad(file2, bl, string3);
    }

    private File getStartFolder(String string) throws FileNotFoundException {
        File file;
        if (string != null && string.length() > 0) {
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            file = new File(this.getFile(), string);
        } else {
            file = this.getFile();
        }
        this.checkArgument(file);
        return file;
    }

    private synchronized void doLoad(File file, boolean bl, String string) throws FileNotFoundException {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            try {
                this.addLevel(fileArray, "", bl);
            }
            catch (InterruptedException interruptedException) {
                ExceptionHandler.rethrow(interruptedException);
            }
        } else {
            throw new FileNotFoundException(ResourceManager.format("exception.nofolderlisting", file.getAbsolutePath()));
        }
    }

    private void addLevel(File[] fileArray, String string, boolean bl) throws FileNotFoundException, InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        for (File file : fileArray) {
            Object object;
            String string2 = file.getName();
            if (file.isDirectory() && bl) {
                object = file.listFiles();
                String string3 = string + string2 + '/';
                if (object == null) {
                    String string4 = ResourceManager.format("exception.nofolderlisting", file.getAbsolutePath());
                    System.out.println(string4);
                    this.addSource(new LocalFileSource(file, string3));
                    continue;
                }
                this.addLevel((File[])object, string3, bl);
                continue;
            }
            object = string + string2;
            if (file.isDirectory()) {
                object = (String)object + '/';
            }
            try {
                this.addSource(new LocalFileSource(file, (String)object));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println(fileNotFoundException.getMessage());
            }
        }
    }

    private void checkArgument(File file) throws FileNotFoundException, IllegalArgumentException {
        if (!file.exists()) {
            throw new FileNotFoundException(ResourceManager.format("exception.filenotfound", file.getPath()));
        }
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException(ResourceManager.format("exception.absolutefilename", file.getPath()));
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(ResourceManager.format("exception.notadirectory", file.getPath()));
        }
    }
}

