/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.decorator.htmlreport;

import com.mathworks.comparisons.decorator.PopupMenuProvider;
import com.mathworks.comparisons.decorator.actionid.ActionIDNext;
import com.mathworks.comparisons.decorator.actionid.ActionIDPrevious;
import com.mathworks.comparisons.decorator.actionid.ActionIDRefresh;
import com.mathworks.comparisons.decorator.actionid.ActionIDSaveAs;
import com.mathworks.comparisons.decorator.actionid.ActionIDSwapSides;
import com.mathworks.comparisons.decorator.actionid.ActionIdMerge;
import com.mathworks.comparisons.decorator.actionid.ActionIdRedo;
import com.mathworks.comparisons.decorator.actionid.ActionIdSaveRightFile;
import com.mathworks.comparisons.decorator.actionid.ActionIdSaveRightFileAs;
import com.mathworks.comparisons.decorator.actionid.ActionIdUndoMerge;
import com.mathworks.comparisons.decorator.htmlreport.ComparisonHtmlComponent;
import com.mathworks.comparisons.decorator.htmlreport.HTMLActionManager;
import com.mathworks.comparisons.decorator.htmlreport.HTMLReportDecorator;
import com.mathworks.comparisons.decorator.htmlreport.SaveAsHtmlAction;
import com.mathworks.comparisons.decorator.htmlreport.toolstrip.TextComparisonToolstripConfigurationContributor;
import com.mathworks.comparisons.event.ComparisonEvent;
import com.mathworks.comparisons.event.ComparisonEventListener;
import com.mathworks.comparisons.event.ComparisonEventSupport;
import com.mathworks.comparisons.event.data.CEventDataErrorOccurred;
import com.mathworks.comparisons.event.data.CEventDataRefresh;
import com.mathworks.comparisons.filter.ComparisonFilterState;
import com.mathworks.comparisons.filter.ComparisonFilterStateProvider;
import com.mathworks.comparisons.filter.Filter;
import com.mathworks.comparisons.filter.NullComparisonFilterState;
import com.mathworks.comparisons.filter.text.TextComparisonFilterState;
import com.mathworks.comparisons.gui.dialogs.CloseReportWarningDialog;
import com.mathworks.comparisons.gui.dialogs.MergeErrorDialog;
import com.mathworks.comparisons.gui.dialogs.OverwriteFileWarningDialog;
import com.mathworks.comparisons.gui.dialogs.UndoWarningDialog;
import com.mathworks.comparisons.param.ComparisonParameterSet;
import com.mathworks.comparisons.param.parameter.ComparisonParameterAllowMerging;
import com.mathworks.comparisons.report.DisabledChildAction;
import com.mathworks.comparisons.report.toolstrip.ToolstripConfiguration;
import com.mathworks.comparisons.source.ComparisonSourcePropertyInfo;
import com.mathworks.comparisons.source.impl.TextMergeAwareComparisonSource;
import com.mathworks.comparisons.source.property.CSPropertyAbsoluteName;
import com.mathworks.comparisons.source.property.CSPropertyReadableLocation;
import com.mathworks.comparisons.util.ComparisonsExecutor;
import com.mathworks.comparisons.util.ExceptionHandler;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.comparisons.util.Restorable;
import com.mathworks.html.BrowserRequest;
import com.mathworks.html.CustomProtocolRequestHandler;
import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.RequestHandler;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mlwidgets.html.HTMLRenderer;
import com.mathworks.mlwidgets.html.HtmlConversionUtils;
import com.mathworks.mlwidgets.html.MJHtmlPanel;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJFormattedTextField;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.toolbox.shared.computils.dialogs.ProgressBarDialog;
import com.mathworks.toolstrip.factory.ContextTargetingManager;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;

public class HTMLTextReportDecorator
extends HTMLReportDecorator {
    private final Action fSaveRightFileAction;
    private final Action fSaveRightFileAsAction;
    private final AtomicReference<Action> fMergeAction;
    private final Action fUndoAction;
    private final Action fRedoAction;
    private Action fNextAction = null;
    private Action fPreviousAction = null;
    private final PropertyChangeListener fColumnsVisibleChangeListener;
    private ComparisonParameterSet fParameters;
    private TextMergeAwareComparisonSource fRightComparisonSource;
    private TextMergeAwareComparisonSource fLeftComparisonSource;
    private final ExecutorService fExecutor = Executors.newSingleThreadExecutor();
    private boolean fKeepDisabled = false;
    private TextComparisonToolstripConfigurationContributor fToolstripConfigurationContributor;
    private final ComparisonEventSupport fEventSupport;
    private volatile Restorable.Memento fCurrentFilterState;
    private static final AtomicBoolean MERGE_ENABLED = new AtomicBoolean(true);
    private ProgressBarDialog fProgressBar;

    public static void setMergeEnabled(boolean bl) {
        MERGE_ENABLED.set(bl);
    }

    public HTMLTextReportDecorator(ComparisonEventSupport comparisonEventSupport, ComparisonEventListener comparisonEventListener, PropertyChangeListener propertyChangeListener) {
        super(comparisonEventListener);
        this.fColumnsVisibleChangeListener = propertyChangeListener;
        this.fEventSupport = comparisonEventSupport;
        this.fSaveRightFileAction = this.createSaveRightFileAction();
        this.getActionManager().addAction(ActionIdSaveRightFile.getInstance().getName(), this.fSaveRightFileAction);
        this.fSaveRightFileAsAction = this.createSaveRightFileAsAction();
        this.getActionManager().addAction(ActionIdSaveRightFileAs.getInstance().getName(), this.fSaveRightFileAsAction);
        this.fMergeAction = new AtomicReference<Action>(this.createMergeAction());
        this.fUndoAction = this.createUndoAction();
        this.fRedoAction = this.createRedoAction();
        if (MERGE_ENABLED.get()) {
            this.getActionManager().addAction(ActionIdMerge.getInstance().getName(), this.fMergeAction.get());
            this.getActionManager().addAction(ActionIdUndoMerge.getInstance().getName(), this.fUndoAction);
            this.getActionManager().addAction(ActionIdRedo.getInstance().getName(), this.fRedoAction);
        }
        comparisonEventSupport.addComparisonEventListener(new ComparisonEventListener(){

            @Override
            public void processEvent(ComparisonEvent comparisonEvent) {
                if (CEventDataErrorOccurred.getInstance().equals(comparisonEvent.getEventData())) {
                    HTMLTextReportDecorator.this.disposeProgressBar();
                }
            }
        });
    }

    public boolean canClose() {
        boolean bl = true;
        if (this.isRightFileDirty()) {
            CloseReportWarningDialog.Option option = this.showCloseReportWarningDialog();
            if (option == CloseReportWarningDialog.Option.CANCEL) {
                bl = false;
            } else if (option == CloseReportWarningDialog.Option.YES) {
                try {
                    this.saveRightFile();
                }
                catch (Exception exception) {
                    ExceptionHandler.handleException(exception);
                }
            }
        }
        return bl;
    }

    @Override
    public void dispose() {
        this.fExecutor.shutdown();
        super.dispose();
    }

    @Override
    public Component createCentralComponent() {
        Component component = super.createCentralComponent();
        SelectionProtocolRequestHandler selectionProtocolRequestHandler = new SelectionProtocolRequestHandler();
        OpenFileProtocolRequestHandler openFileProtocolRequestHandler = new OpenFileProtocolRequestHandler();
        MergeActionNotificationProtocolRequestHandler mergeActionNotificationProtocolRequestHandler = new MergeActionNotificationProtocolRequestHandler();
        HtmlConversionUtils.visitBrowser((HtmlComponent)this.getHTMLRenderer().getHtmlComponent(), (HtmlConversionUtils.BrowserVisitor)new HtmlConversionUtils.BrowserVisitor((RequestHandler)selectionProtocolRequestHandler, (RequestHandler)openFileProtocolRequestHandler, (RequestHandler)mergeActionNotificationProtocolRequestHandler){
            final /* synthetic */ RequestHandler val$selectionRequestHandler;
            final /* synthetic */ RequestHandler val$openToLineRequestHandler;
            final /* synthetic */ RequestHandler val$mergeActionNotificationRequestHandler;
            {
                this.val$selectionRequestHandler = requestHandler;
                this.val$openToLineRequestHandler = requestHandler2;
                this.val$mergeActionNotificationRequestHandler = requestHandler3;
            }

            public void visitMJHtmlPanel(MJHtmlPanel mJHtmlPanel) {
                mJHtmlPanel.addRequestHandler(this.val$selectionRequestHandler);
                mJHtmlPanel.addRequestHandler(this.val$openToLineRequestHandler);
                mJHtmlPanel.addRequestHandler(this.val$mergeActionNotificationRequestHandler);
            }

            public void visitHTMLRenderer(HTMLRenderer hTMLRenderer) {
                hTMLRenderer.addRequestHandler(this.val$selectionRequestHandler);
                hTMLRenderer.addRequestHandler(this.val$openToLineRequestHandler);
                hTMLRenderer.addRequestHandler(this.val$mergeActionNotificationRequestHandler);
            }
        });
        return component;
    }

    @Override
    public ToolstripConfiguration getToolstripConfiguration(ToolstripConfiguration toolstripConfiguration) {
        if (this.getHTMLRenderer() == null) {
            throw new IllegalStateException("Must call createCentralComponent() first.");
        }
        if (this.fToolstripConfigurationContributor == null) {
            this.fToolstripConfigurationContributor = new TextComparisonToolstripConfigurationContributor(this.getActionManager(), new ComparisonFilterStateProvider(){

                public ComparisonFilterState<? extends Filter> getFilters() {
                    if (HTMLTextReportDecorator.this.fKeepDisabled) {
                        return new NullComparisonFilterState();
                    }
                    TextComparisonFilterState textComparisonFilterState = new TextComparisonFilterState(HTMLTextReportDecorator.this.fParameters);
                    HTMLTextReportDecorator.this.fCurrentFilterState = textComparisonFilterState.createMemento();
                    return textComparisonFilterState;
                }
            }, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object = actionEvent.getSource();
                    if (object != null && object instanceof TextComparisonFilterState) {
                        HTMLTextReportDecorator.this.applyFilters((TextComparisonFilterState)object);
                    }
                }
            }, new PropertyChangeListener(){
                private int fPreviouslyRejectedValue = Integer.MIN_VALUE;

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("value".equals(propertyChangeEvent.getPropertyName())) {
                        if (HTMLTextReportDecorator.this.isRightFileDirty()) {
                            int n = (Integer)propertyChangeEvent.getNewValue();
                            if (this.fPreviouslyRejectedValue == n) {
                                this.fPreviouslyRejectedValue = Integer.MIN_VALUE;
                                return;
                            }
                            UndoWarningDialog.Option option = HTMLTextReportDecorator.this.showLoseMergesDialog();
                            if (option == UndoWarningDialog.Option.YES) {
                                HTMLTextReportDecorator.this.fColumnsVisibleChangeListener.propertyChange(propertyChangeEvent);
                            } else {
                                this.fPreviouslyRejectedValue = (Integer)propertyChangeEvent.getOldValue();
                                MJFormattedTextField mJFormattedTextField = (MJFormattedTextField)propertyChangeEvent.getSource();
                                mJFormattedTextField.setValue((Object)this.fPreviouslyRejectedValue);
                            }
                        } else {
                            HTMLTextReportDecorator.this.fColumnsVisibleChangeListener.propertyChange(propertyChangeEvent);
                        }
                    }
                }
            }, this.getHtmlRendererComponent());
        }
        ToolstripConfiguration toolstripConfiguration2 = super.getToolstripConfiguration(toolstripConfiguration);
        this.fToolstripConfigurationContributor.contributeToConfiguration(toolstripConfiguration2);
        return toolstripConfiguration;
    }

    @Override
    public void disableControls() {
        this.showProgressBar();
        this.clearHtmlContents();
        super.disableControls();
        this.enableTextComparisonOptions(false);
        this.fMergeAction.get().setEnabled(false);
        this.fUndoAction.setEnabled(false);
        this.fRedoAction.setEnabled(false);
        this.setSaveActionEnabledStates(false);
    }

    @Override
    public void enableControls() {
        super.enableControls();
        this.enableTextComparisonOptions(true);
        this.fMergeAction.get().setEnabled(false);
        this.fUndoAction.setEnabled(false);
        this.fRedoAction.setEnabled(false);
        this.setSaveActionEnabledStates(false);
        this.disposeProgressBar();
    }

    public void setComparisonParameters(ComparisonParameterSet comparisonParameterSet) {
        this.fParameters = comparisonParameterSet;
        this.handleMergeFunctionalityStateChange(comparisonParameterSet);
    }

    private void handleMergeFunctionalityStateChange(ComparisonParameterSet comparisonParameterSet) {
        boolean bl;
        if (comparisonParameterSet.hasParameter(ComparisonParameterAllowMerging.getInstance()) && !(bl = ((Boolean)comparisonParameterSet.getValue(ComparisonParameterAllowMerging.getInstance())).booleanValue())) {
            this.fMergeAction.set((Action)((Object)new DisabledChildAction(this.fMergeAction.get())));
            this.getActionManager().addAction(ActionIdMerge.getInstance().getName(), this.fMergeAction.get());
        }
    }

    public void setComparisonSources(TextMergeAwareComparisonSource textMergeAwareComparisonSource, TextMergeAwareComparisonSource textMergeAwareComparisonSource2) {
        this.fLeftComparisonSource = textMergeAwareComparisonSource;
        this.fRightComparisonSource = textMergeAwareComparisonSource2;
    }

    public void keepTextComparisonOptionsDisabled(boolean bl) {
        this.fKeepDisabled = bl;
    }

    protected void handleSelectionChanged(final SelectionProtocolRequestHandler.SelectionChangedNotification selectionChangedNotification) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((Action)HTMLTextReportDecorator.this.fMergeAction.get()).setEnabled(HTMLTextReportDecorator.this.fRightComparisonSource != null && selectionChangedNotification.isDiffSelected() && !selectionChangedNotification.isMerged());
            }
        });
    }

    protected void handleMergeActionFinished(MergeActionNotificationProtocolRequestHandler.MergeActionNotification mergeActionNotification) {
        final boolean bl = mergeActionNotification.hasAvailableUndoOperations();
        final boolean bl2 = mergeActionNotification.hasAvailableRedoOperations();
        final boolean bl3 = mergeActionNotification.wasSelectedNodeMerged();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((Action)HTMLTextReportDecorator.this.fMergeAction.get()).setEnabled(HTMLTextReportDecorator.this.fRightComparisonSource != null && !bl3);
                HTMLTextReportDecorator.this.fUndoAction.setEnabled(bl);
                HTMLTextReportDecorator.this.fRedoAction.setEnabled(bl2);
                HTMLTextReportDecorator.this.fSaveRightFileAction.setEnabled(bl);
                HTMLTextReportDecorator.this.fSaveRightFileAsAction.setEnabled(bl);
                HTMLTextReportDecorator.this.fExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (bl) {
                            try {
                                HTMLTextReportDecorator.this.fRightComparisonSource.setText(HTMLTextReportDecorator.this.getRightTextFromReport());
                            }
                            catch (Exception exception) {
                                HTMLTextReportDecorator.this.showMergeErrorDialog(exception);
                            }
                        } else {
                            HTMLTextReportDecorator.this.fRightComparisonSource.setText(null);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                HTMLTextReportDecorator.this.disposeProgressBar();
                            }
                        });
                    }
                });
            }
        });
    }

    protected String getRightTextFromReport() throws Exception {
        String string = null;
        long l = 2000L;
        long l2 = System.currentTimeMillis();
        while (string == null && System.currentTimeMillis() < l2 + l) {
            string = this.getHTMLRenderer().executeScriptWithReturn("getFileNodeTextById('rightText')");
        }
        if (string == null && PlatformInfo.isWindows64()) {
            return "";
        }
        if (string == null) {
            throw new Exception(ResourceManager.format("text.merge.operation.failed", new Object[0]));
        }
        return string;
    }

    @Override
    protected void initializeActions() {
        super.initializeActions();
        this.fNextAction = HTMLActionManager.getNext((HtmlComponent)this.getHTMLRenderer());
        this.getActionManager().addAction(ActionIDNext.getInstance().getName(), this.fNextAction);
        this.fPreviousAction = HTMLActionManager.getPrevious((HtmlComponent)this.getHTMLRenderer());
        this.getActionManager().addAction(ActionIDPrevious.getInstance().getName(), this.fPreviousAction);
        final Action action = this.getActionManager().getAction(ActionIDRefresh.getInstance().getName());
        ChildAction childAction = new ChildAction(action){

            public void actionPerformed(ActionEvent actionEvent) {
                if (HTMLTextReportDecorator.this.isRightFileDirty()) {
                    UndoWarningDialog.Option option = HTMLTextReportDecorator.this.showLoseMergesDialog();
                    if (option == UndoWarningDialog.Option.YES) {
                        action.actionPerformed(actionEvent);
                    }
                } else {
                    action.actionPerformed(actionEvent);
                }
            }
        };
        this.getActionManager().addAction(ActionIDRefresh.getInstance().getName(), (Action)childAction);
        final Action action2 = this.getActionManager().getAction(ActionIDSwapSides.getInstance().getName());
        ChildAction childAction2 = new ChildAction(action2){

            public void actionPerformed(ActionEvent actionEvent) {
                if (HTMLTextReportDecorator.this.isRightFileDirty()) {
                    UndoWarningDialog.Option option = HTMLTextReportDecorator.this.showLoseMergesDialog();
                    if (option == UndoWarningDialog.Option.YES) {
                        action2.actionPerformed(actionEvent);
                    }
                } else {
                    action2.actionPerformed(actionEvent);
                }
            }
        };
        this.getActionManager().addAction(ActionIDSwapSides.getInstance().getName(), (Action)childAction2);
        SaveAsHtmlAction saveAsHtmlAction = new SaveAsHtmlAction(this.getHTMLRenderer());
        this.getActionManager().addAction(ActionIDSaveAs.getInstance().getName(), (Action)((Object)saveAsHtmlAction));
    }

    @Override
    protected PopupMenuProvider createPopupMenuProvider() {
        return new TextReportPopupMenuProvider();
    }

    protected Action getMergeAction() {
        return this.fMergeAction.get();
    }

    protected Action getUndoAction() {
        return this.fUndoAction;
    }

    protected Action getRedoAction() {
        return this.fRedoAction;
    }

    protected ExecutorService getExecutor() {
        return this.fExecutor;
    }

    private void enableTextComparisonOptions(boolean bl) {
        if (!bl || !this.fKeepDisabled) {
            this.fNextAction.setEnabled(bl);
            this.fPreviousAction.setEnabled(bl);
        }
    }

    private void setSaveActionEnabledStates(boolean bl) {
        this.fSaveRightFileAction.setEnabled(bl);
        this.fSaveRightFileAsAction.setEnabled(bl);
    }

    private void applyFilters(TextComparisonFilterState textComparisonFilterState) {
        if (textComparisonFilterState == null || this.isFilterStateUnchanged(textComparisonFilterState)) {
            return;
        }
        if (this.isRightFileDirty()) {
            UndoWarningDialog.Option option = this.showLoseMergesDialog();
            if (option == UndoWarningDialog.Option.YES) {
                this.saveFiltersAndRefresh(textComparisonFilterState);
            }
        } else {
            this.saveFiltersAndRefresh(textComparisonFilterState);
        }
    }

    private boolean isFilterStateUnchanged(Restorable restorable) {
        Restorable.Memento memento = restorable.createMemento();
        return memento.equals(this.fCurrentFilterState);
    }

    private void saveFiltersAndRefresh(TextComparisonFilterState textComparisonFilterState) {
        textComparisonFilterState.saveToPreferences();
        this.fCurrentFilterState = textComparisonFilterState.createMemento();
        this.fireRefreshReportEvent();
    }

    private Action createSaveRightFileAction() {
        return new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ComparisonsExecutor.getInstance().submit(new Runnable(){

                    @Override
                    public void run() {
                        final boolean bl = HTMLTextReportDecorator.this.fRightComparisonSource.isOutOfSync();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    boolean bl2 = false;
                                    if (bl) {
                                        OverwriteFileWarningDialog.Option option = HTMLTextReportDecorator.this.showOverwriteFileWarningDialog();
                                        HTMLTextReportDecorator.this.syncRightComparisonSource();
                                        if (option == OverwriteFileWarningDialog.Option.YES) {
                                            bl2 = HTMLTextReportDecorator.this.saveRightFile();
                                        }
                                    } else {
                                        bl2 = HTMLTextReportDecorator.this.saveRightFile();
                                    }
                                    if (bl2) {
                                        HTMLTextReportDecorator.this.fireRefreshReportEvent();
                                    }
                                }
                                catch (Exception exception) {
                                    ExceptionHandler.handleException(exception);
                                }
                            }
                        });
                    }
                });
            }
        };
    }

    private void syncRightComparisonSource() {
        ComparisonsExecutor.getInstance().submit(new Runnable(){

            @Override
            public void run() {
                HTMLTextReportDecorator.this.fRightComparisonSource.sync();
            }
        });
    }

    private Action createSaveRightFileAsAction() {
        return new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    boolean bl = HTMLTextReportDecorator.this.saveRightFileAs();
                    if (bl) {
                        HTMLTextReportDecorator.this.fireRefreshReportEvent();
                    }
                }
                catch (Exception exception) {
                    ExceptionHandler.handleException(exception);
                }
            }
        };
    }

    private boolean saveRightFile() throws Exception {
        return this.fRightComparisonSource.save(this.getHtmlRendererComponent());
    }

    private boolean saveRightFileAs() throws Exception {
        return this.fRightComparisonSource.saveAs(this.getHtmlRendererComponent());
    }

    private Action createMergeAction() {
        return new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Action)HTMLTextReportDecorator.this.fMergeAction.get()).setEnabled(false);
                HTMLTextReportDecorator.this.showProgressBar(ResourceManager.format("text.progress.merge", new Object[0]));
                HTMLTextReportDecorator.this.fExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        HTMLTextReportDecorator.this.getHTMLRenderer().executeScript("clearRedoStack(); merge()");
                    }
                });
            }
        };
    }

    private Action createUndoAction() {
        MJAbstractAction mJAbstractAction = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                HTMLTextReportDecorator.this.fUndoAction.setEnabled(false);
                HTMLTextReportDecorator.this.showProgressBar(ResourceManager.format("text.progress.undo", new Object[0]));
                HTMLTextReportDecorator.this.fExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        HTMLTextReportDecorator.this.getHTMLRenderer().executeScript("undo()");
                    }
                });
            }
        };
        ContextTargetingManager.setToolName((Action)mJAbstractAction, (String)"undo");
        mJAbstractAction.putValue("IsContextAction", true);
        return mJAbstractAction;
    }

    private Action createRedoAction() {
        MJAbstractAction mJAbstractAction = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                HTMLTextReportDecorator.this.fRedoAction.setEnabled(false);
                HTMLTextReportDecorator.this.showProgressBar(ResourceManager.format("text.progress.redo", new Object[0]));
                HTMLTextReportDecorator.this.fExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        HTMLTextReportDecorator.this.getHTMLRenderer().executeScript("redo()");
                    }
                });
            }
        };
        ContextTargetingManager.setToolName((Action)mJAbstractAction, (String)"redo");
        mJAbstractAction.putValue("IsContextAction", true);
        return mJAbstractAction;
    }

    private boolean isRightFileDirty() {
        return this.fRightComparisonSource != null && this.fRightComparisonSource.getText() != null;
    }

    private static boolean isFileDirty(TextMergeAwareComparisonSource textMergeAwareComparisonSource) {
        return textMergeAwareComparisonSource != null && textMergeAwareComparisonSource.getText() != null;
    }

    private static Editor openFileInEditor(TextMergeAwareComparisonSource textMergeAwareComparisonSource) throws FileNotFoundException {
        File file;
        try {
            file = (File)textMergeAwareComparisonSource.getPropertyValue(CSPropertyReadableLocation.getInstance(), new ComparisonSourcePropertyInfo[0]);
        }
        catch (RuntimeException runtimeException) {
            file = null;
        }
        if (file == null) {
            throw new FileNotFoundException(ResourceManager.format("exception.readfilefailure", textMergeAwareComparisonSource.getPropertyValue(CSPropertyAbsoluteName.getInstance(), new ComparisonSourcePropertyInfo[0])));
        }
        Editor editor = MLEditorServices.getEditorApplication().openEditor(file);
        if (HTMLTextReportDecorator.isFileDirty(textMergeAwareComparisonSource)) {
            try {
                editor.getDocument().remove(0, editor.getDocument().getLength());
                editor.getDocument().insertString(0, textMergeAwareComparisonSource.getText(), null);
            }
            catch (BadLocationException badLocationException) {
                ExceptionHandler.handleException(badLocationException);
            }
        }
        return editor;
    }

    private UndoWarningDialog.Option showLoseMergesDialog() {
        return UndoWarningDialog.showDialog(ResourceManager.format("undo.merges.warning", new Object[0]), this.getHtmlRendererComponent());
    }

    private CloseReportWarningDialog.Option showCloseReportWarningDialog() {
        return CloseReportWarningDialog.showDialog(ResourceManager.format("close.report.with.merges.warning", this.fRightComparisonSource.getFile().getAbsolutePath()), this.getHtmlRendererComponent());
    }

    private OverwriteFileWarningDialog.Option showOverwriteFileWarningDialog() {
        return OverwriteFileWarningDialog.showDialog(ResourceManager.format("overwrite.file.warning", new Object[0]), this.getHtmlRendererComponent());
    }

    protected void showMergeErrorDialog(Exception exception) {
        MergeErrorDialog.showDialog(exception.getMessage(), this.getHtmlRendererComponent());
        this.fireRefreshReportEvent();
    }

    private void fireRefreshReportEvent() {
        ComparisonsExecutor.getInstance().submit(new Runnable(){

            @Override
            public void run() {
                HTMLTextReportDecorator.this.fEventSupport.fireComparisonEvent(new ComparisonEvent(this, CEventDataRefresh.getInstance()));
            }
        });
    }

    private void showProgressBar() {
        this.showProgressBar(ResourceManager.format("text.progress.comparing", new Object[0]));
    }

    private void showProgressBar(String string) {
        this.fProgressBar = this.createProgressBar();
        this.fProgressBar.setProgressStatusLabel(string);
        this.fProgressBar.setVisible(true);
    }

    protected void disposeProgressBar() {
        if (this.fProgressBar != null) {
            this.fProgressBar.setVisible(false);
            this.fProgressBar.dispose();
            this.fProgressBar = null;
        }
    }

    private ProgressBarDialog createProgressBar() {
        ProgressBarDialog progressBarDialog = ProgressBarDialog.createInternalProgressBar((RootPaneContainer)HTMLTextReportDecorator.getRootPaneContainer((Container)this.getHtmlRendererComponent()), (String)ResourceManager.format("text.progress.title", new Object[0]), null);
        progressBarDialog.setCircularProgressBar(true);
        progressBarDialog.setCancelButtonVisible(false);
        return progressBarDialog;
    }

    private static RootPaneContainer getRootPaneContainer(Container container) {
        while (container != null && !(container instanceof RootPaneContainer)) {
            container = container.getParent();
        }
        if (container == null) {
            return null;
        }
        return (RootPaneContainer)((Object)container);
    }

    private void clearHtmlContents() {
        ComparisonHtmlComponent comparisonHtmlComponent = this.getHTMLRenderer();
        if (comparisonHtmlComponent != null && comparisonHtmlComponent.isInitialized() && comparisonHtmlComponent.getHtmlText() != null) {
            comparisonHtmlComponent.executeScript("$('body').html('');");
        }
    }

    protected class MergeActionNotificationProtocolRequestHandler
    extends CustomProtocolRequestHandler {
        private static final String PROTOCOL = "merge";

        private MergeActionNotificationProtocolRequestHandler() {
            super(PROTOCOL, new String[0]);
        }

        protected void handleMatchedRequest(BrowserRequest browserRequest, CustomProtocolUrl customProtocolUrl) {
            HTMLTextReportDecorator.this.handleMergeActionFinished(new MergeActionNotification(customProtocolUrl.getCommand()));
        }

        public class MergeActionNotification {
            private final int fNumAvailableUndoOperations;
            private final int fNumAvailableRedoOperations;
            private final int fNumAvailableMergeOperations;
            private final boolean fSelectedNodeMerged;

            private MergeActionNotification(String string) {
                this.fNumAvailableUndoOperations = this.extractNumUndoOperations(string);
                this.fNumAvailableMergeOperations = this.determineNumAvailableMergeOperations(string);
                this.fNumAvailableRedoOperations = this.extractNumRedoOperations(string);
                this.fSelectedNodeMerged = this.extractSelectedNodeMergedValue(string);
            }

            public boolean hasAvailableUndoOperations() {
                return this.fNumAvailableUndoOperations > 0;
            }

            public boolean hasAvailableRedoOperations() {
                return this.fNumAvailableRedoOperations > 0;
            }

            public boolean hasAvailableMergeOperations() {
                return this.fNumAvailableMergeOperations > 0;
            }

            public int getNumAvailableUndoOperations() {
                return this.fNumAvailableUndoOperations;
            }

            public boolean wasSelectedNodeMerged() {
                return this.fSelectedNodeMerged;
            }

            private int extractNumUndoOperations(String string) {
                int n = string.indexOf(64);
                return new Integer(string.substring(0, n));
            }

            private int extractNumRedoOperations(String string) {
                int n = string.indexOf(64);
                int n2 = string.indexOf(35);
                return new Integer(string.substring(n + 1, n2));
            }

            private int determineNumAvailableMergeOperations(String string) {
                int n = string.indexOf(35);
                int n2 = string.indexOf(36);
                return new Integer(string.substring(n + 1, n2)) - this.fNumAvailableUndoOperations;
            }

            private boolean extractSelectedNodeMergedValue(String string) {
                int n = string.indexOf(36);
                return Boolean.parseBoolean(string.substring(n + 1));
            }
        }
    }

    private class OpenFileProtocolRequestHandler
    extends CustomProtocolRequestHandler {
        private static final String PROTOCOL = "openfile";

        private OpenFileProtocolRequestHandler() {
            super(PROTOCOL, new String[0]);
        }

        protected void handleMatchedRequest(BrowserRequest browserRequest, CustomProtocolUrl customProtocolUrl) {
            final OpenFileRequest openFileRequest = new OpenFileRequest(customProtocolUrl.getCommand());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Editor editor = HTMLTextReportDecorator.openFileInEditor(openFileRequest.getSource());
                        if (openFileRequest.shouldOpenToLine()) {
                            editor.goToLine(openFileRequest.getLine(), true);
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        ExceptionHandler.handleException(fileNotFoundException);
                    }
                }
            });
        }

        private class OpenFileRequest {
            private final TextMergeAwareComparisonSource fSource;
            private final Integer fLineNum;

            private OpenFileRequest(String string) {
                this.fSource = this.getSource(string);
                this.fLineNum = this.getLine(string);
            }

            private TextMergeAwareComparisonSource getSource() {
                return this.fSource;
            }

            private int getLine() {
                return this.fLineNum;
            }

            private boolean shouldOpenToLine() {
                return this.fLineNum != null;
            }

            private TextMergeAwareComparisonSource getSource(String string) {
                return string.startsWith("right") ? HTMLTextReportDecorator.this.fRightComparisonSource : HTMLTextReportDecorator.this.fLeftComparisonSource;
            }

            private Integer getLine(String string) {
                int n = string.indexOf(64);
                if (n < 0) {
                    return null;
                }
                return new Integer(string.substring(n + 1));
            }
        }
    }

    protected class SelectionProtocolRequestHandler
    extends CustomProtocolRequestHandler {
        private static final String PROTOCOL = "selection";

        protected SelectionProtocolRequestHandler() {
            super(PROTOCOL, new String[0]);
        }

        protected void handleMatchedRequest(BrowserRequest browserRequest, CustomProtocolUrl customProtocolUrl) {
            String string = customProtocolUrl.getCommand();
            HTMLTextReportDecorator.this.handleSelectionChanged(new SelectionChangedNotification(string));
        }

        public class SelectionChangedNotification {
            private final String fDiffId;
            private final boolean fMerged;

            private SelectionChangedNotification(String string) {
                this.fDiffId = this.extractDiffId(string);
                this.fMerged = this.extractMergedValue(string);
            }

            public boolean isDiffSelected() {
                return !"null".equals(this.fDiffId);
            }

            public String getDiffId() {
                return this.fDiffId;
            }

            public boolean isMerged() {
                return this.fMerged;
            }

            private String extractDiffId(String string) {
                int n = string.indexOf(64);
                if (n < 0) {
                    return string;
                }
                return string.substring(0, n);
            }

            private boolean extractMergedValue(String string) {
                int n = string.indexOf(64);
                if (n < 0) {
                    return false;
                }
                return "merged".equals(string.substring(n + 1));
            }
        }
    }

    protected class TextReportPopupMenuProvider
    extends HTMLReportDecorator.DefaultPopupMenuProvider {
        protected TextReportPopupMenuProvider() {
        }

        @Override
        public MJPopupMenu createPopupMenu() {
            MJPopupMenu mJPopupMenu = super.createPopupMenu();
            mJPopupMenu.add((Component)new MJMenuItem(HTMLTextReportDecorator.this.fNextAction), 0);
            mJPopupMenu.add((Component)new MJMenuItem(HTMLTextReportDecorator.this.fPreviousAction), 1);
            mJPopupMenu.add((Component)new JPopupMenu.Separator(), 2);
            return mJPopupMenu;
        }
    }
}

