/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.decorator.variable;

import com.mathworks.comparisons.decorator.variable.CompareSelectedAction;
import com.mathworks.comparisons.decorator.variable.SummaryLabel;
import com.mathworks.comparisons.decorator.variable.ValueInfo;
import com.mathworks.comparisons.decorator.variable.VariableComparisonDecorator;
import com.mathworks.comparisons.decorator.variable.VariableDifferenceType;
import com.mathworks.comparisons.decorator.variable.VariableDifferences;
import com.mathworks.comparisons.util.ComparisonColors;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJSplitPane;
import com.mathworks.widgets.spreadsheet.SpreadsheetCellRenderer;
import com.mathworks.widgets.spreadsheet.SpreadsheetScrollPane;
import com.mathworks.widgets.spreadsheet.SpreadsheetTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class ArrayDifferencesPanel
extends MJPanel {
    private static final String LEFT_PREFIX = "Left";
    private static final String RIGHT_PREFIX = "Right";
    private final CompareSelectedAction fCompareSelectedAction;
    private final ArrayViewer fViewer1;
    private final ArrayViewer fViewer2;
    private final ArrayTableModel fModel1;
    private final ArrayTableModel fModel2;
    private final VariableComparisonDecorator fParent;

    public ArrayDifferencesPanel(VariableComparisonDecorator variableComparisonDecorator, VariableDifferences variableDifferences, CompareSelectedAction compareSelectedAction) {
        super((LayoutManager)new BorderLayout());
        Object object;
        Object object2;
        SpreadsheetCellRenderer spreadsheetCellRenderer;
        this.fParent = variableComparisonDecorator;
        this.fModel1 = new ArrayTableModel();
        this.fModel2 = new ArrayTableModel();
        switch (variableDifferences.getType()) {
            case NUMERIC_ARRAYS: {
                spreadsheetCellRenderer = new NumericTableCellRenderer();
                this.fModel1.setNumeric(variableDifferences.getNumeric1());
                this.fModel2.setNumeric(variableDifferences.getNumeric2());
                break;
            }
            case COMPLEX_NUMERIC_ARRAYS: 
            case NON_NUMERIC_ARRAYS: {
                spreadsheetCellRenderer = new NonNumericTableCellRenderer();
                this.fModel1.setNonNumeric(variableDifferences.getNonNumeric1(), variableDifferences.getDiffs());
                this.fModel2.setNonNumeric(variableDifferences.getNonNumeric2(), variableDifferences.getDiffs());
                break;
            }
            case LOGICAL_ARRAYS: {
                spreadsheetCellRenderer = new LogicalTableCellRenderer();
                this.fModel1.setNumeric(variableDifferences.getNumeric1());
                this.fModel2.setNumeric(variableDifferences.getNumeric2());
                break;
            }
            default: {
                assert (variableDifferences.getType() == VariableDifferenceType.UNRELATED_TYPES);
                spreadsheetCellRenderer = new UnrelatedTableCellRenderer();
                object2 = new boolean[1][1];
                object2[0][0] = true;
                object = new ValueInfo[1][1];
                object[0][0] = variableDifferences.getValueSummary1();
                this.fModel1.setNonNumeric((ValueInfo[][])object, (boolean[][])object2);
                ValueInfo[][] valueInfoArray = new ValueInfo[1][1];
                valueInfoArray[0][0] = variableDifferences.getValueSummary2();
                this.fModel2.setNonNumeric(valueInfoArray, (boolean[][])object2);
            }
        }
        this.fViewer1 = new ArrayViewer(this.fModel1, (TableCellRenderer)spreadsheetCellRenderer, new SummaryLabel(variableDifferences, true), variableDifferences.getType(), LEFT_PREFIX);
        this.fViewer2 = new ArrayViewer(this.fModel2, (TableCellRenderer)spreadsheetCellRenderer, new SummaryLabel(variableDifferences, false), variableDifferences.getType(), RIGHT_PREFIX);
        this.fViewer1.setSibling(this.fViewer2);
        object2 = new MJSplitPane(1, (Component)((Object)this.fViewer1), (Component)((Object)this.fViewer2));
        object2.setDividerLocation(0.5);
        this.add((Component)object2, "Center");
        this.fCompareSelectedAction = compareSelectedAction;
        this.fCompareSelectedAction.setRunnable(new Runnable(){

            @Override
            public void run() {
                int n = ArrayDifferencesPanel.this.fViewer1.getTable().getSelectedRow();
                int n2 = ArrayDifferencesPanel.this.fViewer1.getTable().getSelectedColumn();
                if (n >= 0 && n2 >= 0 && ArrayDifferencesPanel.this.fModel1.getRowCount() > n && ArrayDifferencesPanel.this.fModel2.getRowCount() > n && ArrayDifferencesPanel.this.fModel1.getColumnCount() > n2 && ArrayDifferencesPanel.this.fModel2.getColumnCount() > n2) {
                    ArrayDifferencesPanel.this.fParent.doIndexSubsref(n, n2);
                }
            }
        });
        object = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                int n = ArrayDifferencesPanel.this.fViewer1.getTable().getSelectedRow();
                int n2 = ArrayDifferencesPanel.this.fViewer1.getTable().getSelectedColumn();
                if (n >= 0 && n2 >= 0 && ArrayDifferencesPanel.this.fModel1.getRowCount() > n && ArrayDifferencesPanel.this.fModel2.getRowCount() > n && ArrayDifferencesPanel.this.fModel1.getColumnCount() > n2 && ArrayDifferencesPanel.this.fModel2.getColumnCount() > n2) {
                    ArrayDifferencesPanel.this.fCompareSelectedAction.setEnabled(true);
                    return;
                }
                ArrayDifferencesPanel.this.fCompareSelectedAction.setEnabled(false);
            }
        };
        if (variableDifferences.getType() == VariableDifferenceType.NON_NUMERIC_ARRAYS) {
            this.fViewer1.createMouseListener();
            this.fViewer2.createMouseListener();
            this.fViewer1.getTable().getSelectionModel().addListSelectionListener((ListSelectionListener)object);
            this.fViewer2.getTable().getSelectionModel().addListSelectionListener((ListSelectionListener)object);
        }
    }

    private static class ArrayTableSelectionModel
    extends DefaultListSelectionModel {
        private final boolean fIsColumns;
        private final TableModel fSiblingModel;
        private ListSelectionModel fSiblingSelection;
        private boolean fInProgress;

        ArrayTableSelectionModel(TableModel tableModel, ListSelectionModel listSelectionModel, boolean bl) {
            this.fSiblingModel = tableModel;
            this.fSiblingSelection = listSelectionModel;
            this.fIsColumns = bl;
            this.fInProgress = false;
        }

        public void setSiblingSelection(ListSelectionModel listSelectionModel) {
            this.fSiblingSelection = listSelectionModel;
        }

        private boolean inRange(int n) {
            if (this.fIsColumns) {
                return n < this.fSiblingModel.getColumnCount();
            }
            return n < this.fSiblingModel.getRowCount();
        }

        @Override
        public void setSelectionInterval(int n, int n2) {
            super.setSelectionInterval(n, n2);
            if (!this.fInProgress && this.inRange(n) && this.inRange(n2)) {
                this.fInProgress = true;
                this.fSiblingSelection.setSelectionInterval(n, n2);
                this.fInProgress = false;
            }
        }

        @Override
        public void addSelectionInterval(int n, int n2) {
            super.addSelectionInterval(n, n2);
            if (!this.fInProgress && this.inRange(n) && this.inRange(n2)) {
                this.fInProgress = true;
                this.fSiblingSelection.addSelectionInterval(n, n2);
                this.fInProgress = false;
            }
        }

        @Override
        public void setAnchorSelectionIndex(int n) {
            super.setAnchorSelectionIndex(n);
            if (!this.fInProgress && this.inRange(n)) {
                this.fInProgress = true;
                this.fSiblingSelection.setAnchorSelectionIndex(n);
                this.fInProgress = false;
            }
        }

        @Override
        public void setLeadSelectionIndex(int n) {
            super.setLeadSelectionIndex(n);
            if (!this.fInProgress && this.inRange(n)) {
                this.fInProgress = true;
                this.fSiblingSelection.setLeadSelectionIndex(n);
                this.fInProgress = false;
            }
        }

        @Override
        public void insertIndexInterval(int n, int n2, boolean bl) {
            super.insertIndexInterval(n, n2, bl);
            if (!this.fInProgress && this.inRange(n) && this.inRange(n2)) {
                this.fInProgress = true;
                this.fSiblingSelection.insertIndexInterval(n, n2, bl);
                this.fInProgress = false;
            }
        }

        @Override
        public void removeSelectionInterval(int n, int n2) {
            super.removeSelectionInterval(n, n2);
            if (!this.fInProgress && this.inRange(n) && this.inRange(n2)) {
                this.fInProgress = true;
                this.fSiblingSelection.removeSelectionInterval(n, n2);
                this.fInProgress = false;
            }
        }

        @Override
        public void removeIndexInterval(int n, int n2) {
            super.removeIndexInterval(n, n2);
            if (!this.fInProgress && this.inRange(n) && this.inRange(n2)) {
                this.fInProgress = true;
                this.fSiblingSelection.removeIndexInterval(n, n2);
                this.fInProgress = false;
            }
        }
    }

    private class ArrayViewer
    extends MJPanel {
        private static final String PANEL_NAME = "ArrayPanel";
        private static final String TABLE_NAME = "ArrayTable";
        private final SpreadsheetTable fTable;
        private final SummaryLabel fSummary;
        private final SpreadsheetScrollPane fScrollPane;
        private ArrayViewer fSibling;

        ArrayViewer(TableModel tableModel, TableCellRenderer tableCellRenderer, SummaryLabel summaryLabel, VariableDifferenceType variableDifferenceType, String string) {
            super((LayoutManager)new BorderLayout());
            this.setName(string + PANEL_NAME);
            this.fTable = new SpreadsheetTable(tableModel);
            this.fTable.setName(string + TABLE_NAME);
            this.fTable.setScheme(0);
            this.fTable.setDefaultRenderer(Object.class, tableCellRenderer);
            this.fTable.setEditable(false);
            if (variableDifferenceType == VariableDifferenceType.NON_NUMERIC_ARRAYS) {
                this.fTable.setToolTipText(ResourceManager.getString("variable.doubleclickcell"));
                if (tableModel.getColumnCount() == 1) {
                    this.fTable.getColumnModel().getColumn(0).setPreferredWidth(200);
                }
            }
            this.fScrollPane = new SpreadsheetScrollPane((JTable)this.fTable);
            this.add((Component)this.fScrollPane, "Center");
            this.fSummary = summaryLabel;
            this.add((Component)((Object)this.fSummary), "North");
            this.fScrollPane.getViewport().addChangeListener(new ScrollListener());
        }

        SpreadsheetTable getTable() {
            return this.fTable;
        }

        void createMouseListener() {
            this.fTable.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        ArrayDifferencesPanel.this.fCompareSelectedAction.actionPerformed(null);
                    }
                }
            });
        }

        void setSibling(ArrayViewer arrayViewer) {
            this.fSibling = arrayViewer;
            this.fSibling.fSibling = this;
            ArrayTableSelectionModel arrayTableSelectionModel = new ArrayTableSelectionModel(this.fSibling.fTable.getModel(), null, false);
            ArrayTableSelectionModel arrayTableSelectionModel2 = new ArrayTableSelectionModel(this.fTable.getModel(), arrayTableSelectionModel, false);
            arrayTableSelectionModel.setSiblingSelection(arrayTableSelectionModel2);
            this.fTable.setSelectionModel((ListSelectionModel)arrayTableSelectionModel);
            this.fSibling.fTable.setSelectionModel((ListSelectionModel)arrayTableSelectionModel2);
            ArrayTableSelectionModel arrayTableSelectionModel3 = new ArrayTableSelectionModel(this.fSibling.fTable.getModel(), null, true);
            ArrayTableSelectionModel arrayTableSelectionModel4 = new ArrayTableSelectionModel(this.fTable.getModel(), arrayTableSelectionModel3, true);
            arrayTableSelectionModel3.setSiblingSelection(arrayTableSelectionModel4);
            this.fTable.getColumnModel().setSelectionModel(arrayTableSelectionModel3);
            this.fSibling.fTable.getColumnModel().setSelectionModel(arrayTableSelectionModel4);
        }

        private class ScrollListener
        implements ChangeListener {
            private ScrollListener() {
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (ArrayViewer.this.fSibling != null) {
                    Point point = ArrayViewer.this.fScrollPane.getViewport().getViewPosition();
                    Point point2 = new Point(point);
                    Dimension dimension = ArrayViewer.this.fSibling.fScrollPane.getViewport().getViewSize();
                    Dimension dimension2 = ArrayViewer.this.fSibling.fScrollPane.getViewport().getExtentSize();
                    Point point3 = new Point((int)(point2.getX() + dimension2.getWidth()), (int)(point2.getY() + dimension2.getHeight()));
                    if (point3.getX() > dimension.getWidth()) {
                        point2.x = Math.max((int)(dimension.getWidth() - dimension2.getWidth()), 0);
                    }
                    if (point3.getY() > dimension.getHeight()) {
                        point2.y = Math.max((int)(dimension.getHeight() - dimension2.getHeight()), 0);
                    }
                    ArrayViewer.this.fSibling.fScrollPane.getViewport().setViewPosition(point2);
                }
            }
        }
    }

    private static class UnrelatedTableCellRenderer
    extends SpreadsheetCellRenderer {
        private UnrelatedTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, false, false, n, n2);
            component.setBackground(ComparisonColors.getModifiedColor());
            return component;
        }
    }

    private class NonNumericTableCellRenderer
    extends SpreadsheetCellRenderer {
        private NonNumericTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (n >= ArrayDifferencesPanel.this.fModel1.getRowCount() || n2 >= ArrayDifferencesPanel.this.fModel1.getColumnCount()) {
                component.setBackground(ComparisonColors.getAddedColor());
            } else if (n >= ArrayDifferencesPanel.this.fModel2.getRowCount() || n2 >= ArrayDifferencesPanel.this.fModel2.getColumnCount()) {
                component.setBackground(ComparisonColors.getRemovedColor());
            } else if (ArrayDifferencesPanel.this.fModel1.getHighlightAt(n, n2)) {
                component.setBackground(ComparisonColors.getModifiedColor());
            }
            return component;
        }
    }

    private class LogicalTableCellRenderer
    extends SpreadsheetCellRenderer {
        private LogicalTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = (Double)object == 0.0 ? "false" : "true";
            Component component = super.getTableCellRendererComponent(jTable, (Object)string, bl, bl2, n, n2);
            if (n >= ArrayDifferencesPanel.this.fModel1.getRowCount() || n2 >= ArrayDifferencesPanel.this.fModel1.getColumnCount()) {
                component.setBackground(ComparisonColors.getAddedColor());
            } else if (n >= ArrayDifferencesPanel.this.fModel2.getRowCount() || n2 >= ArrayDifferencesPanel.this.fModel2.getColumnCount()) {
                component.setBackground(ComparisonColors.getRemovedColor());
            } else if (ArrayDifferencesPanel.this.fModel1.getNumericValueAt(n, n2) != ArrayDifferencesPanel.this.fModel2.getNumericValueAt(n, n2)) {
                component.setBackground(ComparisonColors.getModifiedColor());
            }
            return component;
        }
    }

    private class NumericTableCellRenderer
    extends SpreadsheetCellRenderer {
        private NumericTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (n >= ArrayDifferencesPanel.this.fModel1.getRowCount() || n2 >= ArrayDifferencesPanel.this.fModel1.getColumnCount()) {
                component.setBackground(ComparisonColors.getAddedColor());
            } else if (n >= ArrayDifferencesPanel.this.fModel2.getRowCount() || n2 >= ArrayDifferencesPanel.this.fModel2.getColumnCount()) {
                component.setBackground(ComparisonColors.getRemovedColor());
            } else if (ArrayDifferencesPanel.this.fModel1.getNumericValueAt(n, n2) != ArrayDifferencesPanel.this.fModel2.getNumericValueAt(n, n2)) {
                component.setBackground(ComparisonColors.getModifiedColor());
            }
            return component;
        }
    }

    private static class ArrayTableModel
    extends AbstractTableModel {
        private double[][] fNumeric = new double[0][0];
        private boolean[][] fHighlight;
        private ValueInfo[][] fNonNumeric;

        ArrayTableModel() {
        }

        boolean isNumeric() {
            return this.fNumeric != null;
        }

        void setNumeric(double[][] dArray) {
            this.fNonNumeric = null;
            this.fNumeric = dArray;
            this.fireTableStructureChanged();
        }

        void setNonNumeric(ValueInfo[][] valueInfoArray, boolean[][] blArray) {
            this.fNumeric = null;
            this.fNonNumeric = valueInfoArray;
            this.fHighlight = blArray;
            this.fireTableStructureChanged();
        }

        @Override
        public int getRowCount() {
            if (this.isNumeric()) {
                return this.fNumeric.length;
            }
            return this.fNonNumeric.length;
        }

        @Override
        public int getColumnCount() {
            if (this.isNumeric()) {
                if (this.fNumeric.length > 0) {
                    return this.fNumeric[0].length;
                }
                return 0;
            }
            if (this.fNonNumeric.length > 0) {
                return this.fNonNumeric[0].length;
            }
            return 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.fNumeric != null) {
                return this.fNumeric[n][n2];
            }
            return this.fNonNumeric[n][n2];
        }

        public double getNumericValueAt(int n, int n2) {
            return this.fNumeric[n][n2];
        }

        public String getNonNumericValueAt(int n, int n2) {
            return this.fNonNumeric[n][n2].toString();
        }

        public boolean getHighlightAt(int n, int n2) {
            return this.fHighlight[n][n2];
        }
    }
}

