/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.main;

import com.mathworks.comparisons.compare.CannotRunWithoutDisplayException;
import com.mathworks.comparisons.main.ComparisonDriver;
import com.mathworks.comparisons.main.DefaultComparisonPlugin;
import com.mathworks.comparisons.main.SelectionIncompleteException;
import com.mathworks.comparisons.plugin.ComparisonPlugin;
import com.mathworks.comparisons.prefs.ComparisonPrefsManager;
import com.mathworks.comparisons.prefs.preference.CPreferenceHistoryLength;
import com.mathworks.comparisons.register.ComparisonType;
import com.mathworks.comparisons.register.ComparisonTypeFeature;
import com.mathworks.comparisons.register.ComparisonTypeRegister;
import com.mathworks.comparisons.register.impl.ComparisonTypeRegisterImpl;
import com.mathworks.comparisons.result.ComparisonResult;
import com.mathworks.comparisons.selection.ComparisonSelection;
import com.mathworks.comparisons.selection.InvalidConversionException;
import com.mathworks.comparisons.selection.SelectionDataType;
import com.mathworks.comparisons.selection.SelectionPolicies;
import com.mathworks.comparisons.selection.SelectionPoliciesRegister;
import com.mathworks.comparisons.selection.dialog.SourceSelectionListModel;
import com.mathworks.comparisons.selection.impl.SelectionPoliciesRegisterImpl;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.util.CheckNullArgument;
import com.mathworks.comparisons.util.ColorManager;
import com.mathworks.util.osgi.ClasspathOSGiManager;
import com.mathworks.widgets.desk.DTGroupPropertyProvider;
import com.mathworks.widgets.desk.Desktop;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;

public class ComparisonTool
implements ComparisonTypeRegister,
SelectionPoliciesRegister {
    private static ComparisonTool mSingletonInstance = null;
    private SourceSelectionListModel mPreviouslyComparedList = null;
    private ComparisonTypeRegister mComparisonTypeRegister = null;
    private SelectionPoliciesRegister mSelectionPoliciesRegister = null;
    private final Set<ComparisonDriver> mCurrentDrivers = new HashSet<ComparisonDriver>();

    public static synchronized ComparisonTool getInstance() {
        if (mSingletonInstance == null) {
            mSingletonInstance = new ComparisonTool();
        }
        return mSingletonInstance;
    }

    private ComparisonTool() {
        ComparisonTool.initializePreferenceColors();
    }

    @Override
    public void register(ComparisonType comparisonType) {
        this.getComparisonTypeRegister().register(comparisonType);
    }

    @Override
    public Collection<String> getDataTypeNames() {
        return this.getComparisonTypeRegister().getDataTypeNames();
    }

    @Override
    public boolean hasDataTypeName(String string) {
        return this.getComparisonTypeRegister().hasDataTypeName(string);
    }

    @Override
    public String getDescriptionByDataTypeName(String string) {
        return this.getComparisonTypeRegister().getDescriptionByDataTypeName(string);
    }

    @Override
    public ComparisonType getMostSuitableComparisonType(ComparisonSource comparisonSource, ComparisonSource comparisonSource2, Set<ComparisonTypeFeature> set) {
        return this.getComparisonTypeRegister().getMostSuitableComparisonType(comparisonSource, comparisonSource2, set);
    }

    @Override
    public ComparisonType getByDataTypeName(String string, ComparisonSource comparisonSource, ComparisonSource comparisonSource2, Set<ComparisonTypeFeature> set) {
        return this.getComparisonTypeRegister().getByDataTypeName(string, comparisonSource, comparisonSource2, set);
    }

    @Override
    public List<ComparisonType> getCompatibleComparisonTypes(ComparisonSource comparisonSource, ComparisonSource comparisonSource2, Set<ComparisonTypeFeature> set) {
        return this.getComparisonTypeRegister().getCompatibleComparisonTypes(comparisonSource, comparisonSource2, set);
    }

    @Override
    public void register(SelectionPolicies selectionPolicies) {
        this.getSelectionPoliciesRegister().register(selectionPolicies);
    }

    @Override
    public Collection<SelectionPolicies> getAllPolicies() {
        return this.getSelectionPoliciesRegister().getAllPolicies();
    }

    @Override
    public SelectionPolicies getPolicies(String string) {
        return this.getSelectionPoliciesRegister().getPolicies(string);
    }

    @Override
    public SelectionPolicies getPolicies(Class<?> clazz) {
        return this.getSelectionPoliciesRegister().getPolicies(clazz);
    }

    @Override
    public <T> ComparisonSource convertToComparisonSource(SelectionDataType<T> selectionDataType, T t) throws InvalidConversionException {
        return this.getSelectionPoliciesRegister().convertToComparisonSource(selectionDataType, t);
    }

    @Override
    public ComparisonSource convertStringToComparisonSource(SelectionDataType selectionDataType, String string) throws InvalidConversionException {
        return this.getSelectionPoliciesRegister().convertStringToComparisonSource(selectionDataType, string);
    }

    public void startNewComparisonAndReturn(final Desktop desktop, final DTGroupPropertyProvider dTGroupPropertyProvider, ComparisonSelection comparisonSelection) {
        CheckNullArgument.check(comparisonSelection, "aSelection");
        final ComparisonDriver comparisonDriver = new ComparisonDriver(comparisonSelection);
        this.mCurrentDrivers.add(comparisonDriver);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                comparisonDriver.compareAndDisplay(desktop, dTGroupPropertyProvider);
            }
        });
    }

    public ComparisonResult startNewComparisonAndWait(ComparisonSelection comparisonSelection) throws SelectionIncompleteException, CannotRunWithoutDisplayException {
        CheckNullArgument.check(comparisonSelection, "aSelection");
        ComparisonDriver comparisonDriver = new ComparisonDriver(comparisonSelection);
        ComparisonResult<?> comparisonResult = comparisonDriver.compareAndReturn();
        comparisonDriver.dispose();
        return comparisonResult;
    }

    public void dispose(ComparisonDriver comparisonDriver) {
        this.removeDriver(comparisonDriver);
        comparisonDriver.dispose();
    }

    void removeDriver(ComparisonDriver comparisonDriver) {
        this.mCurrentDrivers.remove(comparisonDriver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Set<ComparisonDriver> set = this.mCurrentDrivers;
        synchronized (set) {
            for (ComparisonDriver comparisonDriver : this.mCurrentDrivers) {
                comparisonDriver.dispose();
            }
            this.mCurrentDrivers.clear();
        }
    }

    public synchronized SourceSelectionListModel getPreviouslyComparedList() {
        if (this.mPreviouslyComparedList == null) {
            this.mPreviouslyComparedList = new SourceSelectionListModel(this.getSelectionPoliciesRegister(), (Integer)ComparisonPrefsManager.getInstance().getValue(CPreferenceHistoryLength.getInstance()));
        }
        return this.mPreviouslyComparedList;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    private ComparisonTypeRegister getComparisonTypeRegister() {
        if (this.mComparisonTypeRegister == null) {
            this.createRegister();
        }
        return this.mComparisonTypeRegister;
    }

    private SelectionPoliciesRegister getSelectionPoliciesRegister() {
        if (this.mSelectionPoliciesRegister == null) {
            this.createRegister();
        }
        return this.mSelectionPoliciesRegister;
    }

    private synchronized void createRegister() {
        this.mComparisonTypeRegister = ComparisonTypeRegisterImpl.createNewRegister();
        this.mSelectionPoliciesRegister = SelectionPoliciesRegisterImpl.createNewRegister();
        this.registerComponents(new DefaultComparisonPlugin());
        this.findComparisonPlugins();
    }

    private void findComparisonPlugins() {
        Collection collection = ClasspathOSGiManager.getInstance().getImplementors(ComparisonPlugin.class);
        if (collection != null) {
            for (ComparisonPlugin comparisonPlugin : collection) {
                this.registerComponents(comparisonPlugin);
            }
        }
    }

    public void registerComponents(ComparisonPlugin comparisonPlugin) {
        this.registerComparisonTypes(comparisonPlugin);
        this.registerSelectionPolicies(comparisonPlugin);
    }

    private void registerComparisonTypes(ComparisonPlugin comparisonPlugin) {
        if (comparisonPlugin.hasImplementations(ComparisonPlugin.Component.COMPARISONTYPE)) {
            Collection<?> collection = comparisonPlugin.getImplementations(ComparisonPlugin.Component.COMPARISONTYPE);
            for (Object obj : collection) {
                assert (obj instanceof ComparisonType);
                this.register((ComparisonType)obj);
            }
        }
    }

    private void registerSelectionPolicies(ComparisonPlugin comparisonPlugin) {
        if (comparisonPlugin.hasImplementations(ComparisonPlugin.Component.SELECTIONPOLICIES)) {
            Collection<?> collection = comparisonPlugin.getImplementations(ComparisonPlugin.Component.SELECTIONPOLICIES);
            for (Object obj : collection) {
                assert (obj instanceof SelectionPolicies);
                this.register((SelectionPolicies)obj);
            }
        }
    }

    private static void initializePreferenceColors() {
        ColorManager colorManager = ColorManager.getInstance();
        colorManager.initializeCurrentProfileColors();
    }
}

