/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.main;

import com.mathworks.comparisons.compare.CannotRunWithoutDisplayException;
import com.mathworks.comparisons.event.ComparisonEventListener;
import com.mathworks.comparisons.main.ComparisonTool;
import com.mathworks.comparisons.main.NoSuitableComparisonTypeException;
import com.mathworks.comparisons.main.SelectionIncompleteException;
import com.mathworks.comparisons.register.ComparisonType;
import com.mathworks.comparisons.register.type.ComparisonTypeBinary;
import com.mathworks.comparisons.report.ComparisonReportGroup;
import com.mathworks.comparisons.result.ComparisonResult;
import com.mathworks.comparisons.selection.ComparisonSelection;
import com.mathworks.comparisons.selection.InvalidConversionException;
import com.mathworks.comparisons.selection.SelectionPoliciesRegister;
import com.mathworks.comparisons.selection.datatype.SDataTypeFile;
import com.mathworks.comparisons.selection.dialog.SourceSelectionDialog;
import com.mathworks.comparisons.selection.file.FileSelectionPolicies;
import com.mathworks.comparisons.selection.impl.SelectionPoliciesRegisterImpl;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.widgets.desk.DTGroupPropertyProvider;
import com.mathworks.widgets.desk.Desktop;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;

public class ComparisonUtilities {
    private ComparisonUtilities() {
    }

    public static ComparisonSelection createComparisonSelection() {
        return new ComparisonSelection(ComparisonUtilities.getApp());
    }

    public static SourceSelectionDialog createSelectionDialog(ComparisonEventListener comparisonEventListener, ComparisonSelection comparisonSelection) {
        return new SourceSelectionDialog(comparisonEventListener, ComparisonUtilities.getApp(), ComparisonUtilities.getApp(), ComparisonUtilities.getApp().getPreviouslyComparedList(), comparisonSelection);
    }

    public static void startComparison(ComparisonSource comparisonSource, ComparisonSource comparisonSource2) {
        ComparisonUtilities.startComparison(comparisonSource, comparisonSource2, true);
    }

    public static void startComparison(ComparisonSource comparisonSource, ComparisonSource comparisonSource2, boolean bl) {
        ComparisonSelection comparisonSelection = new ComparisonSelection(comparisonSource, comparisonSource2);
        ComparisonUtilities.startComparison(comparisonSelection, bl);
    }

    public static void startComparison(ComparisonSelection comparisonSelection) {
        ComparisonUtilities.startComparison(comparisonSelection, true);
    }

    public static void startComparison(ComparisonSelection comparisonSelection, boolean bl) {
        ComparisonReportGroup comparisonReportGroup = ComparisonReportGroup.getInstance();
        if (comparisonSelection.getComparisonType() == null) {
            ComparisonSource comparisonSource = comparisonSelection.getComparisonSource(ComparisonSelection.Index.FIRST);
            ComparisonSource comparisonSource2 = comparisonSelection.getComparisonSource(ComparisonSelection.Index.SECOND);
            List<ComparisonType> list = ComparisonTool.getInstance().getCompatibleComparisonTypes(comparisonSource, comparisonSource2, null);
            if (list.isEmpty()) {
                throw new NoSuitableComparisonTypeException(comparisonSource, comparisonSource2);
            }
            if (list.size() == 1) {
                comparisonSelection.setComparisonType(list.get(0));
            } else if (list.size() == 2 && list.get(1) instanceof ComparisonTypeBinary) {
                comparisonSelection.setComparisonType(list.get(0));
            } else if (bl) {
                comparisonSelection.setComparisonType(list.get(0));
            }
        }
        ComparisonUtilities.getApp().startNewComparisonAndReturn(comparisonReportGroup.getDesktop(), (DTGroupPropertyProvider)comparisonReportGroup, comparisonSelection);
    }

    public static void startEmptyComparison() {
        ComparisonReportGroup comparisonReportGroup = ComparisonReportGroup.getInstance();
        ComparisonUtilities.startEmptyComparison(comparisonReportGroup.getDesktop(), (DTGroupPropertyProvider)comparisonReportGroup);
    }

    public static void startEmptyComparison(Desktop desktop, DTGroupPropertyProvider dTGroupPropertyProvider) {
        ComparisonUtilities.getApp().startNewComparisonAndReturn(desktop, dTGroupPropertyProvider, ComparisonUtilities.createComparisonSelection());
    }

    public static void startComparison(File file, File file2) throws FileNotFoundException {
        ComparisonUtilities.startComparison(file, file2, true);
    }

    public static void startComparison(File file, File file2, boolean bl) throws FileNotFoundException {
        ComparisonUtilities.startComparison(ComparisonUtilities.createFileSelection(file, file2), bl);
    }

    public static ComparisonResult startComparisonWithReturn(File file, File file2) throws SelectionIncompleteException, CannotRunWithoutDisplayException, FileNotFoundException {
        ComparisonSelection comparisonSelection = ComparisonUtilities.createFileSelection(file, file2);
        ComparisonSource comparisonSource = comparisonSelection.getComparisonSource(ComparisonSelection.Index.FIRST);
        ComparisonSource comparisonSource2 = comparisonSelection.getComparisonSource(ComparisonSelection.Index.SECOND);
        List<ComparisonType> list = ComparisonTool.getInstance().getCompatibleComparisonTypes(comparisonSource, comparisonSource2, null);
        if (list.isEmpty()) {
            throw new NoSuitableComparisonTypeException(comparisonSource, comparisonSource2);
        }
        comparisonSelection.setComparisonType(list.get(0));
        return ComparisonUtilities.getApp().startNewComparisonAndWait(comparisonSelection);
    }

    private static ComparisonTool getApp() {
        return ComparisonTool.getInstance();
    }

    private static ComparisonSelection createFileSelection(File file, File file2) throws FileNotFoundException {
        SelectionPoliciesRegister selectionPoliciesRegister = SelectionPoliciesRegisterImpl.createNewRegister();
        selectionPoliciesRegister.register(new FileSelectionPolicies());
        ComparisonSelection comparisonSelection = new ComparisonSelection(selectionPoliciesRegister);
        comparisonSelection.setSelection(ComparisonSelection.Index.FIRST, SDataTypeFile.getInstance(), file);
        comparisonSelection.setSelection(ComparisonSelection.Index.SECOND, SDataTypeFile.getInstance(), file2);
        try {
            comparisonSelection.convertToComparisonSource(ComparisonSelection.Index.FIRST);
            comparisonSelection.convertToComparisonSource(ComparisonSelection.Index.SECOND);
        }
        catch (InvalidConversionException invalidConversionException) {
            throw new FileNotFoundException(invalidConversionException.getMessage());
        }
        return comparisonSelection;
    }
}

