/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.report;

import com.mathworks.comparisons.gui.dialogs.FileChangedWarningDialog;
import com.mathworks.comparisons.report.ComparisonReport;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.source.ComparisonSourcePropertyInfo;
import com.mathworks.comparisons.source.property.CSPropertyAbsoluteName;
import com.mathworks.comparisons.util.ComparisonsExecutor;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientEvent;
import javax.swing.SwingUtilities;

public class ReportActivationListener
extends DTClientAdapter {
    private final ComparisonReport fReport;
    private final ComparisonSource fLeftSource;
    private final ComparisonSource fRightSource;
    private boolean fClosing = false;

    public ReportActivationListener(ComparisonReport comparisonReport, ComparisonSource comparisonSource, ComparisonSource comparisonSource2) {
        this.fReport = comparisonReport;
        this.fLeftSource = comparisonSource;
        this.fRightSource = comparisonSource2;
    }

    public void clientClosing(DTClientEvent dTClientEvent) {
        this.fClosing = true;
    }

    public void clientActivated(DTClientEvent dTClientEvent) {
        if (this.fClosing) {
            return;
        }
        ComparisonsExecutor.getInstance().submit(new Runnable(){

            @Override
            public void run() {
                String string;
                boolean bl = ReportActivationListener.this.fLeftSource.isOutOfSync();
                boolean bl2 = ReportActivationListener.this.fRightSource.isOutOfSync();
                if (!bl && !bl2) {
                    return;
                }
                String string2 = (String)ReportActivationListener.this.fLeftSource.getPropertyValue(CSPropertyAbsoluteName.getInstance(), new ComparisonSourcePropertyInfo[0]);
                String string3 = (String)ReportActivationListener.this.fRightSource.getPropertyValue(CSPropertyAbsoluteName.getInstance(), new ComparisonSourcePropertyInfo[0]);
                if (bl && bl2) {
                    string = ResourceManager.format("files.changed.warning", string2, string3);
                } else {
                    String string4 = bl ? string2 : string3;
                    string = ResourceManager.format("file.changed.warning", string4);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FileChangedWarningDialog.Option option = FileChangedWarningDialog.showDialog(string, ReportActivationListener.this.fReport.getCentralComponent());
                        ReportActivationListener.this.repaintReport();
                        ComparisonsExecutor.getInstance().submit(new Runnable(){

                            @Override
                            public void run() {
                                ReportActivationListener.this.fLeftSource.sync();
                                ReportActivationListener.this.fRightSource.sync();
                            }
                        });
                        if (option == FileChangedWarningDialog.Option.YES) {
                            ReportActivationListener.this.fReport.refresh();
                        }
                    }
                });
            }
        });
    }

    private void repaintReport() {
        this.fReport.revalidate();
        this.fReport.repaint();
    }
}

