/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.report.toolstrip;

import com.mathworks.comparisons.filter.ComparisonFilterState;
import com.mathworks.comparisons.filter.ComparisonFilterStateProvider;
import com.mathworks.comparisons.filter.Filter;
import com.mathworks.comparisons.filter.NullComparisonFilterState;
import com.mathworks.comparisons.report.toolstrip.ComparisonToolstripTabConfiguration;
import com.mathworks.comparisons.report.toolstrip.ComparisonToolstripUtils;
import com.mathworks.comparisons.report.toolstrip.FilterToolSetFactory;
import com.mathworks.comparisons.report.toolstrip.TSTabConfigurationFactory;
import com.mathworks.comparisons.report.toolstrip.ToolSetFactory;
import com.mathworks.comparisons.report.toolstrip.ToolstripTabConfiguration;
import com.mathworks.comparisons.report.toolstrip.ToolstripTabConfigurationFactory;
import com.mathworks.toolstrip.factory.TSTabConfiguration;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.toolstrip.factory.TSToolSetContents;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DefaultViewTabFactory;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

public class ComparisonViewTabConfigurationFactory
implements ToolstripTabConfigurationFactory {
    public static final String TAB_NAME = "VIEW";
    private final Desktop fDesktop;
    private final DTClientBase fClient;

    public ComparisonViewTabConfigurationFactory(Desktop desktop, DTClientBase dTClientBase) {
        this.fDesktop = desktop;
        this.fClient = dTClientBase;
    }

    @Override
    public ToolstripTabConfiguration createConfiguration() {
        return new ComparisonToolstripTabConfiguration(TAB_NAME, this.getTSTabConfigurationFactory(), this.getToolSetFactories());
    }

    private TSTabConfigurationFactory getTSTabConfigurationFactory() {
        return new TSTabConfigurationFactory(){

            @Override
            public TSTabConfiguration createConfiguration() {
                TSTabConfiguration tSTabConfiguration = ComparisonToolstripUtils.readTabConfiguration(ComparisonViewTabConfigurationFactory.class, "ViewTab.xml");
                if (!ComparisonViewTabConfigurationFactory.this.fDesktop.isClientDocked((Component)ComparisonViewTabConfigurationFactory.this.fClient)) {
                    tSTabConfiguration.removeSection("tiles");
                    tSTabConfiguration.removeSection("document_bar");
                }
                return tSTabConfiguration;
            }
        };
    }

    private List<ToolSetFactory> getToolSetFactories() {
        ArrayList<ToolSetFactory> arrayList = new ArrayList<ToolSetFactory>();
        final DefaultViewTabFactory defaultViewTabFactory = this.fDesktop.getDefaultViewTabFactory();
        arrayList.add(new ToolSetFactory(){

            @Override
            public TSToolSet createToolSet() {
                if (ComparisonViewTabConfigurationFactory.this.fDesktop.isClientDocked((Component)ComparisonViewTabConfigurationFactory.this.fClient)) {
                    return defaultViewTabFactory.createToolSet("File Comparisons");
                }
                return new TSToolSet(new TSToolSetContents("DUMMY"));
            }
        });
        arrayList.add(new FilterToolSetFactory(new ComparisonFilterStateProvider(){

            public ComparisonFilterState<? extends Filter> getFilters() {
                return new NullComparisonFilterState();
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        }));
        return arrayList;
    }
}

