/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.selection.impl;

import com.mathworks.comparisons.selection.InvalidConversionException;
import com.mathworks.comparisons.selection.SelectionDataType;
import com.mathworks.comparisons.selection.SelectionPolicies;
import com.mathworks.comparisons.selection.SelectionPoliciesRegister;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.util.ResourceManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SelectionPoliciesRegisterImpl
implements SelectionPoliciesRegister {
    private Map<String, SelectionPolicies<?>> mDataTypeNameToPolicies = new HashMap();
    private Map<Class<?>, SelectionPolicies> mClassTypeToPolicies = new HashMap();
    private List<SelectionPolicies> mPoliciesInRegistrationOrder = new ArrayList<SelectionPolicies>();

    public static SelectionPoliciesRegister createNewRegister() {
        return new SelectionPoliciesRegisterImpl();
    }

    @Override
    public void register(SelectionPolicies selectionPolicies) {
        SelectionDataType selectionDataType = selectionPolicies.getSelectionDataType();
        String string = selectionDataType.getName();
        Class<?> clazz = selectionDataType.getApplicableType();
        if (this.mDataTypeNameToPolicies.containsKey(string)) {
            throw new UnsupportedOperationException(ResourceManager.format("exception.toomanypolicies", "SelectionPoliciesFactory", string));
        }
        if (this.mClassTypeToPolicies.containsKey(clazz)) {
            throw new UnsupportedOperationException(ResourceManager.format("exception.toomanypolicies", "SelectionPoliciesFactory", clazz.getName()));
        }
        this.mDataTypeNameToPolicies.put(string, selectionPolicies);
        this.mClassTypeToPolicies.put(clazz, selectionPolicies);
        this.mPoliciesInRegistrationOrder.add(selectionPolicies);
    }

    @Override
    public Collection<String> getDataTypeNames() {
        return Collections.unmodifiableCollection(this.mDataTypeNameToPolicies.keySet());
    }

    @Override
    public boolean hasDataTypeName(String string) {
        return this.mDataTypeNameToPolicies.containsKey(string);
    }

    @Override
    public String getDescriptionByDataTypeName(String string) {
        if (this.hasDataTypeName(string)) {
            return this.mDataTypeNameToPolicies.get(string).getDescription();
        }
        throw new UnsupportedOperationException(ResourceManager.format("exception.unknowndatatype", string));
    }

    @Override
    public SelectionPolicies getPolicies(String string) {
        if (this.hasDataTypeName(string)) {
            return this.mDataTypeNameToPolicies.get(string);
        }
        throw new UnsupportedOperationException(ResourceManager.format("exception.unknowndatatype", string));
    }

    @Override
    public SelectionPolicies getPolicies(Class<?> clazz) {
        SelectionPolicies selectionPolicies = null;
        if (this.mClassTypeToPolicies.containsKey(clazz)) {
            selectionPolicies = this.mClassTypeToPolicies.get(clazz);
        } else {
            for (Class<?> clazz2 : this.mClassTypeToPolicies.keySet()) {
                if (!clazz2.isAssignableFrom(clazz)) continue;
                selectionPolicies = this.mClassTypeToPolicies.get(clazz2);
                break;
            }
        }
        return selectionPolicies;
    }

    @Override
    public Collection<SelectionPolicies> getAllPolicies() {
        return Collections.unmodifiableCollection(this.mPoliciesInRegistrationOrder);
    }

    @Override
    public <T> ComparisonSource convertToComparisonSource(SelectionDataType<T> selectionDataType, T t) throws InvalidConversionException {
        String string = selectionDataType.getName();
        if (this.hasDataTypeName(string)) {
            SelectionPolicies<?> selectionPolicies = this.mDataTypeNameToPolicies.get(string);
            return selectionPolicies.convertToComparisonSource(t);
        }
        throw new InvalidConversionException(t, ResourceManager.format("exception.unknowndatatype", string));
    }

    @Override
    public ComparisonSource convertStringToComparisonSource(SelectionDataType selectionDataType, String string) throws InvalidConversionException {
        String string2 = selectionDataType.getName();
        if (this.hasDataTypeName(string2)) {
            return this.mDataTypeNameToPolicies.get(string2).convertStringToComparisonSource(string);
        }
        throw new InvalidConversionException((Object)string, ResourceManager.format("exception.unknowndatatype", string2));
    }
}

