/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.source.impl;

import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.source.ComparisonSourceProperty;
import com.mathworks.comparisons.source.ComparisonSourcePropertyInfo;
import com.mathworks.comparisons.source.impl.ComparisonSourceImpl;
import com.mathworks.comparisons.source.impl.ComparisonSourceListener;
import com.mathworks.comparisons.source.impl.LocalFileSource;
import com.mathworks.comparisons.source.impl.MlxFileSource;
import com.mathworks.comparisons.source.property.CSPropertyAbsoluteName;
import com.mathworks.comparisons.source.property.CSPropertyName;
import com.mathworks.comparisons.source.property.CSPropertyText;
import com.mathworks.comparisons.util.ComparisonsExecutor;
import com.mathworks.comparisons.util.FileUtils;
import com.mathworks.services.mlx.MlxFileUtils;
import com.mathworks.toolbox.shared.computils.confinement.ThreadCheck;
import com.mathworks.toolbox.shared.computils.confinement.predicates.OnlyEDT;
import com.mathworks.widgets.datamodel.TextFileBackingStore;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;
import org.apache.commons.lang.Validate;

public class TextMergeAwareComparisonSource
implements ComparisonSource {
    private final AtomicReference<ComparisonSource> fBaseSource = new AtomicReference();
    private final AtomicReference<String> fText = new AtomicReference();
    private final TextFileBackingStore fBackingStore;

    public TextMergeAwareComparisonSource(ComparisonSource comparisonSource) {
        Validate.notNull((Object)comparisonSource);
        this.fBaseSource.set(comparisonSource);
        this.fBackingStore = TextMergeAwareComparisonSource.createBackingStore(comparisonSource);
    }

    private static TextFileBackingStore createBackingStore(ComparisonSource comparisonSource) {
        TextFileBackingStore textFileBackingStore;
        File file = TextMergeAwareComparisonSource.getFileForComparisonSource(comparisonSource);
        if (file.exists()) {
            textFileBackingStore = TextFileBackingStore.createWithExistentBackingFile((File)file);
        } else {
            textFileBackingStore = TextFileBackingStore.createWithNoBackingFile();
            textFileBackingStore.setFile(file);
        }
        return textFileBackingStore;
    }

    private static File getFileForComparisonSource(ComparisonSource comparisonSource) {
        File file;
        try {
            file = FileUtils.convertComparisonSourceToFile(comparisonSource);
        }
        catch (FileNotFoundException | RuntimeException exception) {
            file = comparisonSource.hasProperty(CSPropertyAbsoluteName.getInstance()) ? new File((String)comparisonSource.getPropertyValue(CSPropertyAbsoluteName.getInstance(), new ComparisonSourcePropertyInfo[0])) : new File((String)comparisonSource.getPropertyValue(CSPropertyName.getInstance(), new ComparisonSourcePropertyInfo[0]));
        }
        return file;
    }

    @Override
    public void addListener(ComparisonSourceListener comparisonSourceListener) {
        this.fBaseSource.get().addListener(comparisonSourceListener);
    }

    @Override
    public void removeListener(ComparisonSourceListener comparisonSourceListener) {
        this.fBaseSource.get().removeListener(comparisonSourceListener);
    }

    @Override
    public boolean isOutOfSync() {
        return this.fBaseSource.get().isOutOfSync();
    }

    @Override
    public void sync() {
        this.fBaseSource.get().sync();
    }

    @Override
    public boolean hasProperty(ComparisonSourceProperty comparisonSourceProperty) {
        if (comparisonSourceProperty.equals(CSPropertyText.getInstance()) && this.fText.get() != null) {
            return true;
        }
        return this.fBaseSource.get().hasProperty(comparisonSourceProperty);
    }

    public Object getPropertyValue(ComparisonSourceProperty comparisonSourceProperty, ComparisonSourcePropertyInfo ... comparisonSourcePropertyInfoArray) {
        String string;
        if (comparisonSourceProperty.equals(CSPropertyText.getInstance()) && (string = this.fText.get()) != null) {
            return string;
        }
        return this.fBaseSource.get().getPropertyValue(comparisonSourceProperty, comparisonSourcePropertyInfoArray);
    }

    public void dispose() {
        this.fBaseSource.get().dispose();
        this.resetText();
    }

    @Override
    public boolean hasProperties(List<ComparisonSourceProperty> list) {
        if (list.contains(CSPropertyText.getInstance()) && this.fText.get() != null) {
            list.remove(CSPropertyText.getInstance());
        }
        return this.fBaseSource.get().hasProperties(list);
    }

    @Override
    public List<ComparisonSourceProperty> getProperties() {
        List<ComparisonSourceProperty> list = this.fBaseSource.get().getProperties();
        if (!list.contains(CSPropertyText.getInstance()) && this.fText.get() != null) {
            list.add(CSPropertyText.getInstance());
        }
        return list;
    }

    @Override
    public void refresh() {
        this.fBaseSource.get().refresh();
        this.resetText();
    }

    public void setText(String string) {
        this.fText.set(string);
    }

    public String getText() {
        return this.fText.get();
    }

    @ThreadCheck(access=OnlyEDT.class)
    public boolean save(Component component) throws Exception {
        boolean bl = this.fBackingStore.negotiateSave((Object)this.createTextDocument(), component);
        if (bl) {
            this.syncOffTheEDT();
        }
        return bl;
    }

    @ThreadCheck(access=OnlyEDT.class)
    public boolean saveAs(Component component) throws Exception {
        File file = this.fBackingStore.getFile();
        boolean bl = this.fBackingStore.negotiateSaveAs((Object)this.createTextDocument(), component);
        if (bl) {
            File file2 = this.fBackingStore.getFile();
            if (!file2.equals(file)) {
                this.updateBaseSource(file2);
            }
            this.syncOffTheEDT();
        }
        return bl;
    }

    private void syncOffTheEDT() {
        ComparisonsExecutor.getInstance().submit(new Runnable(){

            @Override
            public void run() {
                TextMergeAwareComparisonSource.this.sync();
            }
        });
    }

    private void updateBaseSource(File file) throws FileNotFoundException {
        ComparisonSourceImpl comparisonSourceImpl = new LocalFileSource(file, file.getName());
        if (MlxFileUtils.isMlxFile((String)file.getAbsolutePath())) {
            comparisonSourceImpl = new MlxFileSource(comparisonSourceImpl);
        }
        ComparisonSource comparisonSource = this.fBaseSource.getAndSet(comparisonSourceImpl);
        comparisonSource.dispose();
    }

    public File getFile() {
        return this.fBackingStore.getFile();
    }

    private Document createTextDocument() throws BadLocationException {
        PlainDocument plainDocument = new PlainDocument();
        plainDocument.insertString(0, this.fText.get(), new SimpleAttributeSet());
        return plainDocument;
    }

    private void resetText() {
        this.fText.set(null);
    }
}

