/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.util;

import com.mathworks.comparisons.util.ComparisonsExecutor;
import com.mathworks.toolbox.shared.computils.file.ChecksumGenerator;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.Validate;

public class FileChangedNotifier {
    private final File fFile;
    private final Collection<ChangeListener> fListeners = new CopyOnWriteArrayList<ChangeListener>();
    private final AtomicReference<Long> fBaselineChecksum = new AtomicReference();
    private final ConcurrentMap<Callable<Void>, Future<Void>> fMonitors = new ConcurrentHashMap<Callable<Void>, Future<Void>>();

    public FileChangedNotifier(File file) throws IOException {
        Validate.notNull((Object)file);
        this.fFile = file;
        this.fBaselineChecksum.set(ChecksumGenerator.getCRC32Checksum((File)file));
        this.fMonitors.put(this.createPollingCallable(), FileChangedNotifier.createDoNothingFuture());
        this.fMonitors.put(this.createWatchingCallable(), FileChangedNotifier.createDoNothingFuture());
    }

    private Callable<Void> createPollingCallable() {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    FileChangedNotifier.this.notifyIfChangedAndExists();
                }
                return null;
            }
        };
    }

    private Callable<Void> createWatchingCallable() {
        final File file = this.fFile.getAbsoluteFile().getParentFile();
        if (file == null) {
            return FileChangedNotifier.createDoNothingCallable();
        }
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                WatchService watchService;
                try {
                    watchService = FileSystems.getDefault().newWatchService();
                    file.toPath().register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                }
                catch (IOException iOException) {
                    return null;
                }
                while (true) {
                    boolean bl;
                    WatchKey watchKey;
                    try {
                        watchKey = watchService.take();
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    List<WatchEvent<?>> list = watchKey.pollEvents();
                    WatchEvent<?> watchEvent = list.get(list.size() - 1);
                    WatchEvent.Kind<?> kind = watchEvent.kind();
                    if (kind.equals(StandardWatchEventKinds.OVERFLOW) || kind.equals(StandardWatchEventKinds.ENTRY_DELETE)) continue;
                    Path path = (Path)watchEvent.context();
                    if (FileChangedNotifier.this.fFile.getName().equals(path.toString())) {
                        FileChangedNotifier.this.notifyIfChangedAndExists();
                    }
                    if (!(bl = watchKey.reset())) break;
                }
                watchService.close();
                return null;
            }
        };
    }

    private static Callable<Void> createDoNothingCallable() {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                return null;
            }
        };
    }

    private static Future<Void> createDoNothingFuture() {
        return new FutureTask<Void>(FileChangedNotifier.createDoNothingCallable());
    }

    public void addListener(ChangeListener changeListener) {
        this.fListeners.add(changeListener);
    }

    public void stopMonitoring() {
        for (Future future : this.fMonitors.values()) {
            future.cancel(true);
        }
    }

    public void startMonitoring() {
        for (Callable callable : this.fMonitors.keySet()) {
            Future<Void> future = this.fMonitors.replace(callable, ComparisonsExecutor.getInstance().submit(callable));
            if (future == null) continue;
            future.cancel(true);
        }
    }

    private void notifyIfChangedAndExists() {
        if (!this.fFile.exists()) {
            return;
        }
        try {
            long l = ChecksumGenerator.getCRC32Checksum((File)this.fFile);
            if (l != this.fBaselineChecksum.getAndSet(l)) {
                this.notifyListeners();
            }
        }
        catch (IOException iOException) {
            this.notifyListeners();
        }
    }

    private void notifyListeners() {
        for (ChangeListener changeListener : this.fListeners) {
            changeListener.fileChanged();
        }
    }

    public static interface ChangeListener {
        public void fileChanged();
    }
}

