/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.util;

import com.mathworks.comparisons.selection.ComparisonSelection;
import com.mathworks.comparisons.selection.InvalidConversionException;
import com.mathworks.comparisons.selection.SelectionPoliciesRegister;
import com.mathworks.comparisons.selection.datatype.SDataTypeFile;
import com.mathworks.comparisons.selection.file.FileSelectionPolicies;
import com.mathworks.comparisons.selection.impl.SelectionPoliciesRegisterImpl;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.source.ComparisonSourcePropertyInfo;
import com.mathworks.comparisons.source.property.CSPropertyAbsoluteName;
import com.mathworks.comparisons.source.property.CSPropertyReadableLocation;
import com.mathworks.comparisons.util.ResourceManager;
import java.io.File;
import java.io.FileNotFoundException;

public class FileUtils {
    private FileUtils() {
    }

    public static File convertComparisonSourceToFile(ComparisonSource comparisonSource) throws FileNotFoundException {
        File file = (File)comparisonSource.getPropertyValue(CSPropertyReadableLocation.getInstance(), new ComparisonSourcePropertyInfo[0]);
        if (file == null) {
            throw new FileNotFoundException(ResourceManager.format("exception.readfilefailure", (String)comparisonSource.getPropertyValue(CSPropertyAbsoluteName.getInstance(), new ComparisonSourcePropertyInfo[0])));
        }
        return file;
    }

    public static ComparisonSource convertFileToComparisonSource(File file) throws InvalidConversionException {
        SelectionPoliciesRegister selectionPoliciesRegister = SelectionPoliciesRegisterImpl.createNewRegister();
        selectionPoliciesRegister.register(new FileSelectionPolicies());
        ComparisonSelection comparisonSelection = new ComparisonSelection(selectionPoliciesRegister);
        comparisonSelection.setSelection(ComparisonSelection.Index.FIRST, SDataTypeFile.getInstance(), file);
        comparisonSelection.convertToComparisonSource(ComparisonSelection.Index.FIRST);
        return comparisonSelection.getComparisonSource(ComparisonSelection.Index.FIRST);
    }
}

