/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.ICProp;
import com.mathworks.toolbox.instrument.VISA;
import com.mathworks.toolbox.instrument.VisaGeneral;
import com.mathworks.toolbox.instrument.util.DefaultICProp;
import com.mathworks.toolbox.instrument.util.Displays;
import com.mathworks.toolbox.testmeas.util.TMException;

public class TcpipVisa
extends VisaGeneral {
    protected int boardIndex = 0;
    protected String lanName = "inst0";
    protected String remoteHost = "";
    protected static final Object[] comVals = new Object[]{new Double(8.0)};
    static ICProp[] objectICProps = new ICProp[]{new ICProp("Alias", "string", "none", "", "", "always", 1, 0), new ICProp("BoardIndex", "double", "none", "", new Integer(0), "whileOpen", 1, 0), new ICProp("ByteOrder", "string", "enum", byteOVals, "littleEndian", "never", 0, 0), new ICProp("BytesAvailableFcnMode", "string", "enum", dModeVals, "eosCharCode", "whileOpen", 0, 0), new ICProp("EOIMode", "string", "enum", boolVals, "on", "never", 1, 0), new ICProp("EOSCharCode", "ASCII Value", "ASCII Value", AsciiVals, "LF", "never", 1, 0), new ICProp("EOSMode", "string", "enum", EOSMVals, "none", "never", 1, 0), new ICProp("LANName", "string", "none", "", "inst0", "whileOpen", 1, 0), new ICProp("RemoteHost", "string", "none", "", "", "whileOpen", 1, 0), new ICProp("RsrcName", "string", "none", "", "", "always", 1, 0), new ICProp("Type", "string", "none", "", "visa-tcpip", "always", 0, 0)};

    public TcpipVisa() {
        this.deleteInstrumentObject(this);
    }

    public TcpipVisa(String string, String string2, String string3, String string4) throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            TcpipVisa.displayError("The Instrument Control Toolbox license check failed when trying to execute: 'visa'.");
        }
        try {
            this.rsrcName = this.visaName = string3;
            try {
                this.parseName(this.visaName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.alias = string4;
            this.useAlias = !this.alias.equals("");
            this.rsrcName = this.visaName;
            this.info[0] = string + FILESEP + string2;
            this.info[1] = TcpipVisa.jarVersion();
            this.info[2] = this.getVendorName(string2);
            this.visa = VISA.createVisaObject((String)this.info[2], (String)this.info[0]);
            this.name = "VISA-TCPIP-" + this.boardIndex + "-" + this.remoteHost + "-" + this.lanName;
            this.type = "visa-tcpip";
            this.displayName = "VISA-TCPIP";
            this.objectProps = DefaultICProp.addObjectProps(objectICProps);
            this.objectPolls = this.visa.VerifyAsyncVISARead();
        }
        catch (Exception exception) {
            this.deleteInstrumentObject(this);
            throw new TMException(exception.getMessage());
        }
    }

    @Override
    public void parseName(String string) {
        int n = string.indexOf("::");
        if (n == -1) {
            return;
        }
        this.boardIndex = n == 5 ? 0 : this.str2num(string.substring(5, n));
        if (this.boardIndex < 0) {
            return;
        }
        String string2 = string.substring(n + 2, string.length());
        if ((n = string2.indexOf("::")) == -1) {
            return;
        }
        this.remoteHost = string2.substring(0, n);
        if ((n = (string2 = string2.substring(n + 2, string2.length())).indexOf("::")) == -1) {
            this.lanName = "inst0";
        } else {
            this.lanName = string2.substring(0, n);
            string2 = string2.substring(n + 2, string2.length());
        }
        if (!string2.toUpperCase().equals("INSTR")) {
            return;
        }
        this.rsrcName = "TCPIP" + this.boardIndex + "::" + this.remoteHost + "::" + this.lanName + "::INSTR";
    }

    @Override
    protected void nameStandardFormat() {
        this.nameStandardFormat = this.name.equals("VISA-TCPIP-" + this.boardIndex + "-" + this.remoteHost + "-" + this.lanName);
    }

    @Override
    public void updateNameProperties() {
        this.rsrcName = "TCPIP" + this.boardIndex + "::" + this.remoteHost + "::" + this.lanName + "::INSTR";
        if (this.nameStandardFormat) {
            this.setName("VISA-TCPIP-" + this.boardIndex + "-" + this.remoteHost + "-" + this.lanName);
        }
    }

    public final void setBoardIndex(int n) throws TMException {
        if (this.useAlias) {
            TcpipVisa.displayError("BoardIndex cannot be set for a VISA object that has an alias.");
        }
        if (this.status == 1) {
            TcpipVisa.displayError("BoardIndex cannot be set while OBJ is open.");
        }
        this.boardIndex = n;
        this.updateNameProperties();
        this.postPropertyChangedEvent("BoardIndex", new Integer(this.boardIndex));
    }

    public final int getBoardIndex() {
        return this.boardIndex;
    }

    public final void setLANName(String string) throws TMException {
        if (this.useAlias) {
            TcpipVisa.displayError("LANName cannot be set for a VISA object that has an alias.");
        }
        if (this.status == 1) {
            TcpipVisa.displayError("LANName cannot be set while OBJ is open.");
        }
        this.lanName = string;
        this.updateNameProperties();
        this.postPropertyChangedEvent("LANName", this.lanName);
    }

    public final String getLANName() {
        return this.lanName;
    }

    public final void setRemoteHost(String string) throws TMException {
        if (this.useAlias) {
            TcpipVisa.displayError("RemoteHost cannot be set for a VISA object that has an alias.");
        }
        if (this.status == 1) {
            TcpipVisa.displayError("RemoteHost cannot be set while OBJ is open.");
        }
        this.remoteHost = string;
        this.postPropertyChangedEvent("RemoteHost", this.remoteHost);
        this.updateNameProperties();
    }

    public final String getRemoteHost() {
        return this.remoteHost;
    }

    public void clrdevice() throws TMException {
        this.verifyObjectState();
        int n = this.visa.Clear(this.handle);
        if (n < 0) {
            TcpipVisa.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n));
        }
    }

    @Override
    public String[] getBrowserInfo() {
        String[] stringArray = new String[]{"Remote host:", this.remoteHost};
        return stringArray;
    }

    @Override
    public String getBrowserString() {
        return this.remoteHost;
    }

    @Override
    public boolean isInUse() {
        for (int i = 0; i < allInstrumentObjects.size(); ++i) {
            Object e = allInstrumentObjects.elementAt(i);
            if (!(e instanceof TcpipVisa)) continue;
            TcpipVisa tcpipVisa = (TcpipVisa)e;
            if (!tcpipVisa.rsrcName.equals(this.rsrcName) || tcpipVisa.status != 1) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void updatePropsOnOpen() throws TMException {
        super.updatePropsOnOpen();
    }

    @Override
    protected void updateObjectSpecificProperties(ICProp[] iCPropArray) {
        for (int i = 0; i < iCPropArray.length; ++i) {
            String string = iCPropArray[i].name;
            if (string.equals("BoardIndex")) {
                iCPropArray[i].setDefaultValue(new Integer(this.boardIndex));
                continue;
            }
            if (string.equals("LANName")) {
                iCPropArray[i].setDefaultValue(this.lanName);
                continue;
            }
            if (string.equals("Name")) {
                iCPropArray[i].setDefaultValue("VISA-TCPIP-" + this.boardIndex + "-" + this.remoteHost + "-" + this.lanName);
                continue;
            }
            if (string.equals("RemoteHost")) {
                iCPropArray[i].setDefaultValue(this.remoteHost);
                continue;
            }
            if (string.equals("RsrcName")) {
                iCPropArray[i].setDefaultValue(this.rsrcName);
                continue;
            }
            if (!string.equals("Alias")) continue;
            iCPropArray[i].setDefaultValue(this.alias);
        }
    }

    public static ICProp[] getProperties() {
        return DefaultICProp.addObjectProps(objectICProps);
    }

    @Override
    public void display() {
        if (!this.isvalid()) {
            System.out.println(Displays.invalidDisplay());
            return;
        }
        String string = LINESEP + "   VISA-TCPIP Object Using " + this.info[2] + " Adaptor : " + this.name + LINESEP + LINESEP + "   Communication Address " + LINESEP + "      RemoteHost:         " + this.remoteHost + LINESEP + LINESEP + "   Communication State " + LINESEP + "      Status:             " + STATUS_ENUM[this.status] + LINESEP + "      RecordStatus:       " + RECORD_STATUS_ENUM[this.bool2int(this.recordStatus)] + LINESEP + LINESEP + "   Read/Write State  " + LINESEP + "      TransferStatus:     " + TRANSFER_STATUS_ENUM[this.transferStatus] + LINESEP + "      BytesAvailable:     " + this.bytesAvailable + LINESEP + "      ValuesReceived:     " + this.getValuesReceived() + LINESEP + "      ValuesSent:         " + this.getValuesSent() + LINESEP + " " + LINESEP;
        System.out.println(string);
    }

    @Override
    public String setDisplay() {
        return Displays.getSetDisplay() + "    VISA-TCPIP specific properties:" + LINESEP + "    BoardIndex" + LINESEP + "    EOIMode: [ {on} | off ]" + LINESEP + "    EOSCharCode" + LINESEP + "    EOSMode: [ {none} | read | write | read&write ]" + LINESEP + "    LANName" + LINESEP + "    RemoteHost" + LINESEP + " " + LINESEP;
    }
}

