/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.ASCIITableConverter;
import com.mathworks.toolbox.instrument.BinarySwapBytes;
import com.mathworks.toolbox.instrument.InstrumentAsync;
import com.mathworks.toolbox.instrument.Poller;
import com.mathworks.toolbox.instrument.VISA;
import com.mathworks.toolbox.instrument.events.ICEvent;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.util.Timer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Vector;

public abstract class VisaGeneral
extends InstrumentAsync
implements ActionListener {
    protected static final int EOIMODE = 100;
    private static final int EOSMODE = 101;
    private static final int EOSCHAR = 102;
    static final int TIMEOUT = 104;
    protected static final int NONE = 0;
    protected static final int READ = 1;
    protected static final int WRITE = 2;
    protected static final int READWRITE = 3;
    protected static final String[] EOSMODES = new String[]{"none", "read", "write", "read&write"};
    protected static final int SUCCESS = 0;
    protected static final int ADAPTOR_DLL_NAME = 0;
    protected static final int ADAPTOR_DLL_VERSION = 1;
    protected static final int ADAPTOR_NAME = 2;
    protected static final String[] HWINFO_FIELDS = new String[]{"adaptordllname", "adaptordllversion", "adaptorname", "vendordllname", "vendordriverdescription", "vendordriverversion"};
    protected static final String HW_NOT_AVAILABLE_ERROR = "Use INSTRHWINFO for a list of available configurations. Use INSTRFIND to " + LINESEP + "determine if other instrument objects are connected to the requested instrument.";
    protected static final String[] dModeVals = new String[]{"eosCharCode", "byte"};
    protected static final Object[] eosCVals = new Object[]{new Double(0.0), new Double(255.0)};
    protected static final String[] EOSMVals = new String[]{"none", "read", "write", "read&write"};
    protected static final Object[] AsciiVals = new Object[]{eosCVals};
    protected String alias = "";
    protected boolean eoiMode = true;
    protected int eosCharCode = 10;
    protected int eosMode = 0;
    protected String rsrcName = "";
    protected VISA visa;
    protected String visaName;
    protected boolean useAlias;
    private int defaultRM;
    protected Object[] info = new Object[6];
    private int readId = 0;
    private int writeId = 0;
    private int oldTransferStatus = 0;
    protected boolean objectPolls = false;
    protected byte[] eosCharByteArray = new byte[1];
    protected Object eosCharCodeObject = "LF";

    @Override
    public Object[] getNonDefaultPVPairs() {
        Vector<Comparable<?>> vector = this.getPVPairs();
        this.addPVPair(vector, "EOIMode", this.bool2OnOff(this.eoiMode));
        this.addPVPair(vector, "EOSMode", EOSMODES[this.eosMode]);
        if (this.bytesAvailableFcnMode == 1) {
            vector.addElement((Comparable<?>)((Object)"BytesAvailableFcnMode"));
            vector.addElement((Comparable<?>)((Object)"byte"));
        }
        if (this.eosCharCode != 10) {
            vector.addElement((Comparable<?>)((Object)"EOSCharCode"));
            vector.addElement(new Integer(this.eosCharCode));
        }
        Object[] objectArray = new Object[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            objectArray[i] = vector.elementAt(i);
        }
        return objectArray;
    }

    public void setAlias(String string) throws TMException {
        VisaGeneral.displayError(this.createReadOnlyPropertyError("Alias"));
    }

    public String getAlias() {
        return this.alias;
    }

    public final void setEOIMode(boolean bl) throws TMException {
        if (this.status == 0) {
            this.eoiMode = bl;
            this.postPropertyChangedEvent("EOIMode", this.bool2OnOff(this.eoiMode));
            return;
        }
        try {
            this.setHardwareEOIMode(bl);
            this.eoiMode = bl;
            this.postPropertyChangedEvent("EOIMode", this.bool2OnOff(this.eoiMode));
        }
        catch (Exception exception) {
            VisaGeneral.displayError(exception.getMessage());
        }
    }

    public final boolean getEOIMode() {
        return this.eoiMode;
    }

    public final void setEOSCharCode(Object object) throws TMException {
        int n = ASCIITableConverter.convertEOSObjectToInt(object);
        if (this.status == 0) {
            this.eosCharCode = n;
            this.eosCharByteArray[0] = (byte)n;
            this.eosCharCodeObject = object;
            return;
        }
        try {
            this.setHardwareEOSChar(n);
            this.eosCharCode = n;
            this.eosCharByteArray[0] = (byte)this.eosCharCode;
            this.eosCharCodeObject = object;
        }
        catch (Exception exception) {
            VisaGeneral.displayError(exception.getMessage());
        }
    }

    public final Object getEOSCharCode() {
        return this.eosCharCodeObject;
    }

    public final void setEOSMode(int n) throws TMException {
        if (this.status == 0) {
            this.eosMode = n;
            this.postPropertyChangedEvent("EOSMode", EOSMODES[this.eosMode]);
            return;
        }
        try {
            this.setHardwareEOSMode(n);
            this.eosMode = n;
            this.postPropertyChangedEvent("EOSMode", EOSMODES[this.eosMode]);
        }
        catch (Exception exception) {
            VisaGeneral.displayError(exception.getMessage());
        }
    }

    public final int getEOSMode() {
        return this.eosMode;
    }

    public void setRsrcName(String string) throws TMException {
        VisaGeneral.displayError(this.createReadOnlyPropertyError("RsrcName"));
    }

    public String getRsrcName() {
        return this.rsrcName;
    }

    protected void setHardwareEOIMode(boolean bl) throws TMException {
        this.visa.setProperty(this.handle, 100, this.bool2int(bl));
    }

    protected void setHardwareEOSChar(int n) throws TMException {
        this.visa.setHardwareEOSChar(this.handle, 102, n, this.eosMode);
    }

    protected void setHardwareEOSMode(int n) throws TMException {
        this.visa.setHardwareEOSMode(this.handle, 101, n, this.eosCharCode);
    }

    @Override
    protected void setHardwareTimeout(double d) throws TMException {
        this.visa.setHardwareTimeout(this.handle, d, 104);
    }

    @Override
    protected double getHardwareTimeout() {
        int n = this.visa.Get(this.handle, 104);
        return (double)n / 1000.0;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.eventTime = Calendar.getInstance();
        if (this.timerFcn != ACTION) {
            this.executeEvent(6, "Timer", this.eventTime, new ICEvent("Timer", VisaGeneral.constructClockVector(this.eventTime)));
        }
    }

    @Override
    protected void createTimer() {
        this.timer = new Timer((int)(this.timerPeriod * 1000.0), (ActionListener)this, 1, 5, "VisaGeneralTimer");
        this.timer.start();
        this.wasTimerStarted = true;
    }

    @Override
    protected void openHardware() throws TMException {
        int[] nArray;
        if (this.isInUse()) {
            VisaGeneral.displayError("The specified configuration: " + this.rsrcName + " is not available.  " + LINESEP + HW_NOT_AVAILABLE_ERROR);
        }
        if ((nArray = this.visa.Create(this, this.rsrcName)) != null) {
            this.handle = nArray[0];
            this.defaultRM = nArray[1];
        } else {
            VisaGeneral.displayError("Could not open VISA object. Use INSTRHWINFO for a list of available configurations.");
        }
        Object[] objectArray = this.visa.GetAliasInfo(this.visaName);
        if (objectArray != null) {
            this.parseName((String)objectArray[1]);
        }
    }

    @Override
    protected void updatePropsOnOpen() throws TMException {
        this.setHardwareEOIMode(this.eoiMode);
        this.setHardwareTimeout(this.timeout);
        this.timeout = this.getHardwareTimeout();
    }

    @Override
    public boolean supportsAsynchronousOperations() {
        return this.objectPolls;
    }

    @Override
    protected void addToPoller() {
        if (this.objectPolls) {
            Poller.addInstrument(this);
        }
        if (this.timerFcn == ACTION) {
            return;
        }
        if (!this.wasTimerStarted) {
            this.createTimer();
        } else {
            this.timer.setDelay((int)(this.timerPeriod * 1000.0));
            this.timer.reset();
        }
    }

    @Override
    protected void closeHardware() throws TMException {
        int n;
        if (this.objectPolls) {
            Poller.removeInstrument(this);
        }
        if (this.wasTimerStarted) {
            this.timer.hold();
        }
        if ((n = this.visa.Close(this.handle, this.defaultRM)) < 0) {
            VisaGeneral.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n));
        }
    }

    @Override
    protected void disposeMLArrayRefs() {
        this.superDisposeMLArrayRef();
        if (this.timer != null) {
            this.timer.removeActionListener((ActionListener)this);
        }
    }

    @Override
    protected void hardwareStopAsync() {
        this.oldTransferStatus = this.transferStatus;
        switch (this.transferStatus) {
            case 1: {
                this.visa.StopAsync(this.handle, this.readId);
                break;
            }
            case 2: {
                this.visa.StopAsync(this.handle, this.writeId);
            }
        }
    }

    @Override
    public final Object[] constructorargs() {
        String string = (String)this.info[0];
        int n = string.lastIndexOf(FILESEP);
        Object[] objectArray = new Object[]{string.substring(0, n), string.substring(n + 1), this.rsrcName, this.alias};
        return objectArray;
    }

    @Override
    public final String getConstructor() {
        return "visa('" + this.info[2] + "', '" + this.rsrcName + "');";
    }

    @Override
    public String getConstructorDescription() {
        return "Vendor - " + this.info[2] + ", Resource Name - " + this.rsrcName;
    }

    @Override
    public String getInstrfindArgs() {
        return "('Type', '" + this.type + "', 'RsrcName', '" + this.rsrcName + "', 'Tag', '" + this.tag + "');";
    }

    @Override
    protected void hardwareFlushInput() {
    }

    @Override
    protected void hardwareFlushOutput() throws TMException {
        this.oldTransferStatus = this.transferStatus;
        switch (this.transferStatus) {
            case 2: {
                this.visa.StopAsync(this.handle, this.writeId);
            }
        }
    }

    @Override
    protected void verifyWriteOperation(int n) throws TMException {
        this.visa.verifyWriteOperation(n, (String)this.info[2], this.type, this.transferStatus);
    }

    @Override
    protected void verifyReadOperation() throws TMException {
        this.visa.verifyReadOperation((String)this.info[2], this.type, this.transferStatus);
        this.transferStatus = 1;
    }

    @Override
    public int getAsyncActionType(int n, int n2) {
        if (n == 0) {
            n = this.transferStatus == 2 ? 2 : (this.transferStatus == 1 ? 0 : (this.oldTransferStatus == 2 ? 2 : (this.oldTransferStatus == 1 ? 0 : -1)));
        }
        return n;
    }

    @Override
    protected String getAsciiMessage(Object[] objectArray) {
        return this.getAsciiMessage(objectArray, this.eosMode, this.eosCharCode);
    }

    @Override
    protected String getAsciiMessage(String string) {
        return this.getAsciiMessage(string, this.eosMode, this.eosCharCode);
    }

    @Override
    protected void updateWriteTransferStatus(boolean bl) {
        this.transferStatus = bl ? 2 : 0;
    }

    @Override
    protected int writeAsciiToHardware(String string) {
        return this.visa.Write(this.handle, string, string.length());
    }

    @Override
    protected int writeBinaryToHardware(Object object, int n, int n2) {
        if (platformByteOrder != this.byteOrder) {
            Object object2 = null;
            try {
                object2 = BinarySwapBytes.swap(object, n2, n);
            }
            catch (Exception exception) {
                return -1;
            }
            object = object2;
        }
        return this.visa.writeBytes(this.handle, object, n, n2);
    }

    @Override
    public int writeBinaryToHardwareAsync(byte[] byArray) {
        int n = this.visa.WriteBinaryByteAsync(this.handle, byArray, byArray.length);
        if (n >= 0) {
            this.writeId = n;
        }
        return n;
    }

    @Override
    protected String removeTerminator(String string) {
        return this.removeTerminator(string, this.eosMode, this.eosCharCode);
    }

    @Override
    protected Object[] readAsciiFromHardware(int n, double d) {
        return this.visa.Read(this.handle, n);
    }

    @Override
    protected Object[] readBinaryFromHardware(int n, double d) {
        return this.visa.ReadBinary(this.handle, n, 0);
    }

    @Override
    public byte[] readAsynchronousDataFromHardware(int n) {
        return this.visa.GetAsyncReadData(this.handle, n);
    }

    @Override
    public int readBinaryFromHardwareAsync(int n) {
        int n2 = this.visa.ReadBinaryByteAsync(this.handle, n);
        if (n2 >= 0) {
            this.readId = n2;
        }
        return n2;
    }

    @Override
    protected int okToGenerateTerminatorBytesAvailableEvent(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return 0;
        }
        if (byArray[byArray.length - 1] == this.eosCharCode) {
            return 1;
        }
        return 0;
    }

    @Override
    protected String getErrorMessageFromHardware(int n) {
        return "VISA: " + this.visa.TranslateErrorCode(this.handle, n);
    }

    @Override
    protected int getSuccessValue() {
        return 0;
    }

    @Override
    protected String wasAsciiReadSuccessful(String string, int n, int n2) {
        String string2 = "";
        switch (n) {
            case 0: {
                if (n2 != 0 || string.length() != this.inputBufferSize) break;
                string2 = "The input buffer was filled before the EOI line was asserted.";
                break;
            }
            default: {
                if (string.length() == n) break;
                string2 = "The EOI line was asserted before SIZE values were available.";
            }
        }
        return string2;
    }

    @Override
    protected String wasBinaryReadSuccessful(int n, int n2, String string, int n3) {
        if (!string.equals("")) {
            return string;
        }
        if (n < n2) {
            return "The EOI line was asserted before SIZE values were available.";
        }
        return "";
    }

    @Override
    protected String getTimeoutMessage(int n, int n2) {
        if (n == 0) {
            return "A timeout occurred before the EOI line was asserted.";
        }
        return "A timeout occurred before the EOI line was asserted or SIZE values were available.";
    }

    public char spoll(int n) throws TMException {
        return this.visa.spoll(this.handle, n, this.getHardwareTimeout());
    }

    public Object ObjectHardwareInfo() {
        return this.visa.ObjectHardwareInfo(this.info, this.handle);
    }

    @Override
    protected Object[] getHwInfoStruct() {
        this.ObjectHardwareInfo();
        return this.info;
    }

    @Override
    protected String[] getHwInfoFields() {
        return HWINFO_FIELDS;
    }

    public abstract void updateNameProperties();

    public abstract boolean isInUse();

    public abstract void parseName(String var1);
}

