/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.hardware;

import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowser;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowserPage;
import com.mathworks.toolbox.instrument.browser.hardware.BoardPage;
import com.mathworks.toolbox.instrument.browser.interfaceobj.CommunicationInfo;
import com.mathworks.toolbox.instrument.browser.interfaceobj.CommunicationPage;
import com.mathworks.toolbox.instrument.browser.objects.BrowserObject;
import com.mathworks.toolbox.instrument.browser.objects.GPIBObject;
import com.mathworks.toolbox.testmeas.browser.BrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.util.Vector;
import javax.swing.JPanel;
import org.w3c.dom.Element;

public class GPIBBoardPage
extends BoardPage {
    private String GPIBBoardIndex = "";
    private static final long serialVersionUID = 1L;
    private Object[] info;

    public GPIBBoardPage(InstrumentControlBrowser instrumentControlBrowser, String string, String string2, String string3, Object[] objectArray) {
        super(instrumentControlBrowser, string, string2, string3, "GPIB");
        this.info = objectArray;
        this.GPIBBoardIndex = string3;
        this.init();
    }

    @Override
    protected void init() {
        this.infoLabel = "Board";
        this.statusMessage = "Scanning for GPIB instruments";
        this.headings = new String[3];
        this.headings[0] = "Primary Address";
        this.headings[1] = "Secondary Address";
        this.headings[2] = "Identification";
        super.init();
    }

    @Override
    public void load(String string, String string2, String string3, Element element) {
        String string4 = element.getAttribute("PrimaryAddress");
        String string5 = element.getAttribute("SecondaryAddress");
        String string6 = element.getAttribute("Identification");
        Object[] objectArray = new Object[]{string4, string5, string6};
        this.tableModel.append(objectArray);
        this.data = this.tableModel.getData();
        String string7 = "PAD-" + string4;
        BrowserTreeNode browserTreeNode = this.createNode(string7, string, string3, string4, string5, string6, string2);
        this.lastNodes.addElement(browserTreeNode);
    }

    public void updateInfo(Object[] objectArray) {
        this.info = objectArray;
    }

    @Override
    public void scanForAll() {
        this.scanForAll(true, true);
    }

    @Override
    public void scanForAll(boolean bl, boolean bl2) {
        super.scanForAll(bl, bl2);
    }

    protected void updateTableData(String string) {
        if (this.headings == null) {
            return;
        }
        String[] stringArray = (String[])this.info[2];
        String[] stringArray2 = (String[])this.info[3];
        String[] stringArray3 = (String[])this.info[4];
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            vector.addElement(stringArray2[i]);
            vector.addElement("0");
            vector.addElement(stringArray3[i]);
        }
        String string2 = TMStringUtil.getDate();
        this.lastScanDateLabel.setText("Last scan date: " + string2);
        this.constructDataArray(TMStringUtil.vector2StringArray(vector), string2);
        if (this.table != null) {
            this.tableModel.setData(this.data);
        }
    }

    protected void updateTableData() {
        this.updateTableData(this.GPIBBoardIndex);
    }

    @Override
    protected void constructDataArray(Object object, String string) {
        if (this.headings == null) {
            this.init();
        }
        String[] stringArray = (String[])object;
        int n = 0;
        this.data = new Object[stringArray.length / 3][this.headings.length];
        String string2 = (String)this.matlabArgs[2];
        String string3 = (String)this.matlabArgs[3];
        if (this.data.length == 0) {
            this.data = new Object[1][this.headings.length];
            this.data[0][0] = "";
            this.data[0][1] = "";
            this.data[0][2] = NO_INSTRUMENT_STRING;
        } else {
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i][0] = stringArray[n++];
                this.data[i][1] = stringArray[n++];
                this.data[i][2] = stringArray[n++];
                String string4 = "PAD-" + this.data[i][0];
                BrowserTreeNode browserTreeNode = this.createNode(string4, string2, string3, (String)this.data[i][0], (String)this.data[i][1], (String)this.data[i][2], string);
                this.currentNodes.add(browserTreeNode);
            }
        }
        this.cleanupNodes();
    }

    private BrowserTreeNode createNode(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        String string8 = this.defineNodeIDString(string6);
        BrowserTreeNode browserTreeNode = this.browser.getNode(this.path, string);
        if (string6.equals(NO_INSTRUMENT_STRING)) {
            if (browserTreeNode == null) {
                browserTreeNode = new BrowserTreeNode(string + string8, (BrowserClient)this.browser);
                browserTreeNode.setType(16);
                browserTreeNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\gpib_instrument.html");
                browserTreeNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "gpib_config");
                browserTreeNode.setPanel((JPanel)((Object)new InstrumentControlBrowserPage()));
                browserTreeNode.setUserData((Object)new Integer(NO_INSTRUMENT_NODE_COUNT++));
                this.browser.addNode(string, this.path, browserTreeNode);
            }
        } else if (browserTreeNode == null) {
            browserTreeNode = new BrowserTreeNode(string + string8, (BrowserClient)this.browser);
            browserTreeNode.setType(4);
            browserTreeNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\gpib_instrument.html");
            browserTreeNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "gpib_config");
            GPIBObject gPIBObject = new GPIBObject(string2, string3, string4, string5, string6, string7);
            CommunicationPage communicationPage = CommunicationPage.getInstance(this.browser);
            CommunicationInfo communicationInfo = new CommunicationInfo(gPIBObject);
            this.browser.addToCommunicationInfoStore(communicationInfo);
            gPIBObject.setPanel(communicationPage);
            browserTreeNode.setPanel((JPanel)((Object)communicationPage));
            browserTreeNode.setUserData((Object)communicationInfo);
            this.browser.addNode(string, this.path, browserTreeNode);
        } else {
            CommunicationInfo communicationInfo = (CommunicationInfo)browserTreeNode.getUserData();
            BrowserObject browserObject = communicationInfo.getBrowserObject();
            browserObject.setIdentification(string6);
            browserObject.setScanDate(string7);
            browserTreeNode.setName(string + string8);
        }
        return browserTreeNode;
    }
}

