/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.hardware;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.Support;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.DefaultSortableTable;
import com.mathworks.toolbox.instrument.I2C;
import com.mathworks.toolbox.instrument.I2CAARDVARK;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowser;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowserPage;
import com.mathworks.toolbox.instrument.browser.interfaceobj.CommunicationInfo;
import com.mathworks.toolbox.instrument.browser.interfaceobj.CommunicationPage;
import com.mathworks.toolbox.instrument.browser.objects.BrowserObject;
import com.mathworks.toolbox.instrument.browser.objects.I2CObject;
import com.mathworks.toolbox.instrument.guiutil.MatrixTableModel;
import com.mathworks.toolbox.testmeas.browser.BrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserConfigFileWriter;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import org.w3c.dom.Element;

public class I2CHardwarePage
extends InstrumentControlBrowserPage
implements ActionListener {
    private String[] fHeadings = new String[]{"Adaptor", "Board Index", "Board Serial", "Remote Address"};
    private Object[][] fData;
    private static final int I2C_SLAVE_ADDRESS_MIN = 8;
    private static final int I2C_SLAVE_ADDRESS_MAX = 119;
    private DefaultSortableTable fTable;
    private MatrixTableModel fTableModel;
    private JButton fScanButton;
    private JLabel fLastScanDateLabel;
    private String fInitialDate;
    private InstrumentControlBrowser fBrowser;
    private String[] fPath = new String[]{"Instrument Control Toolbox", "Hardware", "I2C"};
    private Object[] fMatlabArgs;
    private Vector<BrowserTreeNode> fCurrentNodes = new Vector();
    private Vector<BrowserTreeNode> fLastNodes = new Vector();
    private boolean fDisableonStart = false;
    private boolean fEnableOnFinish = false;
    private String sAdaptorPath;
    private static int MAX_BOARDS_PER_VENDOR = 50;
    private static double HARDWARE_TIMEOUT_FOR_SCAN = 0.01;
    protected static final ResourceBundle sResources = ResourceBundle.getBundle("com.mathworks.toolbox.instrument.browser.resources.RES_BROWSER");

    public I2CHardwarePage(InstrumentControlBrowser instrumentControlBrowser) {
        this.fBrowser = instrumentControlBrowser;
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.layoutPanel();
        this.fMatlabArgs = new Object[2];
        this.fMatlabArgs[0] = "privateBrowserHelper";
        this.fMatlabArgs[1] = "identifyI2C";
        this.cleanup();
    }

    private void layoutPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 10, 0, 10));
        this.add(jPanel, "Center");
        this.fTableModel = new MatrixTableModel(this.fHeadings);
        this.fTableModel.setData(this.fData);
        this.fTable = new DefaultSortableTable((TableModel)this.fTableModel);
        this.fTable.setName("I2C Hardware Table");
        this.fTable.getColumnModel().getColumn(0).setPreferredWidth(300);
        this.fTable.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.fTable.getColumnModel().getColumn(2).setPreferredWidth(300);
        this.fTable.getColumnModel().getColumn(3).setPreferredWidth(300);
        JTableHeader jTableHeader = this.fTable.getTableHeader();
        jTableHeader.setReorderingAllowed(true);
        JScrollPane jScrollPane = new JScrollPane((Component)this.fTable);
        jPanel.add((Component)jScrollPane, "Center");
        jScrollPane.setPreferredSize(new Dimension(50, 50));
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
        this.fInitialDate = TMStringUtil.getDate();
        this.fLastScanDateLabel = new JLabel("Last scan date: " + this.fInitialDate);
        jPanel2.add((Component)this.fLastScanDateLabel, "West");
        jPanel2.add((Component)this.createButtonPanel(), "Center");
        jPanel.add((Component)jPanel2, "South");
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1, 0, 0));
        this.fScanButton = new JButton("Scan");
        this.fScanButton.addActionListener(this);
        this.fScanButton.setName("I2C Scan Button");
        jPanel2.add(this.fScanButton);
        jPanel.add(jPanel2);
        return jPanel;
    }

    @Override
    public void setup() {
        this.fScanButton.addActionListener(this);
    }

    @Override
    public void cleanup() {
        this.fScanButton.removeActionListener(this);
    }

    @Override
    public void dispose() {
        this.cleanup();
        this.fHeadings = null;
        this.fData = null;
    }

    public void save(BrowserConfigFileWriter browserConfigFileWriter, Element element) {
    }

    public void load(String string, String string2, Element element) {
        this.fLastScanDateLabel.setText(string2);
        int n = string2.indexOf(": ");
        string2 = string2.substring(n + 2);
        String string3 = element.getAttribute("Vendor");
        String string4 = element.getAttribute("RemoteAddress");
        String string5 = element.getAttribute("BoardIndex");
        Object[] objectArray = new Object[this.fHeadings.length];
        objectArray[0] = string3;
        objectArray[1] = string5;
        objectArray[2] = string;
        objectArray[3] = string4;
        this.fTableModel.append(objectArray);
        this.fData = this.fTableModel.getData();
        BrowserTreeNode browserTreeNode = this.createNode(string3, string, string2, string4, Integer.parseInt(string5));
        this.fLastNodes.add(browserTreeNode);
    }

    public void addInitialNodes(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            BrowserTreeNode browserTreeNode = this.createNode(stringArray[i], "No instrument was identified", "N/A", this.fInitialDate, i);
            this.fLastNodes.add(browserTreeNode);
        }
        this.initTableData(stringArray);
    }

    private void initTableData(String[] stringArray) {
        this.fData = null;
        if (stringArray == null) {
            return;
        }
        this.fData = new Object[stringArray.length][this.fHeadings.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.fData[i][0] = stringArray[i];
            this.fData[i][1] = "No instrument was identified";
            this.fData[i][2] = "N/A";
        }
        if (this.fTableModel != null) {
            this.fTableModel.setData(this.fData);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.fDisableonStart = true;
        this.fEnableOnFinish = true;
        this.getGUIReadyForMATLABCall();
    }

    public void scanForAll() {
        this.fDisableonStart = true;
        this.fEnableOnFinish = true;
        this.getGUIReadyForMATLABCall();
    }

    @Override
    public void scanForAll(boolean bl, boolean bl2) {
        this.fDisableonStart = bl;
        this.fEnableOnFinish = bl2;
        this.getGUIReadyForMATLABCall();
    }

    public void getGUIReadyForMATLABCall() {
        this.fScanButton.setEnabled(false);
        if (this.fDisableonStart) {
            this.fBrowser.postBlockEventsEvent(true);
        }
        this.fBrowser.postStatusBarUpdateEvent("Scanning for I2C devices");
        Instrument.enableInstrumentObjectEvents(false);
        SwingUtilities.invokeLater(new updateHardwarePage());
    }

    private void updateTableData(String[] stringArray) {
        if (this.fHeadings == null) {
            return;
        }
        String string = TMStringUtil.getDate();
        this.fLastScanDateLabel.setText("Last scan date: " + string);
        String[] stringArray2 = stringArray;
        int n = 0;
        if (stringArray2 != null) {
            n = stringArray2.length;
        }
        this.fData = new Object[n / this.fHeadings.length][this.fHeadings.length];
        if (this.fData.length == 0) {
            this.fData = new Object[1][this.fHeadings.length];
            this.fData[0][0] = "No I2C adaptors were found. Device may be in use or disconnected";
            this.fData[0][1] = "N/A";
            this.fData[0][2] = "N/A";
            this.fData[0][3] = "N/A";
        } else {
            for (int i = 0; i < this.fData.length; ++i) {
                this.fData[i][0] = stringArray2[this.fHeadings.length * i];
                this.fData[i][1] = stringArray2[this.fHeadings.length * i + 1];
                this.fData[i][2] = stringArray2[this.fHeadings.length * i + 2];
                this.fData[i][3] = stringArray2[this.fHeadings.length * i + 3];
                if (!(this.fData[i][2] != "In Use" & this.fData[i][3] != "No slaves found")) continue;
                BrowserTreeNode browserTreeNode = this.createNode((String)this.fData[i][0], (String)this.fData[i][2], (String)this.fData[i][3], string, Integer.parseInt((String)this.fData[i][1]));
                this.fCurrentNodes.add(browserTreeNode);
            }
        }
        if (this.fTableModel != null) {
            this.fTableModel.setData(this.fData);
        }
        this.cleanupNodes();
    }

    private BrowserTreeNode createNode(String string, String string2, String string3, String string4, int n) {
        String string5 = string + ":" + string2 + ":[Remote Address: " + string3 + "]";
        BrowserTreeNode browserTreeNode = this.fBrowser.getNode(this.fPath, string5);
        if (browserTreeNode == null) {
            browserTreeNode = new BrowserTreeNode(string5, (BrowserClient)this.fBrowser);
            browserTreeNode.setType(4);
            browserTreeNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\i2c_instrument.html");
            browserTreeNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "i2c_config");
            I2CObject i2CObject = I2CObject.factoryCreate(string, string2, string3, n, string4);
            CommunicationPage communicationPage = CommunicationPage.getInstance(this.fBrowser);
            CommunicationInfo communicationInfo = new CommunicationInfo(i2CObject);
            this.fBrowser.addToCommunicationInfoStore(communicationInfo);
            i2CObject.setPanel(communicationPage);
            browserTreeNode.setPanel((JPanel)((Object)communicationPage));
            browserTreeNode.setUserData((Object)communicationInfo);
            this.fBrowser.addNode(string5, this.fPath, browserTreeNode);
        } else {
            CommunicationInfo communicationInfo = (CommunicationInfo)browserTreeNode.getUserData();
            BrowserObject browserObject = communicationInfo.getBrowserObject();
            browserObject.setIdentification(string2);
            browserObject.setScanDate(string4);
            browserTreeNode.setName(string5);
        }
        return browserTreeNode;
    }

    private String defineNodeIDString(String string) {
        return "";
    }

    private void cleanupNodes() {
        for (int i = 0; i < this.fLastNodes.size(); ++i) {
            if (this.fCurrentNodes.contains(this.fLastNodes.elementAt(i))) continue;
            BrowserTreeNode browserTreeNode = this.fLastNodes.elementAt(i);
            this.fBrowser.removeNode(browserTreeNode.getName(), this.fPath, browserTreeNode.getUserData());
            this.fBrowser.removeBrowserObjectFromCommunicationInfoStore((CommunicationInfo)browserTreeNode.getUserData());
        }
        this.fLastNodes = this.fCurrentNodes;
        this.fCurrentNodes = null;
        this.fCurrentNodes = new Vector();
    }

    private class updateHardwarePage
    implements Runnable {
        private ArrayList<String> aVendorsAndBoardSerials;

        private updateHardwarePage() {
        }

        @Override
        public void run() {
            this.aVendorsAndBoardSerials = new ArrayList();
            if (I2CHardwarePage.this.sAdaptorPath == null) {
                I2CHardwarePage.this.sAdaptorPath = this.getPathToNativeAdaptorLibrary();
            }
            String[] stringArray = new String[]{""};
            try {
                stringArray = I2C.findValidAdaptors(I2CHardwarePage.this.sAdaptorPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Instrument instrument = null;
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    int n;
                    Class<?> clazz = Class.forName("com.mathworks.toolbox.instrument.I2C" + stringArray[i].toUpperCase());
                    Constructor<?> constructor = clazz.getDeclaredConstructor(String.class, String.class, Integer.TYPE, Integer.TYPE);
                    instrument = (I2C)constructor.newInstance(I2CHardwarePage.this.sAdaptorPath + File.separator + "mw" + stringArray[i].toLowerCase() + "i2c" + Instrument.extension(), stringArray[i].toLowerCase(), 0, 0);
                    Object[] objectArray = ((I2C)instrument).hardwareInfo(I2CHardwarePage.this.sAdaptorPath, stringArray[i], "");
                    ((I2C)instrument).dispose();
                    Integer[] integerArray = (Integer[])objectArray[7];
                    Integer[] integerArray2 = (Integer[])objectArray[3];
                    int n2 = integerArray == null ? 0 : integerArray.length;
                    int n3 = integerArray2 == null ? 0 : integerArray2.length;
                    for (n = 0; n < n3; ++n) {
                        instrument = (I2C)constructor.newInstance(I2CHardwarePage.this.sAdaptorPath + File.separator + "mw" + stringArray[i].toLowerCase() + "i2c" + Instrument.extension(), stringArray[i].toLowerCase(), integerArray2[n], 0);
                        String string = ((I2C)instrument).getBoardSerial();
                        this.aVendorsAndBoardSerials.add(stringArray[i]);
                        this.aVendorsAndBoardSerials.add(Integer.toString(integerArray2[n]));
                        this.aVendorsAndBoardSerials.add(string);
                        I2CSlaveFinder i2CSlaveFinder = new I2CSlaveFinder();
                        i2CSlaveFinder.findI2CSlaves((I2C)instrument);
                        ((I2C)instrument).dispose();
                    }
                    for (n = 0; n < n2; ++n) {
                        this.aVendorsAndBoardSerials.add(stringArray[i]);
                        this.aVendorsAndBoardSerials.add(Integer.toString(integerArray[n]));
                        this.aVendorsAndBoardSerials.add("In Use");
                        this.aVendorsAndBoardSerials.add("N/A");
                    }
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.out.println("InternalError:I2CHardwarePage: Could not find adaptor class specialization!");
                    classNotFoundException.printStackTrace();
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    System.out.println("InternalError:I2CHardwarePage:Could not create adaptor object!");
                    noSuchMethodException.printStackTrace();
                    break;
                }
                catch (Exception exception) {
                    if (!instrument.isvalid()) break;
                    try {
                        ((I2C)instrument).dispose();
                    }
                    catch (TMException tMException) {}
                    break;
                }
            }
            I2CHardwarePage.this.updateTableData(this.aVendorsAndBoardSerials.toArray(new String[this.aVendorsAndBoardSerials.size()]));
            I2CHardwarePage.this.fBrowser.postStatusBarUpdateEvent("");
            I2CHardwarePage.this.fBrowser.postBlockEventsEvent(false);
            I2CHardwarePage.this.fScanButton.setEnabled(true);
            I2CHardwarePage.this.fBrowser.postRefreshFinishedEvent();
            Instrument.enableInstrumentObjectEvents(true);
        }

        private String getPathToNativeAdaptorLibrary() {
            return Matlab.matlabRoot() + File.separator + "toolbox" + File.separator + "instrument" + File.separator + "instrumentadaptors" + File.separator + Support.arch();
        }

        protected class I2CSlaveFinder {
            int initTargetPower = 1;
            double initTimeout = 10.0;
            int initPullups = 1;

            protected I2CSlaveFinder() {
            }

            private void findI2CSlaves(I2C i2C) {
                if (this.prepareI2CObjectForScanning(i2C)) {
                    int n = 0;
                    for (int i = 8; i < 119; ++i) {
                        boolean bl;
                        try {
                            i2C.setRemoteAddress(i);
                        }
                        catch (TMException tMException) {
                            this.cleanupI2CObjectAfterScanning(i2C);
                            return;
                        }
                        try {
                            bl = i2C.hasI2CSlaveReturnedAck();
                        }
                        catch (Exception exception) {
                            this.cleanupI2CObjectAfterScanning(i2C);
                            return;
                        }
                        if (!bl) continue;
                        ++n;
                        updateHardwarePage.this.aVendorsAndBoardSerials.add("0x" + Integer.toHexString(i));
                        updateHardwarePage.this.aVendorsAndBoardSerials.add(updateHardwarePage.this.aVendorsAndBoardSerials.get(updateHardwarePage.this.aVendorsAndBoardSerials.size() - I2CHardwarePage.this.fHeadings.length));
                        updateHardwarePage.this.aVendorsAndBoardSerials.add(updateHardwarePage.this.aVendorsAndBoardSerials.get(updateHardwarePage.this.aVendorsAndBoardSerials.size() - I2CHardwarePage.this.fHeadings.length));
                        updateHardwarePage.this.aVendorsAndBoardSerials.add(updateHardwarePage.this.aVendorsAndBoardSerials.get(updateHardwarePage.this.aVendorsAndBoardSerials.size() - I2CHardwarePage.this.fHeadings.length));
                    }
                    this.cleanupI2CObjectAfterScanning(i2C);
                    if (n > 0) {
                        updateHardwarePage.this.aVendorsAndBoardSerials.remove(updateHardwarePage.this.aVendorsAndBoardSerials.size() - 1);
                        updateHardwarePage.this.aVendorsAndBoardSerials.remove(updateHardwarePage.this.aVendorsAndBoardSerials.size() - 1);
                        updateHardwarePage.this.aVendorsAndBoardSerials.remove(updateHardwarePage.this.aVendorsAndBoardSerials.size() - 1);
                    } else {
                        updateHardwarePage.this.aVendorsAndBoardSerials.add("No slaves found");
                    }
                }
            }

            private boolean prepareI2CObjectForScanning(I2C i2C) {
                if (i2C.getStatus() == 0) {
                    try {
                        i2C.fopen();
                        this.initTimeout = i2C.getTimeout();
                        this.initPullups = i2C.getPullupResistors();
                    }
                    catch (TMException tMException) {
                        return false;
                    }
                }
                try {
                    I2CAARDVARK i2CAARDVARK = (I2CAARDVARK)i2C;
                    this.initTargetPower = i2CAARDVARK.getTargetPower();
                    i2CAARDVARK.setTargetPower(1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    i2C.setPullupResistors(1);
                }
                catch (TMException tMException) {
                    // empty catch block
                }
                try {
                    i2C.setTimeout(HARDWARE_TIMEOUT_FOR_SCAN);
                }
                catch (Exception exception) {
                    return false;
                }
                return true;
            }

            private void cleanupI2CObjectAfterScanning(I2C i2C) {
                try {
                    I2CAARDVARK i2CAARDVARK = (I2CAARDVARK)i2C;
                    i2CAARDVARK.setTargetPower(this.initTargetPower);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    i2C.setPullupResistors(this.initPullups);
                }
                catch (TMException tMException) {
                    // empty catch block
                }
                try {
                    i2C.setTimeout(this.initTimeout);
                    i2C.fclose();
                }
                catch (TMException tMException) {
                    // empty catch block
                }
            }
        }
    }
}

