/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.drivers.vxipnp.sub;

import com.mathworks.toolbox.instrument.device.drivers.vxipnp.VXIPnPHeaderParser;
import com.mathworks.toolbox.instrument.device.drivers.vxipnp.sub.AttributeIdentifier;
import com.mathworks.toolbox.instrument.device.drivers.vxipnp.sub.ClassIdentifier;
import com.mathworks.toolbox.instrument.device.drivers.vxipnp.sub.FunctionIdentifier;
import com.mathworks.toolbox.instrument.device.drivers.vxipnp.sub.ValueSet;
import com.mathworks.toolbox.testmeas.util.TMException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;

public class SubFileParser {
    protected String fileName;
    protected FileReader fr = null;
    protected BufferedReader reader = null;
    protected String subType = "";
    protected String subVersion = "";
    protected Hashtable<String, ValueSet> valueSets;
    protected Hashtable<String, FunctionIdentifier> functionIdentifiers;
    protected Hashtable<String, ClassIdentifier> classIdentifiers;
    protected Hashtable<String, AttributeIdentifier> attributeIdentifiers;
    protected ClassIdentifier[] currentClassIdentifier;
    protected int currentClassLevel;
    protected VXIPnPHeaderParser hp = null;

    public SubFileParser(String string) {
        this.fileName = string;
        this.valueSets = new Hashtable();
        this.functionIdentifiers = new Hashtable();
        this.classIdentifiers = new Hashtable();
        this.attributeIdentifiers = new Hashtable();
    }

    private String calculateHeaderFileName(String string) {
        String string2 = "";
        File file = new File(string);
        String string3 = file.getParent();
        File file2 = new File(string3);
        String string4 = file2.getParent();
        string2 = string4 + "\\Include\\" + file.getName().replaceFirst("sub", "h");
        if (new File(string2).exists()) {
            return string2;
        }
        File file3 = new File(string4);
        String string5 = file3.getParent();
        string2 = string5 + "\\Include\\" + file.getName().replaceFirst("sub", "h");
        return string2;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getSubVersion() {
        return this.subVersion;
    }

    public Hashtable<String, ValueSet> getValueSets() {
        return this.valueSets;
    }

    public Hashtable<String, FunctionIdentifier> getFunctionIdentifiers() {
        return this.functionIdentifiers;
    }

    public Hashtable<String, ClassIdentifier> getClassIdentifiers() {
        return this.classIdentifiers;
    }

    public Hashtable<String, AttributeIdentifier> getAttributeIdentifiers() {
        return this.attributeIdentifiers;
    }

    public void parse() throws TMException {
        String string = this.calculateHeaderFileName(this.fileName);
        this.hp = new VXIPnPHeaderParser(string);
        this.hp.parse();
        this.currentClassIdentifier = new ClassIdentifier[7];
        this.currentClassLevel = 0;
        try {
            this.fr = new FileReader(this.fileName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new TMException("File not found.");
        }
        this.reader = new BufferedReader(this.fr);
        String string2 = null;
        try {
            String string3;
            this.readHeader();
            while ((string3 = this.reader.readLine()) != null) {
                if (string3.length() == 0) continue;
                char c = string3.charAt(0);
                if (Character.isWhitespace(c)) {
                    if (string2 == null) continue;
                    string2 = string2 + '\n' + string3;
                    continue;
                }
                if (c == 'v') {
                    if (string2 != null) {
                        this.processItem(string2);
                    }
                    string2 = string3;
                    continue;
                }
                if (Character.isDigit(c)) {
                    if (string2 != null) {
                        this.processItem(string2);
                    }
                    if (Integer.parseInt(string3.substring(0, 1)) <= 7) {
                        string2 = string3;
                        continue;
                    }
                }
                throw new TMException("File does not comply with the VXIplug&play sub file format.");
            }
            if (string2 != null) {
                this.processItem(string2);
            }
        }
        catch (IOException iOException) {
            throw new TMException(iOException.getMessage());
        }
    }

    public void readHeader() throws IOException, TMException {
        if (!this.getNextLine().equals("FPAttributeValueFile")) {
            throw new TMException("File does not comply with the VXIplug&play sub file format.");
        }
        String string = this.getNextLine();
        String[] stringArray = string.split("[\\s=]+");
        if (!(stringArray.length >= 3 && stringArray[0].equals("n") && stringArray[1].equals("SubType") && stringArray[2].equals("\"IVI\""))) {
            throw new TMException("File does not comply with the VXIplug&play sub file format.");
        }
        this.subType = stringArray[2].replaceAll("\"", "");
        string = this.getNextLine();
        stringArray = string.split("[\\s=]+");
        if (stringArray.length < 3 || !stringArray[0].equals("n") || !stringArray[1].equals("SubVersion")) {
            throw new TMException("File does not comply with the VXIplug&play sub file format.");
        }
        this.subVersion = stringArray[2].replaceAll("\"", "");
    }

    protected void processItem(String string) throws TMException {
        if ((string = SubFileParser.removeEscapes(string)).charAt(0) == '0') {
            FunctionIdentifier functionIdentifier = FunctionIdentifier.initWithString(string);
            if (functionIdentifier == null) {
                return;
            }
            this.functionIdentifiers.put(functionIdentifier.getName(), functionIdentifier);
            return;
        }
        String[] stringArray = SubFileParser.split(string);
        if (string.charAt(0) == 'v') {
            ValueSet valueSet = ValueSet.initWithStringArray(stringArray);
            if (valueSet == null) {
                return;
            }
            this.valueSets.put(valueSet.getName().toLowerCase(), valueSet);
            return;
        }
        if (stringArray.length < 3) {
            return;
        }
        if (stringArray.length == 3 || stringArray[3].charAt(0) == '\"') {
            ClassIdentifier classIdentifier = (ClassIdentifier)ClassIdentifier.initWithStringArray(stringArray);
            if (classIdentifier == null) {
                return;
            }
            this.classIdentifiers.put(classIdentifier.getName(), classIdentifier);
            int n = classIdentifier.getLevel() - 1;
            if (n == this.currentClassLevel) {
                if (this.currentClassIdentifier[this.currentClassLevel] != null) {
                    classIdentifier.setParentClassName(this.currentClassIdentifier[this.currentClassLevel].getParentClassName());
                }
            } else if (n > this.currentClassLevel) {
                if (this.currentClassIdentifier[this.currentClassLevel] != null) {
                    classIdentifier.setParentClassName(this.currentClassIdentifier[this.currentClassLevel].getName());
                }
            } else if (n > 1 && this.currentClassIdentifier[this.currentClassLevel - 1] != null) {
                classIdentifier.setParentClassName(this.currentClassIdentifier[n - 1].getName());
            }
            this.currentClassIdentifier[n] = classIdentifier;
            this.currentClassLevel = n;
        } else {
            AttributeIdentifier attributeIdentifier = (AttributeIdentifier)AttributeIdentifier.initWithStringArray(stringArray);
            if (attributeIdentifier == null) {
                return;
            }
            if (this.currentClassIdentifier[attributeIdentifier.getLevel() - 1] != null) {
                attributeIdentifier.setParentClassName(this.currentClassIdentifier[attributeIdentifier.getLevel() - 1].getName());
            }
            int n = this.hp.getAtttributeID(attributeIdentifier.getMacroName());
            attributeIdentifier.setAttributeID(n);
            attributeIdentifier.setFlattenedClassName(this.calculateFlattenedClassName());
            this.attributeIdentifiers.put(attributeIdentifier.getName(), attributeIdentifier);
        }
    }

    private String calculateFlattenedClassName() {
        String string = "";
        if (this.currentClassLevel == 0 && this.currentClassIdentifier[0] == null) {
            return "parent";
        }
        for (int i = 0; i <= this.currentClassLevel; ++i) {
            String string2 = this.currentClassIdentifier[i].getName().replaceAll(" ", "");
            string2 = string2.substring(1, string2.length() - 1);
            string = string + string2;
        }
        return string;
    }

    public String getNextLine() throws IOException {
        String string;
        while ((string = this.reader.readLine()) != null && string.length() == 0) {
        }
        return string;
    }

    public static String formatHelpString(String string) {
        string = SubFileParser.formatMultilineString(string.trim());
        return SubFileParser.removeEscapes(string);
    }

    public static String formatMultilineString(String string) {
        return string.replaceAll("\"([\\s]*)\"", "");
    }

    public static String removeEscapes(String string) {
        int n;
        String string2 = "";
        int n2 = 0;
        block5: while ((n = string.indexOf(92, n2)) >= 0) {
            string2 = string2 + string.substring(n2, n);
            n2 = n + 1;
            if (n == string.length() - 1) {
                string2 = string2 + "\\";
                continue;
            }
            switch (string.charAt(n + 1)) {
                case 'n': {
                    string2 = string2 + "\n";
                    ++n2;
                    continue block5;
                }
                case '\\': {
                    string2 = string2 + "\\";
                    ++n2;
                    continue block5;
                }
                case '\"': {
                    string2 = string2 + "'";
                    ++n2;
                    continue block5;
                }
            }
            string2 = string2 + "\\";
        }
        if (n2 < string.length()) {
            string2 = string2 + string.substring(n2, string.length());
        }
        return string2;
    }

    public static String[] split(String string) {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        String[] stringArray = new String[20];
        int n2 = 0;
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\"') {
                bl = !bl;
                bl2 = false;
            } else if (Character.isWhitespace(cArray[i])) {
                if (!bl) {
                    if (!bl2) {
                        stringArray[n++] = string.substring(n2, i);
                        n2 = i + 1;
                        bl2 = true;
                    } else {
                        ++n2;
                    }
                }
            } else if (cArray[i] == '=') {
                if (!bl) {
                    if (!bl2) {
                        stringArray[n++] = string.substring(n2, i);
                        n2 = i + 1;
                        bl2 = true;
                    } else {
                        ++n2;
                    }
                }
            } else {
                bl2 = false;
            }
            if (n != stringArray.length) continue;
            String[] stringArray2 = new String[n + 20];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            stringArray = stringArray2;
        }
        if (!bl2 && n2 < string.length()) {
            stringArray[n++] = string.substring(n2, string.length());
        }
        if (n > 0) {
            String[] stringArray3 = new String[n];
            System.arraycopy(stringArray, 0, stringArray3, 0, n);
            return stringArray3;
        }
        return null;
    }
}

