/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtest.panel;

import com.mathworks.toolbox.instrument.device.guiutil.midtest.CodeGenerator;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.MIDTestToolClient;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.MIDTestToolFileWriter;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.FunctionInfo;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.MIDStepPanel;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.StepInfo;
import com.mathworks.toolbox.testmeas.guiutil.TMHelpViewer;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FunctionPanel
extends MIDStepPanel
implements ListSelectionListener,
ActionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    private static final String NO_HELP = "No help is defined for this function.";
    private JLabel functionsToTestLabel;
    private JList functionsToTest;
    private JLabel functionDefinitionLabel;
    private JLabel objectToTestLabel;
    private JLabel inputArgLabel;
    private JLabel outputArgLabel;
    private JTextField functionDefinition;
    private JComboBox objectToTest;
    private JTextField inputArg;
    private JTextField outputArg;
    private JTextField stepPassesOutputArgs;
    private JTextField stepPassesFunction;
    private JCheckBox noErrorStepPass;
    private JCheckBox argsStepPass;
    private JCheckBox functionStepPass;
    private JLabel tempLabel = new JLabel("");
    private JButton helpButton;
    private boolean isEnabled = true;
    private String[] defaultFunctionNames = new String[]{"devicereset", "geterror", "selftest"};
    protected Vector<String> functions;
    protected int[] functionLabelLocations;
    protected String[] functionLabelNames;
    protected int numOfFunctionGroups = 0;
    protected long driverLastModified = 0L;

    public FunctionPanel(MIDTestToolClient mIDTestToolClient) {
        this.client = mIDTestToolClient;
        this.layoutPanel();
        this.setName("Function Step Panel");
    }

    @Override
    public void update(StepInfo stepInfo) {
        FunctionInfo functionInfo = (FunctionInfo)stepInfo;
        if (!functionInfo.getNeedsToUpdate()) {
            this.functionsToTest.setSelectedIndex(functionInfo.getFunctionToTest());
            this.functionDefinition.setText(functionInfo.getFunctionDefinition());
            this.functionDefinition.setCaretPosition(0);
            try {
                this.objectToTest.setSelectedIndex(functionInfo.getObjectToTest());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.inputArg.setText(functionInfo.getInputArguments());
            this.outputArg.setText(functionInfo.getOutputArguments());
            this.noErrorStepPass.setSelected(functionInfo.getNoErrorStepPass());
            this.argsStepPass.setSelected(functionInfo.getArgsStepPass());
            this.functionStepPass.setSelected(functionInfo.getFunctionStepPass());
            this.stepPassesOutputArgs.setText(functionInfo.getStepPassesOutputArguments());
            this.stepPassesFunction.setText(functionInfo.getStepPassesFunction());
            return;
        }
        boolean bl = this.updateAfterDriverReload(functionInfo);
        if (!bl) {
            this.functionDefinition.setText("");
            this.outputArg.setText("");
            this.inputArg.setText("");
            this.noErrorStepPass.setSelected(true);
            this.argsStepPass.setSelected(false);
            this.functionStepPass.setSelected(false);
            this.stepPassesOutputArgs.setText("");
            this.stepPassesFunction.setText("");
        }
        functionInfo.setNeedsToUpdate(false);
    }

    public void updatePanelAfterDriverReload() {
        this.updateFunctionsInListBox();
    }

    private boolean updateAfterDriverReload(FunctionInfo functionInfo) {
        this.updateFunctionsInListBox();
        if (functionInfo.getFunction().equals("")) {
            this.functionsToTest.setSelectedIndex(0);
            return false;
        }
        String string = functionInfo.getGroup();
        String string2 = functionInfo.getFunction();
        int n = this.getFunctionIndex(string2, string);
        if (n == -1) {
            this.functionsToTest.setSelectedIndex(0);
            return false;
        }
        this.functionsToTest.setSelectedIndex(n);
        this.updateFunctionInformation(functionInfo.getFunction(), functionInfo.getGroup(), n);
        this.objectToTest.setSelectedItem(functionInfo.getObject());
        if (this.inputArg.isEnabled()) {
            this.inputArg.setText(functionInfo.getInputArguments());
        } else {
            this.inputArg.setText("");
        }
        if (this.outputArg.isEnabled()) {
            this.outputArg.setText(functionInfo.getOutputArguments());
        } else {
            this.outputArg.setText("");
        }
        this.noErrorStepPass.setSelected(functionInfo.getNoErrorStepPass());
        this.argsStepPass.setSelected(functionInfo.getArgsStepPass());
        this.functionStepPass.setSelected(functionInfo.getFunctionStepPass());
        this.stepPassesOutputArgs.setText(functionInfo.getStepPassesOutputArguments());
        this.stepPassesFunction.setText(functionInfo.getStepPassesFunction());
        return true;
    }

    @Override
    public void cleanup(StepInfo stepInfo) {
        FunctionInfo functionInfo = (FunctionInfo)stepInfo;
        functionInfo.setFunctionToTest(this.functionsToTest.getSelectedIndex());
        functionInfo.setFunctionDefinition(this.functionDefinition.getText());
        functionInfo.setObjectToTest(this.objectToTest.getSelectedIndex());
        functionInfo.setInputArguments(this.inputArg.getText());
        functionInfo.setOutputArguments(this.outputArg.getText());
        functionInfo.setNoErrorStepPass(this.noErrorStepPass.isSelected());
        functionInfo.setArgsStepPass(this.argsStepPass.isSelected());
        functionInfo.setFunctionStepPass(this.functionStepPass.isSelected());
        functionInfo.setStepPassesOutputArguments(this.stepPassesOutputArgs.getText());
        functionInfo.setStepPassesFunction(this.stepPassesFunction.getText());
        int n = this.functionsToTest.getSelectedIndex();
        if (n == -1) {
            n = 0;
        }
        functionInfo.setFunction(this.getFunction(n));
        functionInfo.setGroup(this.getSelectedFunctionGroup(n));
        functionInfo.setObject((String)this.objectToTest.getSelectedItem());
    }

    @Override
    public void save(MIDTestToolFileWriter mIDTestToolFileWriter, Element element, StepInfo stepInfo) {
        FunctionInfo functionInfo = (FunctionInfo)stepInfo;
        mIDTestToolFileWriter.addNode(element, "Name", functionInfo.getName());
        mIDTestToolFileWriter.addNode(element, "Function", functionInfo.getFunction());
        mIDTestToolFileWriter.addNode(element, "Group", functionInfo.getGroup());
        mIDTestToolFileWriter.addNode(element, "Object", functionInfo.getObject());
        mIDTestToolFileWriter.addNode(element, "FunctionIndex", functionInfo.getFunctionToTest());
        mIDTestToolFileWriter.addNode(element, "ObjectIndex", functionInfo.getObjectToTest());
        mIDTestToolFileWriter.addNode(element, "InputArguments", functionInfo.getInputArguments());
        mIDTestToolFileWriter.addNode(element, "OutputArguments", functionInfo.getOutputArguments());
        mIDTestToolFileWriter.addNode(element, "NoErrorStepPass", functionInfo.getNoErrorStepPass());
        mIDTestToolFileWriter.addNode(element, "ArgsStepPass", functionInfo.getArgsStepPass());
        mIDTestToolFileWriter.addNode(element, "FunctionStepPass", functionInfo.getFunctionStepPass());
        mIDTestToolFileWriter.addNode(element, "StepPassesOutputArguments", functionInfo.getStepPassesOutputArguments());
        mIDTestToolFileWriter.addNode(element, "StepPassesFunction", functionInfo.getStepPassesFunction());
    }

    @Override
    public void load(Node node, StepInfo stepInfo) {
        FunctionInfo functionInfo = (FunctionInfo)stepInfo;
        functionInfo.setNeedsToUpdate(true);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = nodeList.item(i).getNodeName();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            if (nodeList2.getLength() == 0) continue;
            if (string.equals("Name")) {
                functionInfo.setName(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string.equals("Function")) {
                functionInfo.setFunction(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string.equals("Group")) {
                functionInfo.setGroup(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string.equals("Object")) {
                functionInfo.setObject(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string.equals("FunctionIndex")) {
                functionInfo.setFunctionToTest(new Integer(nodeList2.item(0).getNodeValue()));
                continue;
            }
            if (string.equals("ObjectIndex")) {
                functionInfo.setObjectToTest(new Integer(nodeList2.item(0).getNodeValue()));
                continue;
            }
            if (string.equals("InputArguments")) {
                functionInfo.setInputArguments(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string.equals("OutputArguments")) {
                functionInfo.setOutputArguments(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string.equals("NoErrorStepPass")) {
                functionInfo.setNoErrorStepPass(new Boolean(nodeList2.item(0).getNodeValue()));
                continue;
            }
            if (string.equals("ArgsStepPass")) {
                functionInfo.setArgsStepPass(new Boolean(nodeList2.item(0).getNodeValue()));
                continue;
            }
            if (string.equals("FunctionStepPass")) {
                functionInfo.setFunctionStepPass(new Boolean(nodeList2.item(0).getNodeValue()));
                continue;
            }
            if (string.equals("StepPassesOutputArguments")) {
                functionInfo.setStepPassesOutputArguments(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (!string.equals("StepPassesFunction")) continue;
            functionInfo.setStepPassesFunction(nodeList2.item(0).getNodeValue());
        }
        functionInfo.setIsNodeDirty(false);
    }

    @Override
    public void duplicate(StepInfo stepInfo, StepInfo stepInfo2) {
        FunctionInfo functionInfo = (FunctionInfo)stepInfo;
        FunctionInfo functionInfo2 = (FunctionInfo)stepInfo2;
        functionInfo.setFunctionToTest(functionInfo2.getFunctionToTest());
        functionInfo.setFunctionDefinition(functionInfo2.getFunctionDefinition());
        functionInfo.setObjectToTest(functionInfo2.getObjectToTest());
        functionInfo.setInputArguments(functionInfo2.getInputArguments());
        functionInfo.setOutputArguments(functionInfo2.getOutputArguments());
        functionInfo.setNoErrorStepPass(functionInfo2.getNoErrorStepPass());
        functionInfo.setArgsStepPass(functionInfo2.getArgsStepPass());
        functionInfo.setFunctionStepPass(functionInfo2.getFunctionStepPass());
        functionInfo.setStepPassesOutputArguments(functionInfo2.getStepPassesOutputArguments());
        functionInfo.setStepPassesFunction(functionInfo2.getStepPassesFunction());
        functionInfo.setFunction(functionInfo2.getFunction());
        functionInfo.setGroup(functionInfo2.getGroup());
        functionInfo.setObject(functionInfo2.getObject());
    }

    private void layoutPanel() {
        this.setLayout(new BorderLayout(0, 0));
        JPanel jPanel = this.add(this.createFunctionToTestPanel(), this.createFunctionInfoPanel(), 5);
        JPanel jPanel2 = this.add(jPanel, this.createStepPassesPanel(), 5);
        this.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 0, 0));
        this.helpButton = new JButton("Show Help on Function...");
        this.helpButton.setName("Show Help on Function Button");
        this.helpButton.addActionListener(this);
        jPanel3.add(this.helpButton);
        this.add((Component)jPanel3, "South");
        this.valueChanged(new ListSelectionEvent(this.functionsToTest, 1, 1, false));
    }

    private JPanel createFunctionToTestPanel() {
        this.functionsToTestLabel = new JLabel("Function to test:");
        this.functionsToTestLabel.setVerticalAlignment(1);
        this.functionsToTest = new JList();
        this.functionsToTest.setSelectionMode(0);
        this.functionsToTest.setName("Function to test Listbox");
        this.functionsToTest.setListData(this.getFunctionListData());
        JScrollPane jScrollPane = new JScrollPane(this.functionsToTest);
        jScrollPane.setPreferredSize(new Dimension(70, 300));
        this.functionsToTest.addListSelectionListener(this);
        if (this.functionsToTest.getModel().getSize() > 0) {
            this.functionsToTest.setSelectedIndex(0);
        }
        JPanel jPanel = new JPanel(new BorderLayout(0, 4));
        jPanel.add((Component)this.functionsToTestLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        return jPanel;
    }

    private JPanel createFunctionInfoPanel() {
        this.functionDefinitionLabel = new JLabel("Function definition:");
        this.objectToTestLabel = new JLabel("Object(s) to test:");
        this.inputArgLabel = new JLabel("Input argument(s):");
        this.outputArgLabel = new JLabel("Output argument(s):");
        this.objectToTestLabel.setVerticalAlignment(1);
        this.inputArgLabel.setVerticalAlignment(1);
        this.outputArgLabel.setVerticalAlignment(1);
        this.functionDefinition = new JTextField(20);
        this.objectToTest = new JComboBox();
        this.inputArg = new JTextField();
        this.outputArg = new JTextField();
        this.functionDefinition.setEditable(false);
        this.functionDefinition.setBorder(null);
        this.functionDefinition.setBackground(this.functionDefinitionLabel.getBackground());
        this.functionDefinition.setForeground(this.functionDefinitionLabel.getForeground());
        this.functionDefinition.setCaretPosition(0);
        this.functionDefinition.addMouseListener(this);
        this.functionDefinition.setName("Function definition Label");
        this.objectToTest.setName("Object to test Combobox");
        this.inputArg.setName("Input arguments(s) Text Field");
        this.outputArg.setName("Output argument(s) Text Field");
        JPanel jPanel = new JPanel(new BorderLayout(4, 0));
        jPanel.add((Component)this.functionDefinitionLabel, "West");
        jPanel.add((Component)this.functionDefinition, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 4));
        jPanel2.add((Component)this.objectToTestLabel, "North");
        jPanel2.add((Component)this.objectToTest, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout(0, 4));
        jPanel3.add((Component)this.inputArgLabel, "North");
        jPanel3.add((Component)this.inputArg, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout(0, 4));
        jPanel4.add((Component)this.outputArgLabel, "North");
        jPanel4.add((Component)this.outputArg, "Center");
        JPanel jPanel5 = new JPanel(new GridLayout(3, 1, 0, 0));
        jPanel5.add(jPanel2);
        jPanel5.add(jPanel3);
        jPanel5.add(jPanel4);
        JPanel jPanel6 = new JPanel(new BorderLayout(0, 2));
        jPanel6.add((Component)jPanel, "North");
        jPanel6.add((Component)jPanel5, "Center");
        jPanel6.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        return jPanel6;
    }

    private JPanel createStepPassesPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        this.stepPassesOutputArgs = new JTextField();
        this.stepPassesFunction = new JTextField();
        this.noErrorStepPass = new JCheckBox("If no MATLAB or instrument error occurs", true);
        this.argsStepPass = new JCheckBox("If output arguments are: ", false);
        this.functionStepPass = new JCheckBox("If output of function: ", false);
        this.stepPassesOutputArgs.setName("Step Passes Output Arguments Text field");
        this.stepPassesFunction.setName("Step Passes Function Text Field");
        this.noErrorStepPass.setName("No error Checkbox");
        this.argsStepPass.setName("Matches CheckBox");
        this.functionStepPass.setName("Function CheckBox");
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1, 0, 0));
        jPanel2.setBorder(BorderFactory.createTitledBorder("Select when this step passes"));
        jPanel2.add(this.noErrorStepPass);
        jPanel2.add(this.addTextFieldToComponent(this.argsStepPass, this.stepPassesOutputArgs));
        jPanel2.add(this.createFunctionTestPanel(this.functionStepPass, this.stepPassesFunction));
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    private JPanel createFunctionTestPanel(JCheckBox jCheckBox, JTextField jTextField) {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        jPanel.add((Component)jCheckBox, "West");
        jPanel.add((Component)jTextField, "Center");
        JLabel jLabel = new JLabel("  is true");
        jPanel.add((Component)jLabel, "East");
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.functionsToTest.getSelectedIndex();
        String string = this.getSelectedFunctionGroup(n);
        String string2 = this.getFunctionHelp(string, n);
        string2 = "<html>" + string2 + "</html>";
        TMHelpViewer tMHelpViewer = TMHelpViewer.getInstance();
        tMHelpViewer.update(string2, this.getFunction(n) + " Help");
        tMHelpViewer.addToFrame();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting() || this.objectToTest == null) {
            return;
        }
        int n = this.functionsToTest.getSelectedIndex();
        if (this.isHeader(this.functionLabelLocations, n)) {
            this.setComponentsEnabled(false);
            this.functionDefinition.setText("");
            this.objectToTest.removeAllItems();
            return;
        }
        this.setComponentsEnabled(true);
        String string = this.getFunction(n);
        String string2 = this.getSelectedFunctionGroup(n);
        this.updateFunctionInformation(string, string2, n);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.tempLabel.setText(this.functionDefinition.getText());
        if (this.functionDefinition.getWidth() < this.tempLabel.getPreferredSize().width) {
            this.functionDefinition.setToolTipText(this.functionDefinition.getText());
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.functionDefinition.setToolTipText("");
    }

    private void updateFunctionInformation(String string, String string2, int n) {
        this.updateObjectToTest(string2);
        String string3 = this.getFunctionDefinition(string2, n);
        this.functionDefinition.setText(string3);
        this.functionDefinition.setCaretPosition(0);
        String string4 = "'" + string + "')";
        this.inputArg.setText("");
        if (this.isDefaultFunctionName(string, string2)) {
            this.enableInputArgument(false);
        } else if (string3.indexOf(string4) != -1) {
            this.enableInputArgument(false);
        } else {
            this.enableInputArgument(true);
        }
        this.outputArg.setText("");
        if (string3.indexOf("=") == -1) {
            this.enableOutputArgument(false);
        } else {
            this.enableOutputArgument(true);
        }
    }

    private void enableOutputArgument(boolean bl) {
        this.outputArg.setEnabled(bl);
        this.outputArgLabel.setEnabled(bl);
    }

    private void enableInputArgument(boolean bl) {
        this.inputArg.setEnabled(bl);
        this.inputArgLabel.setEnabled(bl);
    }

    private boolean isDefaultFunctionName(String string, String string2) {
        if (!string2.equals("parent")) {
            return false;
        }
        for (int i = 0; i < this.defaultFunctionNames.length; ++i) {
            if (!this.defaultFunctionNames[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    private void updateFunctionsInListBox() {
        this.functionsToTest.removeListSelectionListener(this);
        this.functionsToTest.setListData(this.getFunctionListData());
        this.functionsToTest.addListSelectionListener(this);
    }

    private void updateObjectToTest(String string) {
        this.objectToTest.removeAllItems();
        if (string.equals("parent")) {
            this.objectToTest.addItem("Device object");
            return;
        }
        int n = this.getGroupSize(string);
        for (int i = 0; i < n; ++i) {
            this.objectToTest.addItem(this.getGroupCommandNameAt(string, i + 1));
        }
        this.objectToTest.addItem("All " + string + " group objects");
    }

    public void setComponentsEnabled(boolean bl) {
        if (this.isEnabled == bl) {
            return;
        }
        this.functionDefinitionLabel.setEnabled(bl);
        this.objectToTestLabel.setEnabled(bl);
        this.inputArgLabel.setEnabled(bl);
        this.outputArgLabel.setEnabled(bl);
        this.objectToTest.setEnabled(bl);
        this.inputArg.setEnabled(bl);
        this.outputArg.setEnabled(bl);
        this.noErrorStepPass.setEnabled(bl);
        this.argsStepPass.setEnabled(bl);
        this.functionStepPass.setEnabled(bl);
        this.stepPassesOutputArgs.setEnabled(bl);
        this.stepPassesFunction.setEnabled(bl);
        this.helpButton.setEnabled(bl);
        if (!bl) {
            this.stepPassesOutputArgs.setText("");
            this.stepPassesFunction.setText("");
        }
        this.isEnabled = bl;
    }

    protected Vector<String> getFunctionListData() {
        if (this.getDriverDate() == this.driverLastModified) {
            return this.functions;
        }
        this.driverLastModified = this.getDriverDate();
        this.functions = new Vector();
        String[] stringArray = this.getGroupNames();
        this.functionLabelLocations = new int[stringArray.length + 1];
        this.functionLabelNames = new String[stringArray.length + 1];
        this.numOfFunctionGroups = 0;
        Vector<String> vector = this.getParser().getMethods("parent");
        Vector vector2 = vector == null ? new Vector() : (Vector)vector.clone();
        vector2.add("devicereset");
        vector2.add("geterror");
        vector2.add("selftest");
        vector2 = TMStringUtil.stringArray2Vector((String[])TMStringUtil.sort((String[])TMStringUtil.vector2StringArray((Vector)vector2)));
        this.addToVector(this.functions, vector2, "Device object functions:");
        this.functionLabelNames[this.numOfFunctionGroups] = "parent";
        this.functionLabelLocations[this.numOfFunctionGroups] = 0;
        ++this.numOfFunctionGroups;
        for (int i = 0; i < stringArray.length; ++i) {
            int n = this.functions.size();
            String string = stringArray[i] + " group object functions:";
            int n2 = this.addToVector(this.functions, this.getParser().getMethods(stringArray[i]), string);
            if (n2 == 0) continue;
            this.functionLabelNames[this.numOfFunctionGroups] = stringArray[i];
            this.functionLabelLocations[this.numOfFunctionGroups] = n;
            ++this.numOfFunctionGroups;
        }
        return this.functions;
    }

    protected int getFunctionIndex(String string, String string2) {
        for (int i = 0; i < this.numOfFunctionGroups; ++i) {
            String string3 = this.functionLabelNames[i];
            if (!string2.equals(string3)) continue;
            ListModel listModel = this.functionsToTest.getModel();
            int n = this.functionLabelLocations[i];
            int n2 = listModel.getSize();
            if (i != this.numOfFunctionGroups - 1) {
                n2 = this.functionLabelLocations[i + 1];
            }
            string = "    " + string;
            for (int j = n; j < n2; ++j) {
                if (!string.equals(listModel.getElementAt(j))) continue;
                return j;
            }
            return -1;
        }
        return -1;
    }

    protected String getSelectedFunctionGroup(int n) {
        String string = this.functionLabelNames[this.numOfFunctionGroups - 1];
        for (int i = 0; i < this.numOfFunctionGroups; ++i) {
            if (this.functionLabelLocations[i] <= n) continue;
            string = this.functionLabelNames[i - 1];
            break;
        }
        return string;
    }

    protected String getFunctionDefinition(String string, int n) {
        String string2 = this.getFunction(n);
        if (string2.equals("devicereset")) {
            return "devicereset(OBJ)";
        }
        if (string2.equals("geterror")) {
            return "MSG = geterror(OBJ)";
        }
        if (string2.equals("selftest")) {
            return "OUT = selftest(OBJ)";
        }
        return this.getParser().getMethodDefinition(string2, string).getInvokeCommand();
    }

    public String getFunctionHelp(String string, int n) {
        String string2 = this.getFunction(n);
        if (string2.equals("devicereset")) {
            return this.getDeviceResetHelp();
        }
        if (string2.equals("geterror")) {
            return this.getGetErrorHelp();
        }
        if (string2.equals("selftest")) {
            return this.getSelfTestHelp();
        }
        String string3 = this.getParser().getMethodDefinition(string2, string).getDescription();
        string3 = string3 == null || string3.equals("") ? NO_HELP : this.updateHtml(string3);
        return string3;
    }

    public boolean isFunctionHelpDefined(String string, int n) {
        String string2 = this.getFunctionHelp(string, n);
        return !string2.equals(NO_HELP);
    }

    public String getFunction(int n) {
        String string = this.functions.elementAt(n);
        for (int i = 0; i < this.functionLabelLocations.length; ++i) {
            if (n != this.functionLabelLocations[i]) continue;
            return string;
        }
        return string.substring("    ".length());
    }

    private String getDeviceResetHelp() {
        return "<p>DEVICERESET Reset instrument.</p><p> </p><p>DEVICERESET(OBJ) resets the instrument associated with deviceobj object, OBJ. </p>";
    }

    private String getGetErrorHelp() {
        return "<p>GETERROR Check and return error message from instrument.</p><p> </p><p>MSG = GETERROR(OBJ) checks the instrument associated with deviceobj object, OBJ, for an error message and returns to MSG. The interpretation of MSG will vary based on the instrument.</p>";
    }

    private String getSelfTestHelp() {
        return "<p>SELFTEST Run the instrument self-test.</p><p> </p><p>OUT = SELFTEST(OBJ) runs the self-test for the instrument associated with deviceobj object, OBJ and returns the result of the self-test to OUT. OUT will vary based on the instrument.</p>";
    }

    @Override
    public String generateCode(StepInfo stepInfo, boolean bl, boolean bl2, int n) {
        String string;
        FunctionInfo functionInfo = (FunctionInfo)stepInfo;
        boolean bl3 = false;
        if (this.isHeader(this.functionLabelLocations, functionInfo.getFunctionToTest())) {
            if (bl) {
                this.client.assignVariableInformation(new Integer(0));
            }
            return "";
        }
        String string2 = this.getDisplayFunction(bl);
        String string3 = this.getDisplayInsert(bl);
        String string4 = this.addLine("\n", "errorcode = false;");
        string4 = this.addLine(string4, "try");
        string4 = this.addTabbedLine(string4, "% Execute the function.");
        String string5 = functionInfo.getOutputArguments();
        int n2 = this.getNumberOfOutputArguments(string5);
        String[] stringArray = this.getOutputArguments(string5, n2);
        String string6 = this.getInvokeCommand(functionInfo, n2, string5);
        if (functionInfo.getGroup().equals("parent")) {
            string4 = this.addTabbedLine(string4, string6);
        } else {
            string4 = this.addTabbedLine(string4, "groupObj = get(deviceObj, '" + functionInfo.getGroup() + "');");
            String string7 = functionInfo.getObject();
            if (!string7.equals(string = "All " + functionInfo.getGroup() + " group objects")) {
                string4 = this.addTabbedLine(string4, "groupObj = groupObj(" + (functionInfo.getObjectToTest() + 1) + ");");
            } else {
                bl3 = true;
            }
            string4 = this.addTabbedLine(string4, string6);
        }
        if (n2 > 0) {
            string4 = this.addTabbedLine(string4, " ");
            string4 = this.addTabbedLine(string4, "% Store the result so that it can be returned.");
            string4 = this.addTabbedLine(string4, "varargout = {varargout{:}, " + string5 + "};");
        }
        string4 = this.addLine(string4, " ");
        string4 = this.addTabbedLine(string4, "% Check if instrument error occurred.");
        string4 = this.addTabbedLine(string4, "result = geterror(deviceObj);");
        if (functionInfo.getNoErrorStepPass()) {
            string4 = this.addTabbedLine(string4, "errorcode = ~strcmpi(result, noErrorMsg);");
            string4 = this.addTabbedLine(string4, "");
            string4 = this.addTabbedLine(string4, this.postMessage(bl, "An instrument error occurred while executing the function.", "result", true, "    "));
        }
        string4 = this.addLine(string4, "catch aException");
        string4 = this.addTabbedLine(string4, "% A MATLAB error occurred.");
        if (functionInfo.getNoErrorStepPass()) {
            string4 = this.addTabbedLine(string4, "errorcode = true;");
            string4 = this.addLine(string4, "");
            string4 = this.addTabbedLine(string4, "% Post information about error.");
            string4 = this.addTabbedLine(string4, string2 + "('" + CodeGenerator.generateColorCode(bl, "\"#FF0000\"", "A MATLAB error occurred while testing the function.") + string3 + "');");
            string4 = this.addTabbedLine(string4, string2 + "(" + CodeGenerator.generateColorCodeToEval(bl, "\"#FF0000\"", "aException.message") + ");");
        }
        string4 = this.addLine(string4, "end");
        if (functionInfo.getArgsStepPass()) {
            string4 = this.addLine(string4, " ");
            string4 = this.addLine(string4, "% Error if the function output argument(s) do not match the expected value(s).");
            string4 = this.addLine(string4, "if (errorcode == false)");
            switch (n2) {
                case 0: {
                    string4 = this.addTabbedLine(string4, string2 + "('This function returned no output arguments." + string3 + "');");
                    break;
                }
                case 1: {
                    string4 = this.addLine(string4, this.generateResultsCodeForOneOutput(bl, bl3, functionInfo, stringArray));
                    break;
                }
                default: {
                    string4 = this.addLine(string4, this.generateResultsCodeForMultipleOutput(bl, bl3, functionInfo, n2, stringArray));
                }
            }
            string4 = this.addLine(string4, "end");
        }
        if (functionInfo.getFunctionStepPass()) {
            string4 = this.addLine(string4, "");
            string4 = this.addLine(string4, "% Error if the output of the test function does not return true.");
            string4 = this.addLine(string4, "if (errorcode == false)");
            string4 = this.addTabbedLine(string4, "outputOfFeval = feval(" + functionInfo.getStepPassesFunction() + ");");
            string4 = this.addTabbedLine(string4, "");
            string4 = this.addTabbedLine(string4, "if (outputOfFeval == false)");
            string4 = this.addTabbedLine(string4, "    errorcode = true;");
            string4 = this.addTabbedLine(string4, "");
            string4 = this.addTabbedLine(string4, "    % Post information about error.");
            string4 = this.addTabbedLine(string4, "    " + string2 + "('The testing function did not return true." + string3 + "');");
            string4 = this.addTabbedLine(string4, "end");
            string4 = this.addLine(string4, "end");
        }
        if (bl) {
            this.client.assignVariableInformation(new Integer(n2));
            for (int i = 0; i < n2; ++i) {
                this.client.assignVariable(stringArray[i]);
            }
        }
        if (!bl2) {
            return string4;
        }
        int n3 = functionInfo.getFunctionToTest();
        string = functionInfo.getGroup();
        if (!this.isFunctionHelpDefined(string, n3)) {
            string4 = this.addLine(string4, "");
            string4 = this.addLine(string4, "% Post warnings.");
            string4 = this.addLine(string4, "warningOccurred = true;");
            string4 = this.addLine(string4, "stepWarningOccurred = true;");
            string4 = this.addLine(string4, string2 + "('" + CodeGenerator.generateColorCode(bl, "\"#0000FF\"", "Warning: No help is defined for the " + functionInfo.getFunction() + " function in the " + string + " group.") + string3 + "');");
        }
        return string4;
    }

    private String getInvokeCommand(FunctionInfo functionInfo, int n, String string) {
        String string2 = functionInfo.getFunction();
        if (string2.equals("devicereset")) {
            return "devicereset(deviceObj);";
        }
        if (string2.equals("geterror")) {
            if (n > 0) {
                return "[" + string + "] = geterror(deviceObj);";
            }
            return "geterror(deviceObj)";
        }
        if (string2.equals("selftest")) {
            if (n > 0) {
                return "[" + string + "] = selftest(deviceObj);";
            }
            return "selftest(deviceObj)";
        }
        String string3 = "";
        if (n > 0) {
            string3 = "[" + string + "] = ";
        }
        string3 = string3 + "invoke(";
        string3 = functionInfo.getGroup().equals("parent") ? string3 + "deviceObj, '" + functionInfo.getFunction() + "'" : string3 + "groupObj, '" + functionInfo.getFunction() + "'";
        string3 = functionInfo.getInputArguments().equals("") ? string3 + ");" : string3 + ", " + functionInfo.getInputArguments() + ");";
        return string3;
    }

    private String generateResultsCodeForOneOutput(boolean bl, boolean bl2, FunctionInfo functionInfo, String[] stringArray) {
        String string = this.getDisplayFunction(bl);
        String string2 = this.getDisplayInsert(bl);
        String string3 = "";
        String string4 = functionInfo.getOutputArguments();
        String string5 = this.fixQuotes(functionInfo.getStepPassesOutputArguments());
        String string6 = this.getDisplayTab(bl);
        String string7 = this.formatOutputValue(functionInfo.getStepPassesOutputArguments());
        if (bl2) {
            string3 = this.addTabbedLine(string3, "% Compare to the expected value.");
            string3 = this.addTabbedLine(string3, "expectedValue = cell(size(groupObj))';");
            string3 = this.addTabbedLine(string3, "[expectedValue{:}] = deal(" + string7 + ");");
            string3 = this.addTabbedLine(string3, "errorcode = ~isequal(" + string4 + ", expectedValue);");
        } else {
            string3 = this.addTabbedLine(string3, "% Compare to the expected value.");
            string3 = this.addTabbedLine(string3, "errorcode = ~isequal(" + string4 + ", " + string7 + ");");
        }
        string3 = this.addLine(string3, "");
        string3 = this.addTabbedLine(string3, "% Post information about test step failure.");
        string3 = this.addTabbedLine(string3, "if (errorcode == true)");
        string3 = this.addTabbedLine(string3, "    " + string + "('The function did not return the expected value." + string2 + "');");
        string3 = this.addLine(string3, "");
        string3 = this.addLine(string3, this.generatedPostResultsCode(string4, stringArray, bl));
        string3 = this.addTabbedLine(string3, "    % Post the expected values.");
        string3 = this.addTabbedLine(string3, "    " + string + "('Expected value:" + string2 + "');");
        string3 = this.addTabbedLine(string3, "    " + string + "(['" + string6 + string4 + " = " + string5 + string2 + "']);");
        string3 = this.addTabbedLine(string3, "end");
        return string3;
    }

    private String generateResultsCodeForMultipleOutput(boolean bl, boolean bl2, FunctionInfo functionInfo, int n, String[] stringArray) {
        String string = this.getDisplayFunction(bl);
        String string2 = this.getDisplayInsert(bl);
        String string3 = this.getDisplayTab(bl);
        String string4 = "";
        String string5 = functionInfo.getStepPassesOutputArguments();
        String string6 = functionInfo.getOutputArguments();
        String string7 = functionInfo.getStepPassesOutputArguments();
        if (bl2) {
            string4 = this.addTabbedLine(string4, "% Compare to the expected value.");
            string4 = this.addTabbedLine(string4, "expectedValue = cell(1, " + n + ");");
            string4 = this.addTabbedLine(string4, "args = " + this.getCellOfOutputArguments(string7, this.getNumberOfOutputArguments(string7)));
            string4 = this.addLine(string4, "");
            string4 = this.addTabbedLine(string4, "for i = 1:" + n);
            string4 = this.addTabbedLine(string4, "    temp = cell(size(groupObj))';");
            string4 = this.addTabbedLine(string4, "    [temp{:}] = deal(args{i});");
            string4 = this.addTabbedLine(string4, "    expectedValue{i} = temp;");
            string4 = this.addTabbedLine(string4, "end");
            string4 = this.addLine(string4, "");
            string4 = this.addTabbedLine(string4, "errorcode = ~isequal({" + string6 + "}, expectedValue);");
        } else {
            string4 = this.addTabbedLine(string4, "% Compare to the expected value.");
            string4 = this.addTabbedLine(string4, "errorcode = ~isequal({" + string6 + "}, {" + string5 + "});");
        }
        string4 = this.addLine(string4, "");
        string4 = this.addTabbedLine(string4, "% Post information about test step failure.");
        string4 = this.addTabbedLine(string4, "if (errorcode == true)");
        string4 = this.addTabbedLine(string4, "    " + string + "('The function did not return the expected value(s)." + string2 + "');");
        string4 = this.addLine(string4, "");
        string4 = this.addLine(string4, this.generatedPostResultsCode(string6, stringArray, bl));
        String[] stringArray2 = this.getOutputArguments(string7, n);
        string4 = this.addTabbedLine(string4, "    % Post the expected values.");
        string4 = this.addTabbedLine(string4, "    " + string + "('Expected values:" + string2 + "');");
        for (int i = 0; i < n; ++i) {
            string4 = this.addTabbedLine(string4, "    " + string + "(['" + string3 + stringArray[i] + ": " + this.fixQuotes(stringArray2[i]) + string2 + "']);");
        }
        string4 = this.addTabbedLine(string4, "end");
        return string4;
    }

    private String generatedPostResultsCode(String string, String[] stringArray, boolean bl) {
        String string2 = this.getDisplayFunction(bl);
        String string3 = this.getDisplayInsert(bl);
        String string4 = this.getDisplayTab(bl);
        String string5 = "{";
        for (int i = 0; i < stringArray.length; ++i) {
            string5 = string5 + "'" + stringArray[i] + "', ";
        }
        string5 = string5.substring(0, string5.length() - 2) + "};";
        String string6 = this.addTabbedLine("        % Post the results.", "");
        string6 = this.addTabbedLine(string6, "    " + string2 + "('Actual values:" + string3 + "');");
        string6 = this.addTabbedLine(string6, "    allOutputArguments     = {" + string + "};");
        string6 = this.addTabbedLine(string6, "    allOutputArgumentNames = " + string5);
        string6 = this.addTabbedLine(string6, "");
        string6 = this.addTabbedLine(string6, "    for j = 1:length(allOutputArguments)");
        string6 = this.addTabbedLine(string6, "        tempArg  = allOutputArguments{j};");
        string6 = this.addTabbedLine(string6, "        tempName = allOutputArgumentNames{j};");
        string6 = this.addTabbedLine(string6, "");
        string6 = this.addTabbedLine(string6, "        if ~iscell(tempArg)");
        string6 = this.addTabbedLine(string6, "            tempArg = {tempArg};");
        string6 = this.addTabbedLine(string6, "        end");
        string6 = this.addLine(string6, "");
        string6 = this.addTabbedLine(string6, "        % Loop through results and display them.");
        string6 = this.addTabbedLine(string6, "        for k = 1:length(tempArg)");
        string6 = this.addTabbedLine(string6, "            if isnumeric(tempArg{k}) && numel(tempArg{k}) < 10");
        string6 = this.addTabbedLine(string6, "                " + string2 + "(['" + string4 + "' tempName '(' num2str(k) '): ' num2str(tempArg{k}) '" + string3 + "']);");
        string6 = this.addTabbedLine(string6, "            elseif ischar(tempArg{k})");
        string6 = this.addTabbedLine(string6, "                " + string2 + "(['" + string4 + "' tempName '(' num2str(k) '): ' tempArg{k} '" + string3 + "']);");
        string6 = this.addTabbedLine(string6, "            else");
        string6 = this.addTabbedLine(string6, "                " + string2 + "(['" + string4 + "' tempName '(' num2str(k) '): ' num2str(size(tempArg{k}, 1)) ' by ' num2str(size(tempArg{k}, 2)) ' ' class(tempArg{k}) '" + string3 + "']);");
        string6 = this.addTabbedLine(string6, "            end");
        string6 = this.addTabbedLine(string6, "        end");
        string6 = this.addTabbedLine(string6, "    end");
        return string6;
    }

    private int getNumberOfOutputArguments(String string) {
        if (string.equals("")) {
            return 0;
        }
        int n = 1;
        int n2 = string.indexOf(",");
        while (n2 != -1) {
            ++n;
            n2 = string.indexOf(",", n2 + 1);
        }
        return n;
    }

    private String[] getOutputArguments(String string, int n) {
        if (n == 0) {
            return null;
        }
        string = TMStringUtil.strrep((String)string, (String)" ", (String)"");
        String[] stringArray = new String[n];
        int n2 = 0;
        int n3 = string.indexOf(",");
        int n4 = 0;
        while (n3 != -1) {
            stringArray[n2++] = string.substring(n4, n3);
            n4 = n3 + 1;
            n3 = string.indexOf(",", n3 + 1);
        }
        stringArray[n2] = string.substring(n4);
        return stringArray;
    }

    private String getCellOfOutputArguments(String string, int n) {
        if (n == 0) {
            return null;
        }
        String string2 = "";
        String[] stringArray = this.getOutputArguments(string, n);
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = string2 + this.formatOutputValue(stringArray[i]) + ", ";
        }
        return "{" + string2.substring(0, string2.length() - 2) + "}";
    }

    private String fixQuotes(String string) {
        if (string == null) {
            return "''";
        }
        if (string.startsWith("'")) {
            string = string.substring(1);
        }
        if (string.endsWith("'")) {
            string = string.substring(0, string.length() - 1);
        }
        return TMStringUtil.strrep((String)string, (String)"'", (String)"''");
    }

    public String formatOutputValue(String string) {
        if (string == null) {
            return "''";
        }
        if (TMStringUtil.isnumeric((String)string)) {
            return string;
        }
        if (TMStringUtil.isdouble((String)string)) {
            return string;
        }
        if (!string.startsWith("'")) {
            string = "'" + string;
        }
        if (!string.endsWith("'")) {
            string = string + "'";
        }
        return string;
    }

    private String getDisplayTab(boolean bl) {
        String string = "    ";
        if (bl) {
            string = "&nbsp;&nbsp;&nbsp;";
        }
        return string;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

