/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtest.panel;

import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.mlwidgets.html.HtmlComponentFactory;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.MessageListener;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.MessageService;
import com.mathworks.toolbox.instrument.guiutil.ICSaveDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class OutputPanel
extends JPanel
implements MessageListener {
    private static final long serialVersionUID = 1L;
    private static final int SHOW_ALL = 0;
    private static final int SHOW_WARNINGS = 1;
    private JComboBox verbosityLevel;
    private int lastVerbosityLevel = 0;
    private HtmlComponent outputWindow;
    private String text = "";

    public OutputPanel() {
        this.layoutPanel();
        MessageService.subscribe(this);
    }

    public void cleanup() {
        this.outputWindow.dispose();
        MessageService.unsubscribe(this);
    }

    private void layoutPanel() {
        this.setName("Output Panel");
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.createVerbosityPanel(), "North");
        this.outputWindow = HtmlComponentFactory.buildHtmlComponent((HtmlComponentFactory.HtmlComponentType[])new HtmlComponentFactory.HtmlComponentType[0]);
        this.outputWindow.setHtmlText("<html></html>");
        this.outputWindow.getComponent().setName("Output window");
        this.add(this.outputWindow.getComponent(), "Center");
    }

    private JPanel createVerbosityPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 1, 1, 0));
        this.verbosityLevel = new JComboBox();
        this.verbosityLevel.addItem("Show all results");
        this.verbosityLevel.addItem("Show all results including warnings");
        this.verbosityLevel.setName("Verbosity Combobox");
        jPanel.add((Component)new JLabel("Verbosity: "), "West");
        jPanel.add((Component)this.verbosityLevel, "Center");
        return jPanel;
    }

    @Override
    public void handleMessage(String string) {
        if (this.text.length() > 12) {
            this.text = this.text.substring(6, this.text.length() - 7);
        }
        this.text = "<html>" + this.text + "<p>" + string + "</p>" + "</html>";
        this.outputWindow.setHtmlText(this.text);
    }

    public void clearOutput() {
        this.text = "";
        this.outputWindow.setHtmlText("<html></html>");
    }

    public boolean hasOutputText() {
        return !this.text.equals("");
    }

    public void print() {
        this.outputWindow.print((HtmlDataListener)new HtmlDataListener<Boolean>(){

            public void dataRetrieved(Boolean bl) {
            }
        });
    }

    public void save(MJFrame mJFrame) {
        if (!ICSaveDialog.save(".html", "Save MATLAB Instrument Driver Test Results", "MATLAB Instrument Driver Test Results(*.html)", mJFrame)) {
            return;
        }
        String string = ICSaveDialog.getFileNameWithPath();
        try {
            File file = new File(string);
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(this.text);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("An error occurred while writing the html file.");
        }
    }

    public boolean reportWarnings() {
        int n = this.verbosityLevel.getSelectedIndex();
        switch (n) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public Component getHtmlComponent() {
        return this.outputWindow.getComponent();
    }

    public String getOutputVerbosity() {
        return (String)this.verbosityLevel.getSelectedItem();
    }

    public void setOutputVerbosity(String string) {
        this.verbosityLevel.setSelectedItem(string);
    }

    public boolean isDirty() {
        return this.lastVerbosityLevel != this.verbosityLevel.getSelectedIndex();
    }

    public void resetDirtyFlag() {
        this.lastVerbosityLevel = this.verbosityLevel.getSelectedIndex();
    }
}

