/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.icb;

import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.toolbox.instrument.icb.IJFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentListener;

public class QueryPanel
extends MJPanel {
    private static final long serialVersionUID = 1L;
    public static final int ASCII = 0;
    public static final int BINARY = 1;
    public static final int BINBLOCK = 2;
    public static final String[] FORMATS = new String[]{"ASCII", "Binary", "Binblock"};
    public static final String[] PRECISIONS = new String[]{"8-bit integer", "16-bit integer", "32-bit integer", "8-bit unsigned integer", "16-bit unsigned integer", "32-bit unsigned integer", "32-bit float", "64-bit float"};
    public static final String[] BYTE_ORDERS = new String[]{"Little Endian", "Big Endian"};
    public static final String[] AFTER_OUTPUT = new String[]{"Repeat query for new data", "Recycle original data", "Hold final value", "Output zero", "Stop simulation"};
    private MJTextField queryCommand;
    private MJLabel responseFormatLabel;
    private MJComboBox responseFormat;
    private MJLabel asciiFormattingLabel;
    private MJTextField asciiFormatting;
    private MJLabel precisionLabel;
    private MJComboBox precision;
    private MJLabel byteOrderLabel;
    private MJComboBox byteOrder;
    private MJLabel valuesToReadLabel;
    private MJTextField valuesToRead;
    private MJCheckBox removeBytes;
    private MJLabel afterOutputActionLabel;
    private MJComboBox afterOutputAction;
    private MJCheckBox enableFrames;
    private MJLabel frameSizeLabel;
    private MJTextField frameSize;

    public QueryPanel() {
        this.initComponents();
    }

    private void initComponents() {
        int n;
        this.setLayout(new GridBagLayout());
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel.setBorder((Border)new TitledBorder("Query command"));
        this.queryCommand = new MJTextField();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        mJPanel.add((Component)this.queryCommand, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)mJPanel, gridBagConstraints);
        mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel.setBorder((Border)new TitledBorder("Instrument response"));
        this.responseFormatLabel = new MJLabel("Data format:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        mJPanel.add((Component)this.responseFormatLabel, (Object)gridBagConstraints);
        this.responseFormat = new MJComboBox();
        for (n = 0; n < FORMATS.length; ++n) {
            this.responseFormat.addItem((Object)new String(FORMATS[n]));
        }
        this.responseFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QueryPanel.this.responseFormatActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        mJPanel.add((Component)this.responseFormat, (Object)gridBagConstraints);
        this.asciiFormattingLabel = new MJLabel("ASCII format string:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        mJPanel.add((Component)this.asciiFormattingLabel, (Object)gridBagConstraints);
        this.asciiFormatting = new MJTextField();
        this.asciiFormatting.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        mJPanel.add((Component)this.asciiFormatting, (Object)gridBagConstraints);
        this.precisionLabel = new MJLabel("Precision:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        mJPanel.add((Component)this.precisionLabel, (Object)gridBagConstraints);
        this.precision = new MJComboBox();
        for (n = 0; n < PRECISIONS.length; ++n) {
            this.precision.addItem((Object)new String(PRECISIONS[n]));
        }
        this.precision.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QueryPanel.this.updateByteOrderStatus();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        mJPanel.add((Component)this.precision, (Object)gridBagConstraints);
        this.byteOrderLabel = new MJLabel("Byte order:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        mJPanel.add((Component)this.byteOrderLabel, (Object)gridBagConstraints);
        this.byteOrder = new MJComboBox();
        for (n = 0; n < BYTE_ORDERS.length; ++n) {
            this.byteOrder.addItem((Object)new String(BYTE_ORDERS[n]));
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        mJPanel.add((Component)this.byteOrder, (Object)gridBagConstraints);
        this.valuesToReadLabel = new MJLabel("Binary values to read:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        mJPanel.add((Component)this.valuesToReadLabel, (Object)gridBagConstraints);
        this.valuesToRead = new MJTextField();
        this.valuesToRead.setColumns(IJFrame.sSmallColumnWidth);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        mJPanel.add((Component)this.valuesToRead, (Object)gridBagConstraints);
        this.removeBytes = new MJCheckBox();
        this.removeBytes.setText("Remove any additional bytes from input buffer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        mJPanel.add((Component)this.removeBytes, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)mJPanel, gridBagConstraints);
        mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel.setBorder((Border)new TitledBorder("Response output"));
        this.afterOutputActionLabel = new MJLabel("After initial response:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        mJPanel.add((Component)this.afterOutputActionLabel, (Object)gridBagConstraints);
        this.afterOutputAction = new MJComboBox();
        for (n = 0; n < AFTER_OUTPUT.length; ++n) {
            this.afterOutputAction.addItem((Object)new String(AFTER_OUTPUT[n]));
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        mJPanel.add((Component)this.afterOutputAction, (Object)gridBagConstraints);
        this.enableFrames = new MJCheckBox("Enable frame output");
        this.enableFrames.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                QueryPanel.this.enableFramesItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        mJPanel.add((Component)this.enableFrames, (Object)gridBagConstraints);
        this.frameSizeLabel = new MJLabel("Frame size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 23, 5, 0);
        gridBagConstraints.anchor = 17;
        mJPanel.add((Component)this.frameSizeLabel, (Object)gridBagConstraints);
        this.frameSize = new MJTextField();
        this.frameSize.setColumns(IJFrame.sSmallColumnWidth);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        gridBagConstraints.anchor = 17;
        mJPanel.add((Component)this.frameSize, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)mJPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new MJPanel(), gridBagConstraints);
        this.responseFormat.setSelectedIndex(0);
        this.afterOutputAction.setSelectedIndex(0);
    }

    public void addActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.responseFormat.addActionListener(actionListener);
        this.precision.addActionListener(actionListener);
        this.byteOrder.addActionListener(actionListener);
        this.afterOutputAction.addActionListener(actionListener);
    }

    public void addItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        this.removeBytes.addItemListener(itemListener);
        this.enableFrames.addItemListener(itemListener);
    }

    public void addTextListener(DocumentListener documentListener) {
        if (documentListener == null) {
            return;
        }
        this.queryCommand.getDocument().addDocumentListener(documentListener);
        this.asciiFormatting.getDocument().addDocumentListener(documentListener);
        this.valuesToRead.getDocument().addDocumentListener(documentListener);
        this.frameSize.getDocument().addDocumentListener(documentListener);
    }

    public int getParameterValues(String[] stringArray, String[] stringArray2, int n) {
        stringArray[n] = new String("queryCommand");
        String string = this.queryCommand.getText();
        stringArray2[n++] = string.length() == 0 ? "''" : string;
        stringArray[n] = new String("responseFormat");
        stringArray2[n++] = (String)this.responseFormat.getSelectedItem();
        stringArray[n] = new String("asciiFormatting");
        string = this.asciiFormatting.getText();
        stringArray2[n++] = string.length() == 0 ? "''" : string;
        stringArray[n] = new String("precision");
        stringArray2[n++] = (String)this.precision.getSelectedItem();
        stringArray[n] = new String("byteOrder");
        stringArray2[n++] = (String)this.byteOrder.getSelectedItem();
        stringArray[n] = new String("valuesToRead");
        stringArray2[n++] = this.valuesToRead.getText();
        stringArray[n] = new String("removeBytes");
        stringArray2[n++] = new String(IJFrame.booleanToString(this.removeBytes.isSelected()));
        stringArray[n] = new String("afterOutputAction");
        stringArray2[n++] = (String)this.afterOutputAction.getSelectedItem();
        stringArray[n] = new String("enableFrames");
        stringArray2[n++] = new String(IJFrame.booleanToString(this.enableFrames.isSelected()));
        stringArray[n] = new String("frameSize");
        stringArray2[n++] = this.frameSize.getText();
        return n;
    }

    public void setParameterValues(String[] stringArray, String[] stringArray2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], stringArray2[i]);
        }
        this.setParameterValues(hashMap);
    }

    public void setParameterValues(Map<String, String> map) {
        String string = map.get("queryCommand");
        if (string.equalsIgnoreCase("''")) {
            this.queryCommand.setText("");
        } else {
            this.queryCommand.setText(string);
        }
        this.responseFormat.setSelectedItem((Object)map.get("responseFormat"));
        string = map.get("asciiFormatting");
        if (string.equalsIgnoreCase("''")) {
            this.asciiFormatting.setText("");
        } else {
            this.asciiFormatting.setText(string);
        }
        this.precision.setSelectedItem((Object)map.get("precision"));
        this.byteOrder.setSelectedItem((Object)map.get("byteOrder"));
        this.valuesToRead.setText(map.get("valuesToRead"));
        if (map.get("removeBytes").compareToIgnoreCase("on") == 0) {
            this.removeBytes.setSelected(true);
        } else {
            this.removeBytes.setSelected(false);
        }
        this.afterOutputAction.setSelectedItem((Object)map.get("afterOutputAction"));
        if (map.get("enableFrames").compareToIgnoreCase("on") == 0) {
            this.enableFrames.setSelected(true);
            this.frameSize.setEnabled(true);
        } else {
            this.enableFrames.setSelected(false);
            this.frameSize.setEnabled(false);
        }
        this.frameSize.setText(map.get("frameSize"));
    }

    public void disableComponents() {
        this.queryCommand.setEnabled(false);
        this.queryCommand.setBackground(this.getBackground());
        this.responseFormatLabel.setEnabled(false);
        this.responseFormat.setEnabled(false);
        this.asciiFormatting.setEnabled(false);
        this.asciiFormatting.setBackground(this.getBackground());
        this.asciiFormattingLabel.setEnabled(false);
        this.precision.setEnabled(false);
        this.precisionLabel.setEnabled(false);
        this.byteOrder.setEnabled(false);
        this.byteOrderLabel.setEnabled(false);
        this.valuesToRead.setEnabled(false);
        this.valuesToRead.setBackground(this.getBackground());
        this.valuesToReadLabel.setEnabled(false);
        this.removeBytes.setEnabled(false);
        this.afterOutputActionLabel.setEnabled(false);
        this.afterOutputAction.setEnabled(false);
        this.enableFrames.setEnabled(false);
        this.frameSize.setEnabled(false);
        this.frameSize.setBackground(this.getBackground());
        this.frameSizeLabel.setEnabled(false);
    }

    public void enableComponents() {
        this.queryCommand.setEnabled(true);
        this.queryCommand.setBackground(Color.white);
        this.responseFormatLabel.setEnabled(true);
        this.responseFormat.setEnabled(true);
        this.responseFormatActionPerformed();
        this.removeBytes.setEnabled(true);
        this.afterOutputActionLabel.setEnabled(true);
        this.afterOutputAction.setEnabled(true);
        this.enableFrames.setEnabled(true);
        if (this.enableFrames.isSelected()) {
            this.frameSize.setEnabled(true);
            this.frameSize.setBackground(Color.white);
            this.frameSizeLabel.setEnabled(true);
        }
    }

    private boolean isMultibytePrecision() {
        int n = this.precision.getSelectedIndex();
        return n != 0 && n != 3;
    }

    private void enableASCII() {
        this.asciiFormatting.setEnabled(true);
        this.asciiFormatting.setBackground(Color.white);
        this.asciiFormattingLabel.setEnabled(true);
        this.precision.setEnabled(false);
        this.precisionLabel.setEnabled(false);
        this.byteOrder.setEnabled(false);
        this.byteOrderLabel.setEnabled(false);
        this.valuesToRead.setEnabled(false);
        this.valuesToRead.setBackground(this.getBackground());
        this.valuesToReadLabel.setEnabled(false);
    }

    private void enableBinary() {
        this.asciiFormatting.setEnabled(false);
        this.asciiFormatting.setBackground(this.getBackground());
        this.asciiFormattingLabel.setEnabled(false);
        this.precision.setEnabled(true);
        this.precisionLabel.setEnabled(true);
        this.updateByteOrderStatus();
        this.valuesToRead.setEnabled(true);
        this.valuesToRead.setBackground(Color.white);
        this.valuesToReadLabel.setEnabled(true);
    }

    private void enableBinblock() {
        this.asciiFormatting.setEnabled(false);
        this.asciiFormatting.setBackground(this.getBackground());
        this.asciiFormattingLabel.setEnabled(false);
        this.precision.setEnabled(true);
        this.precisionLabel.setEnabled(true);
        this.updateByteOrderStatus();
        this.valuesToRead.setEnabled(false);
        this.valuesToRead.setBackground(this.getBackground());
        this.valuesToReadLabel.setEnabled(false);
    }

    private void enableFramesItemStateChanged(ItemEvent itemEvent) {
        if (this.enableFrames.isSelected()) {
            this.frameSizeLabel.setEnabled(true);
            this.frameSize.setEnabled(true);
            this.frameSize.setBackground(Color.white);
        } else {
            this.frameSizeLabel.setEnabled(false);
            this.frameSize.setEnabled(false);
            this.frameSize.setBackground(this.getBackground());
        }
    }

    private void responseFormatActionPerformed() {
        int n = this.responseFormat.getSelectedIndex();
        switch (n) {
            case 0: {
                this.enableASCII();
                break;
            }
            case 1: {
                this.enableBinary();
                break;
            }
            case 2: {
                this.enableBinblock();
            }
        }
    }

    private void updateByteOrderStatus() {
        if (this.isMultibytePrecision()) {
            this.byteOrder.setEnabled(true);
            this.byteOrderLabel.setEnabled(true);
        } else {
            this.byteOrder.setEnabled(false);
            this.byteOrderLabel.setEnabled(false);
        }
    }
}

