/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm;

import com.sun.jini.landlord.ConstrainableLandlordLease;
import com.sun.jini.landlord.Landlord;
import com.sun.jini.landlord.LandlordProxyVerifier;
import com.sun.jini.norm.AbstractProxy;
import com.sun.jini.norm.AdminProxy;
import com.sun.jini.norm.NormProxy;
import com.sun.jini.norm.NormServer;
import com.sun.jini.norm.SetProxy;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.id.Uuid;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.TrustEquivalence;

final class ProxyVerifier
implements Serializable,
TrustVerifier {
    private static final long serialVersionUID = 2L;
    private final RemoteMethodControl serverProxy;
    private final Uuid serverUuid;

    ProxyVerifier(NormServer normServer, Uuid uuid) {
        if (!(normServer instanceof RemoteMethodControl)) {
            throw new UnsupportedOperationException("Verifier requires service proxy to implement RemoteMethodControl");
        }
        if (!(normServer instanceof TrustEquivalence)) {
            throw new UnsupportedOperationException("Verifier requires service proxy to implement TrustEquivalence");
        }
        this.serverProxy = (RemoteMethodControl)normServer;
        this.serverUuid = uuid;
    }

    public boolean isTrustedObject(Object object, TrustVerifier.Context context) throws RemoteException {
        RemoteMethodControl remoteMethodControl;
        if (object == null || context == null) {
            throw new NullPointerException("Arguments must not be null");
        }
        if (object instanceof ConstrainableLandlordLease) {
            return new LandlordProxyVerifier((Landlord)this.serverProxy, this.serverUuid).isTrustedObject(object, context);
        }
        if (object instanceof SetProxy.ConstrainableSetProxy) {
            if (!this.isTrustedObject(((SetProxy)object).getRenewalSetLease(), context)) {
                return false;
            }
            remoteMethodControl = (RemoteMethodControl)((AbstractProxy)object).server;
        } else if (object instanceof AdminProxy.ConstrainableAdminProxy || object instanceof NormProxy.ConstrainableNormProxy) {
            if (!this.serverUuid.equals((Object)((AbstractProxy)object).uuid)) {
                return false;
            }
            remoteMethodControl = (RemoteMethodControl)((AbstractProxy)object).server;
        } else if (object instanceof RemoteMethodControl) {
            remoteMethodControl = (RemoteMethodControl)object;
        } else {
            return false;
        }
        MethodConstraints methodConstraints = remoteMethodControl.getConstraints();
        TrustEquivalence trustEquivalence = (TrustEquivalence)this.serverProxy.setConstraints(methodConstraints);
        return trustEquivalence.checkTrustEquivalence((Object)remoteMethodControl);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (!(this.serverProxy instanceof TrustEquivalence)) {
            throw new InvalidObjectException("serverProxy must implement TrustEquivalence");
        }
    }
}

