/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.UniqueTag;

class Arguments
extends IdScriptable {
    private Object callerObj;
    private Object calleeObj;
    private Object lengthObj;
    private NativeCall activation;
    private Object[] args;

    public Arguments(NativeCall nativeCall) {
        this.setMaxId(3);
        this.activation = nativeCall;
        Scriptable scriptable = nativeCall.getParentScope();
        this.setParentScope(scriptable);
        this.setPrototype(ScriptableObject.getObjectPrototype(scriptable));
        this.args = nativeCall.getOriginalArguments();
        this.lengthObj = new Integer(this.args.length);
        NativeFunction nativeFunction = nativeCall.funObj;
        this.calleeObj = nativeFunction;
        this.callerObj = nativeFunction.version <= 130 && nativeFunction.version != 0 ? null : Scriptable.NOT_FOUND;
    }

    public String getClassName() {
        return "Arguments";
    }

    public boolean has(int n, Scriptable scriptable) {
        if (0 <= n && n < this.args.length && this.args[n] != Scriptable.NOT_FOUND) {
            return true;
        }
        return super.has(n, scriptable);
    }

    public Object get(int n, Scriptable scriptable) {
        Object object;
        if (0 <= n && n < this.args.length && (object = this.args[n]) != Scriptable.NOT_FOUND) {
            String string;
            if (this.NOT_FOUND(n) && (object = this.activation.get(string = this.activation.funObj.argNames[n], (Scriptable)this.activation)) == Scriptable.NOT_FOUND) {
                Context.codeBug();
            }
            return object;
        }
        return super.get(n, scriptable);
    }

    private boolean NOT_FOUND(int n) {
        NativeFunction nativeFunction = this.activation.funObj;
        short s = nativeFunction.argCount;
        if (n < s) {
            if (n < s - 1) {
                String string = nativeFunction.argNames[n];
                int n2 = n + 1;
                while (n2 < s) {
                    if (string.equals(nativeFunction.argNames[n2])) {
                        return false;
                    }
                    ++n2;
                }
            }
            return true;
        }
        return false;
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (0 <= n && n < this.args.length && this.args[n] != Scriptable.NOT_FOUND) {
            if (this.NOT_FOUND(n)) {
                String string = this.activation.funObj.argNames[n];
                this.activation.put(string, (Scriptable)this.activation, object);
                return;
            }
            Arguments arguments = this;
            synchronized (arguments) {
                if (this.args[n] != Scriptable.NOT_FOUND) {
                    if (this.args == this.activation.getOriginalArguments()) {
                        this.args = (Object[])this.args.clone();
                    }
                    this.args[n] = object;
                    return;
                }
            }
        }
        super.put(n, scriptable, object);
    }

    public void delete(int n) {
        if (0 <= n && n < this.args.length) {
            Arguments arguments = this;
            synchronized (arguments) {
                if (this.args[n] != Scriptable.NOT_FOUND) {
                    if (this.args == this.activation.getOriginalArguments()) {
                        this.args = (Object[])this.args.clone();
                    }
                    this.args[n] = Scriptable.NOT_FOUND;
                    return;
                }
            }
        }
        super.delete(n);
    }

    protected int getIdDefaultAttributes(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                return 2;
            }
        }
        return super.getIdDefaultAttributes(n);
    }

    protected boolean hasIdValue(int n) {
        switch (n) {
            case 1: {
                return this.calleeObj != Scriptable.NOT_FOUND;
            }
            case 2: {
                return this.lengthObj != Scriptable.NOT_FOUND;
            }
            case 3: {
                return this.callerObj != Scriptable.NOT_FOUND;
            }
        }
        return super.hasIdValue(n);
    }

    protected Object getIdValue(int n) {
        switch (n) {
            case 1: {
                return this.calleeObj;
            }
            case 2: {
                return this.lengthObj;
            }
            case 3: {
                Object object = this.callerObj;
                if (object == UniqueTag.NULL_VALUE) {
                    object = null;
                } else if (object == null) {
                    NativeCall nativeCall = this.activation.caller;
                    object = nativeCall == null ? null : nativeCall.get("arguments", (Scriptable)nativeCall);
                }
                return object;
            }
        }
        return super.getIdValue(n);
    }

    protected void setIdValue(int n, Object object) {
        switch (n) {
            case 1: {
                this.calleeObj = object;
                return;
            }
            case 2: {
                this.lengthObj = object;
                return;
            }
            case 3: {
                this.callerObj = object != null ? object : UniqueTag.NULL_VALUE;
                return;
            }
        }
        super.setIdValue(n, object);
    }

    protected void deleteIdValue(int n) {
        switch (n) {
            case 1: {
                this.calleeObj = Scriptable.NOT_FOUND;
                return;
            }
            case 2: {
                this.lengthObj = Scriptable.NOT_FOUND;
                return;
            }
            case 3: {
                this.callerObj = Scriptable.NOT_FOUND;
                return;
            }
        }
        super.deleteIdValue(n);
    }

    protected String getIdName(int n) {
        switch (n) {
            case 1: {
                return "callee";
            }
            case 2: {
                return "length";
            }
            case 3: {
                return "caller";
            }
        }
        return null;
    }

    protected int mapNameToId(String string) {
        int n = 0;
        String string2 = null;
        if (string.length() == 6) {
            char c = string.charAt(5);
            if (c == 'e') {
                string2 = "callee";
                n = 1;
            } else if (c == 'h') {
                string2 = "length";
                n = 2;
            } else if (c == 'r') {
                string2 = "caller";
                n = 3;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }
}

