/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.appmanagement;

import com.mathworks.appmanagement.AppManagementApi;
import com.mathworks.appmanagement.AppManagementView;
import com.mathworks.appmanagement.AppMetadata;
import com.mathworks.appmanagement.AppMetadataException;
import com.mathworks.appmanagement.AppPrefKey;
import com.mathworks.appmanagement.DesktopApi;
import com.mathworks.appmanagement.MissingAppException;
import com.mathworks.appmanagement.PackagingApi;
import com.mathworks.appmanagement.ProductDependency;
import com.mathworks.appmanagement.SettingsUtility;
import com.mathworks.appmanagement.UserAppToolSetFactory;
import com.mathworks.install.InstalledProduct;
import com.mathworks.install.InstalledProductFactory;
import com.mathworks.instutil.FolderUtilsImpl;
import com.mathworks.instutil.VersionUtils;
import com.mathworks.jmi.Matlab;
import com.mathworks.toolstrip.factory.TSToolSet;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

final class AppManagementApiImpl
implements AppManagementApi {
    private static final String APPS = "Apps";
    private static final Object[] EMPTY_ARGS = new Object[0];
    private final AppInstallType[] appInstallTypes = new AppInstallType[]{new UpgradeAppInstallType(), new DowngradeAppInstallType(), new ReinstallInstallType(), new DefaultAppInstallType()};
    private final PackagingApi packagingApi;
    private final DesktopApi desktopApi;
    private final AppManagementView appManagementView;
    private final UserAppToolSetFactory userAppToolSetFactory;
    private final TSToolSet toolSet;
    private final ExecutorService appManagementExcutorService;

    AppManagementApiImpl(PackagingApi packagingApi, DesktopApi desktopApi, AppManagementView appManagementView, UserAppToolSetFactory userAppToolSetFactory, TSToolSet tSToolSet, ExecutorService executorService) {
        this.packagingApi = packagingApi;
        this.desktopApi = desktopApi;
        this.appManagementView = appManagementView;
        this.userAppToolSetFactory = userAppToolSetFactory;
        this.toolSet = tSToolSet;
        this.appManagementExcutorService = executorService;
    }

    @Override
    public void loadInstalledApps() {
        try {
            this.userAppToolSetFactory.addApps(this, this.getInstalledApps());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public final void installAsynchronously(final String string) {
        this.appManagementExcutorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    AppManagementApiImpl.this.install(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    @Override
    public final void install(String string) {
        File file = new File(string);
        try {
            if (FilenameUtils.directoryContains((String)this.getMyAppsLocation().getCanonicalPath(), (String)new File(new File(string).getParent()).getCanonicalPath())) {
                this.appManagementView.showAppInstallerInAppInstallFolderError(file.getName());
            } else {
                AppMetadata appMetadata = this.getAppMetadata(file);
                AppInstallType appInstallType = this.getAppInstallType(appMetadata);
                if (appInstallType.confirm(appMetadata) && this.checkProductDependencies(appMetadata)) {
                    this.uninstall(appMetadata.getGuid());
                    this.install(file, appMetadata);
                    appInstallType.notification(appMetadata);
                }
            }
        }
        catch (Throwable throwable) {
            this.appManagementView.handleInstallException(throwable);
        }
    }

    @Override
    public final void uninstallAsynchronously(final String string) {
        this.appManagementExcutorService.submit(new Runnable(){

            @Override
            public void run() {
                AppManagementApiImpl.this.uninstall(string);
            }
        });
    }

    @Override
    public final void uninstall(String string) {
        try {
            File file = this.getAppFileByGuid(string);
            AppMetadata appMetadata = this.getAppMetadata(file);
            File file2 = this.getAppInstallFolder(string);
            this.packagingApi.uninstall(file, file2);
            this.desktopApi.removeItem(appMetadata);
        }
        catch (MissingAppException missingAppException) {
        }
        catch (Exception exception) {
            this.appManagementView.handleUninstallException(exception);
        }
    }

    @Override
    public final void run(String string) throws Exception {
        File file = this.getAppFileByGuid(string);
        File file2 = this.getAppDirByGuid(string);
        AppMetadata appMetadata = this.getAppMetadata(file);
        String string2 = appMetadata.getEntryPoint();
        this.packagingApi.run(string2, file2);
    }

    @Override
    public AppMetadata getAppMetadata(String string) {
        return this.getAppMetadata(new File(string));
    }

    @Override
    public TSToolSet getToolSet() {
        return this.toolSet;
    }

    void updateGallery() throws Exception {
        this.desktopApi.clearMyAppsGallery();
        this.loadInstalledApps();
    }

    @Override
    public AppMetadata[] getInstalledApps() throws Exception {
        ArrayList<AppMetadata> arrayList = new ArrayList<AppMetadata>();
        for (File file : this.getInstalledAppsMap().keySet()) {
            arrayList.add(this.getAppMetadata(file));
        }
        return arrayList.toArray(new AppMetadata[arrayList.size()]);
    }

    private void install(File file, AppMetadata appMetadata) throws Exception {
        File file2 = this.getAppDir(appMetadata);
        this.packagingApi.extract(file, file2);
        this.desktopApi.addItem(this, appMetadata);
        if (!SettingsUtility.isStringSettingSet(AppPrefKey.APPSINSTALLFOLDER).booleanValue()) {
            SettingsUtility.setStringSetting(AppPrefKey.APPSINSTALLFOLDER, file2.getParent());
        }
    }

    private boolean compare(final AppMetadata appMetadata, Comparison comparison) throws Exception {
        try {
            return comparison.compare(new InstalledAppsVisitor<Integer>(new AppVisitor<Integer>(){

                @Override
                public Integer visit(File file) {
                    return VersionUtils.compareVersionNumbers((String)appMetadata.getVersion(), (String)AppManagementApiImpl.this.getAppMetadata(file).getVersion());
                }
            }).visit(appMetadata.getGuid()));
        }
        catch (MissingAppException missingAppException) {
            return false;
        }
    }

    private String getVersionMovingFrom(String string) throws Exception {
        return new InstalledAppsVisitor<String>(new AppVisitor<String>(){

            @Override
            public String visit(File file) {
                return AppManagementApiImpl.this.getAppMetadata(file).getVersion();
            }
        }).visit(string);
    }

    File getDefaultInstallFolder() throws Exception {
        String string = this.desktopApi.getUserPath("userpath", EMPTY_ARGS);
        FolderUtilsImpl folderUtilsImpl = new FolderUtilsImpl();
        String string2 = !string.isEmpty() && folderUtilsImpl.canWriteToFolder(string) && folderUtilsImpl.mkdirs(string) ? string : this.desktopApi.getUserPath("system_dependent", new Object[]{"getuserworkfolder", "default"});
        return new File(new File(string2), APPS);
    }

    private File getAppDirByGuid(String string) throws Exception {
        final Map<File, File> map = this.getInstalledAppsMap();
        return new InstalledAppsVisitor<File>(new AppVisitor<File>(){

            @Override
            public File visit(File file) {
                return (File)map.get(file);
            }
        }).visit(string);
    }

    @Override
    public File getAppInstallFolder(String string) throws Exception {
        final Map<File, File> map = this.getInstalledAppsMap();
        return new InstalledAppsVisitor<File>(new AppVisitor<File>(){

            @Override
            public File visit(File file) {
                return (File)map.get(file);
            }
        }).visit(string);
    }

    private File getAppFileByGuid(String string) throws Exception {
        return new InstalledAppsVisitor<File>(new AppVisitor<File>(){

            @Override
            public File visit(File file) {
                return file;
            }
        }).visit(string);
    }

    private AppMetadata getAppMetadata(File file) {
        AppMetadata appMetadata;
        try {
            appMetadata = this.packagingApi.getAppMetadata(file);
        }
        catch (Exception exception) {
            throw new AppMetadataException(file.getAbsolutePath(), exception);
        }
        return appMetadata;
    }

    private File getAppDir(AppMetadata appMetadata) throws Exception {
        String string = appMetadata.getName();
        return this.getAppDir(string);
    }

    private File getAppDir(String string) throws Exception {
        String string2;
        File file = this.getMyAppsLocation();
        File file2 = new File(file, string2 = this.packagingApi.getAppPathName(string));
        if (file2.exists()) {
            int n = 1;
            File file3 = new File(file, MessageFormat.format("{0} - {1}", string2, n++));
            while (file3.exists()) {
                file3 = new File(file, MessageFormat.format("{0} - {1}", string2, n++));
            }
            return file3;
        }
        return file2;
    }

    @Override
    public File getMyAppsLocation() throws Exception {
        try {
            if (SettingsUtility.isStringSettingSet(AppPrefKey.APPSINSTALLFOLDER).booleanValue()) {
                return new File(SettingsUtility.getStringSetting(AppPrefKey.APPSINSTALLFOLDER));
            }
            return this.getDefaultInstallFolder();
        }
        catch (IllegalStateException illegalStateException) {
            return this.getDefaultInstallFolder();
        }
    }

    private Map<File, File> getInstalledAppsMap() throws Exception {
        File[] fileArray;
        HashMap<File, File> hashMap = new HashMap<File, File>();
        File file = this.getMyAppsLocation();
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                if (fileArray.length <= 0 || !file2.isDirectory()) continue;
                Iterator iterator = FileUtils.iterateFiles((File)file2, (String[])new String[]{"mlappinstall"}, (boolean)false);
                while (iterator.hasNext()) {
                    File file3 = (File)iterator.next();
                    hashMap.put(file3, file3.getParentFile());
                }
            }
        }
        return hashMap;
    }

    private boolean checkProductDependencies(AppMetadata appMetadata) {
        ProductDependency[] productDependencyArray = appMetadata.getRequiredProducts();
        Collection<ProductDependency> collection = this.getMissingProductDependencies(Arrays.asList(productDependencyArray));
        return collection.isEmpty() || this.appManagementView.showDependencyWarning(appMetadata, collection.toArray(new ProductDependency[collection.size()]));
    }

    private Collection<ProductDependency> getMissingProductDependencies(Collection<ProductDependency> collection) {
        ArrayList<ProductDependency> arrayList = new ArrayList<ProductDependency>();
        Collection collection2 = InstalledProductFactory.getInstalledProducts((String)Matlab.matlabRoot());
        if (!collection2.isEmpty()) {
            for (ProductDependency productDependency : collection) {
                if (productDependency.getNumber() <= 0 || this.productDependencyMet(productDependency, collection2)) continue;
                arrayList.add(productDependency);
            }
        }
        return arrayList;
    }

    private boolean productDependencyMet(ProductDependency productDependency, Collection<InstalledProduct> collection) {
        for (InstalledProduct installedProduct : collection) {
            if (installedProduct.getNumber() != productDependency.getNumber()) continue;
            return true;
        }
        return false;
    }

    private AppInstallType getAppInstallType(AppMetadata appMetadata) throws Exception {
        for (AppInstallType appInstallType : this.appInstallTypes) {
            if (!appInstallType.isType(appMetadata)) continue;
            return appInstallType;
        }
        return null;
    }

    private static class EqualToZero
    implements Comparison {
        private EqualToZero() {
        }

        @Override
        public boolean compare(int n) {
            return n == 0;
        }
    }

    private static class LessThanZero
    implements Comparison {
        private LessThanZero() {
        }

        @Override
        public boolean compare(int n) {
            return n < 0;
        }
    }

    private static class GreaterThanZero
    implements Comparison {
        private GreaterThanZero() {
        }

        @Override
        public boolean compare(int n) {
            return n > 0;
        }
    }

    private static interface Comparison {
        public boolean compare(int var1);
    }

    private class ReinstallInstallType
    implements AppInstallType {
        private ReinstallInstallType() {
        }

        @Override
        public boolean confirm(AppMetadata appMetadata) throws Exception {
            return AppManagementApiImpl.this.appManagementView.confirmReinstall(appMetadata);
        }

        @Override
        public void notification(AppMetadata appMetadata) {
            AppManagementApiImpl.this.appManagementView.showInstallNotification(appMetadata);
        }

        @Override
        public boolean isType(AppMetadata appMetadata) throws Exception {
            return AppManagementApiImpl.this.compare(appMetadata, new EqualToZero());
        }
    }

    private class DefaultAppInstallType
    implements AppInstallType {
        private DefaultAppInstallType() {
        }

        @Override
        public boolean confirm(AppMetadata appMetadata) throws Exception {
            return AppManagementApiImpl.this.appManagementView.confirmInstall();
        }

        @Override
        public void notification(AppMetadata appMetadata) {
            AppManagementApiImpl.this.appManagementView.showInstallNotification(appMetadata);
        }

        @Override
        public boolean isType(AppMetadata appMetadata) {
            return true;
        }
    }

    private class DowngradeAppInstallType
    implements AppInstallType {
        private DowngradeAppInstallType() {
        }

        @Override
        public boolean confirm(AppMetadata appMetadata) throws Exception {
            return AppManagementApiImpl.this.appManagementView.confirmDowngrade(appMetadata, AppManagementApiImpl.this.getVersionMovingFrom(appMetadata.getGuid()));
        }

        @Override
        public void notification(AppMetadata appMetadata) {
            AppManagementApiImpl.this.appManagementView.showDowngradeNotification(appMetadata);
        }

        @Override
        public boolean isType(AppMetadata appMetadata) throws Exception {
            return AppManagementApiImpl.this.compare(appMetadata, new LessThanZero());
        }
    }

    private class UpgradeAppInstallType
    implements AppInstallType {
        private UpgradeAppInstallType() {
        }

        @Override
        public boolean confirm(AppMetadata appMetadata) throws Exception {
            return AppManagementApiImpl.this.appManagementView.confirmUpgrade(appMetadata, AppManagementApiImpl.this.getVersionMovingFrom(appMetadata.getGuid()));
        }

        @Override
        public void notification(AppMetadata appMetadata) {
            AppManagementApiImpl.this.appManagementView.showUpgradeNotification(appMetadata);
        }

        @Override
        public boolean isType(AppMetadata appMetadata) throws Exception {
            return AppManagementApiImpl.this.compare(appMetadata, new GreaterThanZero());
        }
    }

    private static interface AppInstallType {
        public boolean confirm(AppMetadata var1) throws Exception;

        public void notification(AppMetadata var1);

        public boolean isType(AppMetadata var1) throws Exception;
    }

    private static interface AppVisitor<V> {
        public V visit(File var1);
    }

    private class InstalledAppsVisitor<V> {
        private AppVisitor<V> appVisitor;

        InstalledAppsVisitor(AppVisitor<V> appVisitor) {
            this.appVisitor = appVisitor;
        }

        V visit(String string) throws Exception {
            for (File file : AppManagementApiImpl.this.getInstalledAppsMap().keySet()) {
                if (!string.equalsIgnoreCase(AppManagementApiImpl.this.packagingApi.getAppMetadata(file).getGuid())) continue;
                return this.appVisitor.visit(file);
            }
            throw new MissingAppException(string);
        }
    }
}

