/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.GlobalCursor;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.mwswing.SimpleNodeList;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import com.mathworks.toolstrip.factory.TSToolPath;
import com.mathworks.util.ClassLoaderBridge;
import com.mathworks.util.Predicate;
import com.mathworks.widgets.desk.DTBorderContainer;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTClientProperty;
import com.mathworks.widgets.desk.DTCloseReplyListener;
import com.mathworks.widgets.desk.DTCloseTransaction;
import com.mathworks.widgets.desk.DTContainer;
import com.mathworks.widgets.desk.DTDocumentContainer;
import com.mathworks.widgets.desk.DTFloatingLocation;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTGroupAdapter;
import com.mathworks.widgets.desk.DTGroupBase;
import com.mathworks.widgets.desk.DTGroupEvent;
import com.mathworks.widgets.desk.DTGroupFrame;
import com.mathworks.widgets.desk.DTGroupListener;
import com.mathworks.widgets.desk.DTGroupProperty;
import com.mathworks.widgets.desk.DTGroupPropertyProvider;
import com.mathworks.widgets.desk.DTInternalFrame;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.DTMultipleClientFrame;
import com.mathworks.widgets.desk.DTNestedLocation;
import com.mathworks.widgets.desk.DTNestingContainer;
import com.mathworks.widgets.desk.DTNotifyingList;
import com.mathworks.widgets.desk.DTOccupant;
import com.mathworks.widgets.desk.DTProperty;
import com.mathworks.widgets.desk.DTPropertyBridge;
import com.mathworks.widgets.desk.DTPropertyProvider;
import com.mathworks.widgets.desk.DTRecoverable;
import com.mathworks.widgets.desk.DTToolBarConfiguration;
import com.mathworks.widgets.desk.DTToolBarContainer;
import com.mathworks.widgets.desk.DTToolBarLocation;
import com.mathworks.widgets.desk.DTUnableToOpenException;
import com.mathworks.widgets.desk.DTWindowCloser;
import com.mathworks.widgets.desk.DeferredRunnable;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.zip.DataFormatException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DTGroup
extends DTOccupant
implements ItemListener {
    private List<DTClient> fClients;
    private Vector<DTGroupListener> fListeners;
    private DTGroupBase fGroupBase;
    private DTRecoverable fRecoverable;
    private DTNotifyingList<DTClient> fSingletons = new DTNotifyingList();
    private DTFrame fContainingFrame;
    private DTDocumentContainer fDocumentContainer;
    private DropTargetListener fDropTargetListener;
    private KeyListener fEmptyKeyListener;
    private DTLocation fLastDocumentLocation;
    private DTLocation.Listener fLocationListener = new LocationListener();
    private Icon fIcon;
    private Icon fSmallIcon;
    private boolean fAlphabetizeDocuments;
    private int fDocumentCount;
    private Object fSavedFrameState;
    private Object fSavedBorderState;
    private Object fSavedNestState;
    private List<String> fSavedUndockedSingletons;
    private Object fSavedDocumentState;
    private boolean fSavedSingletonsShowing;
    private boolean fIsUpdatingToolBars;
    private boolean fWasShowing;
    private boolean fOpenIsPending;
    private boolean fIsRestoringSingletons;
    private String fPropertyClassName;
    private SimpleElement fPropertyDataElement;
    private int fUntitledClientCount;
    private JToolBar fDummyToolBar;
    private String fLastSelectedToolstripTab;
    private boolean fCollapseDocumentToolstrips;
    private boolean fSupportsToolstrip = true;
    private DTToolBarLocation fQuickAccessLocation;
    private MJAbstractAction fCloseAllAction;
    private MJAbstractAction fCloseDockedAction;
    private MJAbstractAction fDockAllAction;
    private MJAbstractAction fAlphabetizeAction;
    static final String GROUP_TAG = "Group";
    private static final String CLASS_ATTRIBUTE = "PropertyClass";
    private static final String PROPERTY_DATA_TAG = "PropertyData";
    private static final String SHOW_SINGLETONS_ATTRIBUTE = "ShowViews";
    private static final String ALPHABETIZE_ATTRIBUTE = "Alphabetize";
    private static final String UNDOCKED_SINGLETON_TAG = "UndockedView";
    private static final String GROUP_VALUE = "group";
    private static final String DOCUMENT_VALUE = "document";
    private static final String COLLAPSE_DOCUMENT_TOOLSTRIPS_ATTRIBUTE = "CollapseUndockedDocumentToolstrips";
    private static final String QUICK_ACCESS_LOCATION_TAG = "QuickAccessLocation";

    DTGroup(Desktop desktop, String string, DTFrame dTFrame) {
        super(desktop);
        this.fTitle = string;
        this.fContainingFrame = dTFrame;
    }

    DTGroup(Desktop desktop, DTGroupPropertyProvider dTGroupPropertyProvider, DTFrame dTFrame) {
        super(desktop);
        this.setPropertyProvider(dTGroupPropertyProvider);
        this.fContainingFrame = dTFrame;
    }

    @Override
    public DTInternalFrame getInternalFrame() {
        return this.getGroupFrame();
    }

    @Override
    boolean isSingleton() {
        return true;
    }

    DTGroupFrame getGroupFrame() {
        if (this.fInternalFrame == null) {
            this.setInternalFrame(new DTGroupFrame(this));
            if (this.fSavedSingletonsShowing) {
                this.restoreSingletons();
            }
        }
        return (DTGroupFrame)this.fInternalFrame;
    }

    @Override
    protected void flush() {
        super.flush();
        this.fGroupBase = null;
        this.disposeDocumentContainer();
        if (this.fListeners != null) {
            this.fListeners.clear();
        }
    }

    void setPropertyProvider(DTGroupPropertyProvider dTGroupPropertyProvider) {
        if (this.fPropertyProvider != null) {
            if (this.fPropertyProvider instanceof DTPropertyBridge && ((DTPropertyBridge)this.fPropertyProvider).getUnderlyingProvider() == dTGroupPropertyProvider) {
                return;
            }
            this.fPropertyProvider.removePropertyChangeListener(this);
            this.fPropertyProvider = null;
        }
        if (dTGroupPropertyProvider == null) {
            return;
        }
        super.setPropertyProvider(new DTPropertyBridge(dTGroupPropertyProvider));
        if (this.fSupportsToolstrip && !this.getBooleanProperty(DTGroupProperty.WILL_SUPPLY_TOOLSTRIP_TABS)) {
            this.fSupportsToolstrip = false;
        }
        if (dTGroupPropertyProvider instanceof DTRecoverable) {
            this.fRecoverable = (DTRecoverable)((Object)dTGroupPropertyProvider);
        }
        if (dTGroupPropertyProvider instanceof DTGroupBase) {
            this.fGroupBase = (DTGroupBase)dTGroupPropertyProvider;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (DTGroup.this.fGroupBase != null) {
                        DTGroup.this.fGroupBase.setParentDesktop(DTGroup.this.fDesktop);
                    }
                }
            });
        }
        this.fPropertyClassName = dTGroupPropertyProvider.getClass().getName();
        dTGroupPropertyProvider.addPropertyChangeListener(this);
        List<DTProperty> list = DTGroupProperty.getGroupPropertyList();
        for (DTProperty dTProperty : list) {
            Object object = this.getProperty(dTProperty);
            if (object == null || object == dTProperty.getDefaultValue()) continue;
            this.propertyChange(new PropertyChangeEvent(dTGroupPropertyProvider, dTProperty.toString(), dTProperty.getDefaultValue(), object));
        }
    }

    @Override
    DTPropertyProvider getPropertyProvider() {
        if (this.fPropertyProvider == null && this.fPropertyClassName != null) {
            this.setPropertyProvider(this.createPropertyProvider());
        }
        return this.fPropertyProvider;
    }

    DTGroupBase getGroupBase() {
        this.getPropertyProvider();
        return this.fGroupBase;
    }

    @Override
    DTGroupPropertyProvider createPropertyProvider() {
        DTGroupPropertyProvider dTGroupPropertyProvider;
        block17: {
            dTGroupPropertyProvider = null;
            try {
                Class[] classArray;
                Class clazz = ClassLoaderBridge.findClass((String)this.fPropertyClassName);
                if (clazz == null) break block17;
                if (this.fPropertyDataElement != null) {
                    try {
                        Object[] objectArray;
                        classArray = new Class[]{SimpleElement.class};
                        Constructor constructor = clazz.getConstructor(classArray);
                        if (constructor != null && (dTGroupPropertyProvider = (DTGroupPropertyProvider)constructor.newInstance(objectArray = new Object[]{this.fPropertyDataElement})) != null) {
                            this.fPropertyDataElement = null;
                            return dTGroupPropertyProvider;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                try {
                    classArray = clazz.getMethod("getInstance", new Class[0]);
                    if (classArray != null) {
                        int n = classArray.getModifiers();
                        if (!Modifier.isPublic(n)) {
                            this.fDesktop.getErrorReportingStream().println(this.fPropertyClassName + " has a getInstance method but it's not public");
                        } else if (!Modifier.isStatic(n)) {
                            this.fDesktop.getErrorReportingStream().println(this.fPropertyClassName + " has a getInstance method but it's not static");
                        } else {
                            dTGroupPropertyProvider = (DTGroupPropertyProvider)classArray.invoke(null, new Object[0]);
                        }
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (dTGroupPropertyProvider == null) {
                    dTGroupPropertyProvider = (DTGroupPropertyProvider)clazz.newInstance();
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (throwable instanceof InvocationTargetException) {
                    throwable2 = ((InvocationTargetException)throwable).getTargetException();
                }
                if (!(throwable2 instanceof DTUnableToOpenException)) {
                    this.reportCreateError(this.fPropertyClassName, throwable2);
                    this.fPropertyClassName = null;
                }
                dTGroupPropertyProvider = null;
            }
        }
        if (this.fRecoverable != null && this.fPropertyDataElement != null) {
            this.fRecoverable.restoreState(this.fPropertyDataElement);
            this.fPropertyDataElement = null;
        }
        return dTGroupPropertyProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(DTGroupListener dTGroupListener) {
        if (this.fListeners == null) {
            this.fListeners = new Vector();
        }
        Vector<DTGroupListener> vector = this.fListeners;
        synchronized (vector) {
            if (!this.fListeners.contains(dTGroupListener)) {
                this.fListeners.add(dTGroupListener);
            }
        }
    }

    void removeListener(DTGroupListener dTGroupListener) {
        if (this.fListeners != null) {
            this.fListeners.remove(dTGroupListener);
        }
    }

    void add(DTClient dTClient) {
        dTClient.setGroup(this);
        if (this.fClients == null) {
            this.fClients = new ArrayList<DTClient>();
        }
        this.fClients.add(dTClient);
        if (dTClient.isSingleton()) {
            this.fSingletons.add(dTClient);
        } else {
            ++this.fDocumentCount;
        }
        if (dTClient.getGroupPropertyProvider() != null) {
            this.setPropertyProvider(dTClient.getGroupPropertyProvider());
        }
        if (this.fIcon == null && dTClient.getIcon() != null) {
            this.fIcon = dTClient.getIcon();
        }
        if (this.fSmallIcon == null && dTClient.getSmallIcon() != null) {
            this.fSmallIcon = dTClient.getSmallIcon();
        }
        dTClient.addPropertyListener(this);
        if (this.fSupportsToolstrip && this.getToolstripTabs().length == 0 && !dTClient.isSingleton() && dTClient.getComponent() != null && dTClient.getToolstripTabs().length == 0) {
            this.fSupportsToolstrip = false;
        }
    }

    void remove(DTClient dTClient) {
        assert (this.fClients != null);
        int n = this.fClients.indexOf(dTClient);
        if (n != -1) {
            if (dTClient.isSingleton()) {
                this.fSingletons.remove(dTClient);
            } else {
                --this.fDocumentCount;
                if (this.fDocumentCount == 0 && dTClient.getLastLocation() != null) {
                    this.fLastDocumentLocation = DTLocation.clone(dTClient.getLastLocation());
                    this.fLastDocumentLocation.setFrame(null);
                    this.fLastDocumentLocation.setContainer(null);
                }
            }
            this.fClients.remove(n);
            dTClient.setGroup(null);
            dTClient.removePropertyListener(this);
        }
    }

    int getCount() {
        return this.fClients == null ? 0 : this.fClients.size();
    }

    List<DTClient> getClients() {
        return this.fClients != null ? Collections.unmodifiableList(this.fClients) : new ArrayList();
    }

    DTNotifyingList<DTClient> getSingletons() {
        return this.fSingletons;
    }

    Iterator<DTClient> getClientIterator() {
        return this.getClientCollection().iterator();
    }

    private Collection<DTClient> getClientCollection() {
        DTClient dTClient;
        int n;
        if (this.fClients == null) {
            this.fClients = new ArrayList<DTClient>();
        }
        int n2 = this.fClients.size();
        ArrayList<DTClient> arrayList = new ArrayList<DTClient>(n2);
        arrayList.addAll(this.getDockedDocuments());
        for (n = 0; n < n2; ++n) {
            dTClient = this.fClients.get(n);
            if (dTClient.isSingleton() || dTClient.getLocation() == null || dTClient.getLocation().isDocked()) continue;
            arrayList.add(dTClient);
        }
        for (n = 0; n < n2; ++n) {
            dTClient = this.fClients.get(n);
            if (!dTClient.isSingleton()) continue;
            arrayList.add(dTClient);
        }
        return arrayList;
    }

    int updateUntitledClientCount() {
        return ++this.fUntitledClientCount;
    }

    void setContainingFrame(DTFrame dTFrame) {
        this.fContainingFrame = dTFrame;
        if (this.fDocumentContainer != null) {
            this.fDocumentContainer.setFrame(dTFrame);
        }
        if (this.fInternalFrame != null) {
            ((DTGroupFrame)this.fInternalFrame).setFrame(dTFrame);
        }
        if (dTFrame != null && !this.fDesktop.isRestoringLayout()) {
            this.processPendingOpenEvent();
        }
    }

    DTFrame getContainingFrame() {
        return this.fContainingFrame;
    }

    synchronized boolean hasDocumentContainer() {
        return this.fDocumentContainer != null;
    }

    synchronized DTDocumentContainer getDocumentContainer() {
        if (this.fDocumentContainer == null) {
            this.fDocumentContainer = this.fSavedDocumentState != null ? new DTDocumentContainer(this.fDesktop, this.fContainingFrame, this, this.fSavedDocumentState) : new DTDocumentContainer(this.fDesktop, this.fContainingFrame, this);
            this.configureDockedOrdering();
            this.fDocumentContainer.addItemListener(this);
            if (this.fDropTargetListener != null) {
                this.fDocumentContainer.addDropTargetListener(this.fDropTargetListener);
            }
            if (this.fEmptyKeyListener != null) {
                this.fDocumentContainer.addEmptyKeyListener(this.fEmptyKeyListener);
            }
        }
        return this.fDocumentContainer;
    }

    void disposeDocumentContainer() {
        if (this.fDocumentContainer != null) {
            if (this.fDropTargetListener != null) {
                this.fDocumentContainer.removeDropTargetListener(this.fDropTargetListener);
            }
            if (this.fEmptyKeyListener != null) {
                this.fDocumentContainer.removeEmptyKeyListener(this.fEmptyKeyListener);
            }
            this.fDocumentContainer.removeItemListener(this);
            this.fDocumentContainer.cleanup();
            this.fDocumentContainer = null;
        }
    }

    public void addDropTargetListener(DropTargetListener dropTargetListener) {
        if (this.fDropTargetListener == null) {
            if (this.fDocumentContainer != null) {
                this.fDocumentContainer.addDropTargetListener(dropTargetListener);
            }
            this.fDropTargetListener = dropTargetListener;
        }
    }

    public void removeDropTargetListener(DropTargetListener dropTargetListener) {
        if (this.fDropTargetListener == dropTargetListener) {
            if (this.fDocumentContainer != null) {
                this.fDocumentContainer.removeDropTargetListener(dropTargetListener);
            }
            this.fDropTargetListener = null;
        }
    }

    public void addEmptyKeyListener(KeyListener keyListener) {
        if (this.fDocumentContainer != null) {
            this.fDocumentContainer.addEmptyKeyListener(this.fEmptyKeyListener);
        } else {
            this.fEmptyKeyListener = keyListener;
        }
    }

    public void removeEmptyKeyListener(KeyListener keyListener) {
        if (this.fDocumentContainer != null) {
            this.fDocumentContainer.removeEmptyKeyListener(this.fEmptyKeyListener);
        } else if (this.fEmptyKeyListener == keyListener) {
            this.fEmptyKeyListener = null;
        }
    }

    @Override
    synchronized void setLocation(DTLocation dTLocation) {
        if (dTLocation == this.fLocation) {
            return;
        }
        DTLocation dTLocation2 = this.fLastLocation;
        if (this.fLocation != null) {
            this.fLocation.removeChangeListener(this.fLocationListener);
        }
        super.setLocation(dTLocation);
        for (DTClient dTClient : this.fSingletons) {
            ((DTClient.ClientToggleAction)dTClient.getToggleAction()).updateEnabling();
        }
        if (dTLocation != null) {
            dTLocation.addChangeListener(this.fLocationListener);
            boolean bl = this.fIsOpen;
            if (!this.fIsOpen) {
                this.fOpenIsPending = true;
            }
            if (dTLocation.isDocked() && (dTLocation2 == null || !dTLocation2.isDocked())) {
                this.fireGroupEvent(this.createGroupEvent(5));
            } else if (!dTLocation.isDocked() && (dTLocation2 == null || dTLocation2.isDocked())) {
                this.fireGroupEvent(this.createGroupEvent(7));
            }
            if (bl) {
                this.fireGroupEvent(this.createGroupEvent(8));
            }
        }
    }

    DTLocation getLastDocumentLocation() {
        return this.fLastDocumentLocation;
    }

    void processPendingOpenEvent() {
        if (this.fOpenIsPending) {
            if (this.fLocation != null) {
                this.fIsOpen = true;
                this.fireGroupEvent(this.createGroupEvent(10));
            }
            this.fOpenIsPending = false;
        }
    }

    void setClosing(boolean bl) {
        this.fIsClosing = bl;
    }

    void setClosed() {
        if (this.fIsOpen || this.fOpenIsPending) {
            this.fIsOpen = false;
            this.fOpenIsPending = false;
            this.fireGroupEvent(this.createGroupEvent(12));
            if (this.fInternalFrame != null) {
                ((DTGroupFrame)this.fInternalFrame).cleanup();
                this.setInternalFrame(null);
                this.disposeDocumentContainer();
            }
        }
    }

    boolean isOpening() {
        return this.fOpenIsPending;
    }

    void saveFrameState(Object object) {
        this.fSavedFrameState = object;
    }

    Object savedFrameState() {
        return this.fSavedFrameState;
    }

    void saveDocumentState(Object object) {
        this.fSavedDocumentState = object;
    }

    Object savedDocumentState() {
        return this.fSavedDocumentState;
    }

    void clearSavedSingletonState() {
        this.fSavedBorderState = null;
        this.fSavedNestState = null;
        this.fSavedUndockedSingletons = null;
    }

    boolean singletonsWereShowing() {
        return this.fSavedSingletonsShowing;
    }

    boolean wasShowing() {
        return this.fWasShowing;
    }

    void saveShowing() {
        this.fWasShowing = this.isShowing();
    }

    boolean supportsToolstrip() {
        return this.fSupportsToolstrip;
    }

    public void setLastSelectedToolstripTab(String string) {
        this.fLastSelectedToolstripTab = string;
    }

    public String getLastSelectedToolstripTab() {
        return this.fLastSelectedToolstripTab;
    }

    void setCollapseDocumentToolstrips(boolean bl) {
        this.fCollapseDocumentToolstrips = bl;
    }

    boolean getCollapseDocumentToolstrips() {
        return this.fCollapseDocumentToolstrips;
    }

    void setQuickAccessLocation(DTToolBarLocation dTToolBarLocation) {
        this.fQuickAccessLocation = dTToolBarLocation;
    }

    DTToolBarLocation getQuickAccessLocation() {
        return this.fQuickAccessLocation;
    }

    @Override
    public String getTitle() {
        String string;
        if (this.fPropertyProvider != null && (string = (String)this.fPropertyProvider.getProperty(DTProperty.TITLE)) != null) {
            this.fTitle = string;
        }
        return this.fTitle;
    }

    @Override
    public Icon getIcon() {
        Icon icon = super.getIcon();
        if (icon == null) {
            icon = this.fIcon;
        }
        if (icon == null && this.fDocumentCount > 0) {
            for (int i = 0; this.fIcon == null && i < this.fClients.size(); ++i) {
                DTClient dTClient = this.fClients.get(i);
                if (dTClient.isSingleton()) continue;
                this.fIcon = dTClient.getIcon();
            }
            icon = this.fIcon;
        }
        return icon == DTProperty.NULL_ICON ? null : icon;
    }

    @Override
    public Icon getSmallIcon() {
        Icon icon = super.getSmallIcon();
        if (icon == null) {
            icon = this.fSmallIcon;
        }
        if (icon == null && this.fDocumentCount > 0) {
            for (int i = 0; this.fSmallIcon == null && i < this.fClients.size(); ++i) {
                DTClient dTClient = this.fClients.get(i);
                if (dTClient.isSingleton()) continue;
                this.fSmallIcon = dTClient.getSmallIcon();
            }
            icon = this.fSmallIcon;
        }
        return icon == DTProperty.NULL_ICON ? null : icon;
    }

    String getLegacyTabTitle() {
        String string = (String)this.getProperty(DTGroupProperty.LEGACY_TOOLSTRIP_TAB_TITLE);
        return string != null ? string : this.getShortTitle();
    }

    @Override
    JToolBar[] getToolBars() {
        JToolBar[] jToolBarArray = super.getToolBars();
        if (jToolBarArray.length == 0 && this.getToolBarAlternative() == null && !this.fDesktop.useToolstrip()) {
            if (this.fDummyToolBar == null) {
                this.fDummyToolBar = new MJToolBar();
                this.fDummyToolBar.setFloatable(false);
            }
            jToolBarArray = new JToolBar[]{this.fDummyToolBar};
        }
        return jToolBarArray;
    }

    boolean allowToolBarRearrangement() {
        return this.getBooleanProperty(DTGroupProperty.ALLOW_TOOLBAR_REARRANGEMENT);
    }

    boolean shouldAppendDocumentTitle() {
        return this.getBooleanProperty(DTGroupProperty.APPEND_DOCUMENT_TITLE);
    }

    Integer getEmptyReopenPolicy() {
        return this.fDesktop.useToolstrip() ? DTGroupProperty.NEVER : (Integer)this.getProperty(DTGroupProperty.EMPTY_REOPEN_POLICY);
    }

    boolean closeUponEmpty() {
        boolean bl = this.fDesktop.closeEmptyGroups();
        Boolean bl2 = (Boolean)this.getProperty(DTGroupProperty.CLOSE_UPON_EMPTY);
        if (bl2 != null) {
            bl = bl2;
        }
        return bl;
    }

    boolean permitUserTile() {
        return this.getBooleanProperty(DTGroupProperty.PERMIT_USER_TILE);
    }

    boolean permitUserFloat() {
        Boolean bl = null;
        if (this.getPropertyProvider() != null) {
            bl = (Boolean)this.getPropertyProvider().getProperty(DTGroupProperty.PERMIT_USER_FLOAT);
        }
        if (bl == null) {
            bl = this.fDesktop.useToolstrip() ? Boolean.FALSE : Boolean.TRUE;
        }
        return bl;
    }

    boolean permitDocumentBarHide() {
        return this.getBooleanProperty(DTGroupProperty.PERMIT_DOCUMENT_BAR_HIDE);
    }

    boolean showSingleEntryDocumentBar() {
        Boolean bl = null;
        if (this.getPropertyProvider() != null) {
            bl = (Boolean)this.getPropertyProvider().getProperty(DTGroupProperty.SHOW_SINGLE_ENTRY_DOCUMENT_BAR);
        }
        if (bl == null) {
            bl = this.fDesktop.useToolstrip() ? Boolean.TRUE : Boolean.FALSE;
        }
        return bl;
    }

    boolean acceptDefaultViewTab() {
        return this.getBooleanProperty(DTGroupProperty.ACCEPT_DEFAULT_VIEW_TAB);
    }

    DropTargetListener getDropListener() {
        return (DropTargetListener)this.getProperty(DTGroupProperty.DROP_LISTENER);
    }

    Comparator<Component> getDocumentBarOrderingComparator() {
        return (Comparator)this.getProperty(DTGroupProperty.DOCUMENT_BAR_ORDERING_COMAPARATOR);
    }

    boolean permitUserDocumentBarReordering() {
        return this.getDocumentBarOrderingComparator() == null;
    }

    Action getNewAction() {
        return (Action)this.getProperty(DTGroupProperty.NEW_ACTION);
    }

    boolean placeToolBarsWithDocumentBar() {
        return this.getBooleanProperty(DTGroupProperty.PLACE_TOOLBARS_WITH_DOCUMENT_BAR);
    }

    Predicate<TSToolPath> getQuickAccessToolBarFilter() {
        return (Predicate)this.getProperty(DTGroupProperty.QUICK_ACCESS_TOOL_BAR_FILTER);
    }

    private void updateDropListener() {
        DropTargetListener dropTargetListener = this.getDropListener();
        if (dropTargetListener != null && this.fDropTargetListener != dropTargetListener) {
            if (this.fDropTargetListener != null) {
                this.removeDropTargetListener(this.fDropTargetListener);
            }
            this.addDropTargetListener(dropTargetListener);
        }
    }

    public int getDocumentCount() {
        return this.fDocumentCount;
    }

    boolean hasDockedDocuments() {
        return this.fDocumentContainer != null && this.fDocumentContainer.getDocumentCount() > 0;
    }

    boolean hasUndockedDocuments() {
        int n = this.fDocumentContainer == null ? 0 : this.fDocumentContainer.getDocumentCount();
        return n < this.fDocumentCount;
    }

    List<DTClient> getDockedDocuments() {
        return this.fDocumentContainer == null ? new ArrayList() : this.fDocumentContainer.getDocumentsInTabOrder();
    }

    private void configureDockedOrdering() {
        if (this.fDocumentContainer == null) {
            return;
        }
        Comparator<DTClient> comparator = null;
        final Comparator<Component> comparator2 = this.getDocumentBarOrderingComparator();
        if (comparator2 != null) {
            comparator = new Comparator<DTClient>(){

                @Override
                public int compare(DTClient dTClient, DTClient dTClient2) {
                    return comparator2.compare(dTClient.getComponent(), dTClient2.getComponent());
                }
            };
        } else if (this.fAlphabetizeDocuments) {
            comparator = new Comparator<DTClient>(){

                @Override
                public int compare(DTClient dTClient, DTClient dTClient2) {
                    return dTClient.compareTo(dTClient2);
                }
            };
        }
        this.fDocumentContainer.getTabProperties().setComparator(comparator);
    }

    List<DTClient> getUndockedDocuments() {
        ArrayList<DTClient> arrayList = new ArrayList<DTClient>();
        if (this.hasUndockedDocuments()) {
            for (DTClient dTClient : this.fClients) {
                if (dTClient.isSingleton() || dTClient.getLocation() == null || dTClient.getLocation().isDocked()) continue;
                arrayList.add(dTClient);
            }
        }
        return arrayList;
    }

    void setAlphabetizeDocuments(boolean bl) {
        if (this.fAlphabetizeDocuments != bl) {
            this.fAlphabetizeDocuments = bl;
            this.configureDockedOrdering();
            if (this.fAlphabetizeAction != null) {
                this.fAlphabetizeAction.setSelected(bl);
            }
        }
    }

    boolean getAlphabetizeDocuments() {
        return this.fAlphabetizeDocuments;
    }

    @Override
    public boolean isSelected() {
        return this.fInternalFrame != null && this.fInternalFrame.isSelected();
    }

    @Override
    void setSelected(boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            if (!this.isEnabled()) {
                return;
            }
            this.fSelectionOrder = this.fDesktop.getSelectionManager().getNextSelectionOrder();
        }
        if (this.fDocumentContainer != null) {
            this.fDocumentContainer.setSelected(bl, false);
        }
        if (this.fInternalFrame != null) {
            if (bl && bl2) {
                if (bl3) {
                    this.requestFocus();
                } else {
                    this.requestFocusLater();
                }
            } else {
                this.fInternalFrame.setSelected(bl);
            }
        }
    }

    @Override
    void requestFocusLater() {
        SwingUtilities.invokeLater(new DeferredRunnable(2){

            @Override
            protected void doTask() {
                DTGroup.this.requestFocus();
            }
        });
    }

    @Override
    void requestFocus() {
        Component component;
        if (!(this.fDocumentContainer == null || (component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner()) != null && SwingUtilities.isDescendingFrom(component, (Component)((Object)this.fInternalFrame)))) {
            this.fDocumentContainer.requestFocus();
        }
    }

    DTClient getSelectedClient() {
        for (DTClient dTClient : this.fSingletons) {
            if (!dTClient.isSelected()) continue;
            return dTClient;
        }
        for (DTClient dTClient : this.fClients) {
            if (!dTClient.isSelected()) continue;
            return dTClient;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int canClose(DTCloseReplyListener dTCloseReplyListener) {
        int n = super.canClose(dTCloseReplyListener);
        if (this.fListeners != null) {
            DTGroupEvent dTGroupEvent = this.createGroupEvent(11);
            if (this.fPropertyProvider == null) {
                this.fireGroupEvent(dTGroupEvent);
            } else {
                DTGroupListener[] dTGroupListenerArray;
                dTGroupEvent.setData(dTCloseReplyListener);
                Vector<DTGroupListener> vector = this.fListeners;
                synchronized (vector) {
                    dTGroupListenerArray = new DTGroupListener[this.fListeners.size()];
                    dTGroupListenerArray = this.fListeners.toArray(dTGroupListenerArray);
                }
                for (int i = 0; i < dTGroupListenerArray.length && n != 0; ++i) {
                    dTGroupListenerArray[i].groupClosing(dTGroupEvent);
                    Object object = this.fPropertyProvider.getProperty(DTProperty.VETO_CLOSE);
                    if (object != null && !object.equals(Boolean.FALSE)) {
                        n = 0;
                        continue;
                    }
                    Object object2 = this.fPropertyProvider.getProperty(DTProperty.DEFER_CLOSE);
                    if (object2 == null) continue;
                    n = 2;
                }
            }
        }
        if (n != 2) {
            this.fCloseReplyListener = null;
        }
        return n;
    }

    @Override
    public void close() {
    }

    DTCloseTransaction getCloseAllTransaction(boolean bl) {
        ArrayList<DTWindowCloser> arrayList = new ArrayList<DTWindowCloser>();
        if (bl && this.isShowing() && this.fCloseReplyListener == null) {
            arrayList.add(this);
        }
        arrayList.addAll(this.getClientCollection());
        return new GroupCloseTransaction(arrayList, true);
    }

    void attemptCloseAll() {
        this.getCloseAllTransaction(false).start();
    }

    DTCloseTransaction getCloseDockedTransaction() {
        return this.getCloseDockedTransaction(true);
    }

    DTCloseTransaction getCloseDockedTransaction(boolean bl) {
        ArrayList<DTWindowCloser> arrayList = new ArrayList<DTWindowCloser>();
        if (bl && this.isShowing() && this.fCloseReplyListener == null) {
            arrayList.add(this);
        }
        arrayList.addAll(this.getDockedDocuments());
        if (this.fClients != null) {
            for (DTClient dTClient : this.fClients) {
                if (!dTClient.isSingleton() || !dTClient.isShowing()) continue;
                arrayList.add(dTClient);
            }
        }
        GroupCloseTransaction groupCloseTransaction = new GroupCloseTransaction(arrayList, bl);
        if (bl && this.getContainingFrame() != null && this.getContainingFrame().isMainFrame()) {
            groupCloseTransaction.setDoneListener(new DTCloseTransaction.DoneListener(){

                @Override
                public void closeTransactionDone(boolean bl) {
                    if (bl) {
                        DTMultipleClientFrame dTMultipleClientFrame = (DTMultipleClientFrame)DTGroup.this.getContainingFrame();
                        if (dTMultipleClientFrame != null) {
                            dTMultipleClientFrame.removeGroup(DTGroup.this);
                        }
                        DTGroup.this.setLocation(null);
                        DTGroup.this.setClosed();
                    }
                }
            });
        }
        return groupCloseTransaction;
    }

    void attemptCloseDocked() {
        this.getCloseDockedTransaction().start();
    }

    void dockAll() {
        if (this.fClients == null) {
            return;
        }
        if (this.fClients.isEmpty()) {
            this.fLastDocumentLocation = null;
            return;
        }
        for (DTClient dTClient : this.fClients) {
            if (dTClient.getLocation() == null || dTClient.getLocation().isDocked() || !dTClient.isDockable()) continue;
            this.fDesktop.setClientDocked(dTClient, true);
        }
    }

    void select() {
        if (this.fInternalFrame != null && this.fInternalFrame.isSelected()) {
            this.fDesktop.toFront(this, DTContainer.Scope.FRAME);
            return;
        }
        DTClient dTClient = this.getMostRecentlySelected(false);
        if (dTClient != null && dTClient.isShowing()) {
            dTClient.setSelected(true);
        } else if (this.fContainingFrame != null && !this.fContainingFrame.isMainFrame()) {
            this.fContainingFrame.toFront();
        } else if (this.fDocumentContainer != null) {
            this.fDocumentContainer.setSelected(true);
        }
    }

    DTClient getMostRecentlySelected(boolean bl) {
        DTClient dTClient = null;
        int n = -1;
        if (this.fClients != null) {
            for (DTClient dTClient2 : this.fClients) {
                if (bl && dTClient2.isSingleton() || dTClient2.getSelectionOrder() <= n) continue;
                dTClient = dTClient2;
                n = dTClient2.getSelectionOrder();
            }
        }
        return dTClient;
    }

    void updateToolBarState(Object object) {
        if (this.fIsUpdatingToolBars) {
            return;
        }
        this.fIsUpdatingToolBars = true;
        this.fToolBarState = object;
        for (DTClient dTClient : this.getDockedDocuments()) {
            dTClient.getInternalFrame().getToolBarContainer().restoreState(object);
        }
        this.fIsUpdatingToolBars = false;
    }

    final MJAbstractAction getCloseAllAction() {
        if (this.fCloseAllAction == null) {
            this.fCloseAllAction = new CloseDocumentsAction(false);
        }
        return this.fCloseAllAction;
    }

    final MJAbstractAction getCloseDockedAction() {
        if (this.fCloseDockedAction == null) {
            this.fCloseDockedAction = new CloseDocumentsAction(true);
        }
        return this.fCloseDockedAction;
    }

    final MJAbstractAction getDockAllAction() {
        if (this.fDockAllAction == null) {
            this.fDockAllAction = new DockAllAction();
        }
        return this.fDockAllAction;
    }

    final MJAbstractAction getAlphabetizeAction() {
        if (!this.permitUserDocumentBarReordering()) {
            return null;
        }
        if (this.fAlphabetizeAction == null) {
            this.fAlphabetizeAction = new AlphabetizeAction();
        }
        return this.fAlphabetizeAction;
    }

    @Override
    protected DTOccupant.OccupantAction createOpenAction() {
        return new GroupOpenAction();
    }

    @Override
    protected DTOccupant.OccupantAction createCloseAction() {
        return new GroupCloseAction();
    }

    @Override
    protected DTOccupant.OccupantAction createDockAction() {
        return new GroupDockAction();
    }

    @Override
    protected DTOccupant.OccupantAction createUndockAction() {
        return new GroupUndockAction();
    }

    @Override
    protected DTOccupant.OccupantAction createMinimizeAction() {
        return new GroupMinimizeAction();
    }

    @Override
    protected DTOccupant.OccupantAction createMaximizeAction() {
        return new GroupMaximizeAction();
    }

    @Override
    protected DTOccupant.OccupantAction createSelectAction() {
        return new GroupSelectAction();
    }

    @Override
    protected DTOccupant.OccupantAction createToggleAction() {
        return new GroupToggleAction();
    }

    DTGroupEvent createGroupEvent(int n) {
        if (this.fPropertyProvider == null) {
            return new DTGroupEvent(this.getTitle(), n);
        }
        DTGroupPropertyProvider dTGroupPropertyProvider = (DTGroupPropertyProvider)((DTPropertyBridge)this.fPropertyProvider).getUnderlyingProvider();
        return new DTGroupEvent(dTGroupPropertyProvider, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireGroupEvent(DTGroupEvent dTGroupEvent) {
        if (this.fListeners == null) {
            return;
        }
        DTGroupListener[] dTGroupListenerArray = this.fListeners;
        synchronized (this.fListeners) {
            DTGroupListener[] dTGroupListenerArray2 = new DTGroupListener[this.fListeners.size()];
            dTGroupListenerArray2 = this.fListeners.toArray(dTGroupListenerArray2);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            block17: for (DTGroupListener dTGroupListener : dTGroupListenerArray2) {
                switch (dTGroupEvent.getType()) {
                    case 1: {
                        dTGroupListener.groupActivating(dTGroupEvent);
                        continue block17;
                    }
                    case 2: {
                        dTGroupListener.groupActivated(dTGroupEvent);
                        continue block17;
                    }
                    case 3: {
                        dTGroupListener.groupDeactivated(dTGroupEvent);
                        continue block17;
                    }
                    case 4: {
                        dTGroupListener.groupDocking(dTGroupEvent);
                        continue block17;
                    }
                    case 5: {
                        dTGroupListener.groupDocked(dTGroupEvent);
                        continue block17;
                    }
                    case 6: {
                        dTGroupListener.groupUndocking(dTGroupEvent);
                        continue block17;
                    }
                    case 7: {
                        dTGroupListener.groupUndocked(dTGroupEvent);
                        continue block17;
                    }
                    case 8: {
                        dTGroupListener.groupRelocated(dTGroupEvent);
                        continue block17;
                    }
                    case 9: {
                        if (!(dTGroupListener instanceof DTGroupAdapter)) continue block17;
                        ((DTGroupAdapter)dTGroupListener).groupResized(dTGroupEvent);
                        continue block17;
                    }
                    case 10: {
                        dTGroupListener.groupOpened(dTGroupEvent);
                        continue block17;
                    }
                    case 11: {
                        dTGroupListener.groupClosing(dTGroupEvent);
                        continue block17;
                    }
                    case 12: {
                        dTGroupListener.groupClosed(dTGroupEvent);
                    }
                }
            }
            return;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        if (object instanceof DTGroupPropertyProvider) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.doPropertyChange(propertyChangeEvent);
            } else {
                SwingUtilities.invokeLater(new DeferredPropertyChange(propertyChangeEvent));
            }
        } else if (object instanceof DTClient) {
            DTClient dTClient = (DTClient)object;
            String string = propertyChangeEvent.getPropertyName();
            if ("Occupant Selected".equals(string)) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                if (bl && dTClient.isSingleton() && dTClient.getLocation() != null && dTClient.getLocation().isDocked()) {
                    this.setSelected(true, false);
                }
            } else if (DTClientProperty.ICON.toString().equals(string)) {
                this.fIcon = dTClient.getIcon();
                this.fSmallIcon = dTClient.getSmallIcon();
            } else if (DTClientProperty.SMALL_ICON.toString().equals(string)) {
                this.fSmallIcon = dTClient.getSmallIcon();
            } else if (DTClientProperty.TOOL_BAR.toString().equals(propertyChangeEvent.getPropertyName())) {
                this.notifyToolBars(this.isSelected());
            }
        }
    }

    @Override
    protected void doPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (DTGroupProperty.DROP_LISTENER.toString().equals(propertyChangeEvent.getPropertyName())) {
            this.updateDropListener();
        } else if (DTGroupProperty.DOCUMENT_BAR_ORDERING_COMAPARATOR.toString().equals(propertyChangeEvent.getPropertyName())) {
            this.configureDockedOrdering();
        }
        super.doPropertyChange(propertyChangeEvent);
    }

    @Override
    protected void forwardPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.fPropertyListeners == null) {
            return;
        }
        int n = this.fPropertyListeners.size();
        for (int i = 0; i < n; ++i) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.fPropertyListeners.get(i);
            propertyChangeListener.propertyChange(propertyChangeEvent);
            int n2 = this.fPropertyListeners.size();
            if (n2 >= n) continue;
            i -= n - n2;
            n = n2;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Boolean bl;
        Boolean bl2;
        boolean bl3;
        boolean bl4 = bl3 = itemEvent.getStateChange() == 1;
        if (bl3) {
            bl2 = Boolean.FALSE;
            bl = Boolean.TRUE;
            this.fireGroupEvent(this.createGroupEvent(1));
            this.fSelectionOrder = this.fDesktop.getSelectionManager().getNextSelectionOrder();
        } else {
            bl2 = Boolean.TRUE;
            bl = Boolean.FALSE;
        }
        if (this.fDocumentContainer != null) {
            this.fDocumentContainer.setSelected(bl3);
        }
        if (this.fInternalFrame != null) {
            this.fInternalFrame.setSelected(bl3);
        }
        this.forwardPropertyChange(new PropertyChangeEvent(this, "Occupant Selected", bl2, bl));
        this.notifyToolBars(bl3);
        if (bl3) {
            this.fireGroupEvent(this.createGroupEvent(2));
        } else {
            this.fireGroupEvent(this.createGroupEvent(3));
        }
    }

    @Override
    public void updateToolBars(String string, DTToolBarConfiguration dTToolBarConfiguration) {
        super.updateToolBars(string, dTToolBarConfiguration);
        if (this.fClients != null) {
            for (DTClient dTClient : this.fClients) {
                if (dTClient.isSingleton()) continue;
                dTClient.updateToolBars(string, dTToolBarConfiguration);
            }
        }
    }

    private void notifyToolBars(boolean bl) {
        for (JToolBar jToolBar : this.getToolBars()) {
            if (!(jToolBar instanceof MJToolBar)) continue;
            ((MJToolBar)jToolBar).setArmed(bl);
        }
    }

    public boolean equals(Object object) {
        String string;
        if (!(object instanceof DTGroup)) {
            return false;
        }
        DTGroup dTGroup = (DTGroup)object;
        String string2 = this.getName();
        return string2 == (string = dTGroup.getName()) || string2 != null && string2.equals(string);
    }

    public int hashCode() {
        return this.getName() == null ? 0 : this.getName().hashCode();
    }

    void updateFrom(DTGroup dTGroup) {
        this.fPropertyDataElement = dTGroup.fPropertyDataElement;
        if (this.fPropertyClassName == null) {
            this.fPropertyClassName = dTGroup.fPropertyClassName;
        }
        if (this.fLocation == null && this.isDockable()) {
            this.fContainingFrame = dTGroup.fContainingFrame;
        }
        this.fWasShowing = dTGroup.fWasShowing;
        this.fSavedSingletonsShowing = dTGroup.fSavedSingletonsShowing;
        if (dTGroup.fLastDockedLocation != null) {
            this.fLastDockedLocation = dTGroup.fLastDockedLocation;
        }
        if (dTGroup.fLastNestedLocation != null) {
            this.fLastNestedLocation = dTGroup.fLastNestedLocation;
        }
        if (dTGroup.fLastUndockedLocation != null) {
            this.fLastUndockedLocation = dTGroup.fLastUndockedLocation;
        }
        if (dTGroup.fLastDocumentLocation != null) {
            this.fLastDocumentLocation = dTGroup.fLastDocumentLocation;
        }
        this.fAlphabetizeDocuments = dTGroup.fAlphabetizeDocuments;
        this.configureDockedOrdering();
        this.fSelectionOrder = dTGroup.fSelectionOrder;
        this.fToolBarState = dTGroup.fToolBarState;
        this.fSavedFrameState = dTGroup.fSavedFrameState;
        this.fSavedBorderState = dTGroup.fSavedBorderState;
        this.fSavedNestState = dTGroup.fSavedNestState;
        this.fSavedDocumentState = dTGroup.fSavedDocumentState;
        this.fSavedUndockedSingletons = dTGroup.fSavedUndockedSingletons;
        this.fCollapseDocumentToolstrips = dTGroup.fCollapseDocumentToolstrips;
        if (dTGroup.fQuickAccessLocation != null) {
            this.fQuickAccessLocation = dTGroup.fQuickAccessLocation;
        }
    }

    void closeSingletons() {
        ArrayList<DTWindowCloser> arrayList = new ArrayList<DTWindowCloser>();
        for (DTClient dTClient : this.fSingletons) {
            if (!dTClient.isShowing()) continue;
            arrayList.add(dTClient);
        }
        if (arrayList.size() > 0) {
            this.startMultipleClose();
            DTCloseTransaction dTCloseTransaction = new DTCloseTransaction(arrayList);
            dTCloseTransaction.setDoneListener(new DTCloseTransaction.DoneListener(){

                @Override
                public void closeTransactionDone(boolean bl) {
                    DTGroup.this.endMultipleClose();
                }
            });
            dTCloseTransaction.start();
        }
    }

    void restoreSingletons() {
        this.fIsRestoringSingletons = true;
        if (this.getLocation() == null) {
            this.fDesktop.setGroupShowing(this, true, null, false);
        }
        if (this.fInternalFrame == null) {
            this.setInternalFrame(new DTGroupFrame(this));
        }
        DTGroupFrame dTGroupFrame = (DTGroupFrame)this.fInternalFrame;
        if (this.fSavedNestState != null || this.fSavedUndockedSingletons != null) {
            this.startMultipleClose();
            for (DTClient object : this.fSingletons) {
                if (!object.isShowing()) continue;
                this.fDesktop.setClientShowing(object, false, null, false);
            }
        } else {
            for (DTClient dTClient : this.fSingletons) {
                if (dTClient.isShowing()) continue;
                this.fDesktop.setClientShowing(dTClient, true, dTClient.getLastLocation(), false);
            }
            this.fIsRestoringSingletons = false;
            return;
        }
        this.endMultipleClose();
        if (this.fSavedBorderState != null || this.fSavedNestState != null) {
            dTGroupFrame.restoreState(this.fSavedBorderState, this.fSavedNestState);
        }
        if (this.fSavedUndockedSingletons != null) {
            for (String string : this.fSavedUndockedSingletons) {
                DTFloatingLocation dTFloatingLocation;
                DTClient dTClient = this.fDesktop.getDTClient(string);
                if (dTClient == null || (dTFloatingLocation = dTClient.getLastUndockedLocation()) == null) continue;
                this.fDesktop.setClientShowing(dTClient, true, dTFloatingLocation, false);
            }
        }
        this.fIsRestoringSingletons = false;
    }

    boolean isRestoringSingletons() {
        return this.fIsRestoringSingletons;
    }

    void setOnTopSingletonsVisible(boolean bl) {
        if (this.fContainingFrame instanceof DTMultipleClientFrame) {
            ((DTMultipleClientFrame)this.fContainingFrame).setOnTopWindowsVisible(this, bl);
        }
    }

    void saveSingletonState() {
        this.fSavedSingletonsShowing = this.areAnySingletonsShowing();
        if (!this.fSavedSingletonsShowing) {
            return;
        }
        DTGroupFrame dTGroupFrame = this.getGroupFrame();
        if (dTGroupFrame.getWidth() <= 0 || dTGroupFrame.getHeight() <= 0) {
            return;
        }
        this.fSavedBorderState = dTGroupFrame.getBorderContainer() != null ? dTGroupFrame.getBorderContainer().getState() : null;
        this.fSavedNestState = dTGroupFrame.getNestingContainer() != null ? dTGroupFrame.getNestingContainer().getState(true) : null;
        this.fSavedUndockedSingletons = new ArrayList<String>(this.fSingletons.size());
        for (DTClient dTClient : this.fSingletons) {
            if (!dTClient.isShowing() || dTClient.getLocation().isDocked()) continue;
            this.fSavedUndockedSingletons.add(dTClient.getShortTitle());
        }
        if (this.fSavedUndockedSingletons.size() == 0) {
            this.fSavedUndockedSingletons = null;
        }
    }

    boolean areAnySingletonsShowing() {
        for (DTClient dTClient : this.fSingletons) {
            if (!dTClient.isShowing()) continue;
            return true;
        }
        return false;
    }

    private void startMultipleClose() {
        if (this.fInternalFrame == null) {
            return;
        }
        DTNestingContainer dTNestingContainer = ((DTGroupFrame)this.fInternalFrame).getNestingContainer();
        if (dTNestingContainer != null) {
            dTNestingContainer.beginMultipleRemove();
        }
    }

    private void endMultipleClose() {
        if (this.fInternalFrame == null) {
            return;
        }
        DTNestingContainer dTNestingContainer = ((DTGroupFrame)this.fInternalFrame).getNestingContainer();
        if (dTNestingContainer != null) {
            dTNestingContainer.endMultipleRemove();
        }
    }

    Element toXML(Document document) {
        return this.toXML(document, true);
    }

    Element toXML(Document document, boolean bl) {
        Object object;
        Element element;
        boolean bl2;
        if (this.fDocumentCount > 0) {
            if (this.hasDockedDocuments()) {
                this.fLastDocumentLocation = this.getDockedDocuments().get(0).getLocation();
            } else {
                for (DTClient dTClient : this.fClients) {
                    if (dTClient.isSingleton()) continue;
                    this.fLastDocumentLocation = dTClient.getLocation();
                    break;
                }
            }
            if (this.fLastDocumentLocation != null) {
                this.fLastDocumentLocation = DTLocation.clone(this.fLastDocumentLocation);
                this.fLastDocumentLocation.setFrame(null);
                this.fLastDocumentLocation.setContainer(null);
            }
        }
        Element element2 = document.createElement(GROUP_TAG);
        if (this.getName() != null) {
            element2.setAttribute("Name", this.getName());
        }
        element2.setAttribute("Title", this.getTitle());
        if (this.fPropertyClassName != null) {
            element2.setAttribute(CLASS_ATTRIBUTE, this.fPropertyClassName);
        }
        element2.setAttribute("Guest", this.isGuest() ? "yes" : "no");
        element2.setAttribute("Show", this.fLocation != null ? "yes" : "no");
        element2.setAttribute(SHOW_SINGLETONS_ATTRIBUTE, (this.fLocation != null ? this.areAnySingletonsShowing() : this.singletonsWereShowing()) ? "yes" : "no");
        element2.setAttribute("Dock", this.fContainingFrame != null && this.fContainingFrame.isMainFrame() ? "yes" : "no");
        element2.setAttribute(ALPHABETIZE_ATTRIBUTE, this.fAlphabetizeDocuments ? "yes" : "no");
        boolean bl3 = bl2 = this.fLocation != null && this.fLocation.isDocked();
        if (this.fSelectionOrder > 0 && bl2) {
            element2.setAttribute("SelectionOrder", Integer.toString(this.fSelectionOrder));
        }
        this.saveToolBarState();
        if (this.fToolBarState != null) {
            element = DTToolBarContainer.stateToXML(this.fToolBarState, document);
            element2.appendChild(element);
        }
        if (this.fLastDockedLocation != null && bl) {
            element = this.fLastDockedLocation.toXML(document);
            element.setAttribute("Context", "docked");
            element2.appendChild(element);
        }
        if (this.fLastNestedLocation != null && bl) {
            element = this.fLastNestedLocation.toXML(document);
            element.setAttribute("Context", "nested");
            element2.appendChild(element);
        }
        if (this.fLastUndockedLocation != null && (this.fLocation == this.fLastUndockedLocation || bl)) {
            element = this.fLastUndockedLocation.toXML(document);
            element.setAttribute("Context", "undocked");
            element2.appendChild(element);
        }
        if (this.fLastDocumentLocation != null && bl) {
            element = this.fLastDocumentLocation.toXML(document);
            element.setAttribute("Context", DOCUMENT_VALUE);
            element2.appendChild(element);
        }
        if (this.fSavedFrameState != null) {
            element2.appendChild(DTMultipleClientFrame.stateToXML(this.fSavedFrameState, document));
        }
        if (this.fLocation != null) {
            this.saveSingletonState();
        }
        if (this.fSavedBorderState != null && (object = DTBorderContainer.stateToXML(this.fSavedBorderState, document)) != null) {
            element2.appendChild((Node)object);
        }
        if (this.fSavedNestState != null && (object = DTNestingContainer.stateToXML(this.fSavedNestState, document)) != null) {
            element2.appendChild((Node)object);
        }
        if (this.fSavedUndockedSingletons != null) {
            for (String string : this.fSavedUndockedSingletons) {
                Element element3 = document.createElement(UNDOCKED_SINGLETON_TAG);
                element3.setAttribute("Title", string);
                element2.appendChild(element3);
            }
        }
        if (this.fDocumentContainer != null) {
            this.fSavedDocumentState = this.fDocumentContainer.getState();
        }
        if (this.fSavedDocumentState != null) {
            element2.appendChild(DTDocumentContainer.stateToXML(this.fSavedDocumentState, document));
        }
        if (this.fRecoverable != null) {
            object = document.createElement(PROPERTY_DATA_TAG);
            this.fRecoverable.saveState(document, (Element)object);
            element2.appendChild((Node)object);
        }
        if (this.fDesktop.useToolstrip()) {
            element2.setAttribute(COLLAPSE_DOCUMENT_TOOLSTRIPS_ATTRIBUTE, this.fCollapseDocumentToolstrips ? "yes" : "no");
        }
        if (this.fQuickAccessLocation != null) {
            element2.appendChild(this.fQuickAccessLocation.toXML(document, QUICK_ACCESS_LOCATION_TAG));
        }
        return element2;
    }

    DTGroup(Desktop desktop, SimpleElement simpleElement) throws DataFormatException {
        super(desktop);
        String string;
        assert (GROUP_TAG.equals(simpleElement.getTagName()));
        if (simpleElement.hasAttribute("Name")) {
            this.fName = simpleElement.getAttribute("Name");
            if (this.fName.length() == 0) {
                throw new DataFormatException("Invalid Name: ");
            }
        }
        if (simpleElement.hasAttribute("Title")) {
            this.fTitle = simpleElement.getAttribute("Title");
            if (this.fTitle.length() == 0) {
                throw new DataFormatException("Invalid Title: ");
            }
        }
        if (simpleElement.hasAttribute("TitleResource")) {
            string = simpleElement.getAttribute("TitleResource");
            int n = string.indexOf(58);
            if (n == -1) {
                throw new DataFormatException("Invalid TitleResource: " + string);
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            this.fTitle = ResourceBundle.getBundle(string2).getString(string3);
        }
        this.fPropertyClassName = simpleElement.getAttribute(CLASS_ATTRIBUTE);
        string = simpleElement.getAttribute("Guest");
        this.fIsGuest = "yes".equalsIgnoreCase(string);
        string = simpleElement.getAttribute("Show");
        this.fWasShowing = "yes".equalsIgnoreCase(string);
        string = simpleElement.getAttribute(SHOW_SINGLETONS_ATTRIBUTE);
        this.fSavedSingletonsShowing = "yes".equalsIgnoreCase(string);
        string = simpleElement.getAttribute("Dock");
        this.fContainingFrame = "yes".equalsIgnoreCase(string) ? desktop.getMainFrame() : null;
        string = simpleElement.getAttribute(ALPHABETIZE_ATTRIBUTE);
        this.fAlphabetizeDocuments = "yes".equalsIgnoreCase(string);
        string = simpleElement.getAttribute("SelectionOrder");
        if (string != null && string.length() > 0) {
            try {
                this.fSelectionOrder = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataFormatException("Invalid SelectionOrder: " + string);
            }
        }
        string = simpleElement.getAttribute(COLLAPSE_DOCUMENT_TOOLSTRIPS_ATTRIBUTE);
        this.fCollapseDocumentToolstrips = "yes".equalsIgnoreCase(string);
        SimpleNodeList simpleNodeList = simpleElement.getChildNodes();
        int n = simpleNodeList.getLength();
        for (int i = 0; i < n; ++i) {
            SimpleElement simpleElement2 = (SimpleElement)simpleNodeList.item(i);
            String string4 = simpleElement2.getNodeName();
            if ("ToolBars".equals(string4)) {
                if (desktop.useToolstrip()) continue;
                this.fToolBarState = DTToolBarContainer.stateFromXML(simpleElement2);
                List<String> list = DTToolBarContainer.keysFromState(this.fToolBarState);
                List<String> list2 = DTToolBarContainer.labelsFromState(this.fToolBarState);
                for (int j = 0; j < list.size(); ++j) {
                    String string5 = list.get(j);
                    String string6 = list2.get(j);
                    if (string5 == null || string6 == null || desktop.getToolBarRegistry().isRegistered(string5)) continue;
                    DTOccupant.ToolBarData toolBarData = new DTOccupant.ToolBarData(this);
                    toolBarData.iLabel = string6;
                    this.fToolBarDataMap.put(string5, toolBarData);
                    desktop.getToolBarRegistry().register(string5, this);
                }
                continue;
            }
            if ("Location".equals(string4)) {
                string = simpleElement2.getAttribute("Context");
                if ("docked".equalsIgnoreCase(string)) {
                    this.fLastDockedLocation = DTLocation.fromXML(simpleElement2);
                    continue;
                }
                if ("nested".equalsIgnoreCase(string)) {
                    this.fLastNestedLocation = (DTNestedLocation)DTLocation.fromXML(simpleElement2);
                    continue;
                }
                if ("undocked".equalsIgnoreCase(string) || GROUP_VALUE.equalsIgnoreCase(string)) {
                    this.fLastUndockedLocation = (DTFloatingLocation)DTLocation.fromXML(simpleElement2);
                    continue;
                }
                if (!DOCUMENT_VALUE.equalsIgnoreCase(string)) continue;
                this.fLastDocumentLocation = DTLocation.fromXML(simpleElement2);
                continue;
            }
            if ("Frame".equals(string4)) {
                this.fSavedFrameState = DTMultipleClientFrame.stateFromXML(simpleElement2);
                continue;
            }
            if ("Borders".equals(string4)) {
                this.fSavedBorderState = DTBorderContainer.stateFromXML(simpleElement2);
                continue;
            }
            if ("Split".equals(string4)) {
                this.fSavedNestState = DTNestingContainer.stateFromXML(simpleElement2);
                continue;
            }
            if ("DocumentArea".equals(string4)) {
                this.fSavedDocumentState = DTDocumentContainer.stateFromXML(simpleElement2);
                continue;
            }
            if (UNDOCKED_SINGLETON_TAG.equals(string4)) {
                if (this.fSavedUndockedSingletons == null) {
                    this.fSavedUndockedSingletons = new ArrayList<String>();
                }
                this.fSavedUndockedSingletons.add(simpleElement2.getAttribute("Title"));
                continue;
            }
            if (PROPERTY_DATA_TAG.equals(string4)) {
                this.fPropertyDataElement = simpleElement2;
                continue;
            }
            if (!QUICK_ACCESS_LOCATION_TAG.equals(string4)) continue;
            this.fQuickAccessLocation = DTToolBarLocation.fromXML(simpleElement2);
        }
    }

    private class AlphabetizeAction
    extends MJAbstractAction {
        AlphabetizeAction() {
            super(DTGroup.this.getDesktop().getString("menuitem.Alphabetize"));
            this.setSelected(DTGroup.this.getAlphabetizeDocuments());
            DTMenuMergeTag.ALPHABETIZE.setTag((Action)((Object)this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTGroup.this.setAlphabetizeDocuments(!DTGroup.this.fAlphabetizeDocuments);
        }
    }

    class DockAllAction
    extends DTOccupant.OccupantAction {
        public DockAllAction() {
            super(DTGroup.this, "menuitem.DockAllInGroup");
            this.setComponentName("DockAll" + DTGroup.this.getName());
            this.putValue("SmallIcon", Desktop.DOCK_ALL_ICON);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTGroup.this.dockAll();
        }
    }

    class CloseDocumentsAction
    extends DTOccupant.OccupantAction {
        boolean fDockedOnly;

        public CloseDocumentsAction(boolean bl) {
            super(DTGroup.this, "menuitem.CloseThis");
            this.fDockedOnly = bl;
            this.setComponentName("Close" + DTGroup.this.getName());
            this.putValue("SmallIcon", Desktop.CLOSE_ICON);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!DTGroup.this.allowForcedClose() || (actionEvent.getModifiers() & 2) == 0 || !"Close".equals(actionEvent.getActionCommand())) {
                if (this.fDockedOnly) {
                    DTGroup.this.attemptCloseDocked();
                } else {
                    DTGroup.this.attemptCloseAll();
                }
            } else {
                if (this.fDockedOnly) {
                    DTGroup.this.getCloseDockedTransaction().close();
                } else {
                    DTGroup.this.getCloseAllTransaction(false).close();
                }
                ((DTMultipleClientFrame)DTGroup.this.getContainingFrame()).removeGroup(DTGroup.this);
                DTGroup.this.setLocation(null);
                DTGroup.this.setClosed();
            }
        }
    }

    class GroupToggleAction
    extends DTOccupant.ToggleAction {
        GroupToggleAction() {
            super(DTGroup.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            if (DTGroup.this.fLocation == null) {
                DTFrame dTFrame = DTGroup.this.fDesktop.getMainFrame();
                if (dTFrame != null) {
                    GlobalCursor.setWait((Window)((Object)dTFrame));
                }
                try {
                    DTGroup.this.fDesktop.setGroupShowing(DTGroup.this, true, null, true);
                }
                finally {
                    if (dTFrame != null) {
                        GlobalCursor.clear((Window)((Object)dTFrame));
                    }
                }
            } else {
                DTGroup.this.fDesktop.closeGroup(DTGroup.this, false, true);
                if (DTGroup.this.fLocation != null) {
                    this.setSelected(true);
                }
            }
        }
    }

    class GroupSelectAction
    extends DTOccupant.SelectAction {
        int fIndex;

        public GroupSelectAction() {
            super(DTGroup.this);
            this.fIndex = DTGroup.this.fDesktop.getGroups().indexOf(DTGroup.this);
            this.setAccelerator();
        }

        void setAccelerator() {
            KeyStroke keyStroke = null;
            if (this.fIndex != -1 && this.fIndex <= 9) {
                keyStroke = KeyStroke.getKeyStroke(48 + this.fIndex, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK | 1);
            }
            this.setAccelerator(keyStroke);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTGroup.this.select();
        }
    }

    class GroupMaximizeAction
    extends DTOccupant.MaximizeAction {
        GroupMaximizeAction() {
            super(DTGroup.this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (DTGroup.this.getLocation() == null) {
                return;
            }
            DTGroup.this.fDesktop.setGroupMaximized(DTGroup.this, !DTGroup.this.getLocation().isMaximized());
        }
    }

    class GroupMinimizeAction
    extends DTOccupant.MinimizeAction {
        GroupMinimizeAction() {
            super(DTGroup.this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (DTGroup.this.getLocation() == null) {
                return;
            }
            boolean bl = !DTGroup.this.getLocation().isMinimized();
            DTGroup.this.fDesktop.setGroupMinimized(DTGroup.this, bl, this.iEdge);
            if (!bl) {
                DTGroup.this.select();
            }
        }
    }

    class GroupUndockAction
    extends DTOccupant.UndockAction {
        GroupUndockAction() {
            super(DTGroup.this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTGroup.this.fDesktop.setGroupDocked(DTGroup.this, false);
        }
    }

    class GroupDockAction
    extends DTOccupant.DockAction {
        GroupDockAction() {
            super(DTGroup.this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTGroup.this.fDesktop.setGroupDocked(DTGroup.this, true);
        }
    }

    class GroupCloseAction
    extends DTOccupant.CloseAction {
        GroupCloseAction() {
            super(DTGroup.this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTGroup.this.fDesktop.closeGroup(DTGroup.this, false, true);
        }
    }

    class GroupOpenAction
    extends DTOccupant.OpenAction {
        GroupOpenAction() {
            super(DTGroup.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            if (DTGroup.this.isShowing()) {
                DTGroup.this.select();
            } else {
                DTFrame dTFrame = DTGroup.this.fDesktop.getMainFrame();
                if (dTFrame != null) {
                    GlobalCursor.setWait((Window)((Object)dTFrame));
                }
                try {
                    DTGroup.this.fDesktop.setGroupShowing(DTGroup.this, true, null, true);
                }
                finally {
                    if (dTFrame != null) {
                        GlobalCursor.clear((Window)((Object)dTFrame));
                    }
                }
            }
        }
    }

    private class DeferredPropertyChange
    implements Runnable {
        PropertyChangeEvent fEvent;

        DeferredPropertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.fEvent = propertyChangeEvent;
        }

        @Override
        public void run() {
            DTGroup.this.doPropertyChange(this.fEvent);
        }
    }

    class GroupCloseTransaction
    extends DTCloseTransaction {
        boolean iClosingContainer;

        public GroupCloseTransaction(Collection<DTWindowCloser> collection, boolean bl) {
            super(collection);
            this.iClosingContainer = bl;
        }

        @Override
        public void start() {
            DTGroup.this.fWasSelectedWhenCloseInitiated = DTGroup.this.isSelected();
            DTGroup.this.fIsClosing = this.iClosingContainer;
            super.start();
        }

        @Override
        protected void done(boolean bl) {
            super.done(bl);
            DTGroup.this.fIsClosing = false;
        }

        @Override
        protected void close() {
            if (this.iClosingContainer) {
                DTGroup.this.saveSingletonState();
            }
            super.close();
        }
    }

    private class LocationListener
    implements DTLocation.Listener {
        private LocationListener() {
        }

        @Override
        public void locationChanged(DTLocation dTLocation, DTLocation.ChangeType changeType) {
            if (!DTGroup.this.isClosing()) {
                if (changeType == DTLocation.ChangeType.MOVE) {
                    DTGroup.this.fireGroupEvent(DTGroup.this.createGroupEvent(8));
                } else if (changeType == DTLocation.ChangeType.RESIZE) {
                    DTGroup.this.fireGroupEvent(DTGroup.this.createGroupEvent(9));
                }
            }
        }
    }
}

