/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.ScrollablePopupList;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.util.Predicate;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTCloseTransaction;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTUtilities;
import com.mathworks.widgets.desk.DTWindowActivator;
import com.mathworks.widgets.desk.DTWindowCloser;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class DTWindowRegistry {
    private List<ActivatorData> fActivators = new ArrayList<ActivatorData>();
    private List<DTWindowCloser> fClosers = new ArrayList<DTWindowCloser>();
    private List<Desktop> fDesktops = new ArrayList<Desktop>();
    private int fVersion;
    private JMenu fItemOwner;
    private int fOwnerBottom;
    private int fOwnedVersion;
    private int fOwnedCount;
    private ActivatorData fTargetData = new ActivatorData();
    private static DTWindowRegistry sInstance = new DTWindowRegistry();
    private static final String NO_GROUP = "NO GROUP";

    public static DTWindowRegistry getInstance() {
        return sInstance;
    }

    public synchronized void addActivator(DTWindowActivator dTWindowActivator) {
        ActivatorData activatorData = new ActivatorData(dTWindowActivator);
        int n = this.fActivators.indexOf(activatorData);
        if (n != -1) {
            return;
        }
        activatorData.init();
        ++this.fVersion;
        String string = null;
        int n2 = this.fActivators.size();
        for (n = 0; n < n2; ++n) {
            ActivatorData activatorData2 = this.fActivators.get(n);
            if (string != null && !string.equals(activatorData2.fGroup) && string.equals(activatorData.fGroup)) break;
            string = activatorData2.fGroup;
        }
        this.fActivators.add(n, activatorData);
        if (dTWindowActivator instanceof DTWindowCloser) {
            this.fClosers.add((DTWindowCloser)((Object)dTWindowActivator));
        }
    }

    public synchronized void removeActivator(DTWindowActivator dTWindowActivator) {
        this.fTargetData.fActivator = dTWindowActivator;
        int n = this.fActivators.indexOf(this.fTargetData);
        this.fTargetData.fActivator = null;
        if (n == -1) {
            return;
        }
        ++this.fVersion;
        ActivatorData activatorData = this.fActivators.get(n);
        activatorData.fAction.disarm();
        this.fActivators.remove(n);
        if (dTWindowActivator instanceof DTWindowCloser) {
            DTWindowCloser dTWindowCloser = (DTWindowCloser)((Object)dTWindowActivator);
            this.fClosers.remove(dTWindowCloser);
        }
    }

    public synchronized void nameChange(DTWindowActivator dTWindowActivator) {
        this.fTargetData.fActivator = dTWindowActivator;
        int n = this.fActivators.indexOf(this.fTargetData);
        this.fTargetData.fActivator = null;
        if (n == -1) {
            return;
        }
        ActivatorData activatorData = this.fActivators.get(n);
        if (SwingUtilities.isEventDispatchThread()) {
            activatorData.fAction.updateName();
        } else {
            SwingUtilities.invokeLater(new NameUpdater(activatorData.fAction));
        }
    }

    public synchronized void setVisible(DTWindowActivator dTWindowActivator, boolean bl) {
        this.fTargetData.fActivator = dTWindowActivator;
        int n = this.fActivators.indexOf(this.fTargetData);
        this.fTargetData.fActivator = null;
        if (n == -1) {
            return;
        }
        ActivatorData activatorData = this.fActivators.get(n);
        if (activatorData.fIsVisible != bl) {
            activatorData.fIsVisible = bl;
            ++this.fVersion;
        }
    }

    public synchronized void addCloser(DTWindowCloser dTWindowCloser) {
        this.fClosers.add(dTWindowCloser);
    }

    public synchronized void removeCloser(DTWindowCloser dTWindowCloser) {
        this.fClosers.remove(dTWindowCloser);
    }

    public synchronized void addDesktop(Desktop desktop) {
        this.fDesktops.add(desktop);
    }

    public synchronized void removeDesktop(Desktop desktop) {
        this.fDesktops.remove(desktop);
    }

    synchronized boolean isEmpty() {
        return this.fActivators.isEmpty();
    }

    synchronized boolean hasAnyVisible() {
        int n = this.fActivators.size();
        for (int i = 0; i < n; ++i) {
            ActivatorData activatorData = this.fActivators.get(i);
            if (!activatorData.fIsVisible) continue;
            return true;
        }
        return false;
    }

    synchronized void populate(JMenu jMenu, boolean bl, Predicate<DTWindowActivator> predicate) {
        JPopupMenu jPopupMenu = jMenu.getPopupMenu();
        Component component = jPopupMenu.getInvoker();
        int n = component.isShowing() ? component.getLocationOnScreen().y : 0;
        int n2 = n + component.getHeight();
        if (this.fItemOwner == jMenu && this.fVersion == this.fOwnedVersion && n2 == this.fOwnerBottom) {
            return;
        }
        if (this.fItemOwner != null) {
            this.depopulate(this.fItemOwner);
        }
        if (this.isEmpty()) {
            return;
        }
        Rectangle rectangle = WindowUtils.getScreenBounds();
        int n3 = rectangle.y + rectangle.height - n2;
        if (n3 < n - rectangle.y) {
            n3 = n - rectangle.y;
        }
        int n4 = jPopupMenu.getPreferredSize().height;
        int n5 = new MJMenu((String)Desktop.getString((Component)jMenu, (String)"menu.More")).getPreferredSize().height;
        int n6 = new JSeparator().getPreferredSize().height;
        int n7 = 0;
        String string = NO_GROUP;
        boolean bl2 = false;
        int n8 = 0;
        int n9 = this.fActivators.size();
        for (int i = 0; i < n9; ++i) {
            ActivatorData activatorData = this.fActivators.get(i);
            if (!activatorData.fIsVisible || predicate != null && !predicate.accept((Object)activatorData.fActivator)) continue;
            if (!(jMenu.getMenuComponentCount() <= 0 || activatorData.fGroup != null && activatorData.fGroup.equals(string))) {
                jMenu.addSeparator();
                n4 += n6;
                ++n7;
                bl2 = true;
            }
            activatorData.fAction.setMnemonicIndex(bl ? n8 : -1);
            ++n8;
            string = activatorData.fGroup;
            MJMenuItem mJMenuItem = activatorData.getMenuItem();
            n4 += mJMenuItem.getPreferredSize().height;
            if (i == n9 - 1) {
                n5 = 0;
            }
            if (n4 + n5 < n3) {
                jMenu.add((JMenuItem)mJMenuItem);
                ++n7;
                bl2 = false;
                continue;
            }
            if (!bl2) {
                jMenu.addSeparator();
                ++n7;
            }
            jMenu.add((JMenuItem)((Object)new MoreMenu(jMenu, i, bl)));
            ++n7;
            break;
        }
        this.fItemOwner = jMenu;
        this.fOwnerBottom = n2;
        this.fOwnedVersion = this.fVersion;
        this.fOwnedCount = n7;
    }

    synchronized void depopulate(JMenu jMenu) {
        if (jMenu == this.fItemOwner) {
            int n = jMenu.getMenuComponentCount();
            for (int i = 0; i < this.fOwnedCount; ++i) {
                jMenu.remove(--n);
            }
            this.fItemOwner = null;
            this.fOwnerBottom = 0;
        }
    }

    public synchronized Collection<DTWindowActivator> getActivators() {
        ArrayList<DTWindowActivator> arrayList = new ArrayList<DTWindowActivator>(this.fActivators.size());
        int n = this.fActivators.size();
        for (int i = 0; i < n; ++i) {
            ActivatorData activatorData = this.fActivators.get(i);
            if (!activatorData.fIsVisible) continue;
            arrayList.add(activatorData.fActivator);
        }
        return arrayList;
    }

    public synchronized String getActivatorsAsString() {
        StringBuilder stringBuilder = new StringBuilder("");
        String string = null;
        int n = this.fActivators.size();
        for (int i = 0; i < n; ++i) {
            ActivatorData activatorData = this.fActivators.get(i);
            if (!activatorData.fIsVisible) continue;
            if (string != null && !activatorData.fActivator.getGroupName().equals(string)) {
                stringBuilder.append(" '-'");
            }
            stringBuilder.append(" '");
            stringBuilder.append(activatorData.fActivator.getShortTitle());
            stringBuilder.append("'");
            string = activatorData.fActivator.getGroupName();
        }
        if (string != null) {
            stringBuilder.append(" '-'");
        }
        return stringBuilder.toString();
    }

    public synchronized List<Action> getActivationActions(String string) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        for (ActivatorData activatorData : this.fActivators) {
            if (!activatorData.fIsVisible || string != null && !string.equals(activatorData.fGroup)) continue;
            arrayList.add((Action)((Object)activatorData.fAction));
        }
        return arrayList;
    }

    public synchronized List<Action> getActivationActions(Predicate<String> predicate) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        for (ActivatorData activatorData : this.fActivators) {
            if (!activatorData.fIsVisible || !predicate.accept((Object)activatorData.fGroup)) continue;
            arrayList.add((Action)((Object)activatorData.fAction));
        }
        return arrayList;
    }

    public synchronized Collection<DTWindowCloser> getClosers() {
        return new ArrayList<DTWindowCloser>(this.fClosers);
    }

    synchronized DTCloseTransaction getCloseAllListedTransaction() {
        ArrayList<DTWindowCloser> arrayList = new ArrayList<DTWindowCloser>(this.fActivators.size());
        int n = this.fActivators.size();
        for (int i = 0; i < n; ++i) {
            ActivatorData activatorData = this.fActivators.get(i);
            if (!(activatorData.fActivator instanceof DTWindowCloser) || activatorData.fActivator instanceof DTClient && !((DTClient)activatorData.fActivator).permitUserClose()) continue;
            arrayList.add((DTWindowCloser)((Object)activatorData.fActivator));
        }
        return new DTCloseTransaction(arrayList){

            @Override
            public void start() {
                DTWindowRegistry.this.alertAllGroups(true);
                super.start();
            }

            @Override
            protected void done(boolean bl) {
                DTWindowRegistry.this.alertAllGroups(false);
                if (bl) {
                    DTWindowRegistry.this.closeAllGroups();
                }
                super.done(bl);
            }
        };
    }

    private void closeAllGroups() {
        for (Desktop desktop : this.fDesktops) {
            List<DTGroup> list = desktop.getGroups();
            for (DTGroup dTGroup : list) {
                DTGroup dTGroup2 = dTGroup;
                if (dTGroup2.getLocation() == null || !dTGroup2.permitUserClose()) continue;
                desktop.closeGroup(dTGroup2, false, true);
            }
        }
    }

    private void alertAllGroups(boolean bl) {
        for (Desktop desktop : this.fDesktops) {
            List<DTGroup> list = desktop.getGroups();
            for (DTGroup dTGroup : list) {
                DTGroup dTGroup2 = dTGroup;
                if (dTGroup2.getLocation() == null || !dTGroup2.permitUserClose()) continue;
                dTGroup2.setClosing(bl);
            }
        }
    }

    synchronized DTCloseTransaction getCloseAllTransaction() {
        return new DTCloseTransaction(new ArrayList<DTWindowCloser>(this.fClosers));
    }

    synchronized boolean canCloseAll() {
        int n = 0;
        int n2 = this.fClosers.size();
        while (n < n2) {
            if (!this.fClosers.get(n).canClose()) {
                return false;
            }
            if (this.fClosers.size() < n2) {
                n2 = this.fClosers.size();
                continue;
            }
            ++n;
        }
        return true;
    }

    synchronized void closeAll() {
        int n = 0;
        int n2 = this.fClosers.size();
        while (n < n2) {
            DTWindowCloser dTWindowCloser = this.fClosers.get(n);
            dTWindowCloser.close();
            if (this.fClosers.size() < n2) {
                n2 = this.fClosers.size();
                continue;
            }
            ++n;
        }
    }

    private static String prependMnemonic(String string, int n) {
        char c = ' ';
        StringBuffer stringBuffer = new StringBuffer(string.length() + 3);
        if (n < 26) {
            c = (char)(65 + n);
            stringBuffer.append('&');
        }
        stringBuffer.append(c);
        stringBuffer.append(' ');
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private class MoreMenu
    extends MJMenu
    implements MenuListener {
        private int iFirstIndex;
        private ScrollablePopupList iList;
        private boolean iShowMnemonics;

        MoreMenu(JMenu jMenu, int n, boolean bl) {
            super(Desktop.getString(jMenu, "menu.More"));
            this.iFirstIndex = n;
            this.iShowMnemonics = bl;
            this.addMenuListener(this);
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            if (this.iList == null) {
                this.iList = new ScrollablePopupList();
                this.iList.setVisibleRowCount(100);
                String string = DTWindowRegistry.NO_GROUP;
                int n = 0;
                int n2 = DTWindowRegistry.this.fActivators.size();
                for (int i = this.iFirstIndex; i < n2; ++i) {
                    ActivatorData activatorData = (ActivatorData)DTWindowRegistry.this.fActivators.get(i);
                    if (!activatorData.fIsVisible) continue;
                    if (activatorData.fGroup == null || !activatorData.fGroup.equals(string)) {
                        if (n > 0) {
                            this.iList.addSeparator();
                        }
                        string = activatorData.fGroup;
                    }
                    activatorData.fAction.setMnemonicIndex(this.iShowMnemonics ? n : -1);
                    ++n;
                    this.iList.addItem((Action)((Object)activatorData.fAction));
                }
            }
            this.iList.addToMenu((JMenu)((Object)this));
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
            if (this.iList != null) {
                this.iList.removeFromMenu((JMenu)((Object)this));
            }
        }

        @Override
        public void menuCanceled(MenuEvent menuEvent) {
            this.menuDeselected(menuEvent);
        }
    }

    static class ActivationAction
    extends MJAbstractAction {
        DTWindowActivator fActivator;
        int fMnemonicIndex = -1;

        ActivationAction(DTWindowActivator dTWindowActivator) {
            super(dTWindowActivator.getShortTitle());
            this.fActivator = dTWindowActivator;
            this.setComponentName("Select" + dTWindowActivator.getShortTitle());
            this.updateTip();
        }

        void setMnemonicIndex(int n) {
            if (this.fActivator == null) {
                return;
            }
            if (n != this.fMnemonicIndex) {
                this.fMnemonicIndex = n;
                this.setName(this.createName(this.fActivator, this.fMnemonicIndex));
                this.updateTip();
            }
        }

        void updateName() {
            if (this.fActivator == null) {
                return;
            }
            this.setName(this.createName(this.fActivator, this.fMnemonicIndex));
            this.setComponentName("Select" + this.fActivator.getShortTitle());
            this.updateTip();
        }

        void updateTip() {
            DTClient dTClient;
            String string = null;
            if (this.fActivator instanceof DTClient && !(dTClient = (DTClient)this.fActivator).getTitle().equals(this.fActivator.getShortTitle())) {
                string = dTClient.getTitle();
            }
            this.setTip(string);
        }

        private String createName(DTWindowActivator dTWindowActivator, int n) {
            String string = dTWindowActivator.getShortTitle();
            string = string == null ? MJUtilities.intlString((String)"window.Untitled") : DTUtilities.constrainTitle(string, 32);
            return n < 0 ? string : DTWindowRegistry.prependMnemonic(string, n);
        }

        void disarm() {
            this.fActivator = null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.fActivator != null) {
                this.fActivator.activate();
            }
        }
    }

    class ActivatorData {
        DTWindowActivator fActivator;
        String fGroup;
        ActivationAction fAction;
        boolean fIsVisible = true;
        private MJMenuItem fMenuItem;

        ActivatorData() {
        }

        ActivatorData(DTWindowActivator dTWindowActivator) {
            this.fActivator = dTWindowActivator;
        }

        void init() {
            this.fGroup = this.fActivator.getGroupName();
            this.fAction = new ActivationAction(this.fActivator);
        }

        MJMenuItem getMenuItem() {
            if (this.fMenuItem == null) {
                this.fMenuItem = new MJMenuItem((Action)((Object)this.fAction));
            }
            this.fMenuItem.setToolTipText(this.fAction.getTip());
            return this.fMenuItem;
        }

        public boolean equals(Object object) {
            return object instanceof ActivatorData && ((ActivatorData)object).fActivator == this.fActivator;
        }
    }

    class NameUpdater
    implements Runnable {
        ActivationAction fAction;

        NameUpdater(ActivationAction activationAction) {
            this.fAction = activationAction;
        }

        @Override
        public void run() {
            this.fAction.updateName();
        }
    }
}

