/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.glazedlists;

import ca.odell.glazedlists.TreeList;
import ca.odell.glazedlists.swing.TreeNodeData;
import ca.odell.glazedlists.swing.TreeTableNodeDataRenderer;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.TableUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class GlazedTableSupport {
    private MouseAdapter fListener;
    private JTable fTable;
    private KeyListener fKeyListener;
    private TreeList<?> fTreeList;

    private GlazedTableSupport(final JTable jTable, final TreeList<?> treeList, TableCellRenderer tableCellRenderer) {
        this.fTable = jTable;
        this.fTreeList = treeList;
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            TableCellRenderer tableCellRenderer2 = jTable.getColumnModel().getColumn(i).getCellRenderer();
            if (tableCellRenderer2 == null) {
                tableCellRenderer2 = new DefaultTableCellRenderer();
            }
            this.fTable.getColumnModel().getColumn(i).setCellRenderer((TableCellRenderer)((Object)new GroupingTableRenderer(tableCellRenderer2, treeList, tableCellRenderer)));
        }
        Dimension dimension = this.fTable.getIntercellSpacing();
        this.fTable.setIntercellSpacing(new Dimension(0, dimension.height));
        this.fListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n;
                Component component;
                if (mouseEvent.getButton() == 1 && !((component = SwingUtilities.getDeepestComponentAt(GlazedTableSupport.this.fTable, mouseEvent.getPoint().x, mouseEvent.getPoint().y)) instanceof AbstractButton) && treeList.getAllowsChildren(n = jTable.rowAtPoint(mouseEvent.getPoint()))) {
                    treeList.toggleExpanded(n);
                }
            }
        };
        this.fKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (GlazedTableSupport.this.fTable.getSelectedRowCount() == 1) {
                    int n2 = GlazedTableSupport.this.fTable.getSelectedRow();
                    while (!GlazedTableSupport.this.fTreeList.hasChildren(n2)) {
                        --n2;
                    }
                    if (n == 37) {
                        GlazedTableSupport.this.fTreeList.setExpanded(n2, false);
                    } else if (n == 39) {
                        GlazedTableSupport.this.fTreeList.setExpanded(n2, true);
                    }
                }
            }
        };
        this.fTable.addMouseListener(this.fListener);
        this.fTable.addKeyListener(this.fKeyListener);
    }

    public void uninstall() {
        this.fTable.removeMouseListener(this.fListener);
        this.fTable.removeKeyListener(this.fKeyListener);
        this.fListener = null;
        this.fTable = null;
        this.fKeyListener = null;
        this.fTreeList = null;
    }

    public static GlazedTableSupport install(JTable jTable, TreeList<?> treeList) {
        return new GlazedTableSupport(jTable, treeList, null);
    }

    public static GlazedTableSupport install(JTable jTable, TreeList<?> treeList, TableCellRenderer tableCellRenderer) {
        return new GlazedTableSupport(jTable, treeList, tableCellRenderer);
    }

    private static class TitleRowRenderer
    extends MJPanel {
        private TitleRowRenderer(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2, boolean bl3, TableCellRenderer tableCellRenderer) {
            boolean bl4;
            this.setOpaque(true);
            Icon icon = bl3 ? UIManager.getIcon("Tree.expandedIcon") : UIManager.getIcon("Tree.collapsedIcon");
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setPreferredSize(new Dimension(jTable.getWidth(), this.getHeight()));
            FormLayout formLayout = new FormLayout(-TableUtils.getXForColumn((JTable)jTable, (int)n2) + "px, 2dlu, p, p:grow", "p");
            this.setLayout((LayoutManager)formLayout);
            MJLabel mJLabel = new MJLabel(icon);
            mJLabel.setOpaque(false);
            mJLabel.setVerticalAlignment(0);
            this.add((Component)mJLabel, new CellConstraints("3, 1, center, center"));
            boolean bl5 = bl4 = bl || jTable.isRowSelected(n);
            if (tableCellRenderer != null) {
                this.add(tableCellRenderer.getTableCellRendererComponent(jTable, object, bl4, bl2, n, n2), new CellConstraints("4, 1, fill, fill"));
            } else {
                MJLabel mJLabel2 = new MJLabel(jTable.getModel().getValueAt(n, n2).toString());
                mJLabel2.setFont(mJLabel2.getFont().deriveFont(1));
                mJLabel2.setOpaque(false);
                this.add((Component)mJLabel2, new CellConstraints("4, 1, fill, fill"));
            }
            this.setBackground(bl4 ? jTable.getSelectionBackground() : jTable.getBackground());
        }

        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint = graphics2D.getPaint();
            Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setPaint(this.getBackground());
            graphics2D.fill(rectangle);
            graphics2D.setPaint(paint);
        }
    }

    private static class GroupingTableRenderer
    implements TreeTableNodeDataRenderer {
        private final TableCellRenderer fDelegate;
        private final TreeList<?> fList;
        private final TableCellRenderer fCustomTitleRenderer;

        private GroupingTableRenderer(TableCellRenderer tableCellRenderer, TreeList<?> treeList, TableCellRenderer tableCellRenderer2) {
            this.fDelegate = tableCellRenderer;
            this.fList = treeList;
            this.fCustomTitleRenderer = tableCellRenderer2;
        }

        public void setTreeNodeData(TreeNodeData treeNodeData) {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return this.fList.hasChildren(n) ? new TitleRowRenderer(jTable, object, bl, bl2, n, n2, this.fList.isExpanded(n), this.fCustomTitleRenderer) : this.fDelegate.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }
}

