/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.grouptable;

import com.mathworks.util.Holder;
import com.mathworks.util.RequestFilter;
import com.mathworks.widgets.grouptable.Affordance;
import com.mathworks.widgets.grouptable.DisplayEffects;
import com.mathworks.widgets.grouptable.GroupingTable;
import com.mathworks.widgets.grouptable.GroupingTableRow;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

final class AffordanceManager<T> {
    private Map<T, DisplayEffects> fEffectsCache;
    private final List<Map<T, DisplayEffects>> fObsoleteEffectsCaches;
    private final GroupingTable<T> fTable;
    private final Object fLock;
    private final ChangeListener fAffordanceListener;
    private final RequestFilter fLoadFilter;

    AffordanceManager(GroupingTable<T> groupingTable) {
        this.fTable = groupingTable;
        this.fLock = new Object();
        this.fObsoleteEffectsCaches = new ArrayList<Map<T, DisplayEffects>>();
        this.fLoadFilter = new RequestFilter(new Runnable(){

            @Override
            public void run() {
                AffordanceManager.this.updateCacheForVisibleItems();
            }
        });
        this.fEffectsCache = new WeakHashMap<T, DisplayEffects>();
        this.fAffordanceListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                AffordanceManager.this.invalidateCacheAndReplaceVisibleEffects();
            }
        };
        this.adjustAffordanceListener(new ArrayList<Affordance<T>>(), groupingTable.getConfiguration().getAffordances());
        this.updateCacheAndListenersWhenAffordanceListChanges();
        this.startUpdatingCacheWhenRowsBecomeVisible();
        this.flushCacheWhenLocationChanges();
        this.fLoadFilter.request();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayEffects getEffects(T t) {
        Object object = this.fLock;
        synchronized (object) {
            DisplayEffects displayEffects = this.fEffectsCache.get(t);
            if (displayEffects == null) {
                Map<T, DisplayEffects> map;
                Iterator<Map<T, DisplayEffects>> iterator = this.fObsoleteEffectsCaches.iterator();
                while (iterator.hasNext() && (displayEffects = (map = iterator.next()).get(t)) == null) {
                }
            }
            return displayEffects;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayEffects getEffects(GroupingTableRow<T> groupingTableRow) {
        Object object = this.fLock;
        synchronized (object) {
            GroupingTableRow groupingTableRow2 = groupingTableRow;
            while (groupingTableRow2 != null) {
                DisplayEffects displayEffects;
                if (groupingTableRow2.getItem() != null && (displayEffects = this.getEffects(groupingTableRow2.getItem())) != null) {
                    return displayEffects;
                }
                if (groupingTableRow2.getParent() instanceof GroupingTableRow) {
                    groupingTableRow2 = (GroupingTableRow)groupingTableRow2.getParent();
                    continue;
                }
                groupingTableRow2 = null;
            }
            return null;
        }
    }

    private void flushCacheWhenLocationChanges() {
        this.fTable.getGroupingModel().addLocationListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Object object = AffordanceManager.this.fLock;
                synchronized (object) {
                    AffordanceManager.this.fEffectsCache = new WeakHashMap();
                    AffordanceManager.this.fObsoleteEffectsCaches.clear();
                }
            }
        });
    }

    private void updateCacheAndListenersWhenAffordanceListChanges() {
        this.fTable.getConfiguration().addPropertyChangeListener("affordances", new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object = AffordanceManager.this.fLock;
                synchronized (object) {
                    AffordanceManager.this.adjustAffordanceListener((List)propertyChangeEvent.getOldValue(), (List)propertyChangeEvent.getNewValue());
                    AffordanceManager.this.invalidateCacheAndReplaceVisibleEffects();
                }
            }
        });
    }

    private void startUpdatingCacheWhenRowsBecomeVisible() {
        this.fTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                AffordanceManager.this.fLoadFilter.request();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateCacheAndReplaceVisibleEffects() {
        Object object = this.fLock;
        synchronized (object) {
            this.fObsoleteEffectsCaches.add(0, this.fEffectsCache);
            this.fEffectsCache = new WeakHashMap<T, DisplayEffects>();
        }
        this.fLoadFilter.request();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushInvalidCacheData() {
        Object object = this.fLock;
        synchronized (object) {
            this.fObsoleteEffectsCaches.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCacheForVisibleItems() {
        block13: {
            assert (!SwingUtilities.isEventDispatchThread());
            final Holder holder = new Holder();
            final Holder holder2 = new Holder();
            try {
                HashSet<T> hashSet;
                Map<T, DisplayEffects> map;
                Iterator iterator = this.fLock;
                synchronized (iterator) {
                    map = this.fEffectsCache;
                    hashSet = new HashSet<T>(map.keySet());
                }
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        holder.set((Object)AffordanceManager.this.getVisibleItems());
                        holder2.set(AffordanceManager.this.fTable.getConfiguration().getAffordances());
                    }
                });
                if (holder == null || holder.get() == null || ((List)holder.get()).isEmpty()) break block13;
                iterator = ((List)holder.get()).iterator();
                while (iterator.hasNext()) {
                    if (!hashSet.contains(iterator.next())) continue;
                    iterator.remove();
                }
                HashMap hashMap = new HashMap();
                for (Affordance affordance : (List)holder2.get()) {
                    this.combineEffects(hashMap, affordance.getDisplayEffects((List)holder.get()));
                }
                Object object = this.fLock;
                synchronized (object) {
                    map.putAll(hashMap);
                    if (map == this.fEffectsCache) {
                        this.flushInvalidCacheData();
                    }
                    if (!((List)holder.get()).isEmpty()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                AffordanceManager.this.fTable.revalidate();
                                AffordanceManager.this.fTable.repaint();
                            }
                        });
                    }
                }
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }
    }

    private List<T> getVisibleItems() {
        assert (SwingUtilities.isEventDispatchThread());
        ArrayList<T> arrayList = new ArrayList<T>();
        for (int i = 0; i < this.fTable.getRowCount(); ++i) {
            T t = this.fTable.get(i);
            if (t == null) continue;
            arrayList.add(t);
        }
        return arrayList;
    }

    private void combineEffects(Map<T, DisplayEffects> map, Map<T, DisplayEffects> map2) {
        for (Map.Entry<T, DisplayEffects> entry : map2.entrySet()) {
            if (entry.getValue() == null) continue;
            DisplayEffects displayEffects = map.get(entry.getKey());
            if (displayEffects != null) {
                map.put(entry.getKey(), new DisplayEffects(displayEffects, entry.getValue()));
                continue;
            }
            map.put(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustAffordanceListener(List<Affordance<T>> list, List<Affordance<T>> list2) {
        Object object = this.fLock;
        synchronized (object) {
            for (Affordance<T> affordance : list) {
                if (list2.contains(affordance)) continue;
                affordance.removeChangeListener(this.fAffordanceListener);
            }
            for (Affordance<T> affordance : list2) {
                if (list.contains(affordance)) continue;
                affordance.addChangeListener(this.fAffordanceListener);
            }
        }
    }
}

