/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.grouptable;

import com.mathworks.mwswing.ComponentUtils;
import com.mathworks.widgets.ClosableToolTip;
import com.mathworks.widgets.ClosableToolTipData;
import com.mathworks.widgets.ToolTipSourceParentIsNullException;
import com.mathworks.widgets.grouptable.GroupingTable;
import com.mathworks.widgets.grouptable.NonRectangularCellRenderer;
import com.mathworks.widgets.tooltip.BalloonToolTip;
import com.mathworks.widgets.tooltip.ToolTipAndComponentAWTListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public final class ToolTipSupport {
    private static final Map<GroupingTable<?>, Listener> sSupport = new HashMap();
    private static final List<BalloonToolTip.ArrowDirection> sDirections = new ArrayList<BalloonToolTip.ArrowDirection>();

    private ToolTipSupport() {
    }

    public static <T> void uninstall(GroupingTable<T> groupingTable) {
        ToolTipAndComponentAWTListener toolTipAndComponentAWTListener = sSupport.remove(groupingTable);
        if (toolTipAndComponentAWTListener != null) {
            toolTipAndComponentAWTListener.uninstall();
        }
    }

    public static <T> void hideTip(GroupingTable<T> groupingTable) {
        Listener listener = sSupport.get(groupingTable);
        if (listener != null) {
            listener.hideTip();
        }
    }

    public static <T> void install(GroupingTable<T> groupingTable) {
        sSupport.put(groupingTable, new Listener(groupingTable));
    }

    static {
        sDirections.add(BalloonToolTip.ArrowDirection.SOUTH);
    }

    public static class Listener
    extends ToolTipAndComponentAWTListener {
        private final GroupingTable<?> iTable;
        private ClosableToolTip iTip;
        private ClosableToolTipData iCurrentData;
        private int iCurrentRow = -1;

        Listener(GroupingTable<?> groupingTable) {
            super((Component)((Object)groupingTable), ToolTipManager.sharedInstance().getInitialDelay());
            this.setPersistentInsideSource(true);
            this.iTable = groupingTable;
        }

        @Override
        protected boolean shouldStartHideTimer() {
            return this.iTip != null;
        }

        @Override
        protected void hideTip() {
            if (this.iTip != null) {
                this.iTip.cleanup();
                this.iTip = null;
                this.iCurrentData = null;
            }
        }

        @Override
        protected void movedInsideSource(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, this.iTable);
            if (this.iTip != null && ComponentUtils.isChild((Component)mouseEvent.getComponent(), (Component)this.iTip.getDialog())) {
                this.stopHideTimer();
                return;
            }
            ClosableToolTipData closableToolTipData = this.iTable.getToolTipData(mouseEvent);
            int n = this.iTable.rowAtPoint(mouseEvent.getPoint());
            if (closableToolTipData != null) {
                if (!(this.iCurrentData == null || this.iCurrentData.equals(closableToolTipData) && n == this.iCurrentRow)) {
                    this.resetState();
                    this.restartShowTimer(true);
                    return;
                }
                if (this.iCurrentData == null || !this.iCurrentData.equals(closableToolTipData) || this.iCurrentRow != n) {
                    if (this.iTip != null) {
                        this.iTip.cleanup();
                    }
                    point.x += 15;
                    try {
                        this.iTip = ClosableToolTip.show(mouseEvent, closableToolTipData, this.getTargetRect(mouseEvent), sDirections, point);
                    }
                    catch (ToolTipSourceParentIsNullException toolTipSourceParentIsNullException) {
                        return;
                    }
                    this.iCurrentRow = n;
                } else {
                    this.stopHideTimer();
                }
            } else {
                this.resetState();
                this.restartShowTimer(false);
            }
            this.iCurrentData = closableToolTipData;
        }

        private void resetState() {
            if (this.iTip != null) {
                this.iTip.cleanup();
                this.iTip = null;
                this.iCurrentRow = -1;
                this.iCurrentData = null;
            }
        }

        @Override
        protected boolean isTipShowing() {
            return this.iTip != null;
        }

        @Override
        public boolean doesTipContainScreenCoordinates(Point point) {
            return this.iTip != null && this.iTip.containsScreenPoint(point);
        }

        @Override
        protected void mouseWheeledInsideTip(MouseWheelEvent mouseWheelEvent) {
        }

        @Override
        protected void mouseClickedInsideTip(MouseEvent mouseEvent) {
        }

        private Rectangle getTargetRect(MouseEvent mouseEvent) {
            Rectangle rectangle;
            Point point;
            int n;
            Object object = this.iTable;
            if (mouseEvent.getSource() != null && mouseEvent.getSource() instanceof Component) {
                object = (Component)mouseEvent.getSource();
            }
            if ((n = this.iTable.rowAtPoint(point = SwingUtilities.convertPoint(object, mouseEvent.getPoint(), this.iTable))) == -1) {
                rectangle = new Rectangle(point, new Dimension(1, 1));
            } else {
                int n2 = this.iTable.columnAtPoint(point);
                if (n2 == -1) {
                    rectangle = this.iTable.getCellRect(n, 0, true);
                } else {
                    NonRectangularCellRenderer nonRectangularCellRenderer = this.iTable.setupRenderer(n, n2);
                    Rectangle rectangle2 = this.iTable.getCellRect(n, n2, true);
                    rectangle = nonRectangularCellRenderer.getRightClickSelectionBoundingRect();
                    if (rectangle.getBounds().equals(new Rectangle(0, 0, 0, 0))) {
                        rectangle = rectangle2;
                    } else {
                        rectangle.y += rectangle2.y;
                        rectangle.x += rectangle2.x;
                    }
                    rectangle.width += rectangle.x;
                    rectangle.x = 0;
                }
            }
            Point point2 = rectangle.getLocation();
            SwingUtilities.convertPointToScreen(point2, this.iTable);
            return new Rectangle(point2, rectangle.getSize());
        }
    }
}

