/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

public abstract class SpreadsheetColumnModel
extends DefaultTableColumnModel {
    private static int sDefaultColumnWidth = 75;
    public SortedMap<Integer, TableColumn> fDefinedColumns;
    public int fColumnCount = -1;

    protected SpreadsheetColumnModel(int n) {
        this.fColumnCount = n;
        this.fDefinedColumns = new TreeMap<Integer, TableColumn>();
    }

    @Override
    public void addColumn(TableColumn tableColumn) {
        assert (tableColumn.getModelIndex() == this.fColumnCount);
        this.fDefinedColumns.put(this.fColumnCount, tableColumn);
        ++this.fColumnCount;
    }

    @Override
    public boolean getColumnSelectionAllowed() {
        return true;
    }

    @Override
    public Enumeration<TableColumn> getColumns() {
        return new SpreadsheetColumnEnumeration();
    }

    public void clear() {
        this.totalColumnWidth = -1;
        this.fDefinedColumns.clear();
    }

    public int[] getColumnPosition(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = sDefaultColumnWidth;
        for (int n5 : this.fDefinedColumns.keySet()) {
            int n6 = ((TableColumn)this.fDefinedColumns.get(n5)).getWidth();
            if (n5 < n) {
                n3 += n6;
                ++n2;
                continue;
            }
            if (n5 == n) {
                n4 = n6;
                break;
            }
            n4 = sDefaultColumnWidth;
            break;
        }
        return new int[]{(n - n2) * sDefaultColumnWidth + n3, (n - n2) * sDefaultColumnWidth + n3 + n4 - 1};
    }

    public void doLayout() {
        for (TableColumn tableColumn : this.fDefinedColumns.values()) {
            tableColumn.setWidth(tableColumn.getPreferredWidth());
        }
    }

    protected abstract void updateColumnProperties(TableColumn var1);

    @Override
    public TableColumn getColumn(int n) {
        TableColumn tableColumn = (TableColumn)this.fDefinedColumns.get(n);
        if (tableColumn == null) {
            final TableColumn tableColumn2 = new TableColumn(n);
            this.updateColumnProperties(tableColumn2);
            tableColumn2.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (!SpreadsheetColumnModel.this.fDefinedColumns.containsKey(tableColumn2.getModelIndex())) {
                        SpreadsheetColumnModel.this.fDefinedColumns.put(tableColumn2.getModelIndex(), tableColumn2);
                    }
                    SpreadsheetColumnModel.this.propertyChange(propertyChangeEvent);
                }
            });
            tableColumn = tableColumn2;
        }
        return tableColumn;
    }

    @Override
    public int getColumnCount() {
        return this.fColumnCount;
    }

    @Override
    public int getColumnIndex(Object object) {
        for (int n : this.fDefinedColumns.keySet()) {
            if (!object.equals(((TableColumn)this.fDefinedColumns.get(n)).getIdentifier())) continue;
            return n;
        }
        return -1;
    }

    @Override
    public int getColumnIndexAtX(int n) {
        if (n < 0) {
            return -1;
        }
        int n2 = 0;
        int n3 = 0;
        for (int n4 : this.fDefinedColumns.keySet()) {
            int n5 = (n4 - n2) * sDefaultColumnWidth + n3;
            int n6 = ((TableColumn)this.fDefinedColumns.get(n4)).getWidth();
            if (n5 > n) {
                return (n - n3) / sDefaultColumnWidth + n2;
            }
            if (n5 <= n && n5 + n6 >= n) {
                return n4;
            }
            n3 += n6;
            ++n2;
        }
        int n7 = (n - n3) / sDefaultColumnWidth + n2;
        if (n7 >= this.getColumnCount()) {
            n7 = -1;
        }
        return n7;
    }

    @Override
    public void moveColumn(int n, int n2) {
        TableColumn tableColumn = (TableColumn)this.fDefinedColumns.get(n);
        TableColumn tableColumn2 = (TableColumn)this.fDefinedColumns.get(n2);
        if (tableColumn == null && tableColumn2 != null) {
            this.fDefinedColumns.remove(n2);
        } else if (tableColumn != null && tableColumn2 == null) {
            this.fDefinedColumns.remove(n);
            tableColumn.setModelIndex(n2);
            this.fDefinedColumns.put(n2, tableColumn);
        } else if (tableColumn != null) {
            tableColumn.setModelIndex(n2);
            this.fDefinedColumns.put(n2, tableColumn);
            tableColumn2.setModelIndex(n);
            this.fDefinedColumns.put(n, tableColumn2);
        }
    }

    @Override
    public void removeColumn(TableColumn tableColumn) {
        --this.fColumnCount;
        if (!this.fDefinedColumns.containsValue(tableColumn)) {
            return;
        }
        int n = -1;
        Object object = this.fDefinedColumns.keySet().iterator();
        while (object.hasNext()) {
            int n2 = object.next();
            if (!tableColumn.equals(this.fDefinedColumns.get(n2))) continue;
            n = n2;
            break;
        }
        object = new TreeMap();
        SortedMap<Integer, TableColumn> sortedMap = this.fDefinedColumns.headMap(n);
        SortedMap<Integer, TableColumn> sortedMap2 = this.fDefinedColumns.tailMap(n + 1);
        for (int n3 : sortedMap.keySet()) {
            object.put(n3, sortedMap.get(n3));
        }
        for (int n3 : sortedMap2.keySet()) {
            object.put(n3 - 1, sortedMap.get(n3));
        }
        this.fDefinedColumns = object;
    }

    @Override
    protected void recalcWidthCache() {
        int n = this.fDefinedColumns.size();
        this.totalColumnWidth = 0;
        for (TableColumn tableColumn : this.fDefinedColumns.values()) {
            this.totalColumnWidth += tableColumn.getWidth();
        }
        this.totalColumnWidth += sDefaultColumnWidth * (this.fColumnCount - n);
    }

    private class SpreadsheetColumnEnumeration
    implements Enumeration<TableColumn> {
        private int iPtr = 0;

        private SpreadsheetColumnEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return this.iPtr < SpreadsheetColumnModel.this.getColumnCount() - 1;
        }

        @Override
        public TableColumn nextElement() {
            if (!this.hasMoreElements()) {
                return null;
            }
            ++this.iPtr;
            return SpreadsheetColumnModel.this.getColumn(this.iPtr - 1);
        }
    }
}

