/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet.data;

import com.mathworks.util.ArrayUtils;
import com.mathworks.widgets.spreadsheet.data.ComplexArray;
import com.mathworks.widgets.spreadsheet.data.ComplexScalarShort;
import java.util.Arrays;

public final class ComplexArrayShort
extends ComplexArray {
    private final short[][] fR;
    private final short[][] fI;

    public static ComplexArrayShort valueOf(short[][] sArray) {
        return ComplexArrayShort.valueOf(sArray, true);
    }

    public static ComplexArrayShort valueOf(short[][] sArray, boolean bl) {
        if (sArray == null) {
            throw new IllegalArgumentException("null arrays are not permitted");
        }
        if (!ArrayUtils.isRectangular((Object)sArray)) {
            throw new IllegalArgumentException("Array argument must be rectangular.");
        }
        return new ComplexArrayShort(sArray, bl);
    }

    public static ComplexArrayShort valueOf(short[][] sArray, short[][] sArray2) {
        return ComplexArrayShort.valueOf(sArray, sArray2, true);
    }

    public static ComplexArrayShort valueOf(short[][] sArray, short[][] sArray2, boolean bl) {
        if (sArray == null || sArray2 == null) {
            throw new IllegalArgumentException("null arrays are not permitted");
        }
        if (!Arrays.equals(ArrayUtils.getLengths((short[][])sArray), ArrayUtils.getLengths((short[][])sArray2))) {
            throw new IllegalArgumentException("Real and imaginary array arguments must have the same size.");
        }
        return new ComplexArrayShort(sArray, sArray2, bl);
    }

    private ComplexArrayShort(short[][] sArray, boolean bl) {
        super(bl);
        this.fR = sArray;
        this.fI = null;
    }

    private ComplexArrayShort(short[][] sArray, short[][] sArray2, boolean bl) {
        super(bl);
        this.fR = sArray;
        this.fI = sArray2;
    }

    public short[][] shortValueReal() {
        return this.fR;
    }

    public short[][] shortValueImaginary() {
        return this.fI;
    }

    @Override
    public boolean isReal() {
        return this.fI == null;
    }

    @Override
    public int[] getLengths() {
        return ArrayUtils.getLengths((short[][])this.fR);
    }

    @Override
    public ComplexScalarShort getValueAt(int n, int n2) {
        if (this.isReal()) {
            return ComplexScalarShort.valueOf(this.fR[n][n2], this.isSigned());
        }
        return ComplexScalarShort.valueOf(this.fR[n][n2], this.fI[n][n2], this.isSigned());
    }
}

