/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text;

import com.mathworks.services.ColorPrefs;
import com.mathworks.services.FontPrefs;
import com.mathworks.services.KeyboardPrefs;
import com.mathworks.services.Prefs;
import com.mathworks.services.PrefsAWT;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.text.MWSettingsNames;
import com.mathworks.widgets.text.matlab.MatlabFunctionIndentingScheme;
import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.util.ResourceBundle;
import org.netbeans.editor.Coloring;

public class EditorPrefsAccessor {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.widgets.text.resources.RES_text");
    public static final String TAB_TO_SPACE = "TabToSpaces";
    public static final String EMACS_STYLE_TAB = "EmacsTab";
    public static final String SPACES_PER_INDENT = "SpacesPerIndent";
    public static final String RIGHT_TEXT_VISIBLE = "RightTextLineVisible";
    public static final String RIGHT_TEXT_LIMIT = "RightTextLineLimit";
    public static final String RIGHT_TEXT_LIMIT_LINE_WDITH = "RightTextLimitLineWidth";
    public static final String RIGHT_TEXT_LIMIT_LINE_COLOR = "RightTextLimitLineColor";
    static final int PRINTSTYLE_BW = 1;
    public static final String MLINT_ENABLED = "mlint-display";
    public static final String MLINT_UNDERLINING = "mlint-underlining";
    public static final String M_FUNCTION_INDENT_TYPE = "MFunctionIndentType";
    public static final String HIGHLIGHT_LINES = "highlight-lines";
    public static final String HIGHLIGHT_CARET_ROW = "highlight-caret-row-boolean";
    public static final String HIGHLIGHT_CARET_ROW_COLOR = "highlight-caret-row-boolean-color";
    public static final int DEFAULT_RIGHT_TEXT_LIMIT = 75;
    public static final int DEFAULT_TEXT_LIMIT_LINE_WIDTH = 1;
    public static final Color DEFAULT_TEXT_LIMIT_LINE_COLOR = new Color(204, 204, 204);
    public static final int PRINT_HEADER = 1;
    public static final int PRINT_COLOR = 2;
    public static final int PRINT_LINE_NUMBERS = 4;
    public static final int PRINT_LINE_WRAP = 8;
    public static final int PRINT_NUMBER_FROM_ZERO = 16;
    public static final int PRINT_LINE_NUMBER_END = 32;
    public static final int PRINT_HEADER1_STYLE = 0x100000;
    public static final int PRINT_HEADER2_STYLE = 0x200000;
    public static final int PRINT_HEADER3_STYLE = 0x300000;
    public static final int PRINT_HEADER4_STYLE = 0x400000;
    public static final int PRINT_SINGLE_LINE = 0x1000000;
    public static final int PRINT_DOUBLE_LINE = 0x2000000;
    public static final int PRINT_BOX = 0x3000000;
    public static final int PRINT_SHADED_BOX = 0x4000000;
    public static final int PRINT_BORDER_NONE = 0x5000000;
    public static final int PRINT_PAGENUM1_STYLE = 0x10000000;
    public static final int PRINT_PAGENUM2_STYLE = 0x20000000;
    public static final int PRINT_PAGENUM3_STYLE = 0x30000000;
    public static final int HEADER_STYLE_MASK = 0xF00000;
    public static final int BORDER_MASK = 0xF000000;
    public static final int PAGE_NUMBER_MASK = -268435456;
    public static final int HEADER_MASK = -65536;
    public static final int SYNTAX_BW = 4096;
    public static final int SYNTAX_COLOR = 2048;
    public static final int SYNTAX_STYLE = 6144;
    public static final int SYNTAX_OPTIONS_MASK = 6144;
    public static final int SYNTAX_OPTIONS_CLEAR_MASK = 59391;
    public static final int CODEFOLDING_MRUFILES_DEFAULT = 50;
    public static final int TEXT_FONT = 32768;
    public static final int HEADER_FONT = 16384;
    public static final int FONT_OPTIONS_MASK = 57344;
    public static final int DEFAULT_PRINT_OPTIONS = 571525129;

    private EditorPrefsAccessor() {
    }

    public static boolean isCodeFoldingEnabled() {
        return Prefs.getBooleanPref((String)"Editorcode-folding-enable", (boolean)true);
    }

    public static int getCodeFoldingStateMRUFileCount() {
        return Prefs.getIntegerPref((String)"EditorcodeFoldingStateMRUFilesCount", (int)50);
    }

    public static boolean isDelimMatchingWhileTyping() {
        return KeyboardPrefs.isDelimMatchingWhileTyping();
    }

    public static boolean isDelimMatchingWhileMousing() {
        return KeyboardPrefs.isDelimMatchingWhileMousing();
    }

    public static int getDelimMatchTypeWhileTyping() {
        return KeyboardPrefs.getDelimMatchTypeWhileTyping();
    }

    public static int getDelimMismatchTypeWhileTyping() {
        return KeyboardPrefs.getDelimMismatchTypeWhileTyping();
    }

    public static int getDelimMatchTypeWhileMousing() {
        return KeyboardPrefs.getDelimMatchTypeWhileMousing();
    }

    public static int getDelimMismatchTypeWhileMousing() {
        return KeyboardPrefs.getDelimMismatchTypeWhileMousing();
    }

    public static boolean isTabMode() {
        return Prefs.getBooleanPref((String)"EditorTabMode", (boolean)true);
    }

    public static boolean getShowLineNumbers() {
        return Prefs.getBooleanPref((String)"EditorShowLineNumbers", (boolean)true);
    }

    public static int getSpacesPerTab() {
        return Prefs.getIntegerPref((String)"EditorSpacesPerTab", (int)EditorPrefsAccessor.getDefaultSpacesPerTab());
    }

    public static int getDefaultSpacesPerTab() {
        return 4;
    }

    public static int getSpacesPerIndent() {
        return Prefs.getIntegerPref((String)"EditorSpacesPerIndent", (int)EditorPrefsAccessor.getDefaultSpacesPerIndent());
    }

    public static int getDefaultSpacesPerIndent() {
        return 4;
    }

    public static MatlabFunctionIndentingScheme getMatlabIndentingScheme() {
        return MatlabFunctionIndentingScheme.lookup(Prefs.getStringPref((String)"EditorMFunctionIndentType", (String)EditorPrefsAccessor.getDefaultMFunctionIndentMode().getInternalName()));
    }

    public static MatlabFunctionIndentingScheme getDefaultMFunctionIndentMode() {
        return MatlabFunctionIndentingScheme.MIXED;
    }

    public static boolean isTabChangedToSpaces() {
        return Prefs.getBooleanPref((String)"EditorTabToSpaces", (boolean)EditorPrefsAccessor.getDefaultTabToSpace());
    }

    public static boolean getDefaultTabToSpace() {
        return true;
    }

    public static boolean isEmacsStyleTab() {
        return Prefs.getBooleanPref((String)"EditorEmacsTab", (boolean)false);
    }

    public static Font getFont() {
        return FontPrefs.getFontForComponent((String)BUNDLE.getString("editor.name"));
    }

    private static Coloring getColoringFromPrefs(String string) {
        return new Coloring(null, 0, ColorPrefs.getColorPref((String)string), ColorPrefs.getBackgroundColor());
    }

    public static Coloring getErrorsColoring() {
        return EditorPrefsAccessor.getColoringFromPrefs(MWSettingsNames.ERRORS);
    }

    public static Coloring getTextColoring() {
        return new Coloring(EditorPrefsAccessor.getFont(), EditorPrefsAccessor.getTextColor(), ColorPrefs.getBackgroundColor());
    }

    private static Color getColorFromPrefs(String string, boolean bl) {
        if (!bl) {
            return ColorPrefs.getColorPref((String)string);
        }
        return ColorPrefs.getDefaultColor((String)string);
    }

    public static Color getCommentColor(boolean bl) {
        return EditorPrefsAccessor.getColorFromPrefs(MWSettingsNames.COMMENTS, bl);
    }

    public static Color getIncompleteStringColor(boolean bl) {
        return EditorPrefsAccessor.getColorFromPrefs(MWSettingsNames.UNTERMINATED_STRINGS, bl);
    }

    public static Color getSystemColor(boolean bl) {
        return EditorPrefsAccessor.getColorFromPrefs(MWSettingsNames.SYSTEM_COMMANDS, bl);
    }

    public static Color getErrorsColor(boolean bl) {
        return EditorPrefsAccessor.getColorFromPrefs(MWSettingsNames.ERRORS, bl);
    }

    public static Color getKeywordsColor(boolean bl) {
        return EditorPrefsAccessor.getColorFromPrefs(MWSettingsNames.KEYWORDS, bl);
    }

    public static Color getTextColor() {
        Color color = ColorPrefs.getTextColor();
        if (PlatformInfo.isMacintosh() && color.equals(SystemColor.textText)) {
            color = new Color(color.getRed(), color.getGreen(), color.getBlue());
        }
        return color;
    }

    public static Color getStringColor(boolean bl) {
        return EditorPrefsAccessor.getColorFromPrefs(MWSettingsNames.STRINGS, bl);
    }

    public static boolean isMLintEnabled() {
        return Prefs.getBooleanPref((String)"Editormlint-display", (boolean)true);
    }

    public static int getMLintUnderlining() {
        return Prefs.getIntegerPref((String)"Editormlint-underlining", (int)2);
    }

    public static boolean isTextLimitOn() {
        return Prefs.getBooleanPref((String)"EditorRightTextLineVisible", (boolean)true);
    }

    public static int getTextLimit() {
        return Prefs.getIntegerPref((String)"EditorRightTextLineLimit", (int)75);
    }

    public static int getTextLimitLineWidth() {
        return Prefs.getIntegerPref((String)"EditorRightTextLimitLineWidth", (int)1);
    }

    public static Color getTextLimitLineColor() {
        return Prefs.getColorPref((String)"EditorRightTextLimitLineColor", (Color)DEFAULT_TEXT_LIMIT_LINE_COLOR);
    }

    public static boolean isPrintWrapLines() {
        return (EditorPrefsAccessor.getPrintOptions() & 8) != 0;
    }

    public static boolean isPrintHeader() {
        int n = EditorPrefsAccessor.getPrintOptions();
        return (n & 1) != 0;
    }

    public static boolean isPrintLineNumbers() {
        int n = EditorPrefsAccessor.getPrintOptions();
        return (n & 4) != 0;
    }

    public static int getPrintOptions() {
        return Prefs.getIntegerPref((String)"EditorPrintOptions", (int)571525129);
    }

    public static Font getPrintingBodyFont() {
        int n = EditorPrefsAccessor.getPrintOptions();
        if ((n & 0x8000) != 0) {
            return EditorPrefsAccessor.getFont();
        }
        return Prefs.getFontPref((String)"EditorTextFont", (Font)EditorPrefsAccessor.getFont());
    }

    public static Font getPrintingHeaderFont() {
        int n = EditorPrefsAccessor.getPrintOptions();
        if ((n & 0x4000) != 0) {
            return EditorPrefsAccessor.getPrintingBodyFont();
        }
        return Prefs.getFontPref((String)"EditorHeaderFont", (Font)EditorPrefsAccessor.getPrintingBodyFont());
    }

    public static Color getHighlightingColor() {
        return PrefsAWT.getColorPref((String)"Editorhighlight-lines", (Color)new Color(252, 252, 220));
    }

    public static boolean isHighlightCaretRow() {
        return Prefs.getBooleanPref((String)"Editorhighlight-caret-row-boolean", (boolean)false);
    }

    public static Color getHighlightCaretRowColor() {
        return PrefsAWT.getColorPref((String)"Editorhighlight-caret-row-boolean-color", (Color)new Color(222, 238, 216));
    }
}

