/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.cplusplus;

import com.mathworks.widgets.text.cplusplus.CCSettingsDefaults;
import org.netbeans.editor.ImageTokenID;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtFormatSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;
import org.netbeans.modules.cnd.editor.cplusplus.CCTokenContext;
import org.openide.util.NbBundle;

public class CCFormatSupport
extends ExtFormatSupport {
    private TokenContextPath tokenContextPath;

    public CCFormatSupport(FormatWriter formatWriter) {
        this(formatWriter, CCTokenContext.contextPath);
    }

    public CCFormatSupport(FormatWriter formatWriter, TokenContextPath tokenContextPath) {
        super(formatWriter);
        this.tokenContextPath = tokenContextPath;
    }

    public TokenContextPath getTokenContextPath() {
        return this.tokenContextPath;
    }

    public boolean isComment(TokenItem tokenItem, int n) {
        TokenID tokenID = tokenItem.getTokenID();
        return tokenItem.getTokenContextPath() == this.tokenContextPath && (tokenID == CCTokenContext.LINE_COMMENT || tokenID == CCTokenContext.BLOCK_COMMENT);
    }

    public boolean isPreprocessor(TokenItem tokenItem) {
        if (tokenItem == null) {
            return false;
        }
        FormatTokenPosition formatTokenPosition = this.findLineFirstNonWhitespace(this.getPosition(tokenItem, 0));
        if (formatTokenPosition == null) {
            return false;
        }
        TokenItem tokenItem2 = formatTokenPosition.getToken();
        return tokenItem2.getImage().startsWith("#");
    }

    public boolean isMultiLineComment(TokenItem tokenItem) {
        return tokenItem.getTokenID() == CCTokenContext.BLOCK_COMMENT;
    }

    public boolean isMultiLineComment(FormatTokenPosition formatTokenPosition) {
        TokenItem tokenItem = formatTokenPosition.getToken();
        return tokenItem == null ? false : this.isMultiLineComment(tokenItem);
    }

    public final boolean isImportant(TokenItem tokenItem, int n) {
        return super.isImportant(tokenItem, n) && !this.isPreprocessor(tokenItem);
    }

    public boolean isCCDocComment(TokenItem tokenItem) {
        return this.isMultiLineComment(tokenItem) && tokenItem.getImage().startsWith("/*");
    }

    public TokenID getWhitespaceTokenID() {
        return CCTokenContext.WHITESPACE;
    }

    public TokenContextPath getWhitespaceTokenContextPath() {
        return this.tokenContextPath;
    }

    public boolean canModifyWhitespace(TokenItem tokenItem) {
        if (tokenItem.getTokenContextPath() == CCTokenContext.contextPath) {
            switch (tokenItem.getTokenID().getNumericID()) {
                case 6: 
                case 9: {
                    return true;
                }
            }
        }
        return false;
    }

    public TokenItem findStatement(TokenItem tokenItem) {
        TokenItem tokenItem2 = null;
        for (TokenItem tokenItem3 = this.getPreviousToken(tokenItem); tokenItem3 != null; tokenItem3 = tokenItem3.getPrevious()) {
            if (tokenItem3.getTokenContextPath() != this.tokenContextPath) continue;
            switch (tokenItem3.getTokenID().getNumericID()) {
                case 58: {
                    if (this.isForLoopSemicolon(tokenItem3)) break;
                    return tokenItem2 != null ? tokenItem2 : tokenItem3;
                }
                case 56: 
                case 64: 
                case 65: 
                case 103: {
                    return tokenItem2 != null ? tokenItem2 : tokenItem3;
                }
                case 95: 
                case 100: 
                case 102: 
                case 120: {
                    return tokenItem3;
                }
                case 107: 
                case 109: 
                case 129: {
                    TokenItem tokenItem4;
                    if (tokenItem2 != null && tokenItem2.getTokenID() == CCTokenContext.LPAREN && (tokenItem4 = this.findMatchingToken(tokenItem2, tokenItem, (ImageTokenID)CCTokenContext.RPAREN, false)) != null && tokenItem4.getNext() != null && (tokenItem4 = this.findImportantToken(tokenItem4.getNext(), tokenItem, false)) != null) {
                        return tokenItem4;
                    }
                    return tokenItem3;
                }
            }
            if (this.isPreprocessor(tokenItem3) || !this.isImportant(tokenItem3, 0)) continue;
            tokenItem2 = tokenItem3;
        }
        return tokenItem2;
    }

    public TokenItem findIf(TokenItem tokenItem) {
        if (tokenItem == null || !CCFormatSupport.tokenEquals((TokenItem)tokenItem, (TokenID)CCTokenContext.ELSE, (TokenContextPath)this.tokenContextPath)) {
            throw new IllegalArgumentException(NbBundle.getBundle(CCFormatSupport.class).getString("MSG_AcceptOnlyElse"));
        }
        int n = 0;
        int n2 = 0;
        block7: while ((tokenItem = this.findStatement(tokenItem)) != null) {
            switch (tokenItem.getTokenID().getNumericID()) {
                case 64: {
                    if (--n >= 0) break;
                    return null;
                }
                case 65: {
                    ++n;
                    break;
                }
                case 103: {
                    if (n != 0) break;
                    ++n2;
                    break;
                }
                case 56: 
                case 58: 
                case 95: 
                case 100: 
                case 102: 
                case 107: 
                case 129: {
                    break;
                }
                case 109: {
                    if (n != 0 || n2-- != 0) continue block7;
                    return tokenItem;
                }
            }
        }
        return null;
    }

    public TokenItem findSwitch(TokenItem tokenItem) {
        if (tokenItem == null || !CCFormatSupport.tokenEquals((TokenItem)tokenItem, (TokenID)CCTokenContext.CASE, (TokenContextPath)this.tokenContextPath) && !CCFormatSupport.tokenEquals((TokenItem)tokenItem, (TokenID)CCTokenContext.DEFAULT, (TokenContextPath)this.tokenContextPath)) {
            throw new IllegalArgumentException(NbBundle.getBundle(CCFormatSupport.class).getString("MSG_AcceptOlyCaseDefault"));
        }
        int n = 1;
        while ((tokenItem = this.findStatement(tokenItem)) != null) {
            switch (tokenItem.getTokenID().getNumericID()) {
                case 64: {
                    if (--n >= 0) break;
                    return null;
                }
                case 65: {
                    ++n;
                    break;
                }
                case 100: 
                case 120: {
                    if (n != 0) break;
                    return tokenItem;
                }
            }
        }
        return null;
    }

    private TokenItem findClassifier(TokenItem tokenItem) {
        int n = 1;
        TokenItem tokenItem2 = tokenItem;
        while ((tokenItem2 = this.findStatement(tokenItem2)) != null) {
            switch (tokenItem2.getTokenID().getNumericID()) {
                case 64: {
                    if (--n < 0) {
                        return null;
                    }
                    if (n != 0) break;
                    while ((tokenItem2 = tokenItem2.getPrevious()) != null) {
                        switch (tokenItem2.getTokenID().getNumericID()) {
                            case 85: 
                            case 97: {
                                return tokenItem2;
                            }
                        }
                    }
                    return null;
                }
                case 65: {
                    ++n;
                }
            }
        }
        return null;
    }

    public TokenItem findTry(TokenItem tokenItem) {
        if (tokenItem == null || !CCFormatSupport.tokenEquals((TokenItem)tokenItem, (TokenID)CCTokenContext.CATCH, (TokenContextPath)this.tokenContextPath)) {
            throw new IllegalArgumentException(NbBundle.getBundle(CCFormatSupport.class).getString("MSG_AcceptOnlyCatch"));
        }
        int n = 0;
        while ((tokenItem = this.findStatement(tokenItem)) != null) {
            switch (tokenItem.getTokenID().getNumericID()) {
                case 64: {
                    if (--n >= 0) break;
                    return null;
                }
                case 65: {
                    ++n;
                    break;
                }
                case 125: {
                    if (n != 0) break;
                    return tokenItem;
                }
            }
        }
        return null;
    }

    public TokenItem findStatementStart(TokenItem tokenItem) {
        TokenItem tokenItem2 = this.findStatement(tokenItem);
        if (tokenItem2 != null) {
            switch (tokenItem2.getTokenID().getNumericID()) {
                case 58: {
                    TokenItem tokenItem3 = this.findStatement(tokenItem2);
                    if (tokenItem3 == null) {
                        return tokenItem;
                    }
                    switch (tokenItem3.getTokenID().getNumericID()) {
                        case 56: 
                        case 58: 
                        case 64: 
                        case 65: 
                        case 95: 
                        case 100: {
                            return tokenItem2;
                        }
                        case 102: 
                        case 107: 
                        case 109: 
                        case 129: {
                            return this.findStatementStart(tokenItem2);
                        }
                        case 103: {
                            TokenItem tokenItem4 = this.findIf(tokenItem3);
                            if (tokenItem4 != null) {
                                return this.findStatementStart(tokenItem4);
                            }
                            return tokenItem3;
                        }
                    }
                    TokenItem tokenItem5 = this.findStatement(tokenItem3);
                    if (tokenItem5 != null) {
                        switch (tokenItem5.getTokenID().getNumericID()) {
                            case 56: 
                            case 58: 
                            case 64: 
                            case 65: {
                                return tokenItem3;
                            }
                            case 102: 
                            case 107: 
                            case 109: 
                            case 129: {
                                return this.findStatementStart(tokenItem5);
                            }
                            case 103: {
                                TokenItem tokenItem6 = this.findIf(tokenItem5);
                                if (tokenItem6 != null) {
                                    return this.findStatementStart(tokenItem6);
                                }
                                return tokenItem5;
                            }
                        }
                    }
                    return tokenItem3;
                }
                case 64: {
                    return tokenItem;
                }
                case 65: {
                    TokenItem tokenItem7;
                    TokenItem tokenItem8 = this.findMatchingToken(tokenItem2, null, (ImageTokenID)CCTokenContext.LBRACE, true);
                    if (tokenItem8 != null && (tokenItem7 = this.findStatement(tokenItem8)) != null) {
                        switch (tokenItem7.getTokenID().getNumericID()) {
                            case 103: {
                                TokenItem tokenItem9 = this.findIf(tokenItem7);
                                if (tokenItem9 != null) {
                                    return this.findStatementStart(tokenItem9);
                                }
                                return tokenItem7;
                            }
                            case 96: {
                                TokenItem tokenItem10 = this.findTry(tokenItem7);
                                if (tokenItem10 != null) {
                                    return this.findStatementStart(tokenItem10);
                                }
                                return tokenItem7;
                            }
                            case 102: 
                            case 107: 
                            case 109: 
                            case 129: {
                                return this.findStatementStart(tokenItem7);
                            }
                        }
                        if (tokenItem7.getTokenID().getNumericID() == 64) {
                            return tokenItem2;
                        }
                        return tokenItem7;
                    }
                    return tokenItem2;
                }
                case 56: 
                case 95: 
                case 100: {
                    return tokenItem;
                }
                case 103: {
                    TokenItem tokenItem11 = this.findIf(tokenItem2);
                    return tokenItem11 != null ? this.findStatementStart(tokenItem11) : tokenItem2;
                }
                case 102: 
                case 107: 
                case 109: 
                case 129: {
                    return this.findStatementStart(tokenItem2);
                }
                case 7: {
                    return tokenItem2;
                }
            }
            return tokenItem2;
        }
        return tokenItem;
    }

    public int getTokenIndent(TokenItem tokenItem, boolean bl) {
        FormatTokenPosition formatTokenPosition = this.getPosition(tokenItem, 0);
        FormatTokenPosition formatTokenPosition2 = bl ? this.findLineFirstNonWhitespace(formatTokenPosition) : this.findLineFirstNonWhitespaceAndNonLeftBrace(formatTokenPosition);
        if (formatTokenPosition2 != null) {
            formatTokenPosition = formatTokenPosition2;
        }
        return this.getVisualColumnOffset(formatTokenPosition);
    }

    public int getTokenIndent(TokenItem tokenItem) {
        return this.getTokenIndent(tokenItem, false);
    }

    public int findIndent(TokenItem tokenItem) {
        TokenItem tokenItem2;
        TokenItem tokenItem3;
        TokenItem tokenItem4;
        TokenItem tokenItem5;
        int n = -1;
        if (tokenItem != null) {
            block0 : switch (tokenItem.getTokenID().getNumericID()) {
                case 103: {
                    tokenItem5 = this.findIf(tokenItem);
                    if (tokenItem5 == null) break;
                    n = this.getTokenIndent(tokenItem5);
                    break;
                }
                case 64: {
                    tokenItem4 = this.findStatement(tokenItem);
                    if (tokenItem4 == null) {
                        n = 0;
                        break;
                    }
                    switch (tokenItem4.getTokenID().getNumericID()) {
                        case 102: 
                        case 103: 
                        case 107: 
                        case 109: 
                        case 129: {
                            n = this.getTokenIndent(tokenItem4);
                            break block0;
                        }
                        case 64: {
                            n = this.getTokenIndent(tokenItem4) + this.getShiftWidth();
                            break block0;
                        }
                    }
                    tokenItem4 = this.findStatementStart(tokenItem);
                    if (tokenItem4 == null) {
                        n = 0;
                        break;
                    }
                    if (tokenItem4 == tokenItem) {
                        tokenItem4 = this.findStatement(tokenItem);
                        n = tokenItem4 != null ? (n = this.getTokenIndent(tokenItem4)) : 0;
                        break;
                    }
                    n = this.getTokenIndent(tokenItem4);
                    switch (tokenItem4.getTokenID().getNumericID()) {
                        case 64: {
                            n += this.getShiftWidth();
                        }
                    }
                    break;
                }
                case 65: {
                    tokenItem3 = this.findMatchingToken(tokenItem, null, (ImageTokenID)CCTokenContext.LBRACE, true);
                    if (tokenItem3 != null) {
                        tokenItem2 = this.findStatement(tokenItem3);
                        boolean bl = false;
                        if (tokenItem2 == null) {
                            tokenItem2 = tokenItem3;
                        } else {
                            switch (tokenItem2.getTokenID().getNumericID()) {
                                case 58: 
                                case 64: 
                                case 65: {
                                    tokenItem2 = tokenItem3;
                                    bl = true;
                                }
                            }
                        }
                        n = this.getTokenIndent(tokenItem2, bl);
                        break;
                    }
                    n = this.getTokenIndent(tokenItem);
                    break;
                }
                case 95: 
                case 100: {
                    tokenItem2 = this.findSwitch(tokenItem);
                    if (tokenItem2 == null) break;
                    n = this.getTokenIndent(tokenItem2) + this.getShiftWidth();
                    break;
                }
                case 114: 
                case 115: 
                case 116: {
                    TokenItem tokenItem6 = this.findClassifier(tokenItem);
                    if (tokenItem6 == null) break;
                    n = this.getTokenIndent(tokenItem6);
                }
            }
        }
        if (n < 0) {
            tokenItem5 = this.findImportantToken(tokenItem, null, true);
            while (tokenItem5 != null && this.getPosition(tokenItem5, 0) != null && this.findLineFirstNonWhitespace(this.getPosition(tokenItem5, 0)) != null && this.isPreprocessor(this.findLineFirstNonWhitespace(this.getPosition(tokenItem5, 0)).getToken())) {
                tokenItem5 = this.findImportantToken(tokenItem5, null, true);
            }
            if (tokenItem5 != null) {
                switch (tokenItem5.getTokenID().getNumericID()) {
                    case 58: {
                        tokenItem4 = this.findStatementStart(tokenItem);
                        while (tokenItem4 != null && (this.isPreprocessor(tokenItem4) || tokenItem4.getImage().startsWith("\n"))) {
                            tokenItem4 = this.findStatementStart(tokenItem4.getPrevious());
                        }
                        n = this.getTokenIndent(tokenItem4);
                        break;
                    }
                    case 64: {
                        tokenItem3 = this.findStatement(tokenItem5);
                        if (tokenItem3 == null) {
                            tokenItem3 = tokenItem5;
                        }
                        n = this.getTokenIndent(tokenItem3) + this.getShiftWidth();
                        break;
                    }
                    case 65: {
                        tokenItem2 = this.findStatementStart(tokenItem);
                        n = this.getTokenIndent(tokenItem2);
                        break;
                    }
                    case 61: {
                        TokenItem tokenItem7 = this.findMatchingToken(tokenItem5, null, (ImageTokenID)CCTokenContext.LPAREN, true);
                        if (tokenItem7 == null || (tokenItem7 = this.findImportantToken(tokenItem7, null, true)) == null || tokenItem7.getTokenContextPath() != this.tokenContextPath) break;
                        switch (tokenItem7.getTokenID().getNumericID()) {
                            case 107: 
                            case 109: 
                            case 129: {
                                n = this.getTokenIndent(tokenItem7) + this.getShiftWidth();
                            }
                        }
                        break;
                    }
                    case 56: {
                        TokenItem tokenItem8 = this.findAnyToken(tokenItem5, null, new TokenID[]{CCTokenContext.CASE, CCTokenContext.DEFAULT, CCTokenContext.FOR, CCTokenContext.QUESTION}, tokenItem5.getTokenContextPath(), true);
                        if (tokenItem8 != null && tokenItem8.getTokenID().getNumericID() == 59) {
                            n = this.getTokenIndent(tokenItem8) + this.getShiftWidth();
                            break;
                        }
                        n = this.getTokenIndent(tokenItem5) + this.getShiftWidth();
                        break;
                    }
                    case 59: 
                    case 102: 
                    case 103: {
                        n = this.getTokenIndent(tokenItem5) + this.getShiftWidth();
                        break;
                    }
                    case 55: {
                        if (this.isEnumComma(tokenItem5)) {
                            n = this.getTokenIndent(tokenItem5);
                            break;
                        }
                    }
                    default: {
                        TokenItem tokenItem9 = this.findStatementStart(tokenItem5);
                        n = this.getTokenIndent(tokenItem9);
                        if (tokenItem9 == null) break;
                        if (tokenItem5 != null && CCFormatSupport.tokenEquals((TokenItem)tokenItem5, (TokenID)CCTokenContext.COMMA, (TokenContextPath)this.tokenContextPath) && this.isArrayInitializationBraceBlock(tokenItem5, null) && !this.isInsideParens(tokenItem5, tokenItem9)) {
                            n -= this.getFormatStatementContinuationIndent();
                        }
                        n += this.getFormatStatementContinuationIndent();
                    }
                }
                if (n < 0) {
                    n = this.getTokenIndent(tokenItem5);
                }
            }
        }
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public FormatTokenPosition indentLine(FormatTokenPosition formatTokenPosition) {
        int n = 0;
        FormatTokenPosition formatTokenPosition2 = this.findLineFirstNonWhitespace(formatTokenPosition);
        if (formatTokenPosition2 != null) {
            if (!this.isPreprocessor(formatTokenPosition2.getToken())) {
                if (this.isComment(formatTokenPosition2)) {
                    if (this.isMultiLineComment(formatTokenPosition2) && formatTokenPosition2.getOffset() != 0) {
                        n = this.getLineIndent(this.getPosition(formatTokenPosition2.getToken(), 0), true) + 1;
                        if (!this.isIndentOnly()) {
                            if (this.getChar(formatTokenPosition2) != '*') {
                                if (this.isCCDocComment(formatTokenPosition2.getToken())) {
                                    if (this.getFormatLeadingStarInComment()) {
                                        this.insertString(formatTokenPosition2, "* ");
                                    }
                                } else {
                                    n = this.getLineIndent(formatTokenPosition, true);
                                }
                            }
                        } else if (this.getChar(formatTokenPosition2) != '*' && this.isCCDocComment(formatTokenPosition2.getToken()) && this.getFormatLeadingStarInComment()) {
                            this.insertString(formatTokenPosition2, "* ");
                            this.setIndentShift(2);
                        }
                    } else {
                        n = !this.isMultiLineComment(formatTokenPosition2) ? (formatTokenPosition2.equals(this.findLineStart(formatTokenPosition2)) ? this.getLineIndent(formatTokenPosition2, true) : this.findIndent(formatTokenPosition2.getToken())) : (this.isCCDocComment(formatTokenPosition2.getToken()) ? this.findIndent(formatTokenPosition2.getToken()) : (formatTokenPosition2.getToken().getImage().indexOf(10) == -1 ? this.findIndent(formatTokenPosition2.getToken()) : this.getLineIndent(formatTokenPosition2, true)));
                    }
                } else {
                    n = this.findIndent(formatTokenPosition2.getToken());
                }
            }
        } else {
            TokenItem tokenItem = formatTokenPosition.getToken();
            if (tokenItem == null && (tokenItem = this.findLineStart(formatTokenPosition).getToken()) == null) {
                tokenItem = this.getLastToken();
            }
            if (tokenItem != null && this.isMultiLineComment(tokenItem)) {
                if (this.getFormatLeadingStarInComment() && (this.isIndentOnly() || this.isCCDocComment(tokenItem))) {
                    this.insertString(formatTokenPosition, "*");
                    this.setIndentShift(1);
                }
                n = this.getVisualColumnOffset(this.getPosition(tokenItem, 0)) + 1;
            } else {
                n = this.findIndent(formatTokenPosition.getToken());
            }
        }
        return this.changeLineIndent(formatTokenPosition, n);
    }

    public boolean isForLoopSemicolon(TokenItem tokenItem) {
        if (tokenItem == null || !CCFormatSupport.tokenEquals((TokenItem)tokenItem, (TokenID)CCTokenContext.SEMICOLON, (TokenContextPath)this.tokenContextPath)) {
            throw new IllegalArgumentException("Only accept ';'.");
        }
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        for (tokenItem = tokenItem.getPrevious(); tokenItem != null; tokenItem = tokenItem.getPrevious()) {
            if (CCFormatSupport.tokenEquals((TokenItem)tokenItem, (TokenID)CCTokenContext.LPAREN, (TokenContextPath)this.tokenContextPath)) {
                if (n == 0) {
                    FormatTokenPosition formatTokenPosition = this.getPosition(tokenItem, 0);
                    return (formatTokenPosition = this.findImportant(formatTokenPosition, null, false, true)) != null && CCFormatSupport.tokenEquals((TokenItem)formatTokenPosition.getToken(), (TokenID)CCTokenContext.FOR, (TokenContextPath)this.tokenContextPath);
                }
                --n;
                continue;
            }
            if (CCFormatSupport.tokenEquals((TokenItem)tokenItem, (TokenID)CCTokenContext.RPAREN, (TokenContextPath)this.tokenContextPath)) {
                ++n;
                continue;
            }
            if (CCFormatSupport.tokenEquals((TokenItem)tokenItem, (TokenID)CCTokenContext.LBRACE, (TokenContextPath)this.tokenContextPath)) {
                if (n2 == 0) {
                    return false;
                }
                --n2;
                continue;
            }
            if (CCFormatSupport.tokenEquals((TokenItem)tokenItem, (TokenID)CCTokenContext.RBRACE, (TokenContextPath)this.tokenContextPath)) {
                ++n2;
                continue;
            }
            if (!CCFormatSupport.tokenEquals((TokenItem)tokenItem, (TokenID)CCTokenContext.SEMICOLON, (TokenContextPath)this.tokenContextPath)) continue;
            if (bl) {
                return false;
            }
            bl = true;
        }
        return false;
    }

    private boolean isInsideParens(TokenItem tokenItem, TokenItem tokenItem2) {
        int n = 0;
        for (tokenItem = tokenItem.getPrevious(); tokenItem != null && tokenItem != tokenItem2; tokenItem = tokenItem.getPrevious()) {
            if (CCFormatSupport.tokenEquals((TokenItem)tokenItem, (TokenID)CCTokenContext.LPAREN, (TokenContextPath)this.tokenContextPath)) {
                if (--n >= 0) continue;
                return true;
            }
            if (!CCFormatSupport.tokenEquals((TokenItem)tokenItem, (TokenID)CCTokenContext.RPAREN, (TokenContextPath)this.tokenContextPath)) continue;
            ++n;
        }
        return false;
    }

    private boolean isArrayInitializationBraceBlock(TokenItem tokenItem, TokenItem tokenItem2) {
        int n = 0;
        block5: for (tokenItem = tokenItem.getPrevious(); tokenItem != null && tokenItem != tokenItem2 && tokenItem.getTokenContextPath() == this.tokenContextPath; tokenItem = tokenItem.getPrevious()) {
            switch (tokenItem.getTokenID().getNumericID()) {
                case 65: {
                    ++n;
                    continue block5;
                }
                case 64: {
                    if (--n >= 0) continue block5;
                    TokenItem tokenItem3 = this.findImportantToken(tokenItem, tokenItem2, true);
                    return tokenItem3 != null && tokenItem3.getTokenContextPath() == this.tokenContextPath && (CCTokenContext.RBRACKET.equals(tokenItem3.getTokenID()) || CCTokenContext.EQ.equals(tokenItem3.getTokenID()));
                }
                case 58: 
                case 102: 
                case 107: 
                case 109: 
                case 129: {
                    if (n != 0) continue block5;
                    return false;
                }
            }
        }
        return false;
    }

    public boolean isEnumComma(TokenItem tokenItem) {
        TokenItem tokenItem2;
        TokenItem tokenItem3;
        while (tokenItem != null && CCFormatSupport.tokenEquals((TokenItem)tokenItem, (TokenID)CCTokenContext.COMMA, (TokenContextPath)this.tokenContextPath) && (tokenItem3 = this.findStatementStart(tokenItem)) != tokenItem) {
            tokenItem = tokenItem3;
        }
        return tokenItem != null && CCFormatSupport.tokenEquals((TokenItem)tokenItem, (TokenID)CCTokenContext.IDENTIFIER, (TokenContextPath)this.tokenContextPath) && (tokenItem3 = this.findImportantToken(tokenItem, null, true)) != null && CCFormatSupport.tokenEquals((TokenItem)tokenItem3, (TokenID)CCTokenContext.LBRACE, (TokenContextPath)this.tokenContextPath) && (tokenItem2 = this.findStatementStart(tokenItem3)) != null && this.findToken(tokenItem2, tokenItem3, (TokenID)CCTokenContext.ENUM, this.tokenContextPath, null, false) != null;
    }

    public boolean getFormatSpaceBeforeParenthesis() {
        return this.getSettingBoolean("cc-add-space-before-parenthesis", CCSettingsDefaults.defaultCCFormatSpaceBeforeParenthesis);
    }

    public boolean getFormatSpaceAfterComma() {
        return this.getSettingBoolean("cc-add-space-after-comma", CCSettingsDefaults.defaultCCFormatSpaceAfterComma);
    }

    public boolean getFormatNewlineBeforeBrace() {
        return this.getSettingBoolean("cc-add-newline-before-brace", CCSettingsDefaults.defaultCCFormatNewlineBeforeBrace);
    }

    public boolean getFormatLeadingSpaceInComment() {
        return this.getSettingBoolean("cc-format-leading-space-in-comment", CCSettingsDefaults.defaultCCFormatLeadingSpaceInComment);
    }

    public boolean getFormatLeadingStarInComment() {
        return this.getSettingBoolean("cc-format-leading-star-in-comment", CCSettingsDefaults.defaultCCFormatLeadingStarInComment);
    }

    private int getFormatStatementContinuationIndent() {
        return this.getSettingInteger("cc-format-statement-continuation-indent", CCSettingsDefaults.defaultCCFormatStatementContinuationIndent);
    }

    public FormatTokenPosition findLineFirstNonWhitespaceAndNonLeftBrace(FormatTokenPosition formatTokenPosition) {
        FormatTokenPosition formatTokenPosition2 = super.findLineFirstNonWhitespace(formatTokenPosition);
        if (formatTokenPosition2 == null) {
            return null;
        }
        if (!formatTokenPosition2.getToken().getImage().startsWith("{")) {
            return formatTokenPosition2;
        }
        FormatTokenPosition formatTokenPosition3 = this.findNextEOL(formatTokenPosition2);
        TokenItem tokenItem = this.findMatchingToken(formatTokenPosition2.getToken(), formatTokenPosition3 != null ? formatTokenPosition3.getToken() : null, (ImageTokenID)CCTokenContext.RBRACE, false);
        if (tokenItem != null) {
            return formatTokenPosition2;
        }
        FormatTokenPosition formatTokenPosition4 = this.getNextPosition(formatTokenPosition2);
        if (formatTokenPosition4 == null) {
            return formatTokenPosition2;
        }
        FormatTokenPosition formatTokenPosition5 = this.findImportant(formatTokenPosition4, null, true, false);
        if (formatTokenPosition5 != null) {
            return formatTokenPosition5;
        }
        return formatTokenPosition2;
    }
}

