/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode;

import com.mathworks.matlab.api.debug.ExecutionDisplayAdapter;
import com.mathworks.matlab.api.debug.LineDebugState;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class MExecutionDisplayAdapter
implements ExecutionDisplayAdapter {
    private final List<ExecutionDisplayAdapter.RepaintListener> fRepaintListeners = new ArrayList<ExecutionDisplayAdapter.RepaintListener>();
    protected static final int NO_LINE = -1;
    private int fCurrentLine = -1;
    private boolean fIsAfterLine = false;
    private final List<Integer> fStackLines = new ArrayList<Integer>();

    public void addListener(ExecutionDisplayAdapter.RepaintListener repaintListener) {
        this.fRepaintListeners.add(repaintListener);
    }

    public void removeListener(ExecutionDisplayAdapter.RepaintListener repaintListener) {
        this.fRepaintListeners.remove(repaintListener);
    }

    protected void firePaintNeededEvent() {
        for (ExecutionDisplayAdapter.RepaintListener repaintListener : this.fRepaintListeners) {
            repaintListener.repaintNeeded();
        }
    }

    protected int getCurrentLine() {
        return this.fCurrentLine;
    }

    protected boolean isAfterLine() {
        return this.fIsAfterLine;
    }

    protected void setCurrentLine(int n) {
        this.fCurrentLine = n;
    }

    protected void setIsAfterLine(boolean bl) {
        this.fIsAfterLine = bl;
    }

    public void dispose() {
        this.fRepaintListeners.clear();
    }

    protected List<Integer> getStackLines() {
        return this.fStackLines;
    }

    public EnumSet<LineDebugState> getLineDebugState(int n) {
        EnumSet<LineDebugState> enumSet = EnumSet.noneOf(LineDebugState.class);
        if (n == this.getCurrentLine() && this.getCurrentLine() != -1) {
            if (this.isAfterLine()) {
                enumSet.add(LineDebugState.EXITING_STACK);
            } else {
                enumSet.add(LineDebugState.TOP_OF_STACK);
            }
        }
        if (this.fStackLines.contains(n)) {
            enumSet.add(LineDebugState.IN_STACK);
        }
        return enumSet.isEmpty() ? EnumSet.of(LineDebugState.NOT_ON_STACK) : enumSet;
    }
}

