/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode;

import com.mathworks.services.Prefs;
import com.mathworks.widgets.text.DocumentUtils;
import com.mathworks.widgets.text.ErrorLogger;
import com.mathworks.widgets.text.fold.FoldInfo;
import com.mathworks.widgets.text.mcode.MDocumentUtils;
import com.mathworks.widgets.text.mcode.MFoldInfoCollector;
import com.mathworks.widgets.text.mcode.MTree;
import com.mathworks.widgets.text.mcode.MTreeUtils;
import com.mathworks.widgets.text.mcode.cell.Cell;
import com.mathworks.widgets.text.mcode.cell.CellUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.text.BadLocationException;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;

public class MFoldType
extends Enum<MFoldType> {
    public static final /* enum */ MFoldType HELP_COMMENT = new MFoldType("help-comments", "%...%", new MTree.NodeType[]{MTree.NodeType.FUNCTION, MTree.NodeType.PROTO, MTree.NodeType.CLASSDEF}){

        @Override
        protected FoldInfo createFoldForNode(MTree.Node node, BaseDocument baseDocument) throws BadLocationException {
            int[] nArray = MFoldInfoCollector.findFunctionClassHelpBlock(node);
            return nArray != null ? new FoldInfo(baseDocument.createPosition(DocumentUtils.getRowEndFromLine(baseDocument, nArray[0] - 1)), baseDocument.createPosition(DocumentUtils.getRowEndFromLine(baseDocument, nArray[1] - 1))) : null;
        }
    };
    public static final /* enum */ MFoldType FUNCTION = new MFoldType("function", "...", new MTree.NodeType[]{MTree.NodeType.FUNCTION}){

        @Override
        protected FoldInfo createFoldForNode(MTree.Node node, BaseDocument baseDocument) throws BadLocationException {
            int n = MFoldType.getPreviousNonWhite(baseDocument, MFoldInfoCollector.findEndOfStatement(node) - 1);
            int n2 = MDocumentUtils.findEndOfFunction(baseDocument, node);
            return new FoldInfo(baseDocument.createPosition(n), baseDocument.createPosition(n2));
        }
    };
    public static final /* enum */ MFoldType CELL = new MFoldType("cell", "%%...%%", false, false, new MTree.NodeType[]{MTree.NodeType.FUNCTION, MTree.NodeType.CELL_TITLE}){

        @Override
        protected List<FoldInfo> collectFolds(BaseDocument baseDocument, List<MTree.Node> list) {
            ArrayList<FoldInfo> arrayList = new ArrayList<FoldInfo>();
            LinkedList<MTree.Node> linkedList = new LinkedList<MTree.Node>(list);
            Object object = linkedList.iterator();
            while (object.hasNext()) {
                if (((MTree.Node)object.next()).getType() == MTree.NodeType.CELL_TITLE) continue;
                object.remove();
            }
            try {
                object = CellUtils.getCellLocationsAsList(linkedList, baseDocument.getText(0, baseDocument.getLength()));
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    int n;
                    Cell cell = (Cell)iterator.next();
                    int n2 = cell.getEndLine() - 1;
                    for (n = cell.getStartLine() - 1; n < n2 && Utilities.isRowWhite((BaseDocument)baseDocument, (int)Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n)); ++n) {
                    }
                    if (n == n2) continue;
                    arrayList.add(new FoldInfo(baseDocument.createPosition(DocumentUtils.getRowEndFromLine(baseDocument, n)), baseDocument.createPosition(MFoldType.getPreviousNonWhite(baseDocument, n2))));
                }
            }
            catch (Exception exception) {
                LOGGER.nbDebugLog(exception);
            }
            return arrayList;
        }

        @Override
        protected Priority getPriority() {
            return Priority.SECONDARY;
        }
    };
    public static final /* enum */ MFoldType CLASSDEF = new MFoldType("classdef", "...", MTree.NodeType.CLASSDEF);
    public static final /* enum */ MFoldType WHILE = new MFoldType("while", "...", MTree.NodeType.WHILE);
    public static final /* enum */ MFoldType FOR = new MFoldType("for", "...", MTree.NodeType.FOR, MTree.NodeType.PARFOR);
    public static final /* enum */ MFoldType PROPERTIES = new MFoldType("properties", "...", MTree.NodeType.PROPERTIES);
    public static final /* enum */ MFoldType ENUMERATION = new MFoldType("enumeration", "...", MTree.NodeType.ENUMERATION);
    public static final /* enum */ MFoldType EVENTS = new MFoldType("events", "...", MTree.NodeType.EVENTS);
    public static final /* enum */ MFoldType METHODS = new MFoldType("methods", "...", MTree.NodeType.METHODS);
    public static final /* enum */ MFoldType SPMD = new MFoldType("spmd", "...", MTree.NodeType.SPMD);
    public static final /* enum */ MFoldType IF = new MFoldType("if", "...", false, false, new MTree.NodeType[]{MTree.NodeType.IF}){

        @Override
        protected MTree.Node getNodeForDerivingStartPosition(MTree.Node node) {
            return MTreeUtils.getIfheadNode(node);
        }
    };
    public static final /* enum */ MFoldType TRY = new MFoldType("try", "...", new MTree.NodeType[]{MTree.NodeType.TRY}){

        @Override
        protected FoldInfo createFoldForNode(MTree.Node node, BaseDocument baseDocument) throws BadLocationException {
            return new FoldInfo(baseDocument.createPosition(DocumentUtils.getRowEndFromLine(baseDocument, node.getStartLine() - 1)), baseDocument.createPosition(Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(node.getEndLine() - 1)) + node.getEndColumn()));
        }
    };
    public static final /* enum */ MFoldType SWITCH = new MFoldType("switch", "...", false, false, new MTree.NodeType[]{MTree.NodeType.SWITCH}){

        @Override
        protected List<FoldInfo> collectFolds(BaseDocument baseDocument, List<MTree.Node> list) {
            ArrayList<FoldInfo> arrayList = new ArrayList<FoldInfo>();
            for (MTree.Node node : list) {
                try {
                    if (node.getType() != MTree.NodeType.SWITCH) continue;
                    int n = DocumentUtils.getRowEndFromLine(baseDocument, node.getStartLine() - 1);
                    int n2 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(node.getEndLine() - 1)) + node.getEndColumn();
                    arrayList.add(new FoldInfo(baseDocument.createPosition(n), baseDocument.createPosition(n2)));
                    MTree.Node node2 = node.getRight();
                    while (node2 != MTree.NULL_NODE) {
                        int n3;
                        if (node2.getType().isComment()) {
                            node2 = node2.getNext();
                            continue;
                        }
                        assert (node2.getType() == MTree.NodeType.CASE || node2.getType() == MTree.NodeType.OTHERWISE);
                        int n4 = MFoldType.getPreviousNonWhite(baseDocument, MFoldInfoCollector.findEndOfStatement(node2) - 1);
                        MTree.Node node3 = node2.getNext();
                        if (node3 != MTree.NULL_NODE) {
                            n3 = MFoldType.getIntermediaryStart(baseDocument, node3);
                        } else {
                            int n5 = n2 - 3;
                            int n6 = Utilities.getFirstNonWhiteBwd((BaseDocument)baseDocument, (int)n5);
                            assert (n6 != -1);
                            n3 = n6 + 1;
                        }
                        arrayList.add(new FoldInfo(baseDocument.createPosition(n4), baseDocument.createPosition(n3)));
                        node2 = node3;
                    }
                }
                catch (BadLocationException badLocationException) {
                    LOGGER.nbDebugLog(badLocationException);
                }
            }
            return arrayList;
        }
    };
    public static final /* enum */ MFoldType BLOCK_COMMENT = new MFoldType("blockcomments", "...%}", new MTree.NodeType[]{MTree.NodeType.BLOCK_COMMENT}){

        @Override
        protected FoldInfo createFoldForNode(MTree.Node node, BaseDocument baseDocument) throws BadLocationException {
            return new FoldInfo(baseDocument.createPosition(DocumentUtils.getRowEndFromLine(baseDocument, node.getStartLine() - 1)), baseDocument.createPosition(DocumentUtils.getRowEndFromLine(baseDocument, node.getEndLine() - 1)));
        }
    };
    private final String fTypeName;
    private final FoldType fFoldType;
    private final String fFoldedViewRepresentation;
    private final MTree.NodeType[] fMTreeNodeTypes;
    private final boolean fDefaultFoldEnabled;
    private final boolean fDefaultFoldedOpenOpen;
    private static final ResourceBundle BUNDLE;
    private static final ErrorLogger LOGGER;
    private static final /* synthetic */ MFoldType[] $VALUES;

    public static MFoldType[] values() {
        return (MFoldType[])$VALUES.clone();
    }

    public static MFoldType valueOf(String string) {
        return Enum.valueOf(MFoldType.class, string);
    }

    private MFoldType(String string2, String string3, boolean bl, boolean bl2, MTree.NodeType ... nodeTypeArray) {
        this.fTypeName = string2;
        this.fFoldType = new FoldType(string2);
        this.fFoldedViewRepresentation = string3;
        this.fMTreeNodeTypes = nodeTypeArray;
        this.fDefaultFoldEnabled = bl;
        this.fDefaultFoldedOpenOpen = bl2;
    }

    private MFoldType(String string2, String string3, MTree.NodeType ... nodeTypeArray) {
        this(string2, string3, true, false, nodeTypeArray);
    }

    protected List<FoldInfo> collectFolds(BaseDocument baseDocument, List<MTree.Node> list) {
        ArrayList<FoldInfo> arrayList = new ArrayList<FoldInfo>();
        for (MTree.Node node : list) {
            try {
                FoldInfo foldInfo;
                if (!MTreeUtils.isType(node, this.fMTreeNodeTypes) || (foldInfo = this.createFoldForNode(node, baseDocument)) == null) continue;
                arrayList.add(foldInfo);
            }
            catch (BadLocationException badLocationException) {
                LOGGER.nbDebugLog(badLocationException);
            }
        }
        return arrayList;
    }

    protected Priority getPriority() {
        return Priority.PRIMARY;
    }

    public boolean isFoldEnabled() {
        return Prefs.getBooleanPref((String)this.getFoldEnabledPrefKey(), (boolean)this.isFoldEnabledByDefault());
    }

    public void setFoldEnabled(boolean bl) {
        Prefs.setBooleanPref((String)this.getFoldEnabledPrefKey(), (boolean)bl);
    }

    public boolean isFoldedUponOpen() {
        return Prefs.getBooleanPref((String)this.getFoldedUponOpenPrefKey(), (boolean)this.isFoldedUponOpenByDefault());
    }

    public void setFoldedUponOpen(boolean bl) {
        Prefs.setBooleanPref((String)this.getFoldedUponOpenPrefKey(), (boolean)bl);
    }

    public String getFoldEnabledPrefKey() {
        return "EditorMCodeFoldEnabled" + this.getName();
    }

    public String getFoldedUponOpenPrefKey() {
        return "EditorMCodeFoldCollapseFileOpen" + this.getName();
    }

    public String getPrefTableEntry() {
        return BUNDLE.getString("pref.codefolds.M" + this.getName());
    }

    public String getName() {
        return this.fTypeName;
    }

    public String toString() {
        return this.getName();
    }

    FoldType getType() {
        return this.fFoldType;
    }

    String getCollapsedRepresentation() {
        return this.fFoldedViewRepresentation;
    }

    final MTree.NodeType[] getMTreeNodeTypes() {
        return this.fMTreeNodeTypes;
    }

    private boolean isFoldEnabledByDefault() {
        return this.fDefaultFoldEnabled;
    }

    private boolean isFoldedUponOpenByDefault() {
        return this.fDefaultFoldedOpenOpen;
    }

    static MTree.NodeType[] getNodesNeededForFolds() {
        MFoldType[] mFoldTypeArray;
        HashSet<MTree.NodeType> hashSet = new HashSet<MTree.NodeType>();
        for (MFoldType mFoldType : mFoldTypeArray = MFoldType.values()) {
            if (!mFoldType.isFoldEnabled()) continue;
            MTree.NodeType[] nodeTypeArray = mFoldType.getMTreeNodeTypes();
            hashSet.addAll(Arrays.asList(nodeTypeArray));
        }
        return hashSet.toArray(new MTree.NodeType[hashSet.size()]);
    }

    public static boolean isFoldEnabledPrefKey(String string) {
        for (MFoldType mFoldType : MFoldType.values()) {
            if (!mFoldType.getFoldEnabledPrefKey().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFoldedUponOpenPrefKey(String string) {
        for (MFoldType mFoldType : MFoldType.values()) {
            if (!mFoldType.getFoldedUponOpenPrefKey().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static MFoldType getFoldForPrefKey(String string) {
        for (MFoldType mFoldType : MFoldType.values()) {
            if (!mFoldType.getFoldEnabledPrefKey().equals(string) && !mFoldType.getFoldedUponOpenPrefKey().equals(string)) continue;
            return mFoldType;
        }
        throw new IllegalArgumentException("There is no fold type for prefKey " + string);
    }

    protected FoldInfo createFoldForNode(MTree.Node node, BaseDocument baseDocument) throws BadLocationException {
        int n = MFoldType.getPreviousNonWhite(baseDocument, MFoldInfoCollector.findEndOfStatement(this.getNodeForDerivingStartPosition(node)) - 1);
        int n2 = node.getEndLine() - 1;
        assert (n2 >= 0) : "This method can only be used if the end line is stored in the node. Failed for node '" + node + "'.";
        return new FoldInfo(baseDocument.createPosition(n), baseDocument.createPosition(Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n2) + node.getEndColumn()));
    }

    protected MTree.Node getNodeForDerivingStartPosition(MTree.Node node) {
        return node;
    }

    static List<MFoldType> getFoldTypesWithPriority(Priority priority) {
        ArrayList<MFoldType> arrayList = new ArrayList<MFoldType>();
        for (MFoldType mFoldType : MFoldType.values()) {
            if (mFoldType.getPriority() != priority) continue;
            arrayList.add(mFoldType);
        }
        return arrayList;
    }

    private static int getPreviousNonWhite(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = -1;
        while (n >= 0 && n2 == -1) {
            n2 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n));
            --n;
        }
        assert (n2 != -1);
        return Utilities.getRowEnd((BaseDocument)baseDocument, (int)n2);
    }

    private static int getIntermediaryStart(BaseDocument baseDocument, MTree.Node node) throws BadLocationException {
        int n = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(node.getStartLine() - 1)) + node.getStartColumn() - 1;
        int n2 = Utilities.getFirstNonWhiteBwd((BaseDocument)baseDocument, (int)n);
        assert (n2 != -1);
        int n3 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n2);
        return n3 < n ? n3 : n2 + 1;
    }

    static {
        $VALUES = new MFoldType[]{HELP_COMMENT, FUNCTION, CELL, CLASSDEF, WHILE, FOR, PROPERTIES, ENUMERATION, EVENTS, METHODS, SPMD, IF, TRY, SWITCH, BLOCK_COMMENT};
        BUNDLE = ResourceBundle.getBundle(MFoldType.class.getPackage().getName() + ".resources.RES_mcode");
        LOGGER = ErrorLogger.getLogger();
    }

    static enum Priority {
        PRIMARY,
        SECONDARY;

    }
}

