/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode.variables;

import com.mathworks.matlab.api.editor.EditorLayer;
import com.mathworks.matlab.api.editor.EditorMessage;
import com.mathworks.matlab.api.editor.EditorMessageBarContributor;
import com.mathworks.matlab.api.editor.EditorTipDocHelper;
import com.mathworks.matlab.api.editor.highlighting.EditorHighlighterProvider;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.widgets.messagepanel.AbstractMessageModel;
import com.mathworks.widgets.messagepanel.MessageModel;
import com.mathworks.widgets.text.ColoringDrawLayer;
import com.mathworks.widgets.text.LayerMarkList;
import com.mathworks.widgets.text.MWEditorUI;
import com.mathworks.widgets.text.STPBaseInterface;
import com.mathworks.widgets.text.layer.DefaultEditorMessage;
import com.mathworks.widgets.text.layer.LayerUtils;
import com.mathworks.widgets.text.mcode.MDocumentUtils;
import com.mathworks.widgets.text.mcode.MKit;
import com.mathworks.widgets.text.mcode.MTree;
import com.mathworks.widgets.text.mcode.MTreeUpdater;
import com.mathworks.widgets.text.mcode.MTreeUtils;
import com.mathworks.widgets.text.mcode.variables.NonlocalVariableUtils;
import com.mathworks.widgets.text.mcode.variables.VariableHighlightPrefs;
import java.awt.Color;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.ext.ExtEditorUI;

public class NonlocalVariableHighlightingLayer
implements EditorLayer {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.widgets.text.mcode.variables.resources.RES_variables");
    public static final String LAYER_NAME = "Non-local Variable Highlighting Layer";
    private static final int DRAWLAYER_VISIBILITY = 1000;
    private static final String TEXTCOLOR_LAYER_NAME = "Text Color Non-local Variable Highlighting Layer";
    private static EditorTipDocHelper sDocHelper;
    private boolean fEnabled;
    private STPBaseInterface fTextPane;
    private LayerMarkList fMarkList;
    private AbstractMessageModel fMessageModel;
    private ColoringDrawLayer fTextColorLayer;
    private MTreeUpdater.MTreeListener fMTreeListener;

    private Color getHighlightingColor() {
        assert (this.fTextPane != null) : "should only be called when the layer is enabled";
        return (Color)SettingsUtil.getValue(this.fTextPane.getEditorKit().getClass(), (String)"Editor.NonlocalVariableHighlighting.TextColor", (Object)VariableHighlightPrefs.getPreferredNonlocalVariableTextColor());
    }

    private Coloring createTextColoring() {
        return new Coloring(null, this.getHighlightingColor(), null);
    }

    public void updateHighlights(MTree mTree) {
        MJUtilities.assertIsEventThread();
        this.fMarkList.clear();
        ArrayList<SharedScopeMessage> arrayList = new ArrayList<SharedScopeMessage>();
        for (MTree.Node node : NonlocalVariableUtils.findNonLocalVariables(mTree)) {
            int n = node.getText().length();
            BaseDocument baseDocument = (BaseDocument)this.fTextPane.getDocument();
            int n2 = MTreeUtils.getPosition(node, baseDocument);
            this.fMarkList.addMark(TEXTCOLOR_LAYER_NAME, n2, n);
            arrayList.add(new SharedScopeMessage(VariableType.getVariableType(node), node.getText(), n2, n2 + n, baseDocument, this.getHighlightingColor()));
        }
        this.fMessageModel.update(arrayList, this.fTextPane.getNumLines());
    }

    public void updateDocuments(Document document, Document document2) {
        if (this.fEnabled) {
            if (document != null) {
                MTreeUpdater.stopUpdates(this.fTextPane, MTreeUpdater.UpdateInterval.SYNTAX, this.fMTreeListener);
            }
            if (document2 != null) {
                MTreeUpdater.startUpdates(this.fTextPane, MTreeUpdater.UpdateInterval.SYNTAX, this.fMTreeListener);
            }
        }
    }

    public String getLayerName() {
        return LAYER_NAME;
    }

    public boolean supportsMessageBar() {
        return false;
    }

    public void settingsChanged(String string, ExtEditorUI extEditorUI) {
        if (this.fEnabled && string != null && string.equals("Editor.NonlocalVariableHighlighting.TextColor")) {
            this.fTextColorLayer.setColoring(this.createTextColoring());
        }
        if (string != null && string.equals("Editor.NonlocalVariableHighlighting")) {
            if (this.fEnabled && !this.isHighlighting()) {
                ((MWEditorUI)extEditorUI).disableLayer(this);
            } else if (!this.fEnabled && this.isHighlighting()) {
                ((MWEditorUI)extEditorUI).installLayer(this);
                this.updateHighlights(MDocumentUtils.getMTree((BaseDocument)this.fTextPane.getDocument()));
            }
        }
    }

    private boolean isHighlighting() {
        Class<MKit> clazz = this.fTextPane != null ? this.fTextPane.getEditorKit().getClass() : MKit.class;
        return (Boolean)SettingsUtil.getValue(clazz, (String)"Editor.NonlocalVariableHighlighting", (Object)VariableHighlightPrefs.isNonlocalVariableHighlightingEnabled());
    }

    public void cleanup() {
        this.disable();
    }

    public boolean hasMessages() {
        return this.fEnabled && this.fMessageModel.getMessageCount() > 0;
    }

    public List<? extends EditorMessage> getMessagesAtPosition(int n, int n2) {
        List<Object> list = Collections.emptyList();
        if (this.hasMessages()) {
            list = LayerUtils.getMessagesFromModel(n, n2, this.fMessageModel);
        }
        return list;
    }

    public EditorMessageBarContributor getMessageBarContributor() {
        return null;
    }

    public boolean supportsHighlighting() {
        return false;
    }

    public EditorHighlighterProvider getEditorHighlighterProvider() {
        return null;
    }

    public void enable(JTextComponent jTextComponent) {
        Validate.notNull((Object)jTextComponent);
        if (!this.fEnabled && VariableHighlightPrefs.isNonlocalVariableHighlightingEnabled()) {
            this.fTextPane = (STPBaseInterface)((Object)jTextComponent);
            this.fEnabled = true;
            this.fMarkList = new LayerMarkList(this.fTextPane);
            this.fMessageModel = new AbstractMessageModel(){

                @Override
                public String getTextAt(int n) {
                    return null;
                }

                @Override
                public MessageModel.Priority getModelPriority(int n) {
                    return MessageModel.Priority.TRANSIENT_LAYER;
                }

                @Override
                public int getLineNumberAt(int n) {
                    return ((EditorMessage)this.getMessageAt(n)).getLineNumber();
                }

                @Override
                public int getPriorityAt(int n) {
                    return 1;
                }
            };
            this.fTextColorLayer = new ColoringDrawLayer(TEXTCOLOR_LAYER_NAME, this.createTextColoring());
            this.fTextPane.getEditorUI().addLayer((DrawLayer)this.fTextColorLayer, 1000);
            this.fMTreeListener = new MTreeUpdater.MTreeListener(){

                @Override
                public void treeUpdated(MTree mTree) {
                    NonlocalVariableHighlightingLayer.this.updateHighlights(mTree);
                }
            };
            MTreeUpdater.startUpdates(this.fTextPane, MTreeUpdater.UpdateInterval.SYNTAX, this.fMTreeListener);
        }
    }

    public void disable() {
        if (this.fEnabled) {
            this.fEnabled = false;
            this.fMarkList.clear();
            this.fTextPane.getEditorUI().removeLayer(TEXTCOLOR_LAYER_NAME);
            MTreeUpdater.stopUpdates(this.fTextPane, MTreeUpdater.UpdateInterval.SYNTAX, this.fMTreeListener);
        }
    }

    public LayerMarkList getMarks() {
        return this.fMarkList;
    }

    public static void setDocHelper(EditorTipDocHelper editorTipDocHelper) {
        sDocHelper = editorTipDocHelper;
    }

    private static final class VariableType
    extends Enum<VariableType> {
        public static final /* enum */ VariableType NESTED_FUNCTION = new VariableType("nonlocal.shortMessage", "var_nonlocal");
        public static final /* enum */ VariableType GLOBAL = new VariableType("global.shortMessage", "var_global");
        public static final /* enum */ VariableType PERSISTENT = new VariableType("persistent.shortMessage", "var_persist");
        private final String fShortMessageKey;
        private final String fExtendedMessageKey;
        private static final /* synthetic */ VariableType[] $VALUES;

        public static VariableType[] values() {
            return (VariableType[])$VALUES.clone();
        }

        public static VariableType valueOf(String string) {
            return Enum.valueOf(VariableType.class, string);
        }

        private VariableType(String string2, String string3) {
            this.fShortMessageKey = string2;
            this.fExtendedMessageKey = string3;
        }

        private String getMessage(String string) {
            return MessageFormat.format(BUNDLE.getString(this.fShortMessageKey), string);
        }

        private String getExtendedMessageKey() {
            return this.fExtendedMessageKey;
        }

        private static VariableType getVariableType(MTree.Node node) {
            assert (node.isUsedCrossFunctions() || node.isPersistent() || node.isGlobal()) : "Node must correspond to a variable with shared scope.";
            return node.isUsedCrossFunctions() ? NESTED_FUNCTION : (node.isPersistent() ? PERSISTENT : GLOBAL);
        }

        static {
            $VALUES = new VariableType[]{NESTED_FUNCTION, GLOBAL, PERSISTENT};
        }
    }

    private static class SharedScopeMessage
    extends DefaultEditorMessage {
        private final VariableType fType;

        private SharedScopeMessage(VariableType variableType, String string, int n, int n2, BaseDocument baseDocument, Color color) {
            super(variableType.getMessage(string), n, n2, baseDocument, color, true);
            this.fType = variableType;
        }

        @Override
        public boolean isExtendable() {
            return true;
        }

        @Override
        public boolean hasExtendedInformation() {
            return sDocHelper != null && sDocHelper.hasExtendedHelp(this.fType.getExtendedMessageKey());
        }

        @Override
        public String getExtendedInformation() {
            return sDocHelper.getExtendedHelp(this.fType.getExtendedMessageKey());
        }
    }
}

