/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.util;

import com.mathworks.util.DebugUtils;
import com.mathworks.widgets.util.EmptyIcon;
import java.awt.Component;
import java.awt.Container;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.UIManager;

public final class GUIUtils {
    private static final Icon defaultIcon = new EmptyIcon(32, 32);
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mwswing.resources.RES_mwswing");

    public static void setEnabledRecursively(Container container, boolean bl) {
        assert (container != null) : "Argument \"root\" must not be null.";
        container.setEnabled(bl);
        for (Component component : container.getComponents()) {
            if (component instanceof Container) {
                GUIUtils.setEnabledRecursively((Container)component, bl);
                continue;
            }
            component.setEnabled(bl);
        }
    }

    public static Icon getOptionPaneIcon(int n) {
        switch (n) {
            case 0: {
                return GUIUtils.internalGetOptionPaneIcon("OptionPane.errorIcon");
            }
            case 1: {
                return GUIUtils.internalGetOptionPaneIcon("OptionPane.informationIcon");
            }
            case 2: {
                return GUIUtils.internalGetOptionPaneIcon("OptionPane.warningIcon");
            }
            case 3: {
                return GUIUtils.internalGetOptionPaneIcon("OptionPane.questionIcon");
            }
        }
        assert (DebugUtils.warning((String)("Cannot find icon for message type: " + n)));
        return defaultIcon;
    }

    public static String getStandardDialogString(DialogStringType dialogStringType) {
        assert (dialogStringType != null);
        switch (dialogStringType) {
            case OK_BUTTON: {
                return sRes.getString("labelOK");
            }
            case CANCEL_BUTTON: {
                return sRes.getString("labelCancel");
            }
            case YES_BUTTON: {
                return sRes.getString("dialog.MJOptionPane.Yes");
            }
            case NO_BUTTON: {
                return sRes.getString("dialog.MJOptionPane.No");
            }
            case OPEN_BUTTON: {
                return sRes.getString("filechooser.platform.open");
            }
            case SAVE_BUTTON: {
                return sRes.getString("filechooser.platform.save");
            }
            case HELP_BUTTON: {
                return sRes.getString("labelHelp");
            }
        }
        assert (DebugUtils.warning((String)("There is no standard mapping for: " + dialogStringType.toString())));
        return "";
    }

    private static Icon internalGetOptionPaneIcon(String string) {
        assert (string != null);
        Icon icon = UIManager.getIcon(string);
        assert (DebugUtils.warning(icon == null ? "Cannot find icon: " + string : null));
        return icon != null ? icon : defaultIcon;
    }

    private GUIUtils() {
    }

    public static enum DialogStringType {
        YES_BUTTON,
        NO_BUTTON,
        OK_BUTTON,
        CANCEL_BUTTON,
        HELP_BUTTON,
        OPEN_BUTTON,
        SAVE_BUTTON;

    }
}

