/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.clients.cloudcenter;

import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.client.core.ServiceUnavailableException;
import com.mathworks.webservices.clients.cloudcenter.ClientNotAuthorizedException;
import com.mathworks.webservices.clients.cloudcenter.ClusterExistsException;
import com.mathworks.webservices.clients.cloudcenter.ClusterNameRequiredException;
import com.mathworks.webservices.clients.cloudcenter.ClusterNotFoundException;
import com.mathworks.webservices.clients.cloudcenter.ClusterValidationException;
import com.mathworks.webservices.clients.cloudcenter.EntitlementIdRequiredException;
import com.mathworks.webservices.clients.cloudcenter.HostedOptionNotAvailableException;
import com.mathworks.webservices.clients.cloudcenter.InvalidArgumentException;
import com.mathworks.webservices.clients.cloudcenter.InvalidClusterNameException;
import com.mathworks.webservices.clients.cloudcenter.InvalidNumWorkersException;
import com.mathworks.webservices.clients.cloudcenter.QnameRequiredException;
import com.mathworks.webservices.clients.cloudcenter.UnknownReleaseException;

public enum CloudCenterErrorCode {
    SERVICE_UNAVAILABLE("1000", 503, ServiceUnavailableException.class),
    BAD_REQUEST("1001", 400, MathWorksServiceException.class),
    CLUSTER_EXISTS("2000", 400, ClusterExistsException.class),
    CLUSTER_NOT_FOUND("2001", 400, ClusterNotFoundException.class),
    CLUSTER_INVALID("2002", 400, ClusterValidationException.class),
    QNAME_REQUIRED("2003", 400, QnameRequiredException.class),
    CLUSTER_NAME_REQUIRED("2004", 400, ClusterNameRequiredException.class),
    INVALID_CLUSTER_NAME("2005", 400, InvalidClusterNameException.class),
    UNKNOWN_RELEASE("2006", 400, UnknownReleaseException.class),
    HOSTED_OPTION_NOT_AVAILABLE("2007", 400, HostedOptionNotAvailableException.class),
    ENTITLEMENT_ID_REQUIRED("2010", 400, EntitlementIdRequiredException.class),
    UNAUTHORIZED("2011", 401, ClientNotAuthorizedException.class),
    INVALID_NUM_WORKERS("2012", 400, InvalidNumWorkersException.class),
    INVALID_ARGUMENT("2013", 400, InvalidArgumentException.class);

    private final String value;
    private final int httpStatus;
    private final Class<? extends MathWorksServiceException> exceptionClass;

    private CloudCenterErrorCode(String value, int httpStatus, Class<? extends MathWorksServiceException> theClass) {
        this.value = value;
        this.httpStatus = httpStatus;
        this.exceptionClass = theClass;
    }

    public String getValue() {
        return this.value;
    }

    Class<? extends MathWorksServiceException> getExceptionClass() {
        return this.exceptionClass;
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }
}

