/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search.lucene;

import com.mathworks.search.BooleanSearchOperator;
import com.mathworks.search.CompoundSearchExpression;
import com.mathworks.search.ExactPhraseSearchExpression;
import com.mathworks.search.PartialWordSearchExpression;
import com.mathworks.search.SearchException;
import com.mathworks.search.SearchExpression;
import com.mathworks.search.SearchField;
import com.mathworks.search.SearchLanguage;
import com.mathworks.search.SearchStringParseException;
import com.mathworks.search.SearchVisitor;
import com.mathworks.search.SimpleSearchExpression;
import com.mathworks.search.UnarySearchExpression;
import com.mathworks.search.WildcardSearchExpression;
import com.mathworks.search.lucene.LuceneVersion;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Stack;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

public class LuceneSearchVisitor
implements SearchVisitor {
    private static final EnumSet<SearchLanguage> CJK_LANGUAGES = EnumSet.of(SearchLanguage.SIMPLIFIED_CHINESE, SearchLanguage.JAPANESE, SearchLanguage.KOREAN);
    private final Analyzer fAnalyzer;
    private final Collection<SearchField> fDefaultFields;
    private Query fBaseQuery;
    private BooleanSearchOperator fOperator;
    private Stack<Collection<SearchField>> fSearchFieldsStack = new Stack();
    private final SearchLanguage fLanguage;

    public LuceneSearchVisitor(Analyzer analyzer, Collection<? extends SearchField> defaultFields, SearchLanguage language) {
        this.fAnalyzer = analyzer;
        this.fDefaultFields = defaultFields == null ? null : new ArrayList<SearchField>(defaultFields);
        this.fLanguage = language;
    }

    @Override
    public void visit(SimpleSearchExpression simpleExpr) throws SearchException {
        this.handleSimpleSearchString(simpleExpr.getSearchString(), this.getFields(simpleExpr), simpleExpr.getBooleanOperator());
    }

    private void handleSimpleSearchString(String searchString, Collection<SearchField> fields, BooleanSearchOperator operator) throws SearchStringParseException {
        BooleanQuery baseQuery = new BooleanQuery();
        for (SearchField field : fields) {
            TermQuery q;
            if (field.getSearchField().isAnalyzed()) {
                QueryParser parser = new QueryParser(LuceneVersion.CURRENT_VERSION, field.getFieldName(), this.fAnalyzer);
                if (CJK_LANGUAGES.contains((Object)this.fLanguage)) {
                    parser.setAutoGeneratePhraseQueries(true);
                }
                try {
                    searchString = QueryParser.escape((String)searchString);
                    q = parser.parse(searchString);
                }
                catch (ParseException pe) {
                    throw new SearchStringParseException(SearchStringParseException.Type.UNKNOWN_ERROR, (Throwable)pe);
                }
            } else {
                q = new TermQuery(new Term(field.getFieldName(), searchString));
            }
            q.setBoost(field.getWeight());
            baseQuery.add((Query)q, LuceneSearchVisitor.getOccurrence(field.getBooleanOperator()));
        }
        this.setBaseQuery((Query)baseQuery);
        this.setBooleanOperator(operator);
    }

    @Override
    public void visit(PartialWordSearchExpression partialExpr) throws SearchStringParseException {
        String searchString = partialExpr.getSearchString();
        BooleanQuery baseQuery = new BooleanQuery();
        Collection<SearchField> fields = this.getFields(partialExpr);
        if (this.checkForWildcardSupport(searchString, fields)) {
            for (SearchField field : fields) {
                if (field.isAnalyzed()) {
                    searchString = searchString.toLowerCase(Locale.getDefault());
                }
                PrefixQuery pQuery = new PrefixQuery(new Term(field.getFieldName(), searchString));
                pQuery.setBoost(field.getWeight());
                baseQuery.add((Query)pQuery, LuceneSearchVisitor.getOccurrence(field.getBooleanOperator()));
            }
            this.setBaseQuery((Query)baseQuery);
            this.setBooleanOperator(partialExpr.getBooleanOperator());
        } else {
            this.handleSimpleSearchString(searchString, fields, partialExpr.getBooleanOperator());
        }
    }

    @Override
    public void visit(WildcardSearchExpression wildcardExpr) throws SearchStringParseException {
        Collection<SearchField> fields;
        String searchString = wildcardExpr.getSearchString();
        String wildcardStripped = searchString.replaceAll("\\*", "");
        if (this.checkForWildcardSupport(wildcardStripped, fields = this.getFields(wildcardExpr))) {
            BooleanQuery baseQuery = new BooleanQuery();
            for (SearchField field : fields) {
                if (field.getSearchField().isAnalyzed()) {
                    searchString = searchString.toLowerCase(Locale.getDefault());
                }
                WildcardQuery wQuery = new WildcardQuery(new Term(field.getFieldName(), searchString));
                wQuery.setBoost(field.getWeight());
                baseQuery.add((Query)wQuery, LuceneSearchVisitor.getOccurrence(field.getBooleanOperator()));
            }
            this.setBaseQuery((Query)baseQuery);
            this.setBooleanOperator(wildcardExpr.getBooleanOperator());
        } else {
            this.handleSimpleSearchString(wildcardStripped, fields, wildcardExpr.getBooleanOperator());
        }
    }

    private boolean checkForWildcardSupport(String searchString, Collection<SearchField> fields) {
        for (SearchField field : fields) {
            if (!field.isAnalyzed()) continue;
            return this.isWildcardCharacterSupported(searchString, field.getFieldName());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWildcardCharacterSupported(String searchString, String fieldName) {
        TokenStream source = null;
        try {
            source = this.fAnalyzer.tokenStream(fieldName, (Reader)new StringReader(searchString));
            source.reset();
            source.incrementToken();
            boolean bl = !source.incrementToken();
            return bl;
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                source.end();
                source.close();
            }
            catch (IOException ioe) {}
        }
    }

    @Override
    public void visit(ExactPhraseSearchExpression exactExpr) throws SearchException {
        String searchString = exactExpr.getSearchString();
        try {
            BooleanQuery baseQuery = new BooleanQuery();
            for (SearchField field : this.getFields(exactExpr)) {
                QueryParser parser = new QueryParser(LuceneVersion.CURRENT_VERSION, field.getFieldName(), this.fAnalyzer);
                Query q = parser.parse("\"" + searchString + "\"");
                q.setBoost(field.getWeight());
                baseQuery.add(q, LuceneSearchVisitor.getOccurrence(field.getBooleanOperator()));
            }
            this.setBaseQuery((Query)baseQuery);
            this.setBooleanOperator(exactExpr.getBooleanOperator());
        }
        catch (ParseException pe) {
            throw new SearchStringParseException(SearchStringParseException.Type.UNKNOWN_ERROR);
        }
    }

    @Override
    public void visit(CompoundSearchExpression compoundExpr) throws SearchException {
        BooleanQuery query = new BooleanQuery();
        boolean pushed = this.pushSearchFields(compoundExpr);
        for (SearchExpression expr : compoundExpr.getExpressions()) {
            expr.accept(this);
            query.add(this.getBaseQuery(), LuceneSearchVisitor.getOccurrence(this.getBooleanOperator()));
        }
        this.setBaseQuery((Query)query);
        this.setBooleanOperator(compoundExpr.getBooleanOperator());
        if (pushed) {
            this.popSearchFields();
        }
    }

    private Collection<SearchField> getFields(UnarySearchExpression expr) {
        Collection<SearchField> exprFields = expr.getSearchFields();
        if (exprFields != null) {
            return exprFields;
        }
        if (!this.fSearchFieldsStack.isEmpty()) {
            return this.fSearchFieldsStack.peek();
        }
        if (this.fDefaultFields != null && !this.fDefaultFields.isEmpty()) {
            return this.fDefaultFields;
        }
        throw new IllegalStateException("No fields to search");
    }

    private boolean pushSearchFields(CompoundSearchExpression expr) {
        Collection<SearchField> exprFields = expr.getSearchFields();
        if (exprFields != null) {
            this.fSearchFieldsStack.push(exprFields);
            return true;
        }
        return false;
    }

    private void popSearchFields() {
        this.fSearchFieldsStack.pop();
    }

    protected void setBaseQuery(Query query) {
        this.fBaseQuery = query;
    }

    public Query getBaseQuery() {
        return this.fBaseQuery;
    }

    private void setBooleanOperator(BooleanSearchOperator operator) {
        this.fOperator = operator;
    }

    private BooleanSearchOperator getBooleanOperator() {
        return this.fOperator;
    }

    private static BooleanClause.Occur getOccurrence(BooleanSearchOperator operator) {
        switch (operator) {
            case MUST_OCCUR: {
                return BooleanClause.Occur.MUST;
            }
            case MUST_NOT_OCCUR: {
                return BooleanClause.Occur.MUST_NOT;
            }
        }
        return BooleanClause.Occur.SHOULD;
    }
}

