/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search.lucene;

import com.mathworks.search.SearchIndexException;
import com.mathworks.search.lucene.IndexLocation;
import com.mathworks.search.lucene.LuceneSearchIndexException;
import com.mathworks.search.lucene.MWSearcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;

class MWMultiSearcher
implements MWSearcher {
    private final IndexSearcher fSearcher;
    private final MultiReader fReader;
    private final IndexLocation[] fIndexLocations;

    MWMultiSearcher(IndexLocation ... locations) throws SearchIndexException {
        Collection<IndexReader> indexReaders = null;
        try {
            indexReaders = MWMultiSearcher.getIndexReaders(locations);
        }
        catch (IOException ioe) {
            throw new LuceneSearchIndexException(ioe);
        }
        this.fReader = new MultiReader(indexReaders.toArray(new IndexReader[indexReaders.size()]));
        this.fSearcher = new IndexSearcher((IndexReader)this.fReader);
        this.fIndexLocations = locations;
    }

    private static Collection<IndexReader> getIndexReaders(IndexLocation[] locations) throws IOException {
        ArrayList<IndexReader> indexReaders = new ArrayList<IndexReader>();
        for (IndexLocation location : locations) {
            indexReaders.add((IndexReader)DirectoryReader.open((Directory)location.getSearchDirectory()));
        }
        return indexReaders;
    }

    @Override
    public IndexLocation getIndexForDocument(int docNum) {
        int counter = 0;
        try {
            for (IndexReader r : MWMultiSearcher.getIndexReaders(this.fIndexLocations)) {
                if (docNum <= r.numDocs()) break;
                docNum -= r.numDocs();
                ++counter;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.fIndexLocations[counter];
    }

    @Override
    public IndexSearcher getSearcher() {
        return this.fSearcher;
    }

    @Override
    public IndexReader getReader() {
        return this.fReader;
    }

    @Override
    public void close() throws IOException {
        this.fReader.close();
    }
}

