/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search.lucene;

import com.mathworks.search.SearchField;
import com.mathworks.search.SearchHighlight;
import com.mathworks.search.SearchSuggestions;
import com.mathworks.search.TextHighlighter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;

public class SuggestionProvider {
    private static final Pattern FIND_LAST_WORD_PATTERN = Pattern.compile("^(.*\\s+)(\\w+)\\s*$");
    private IndexReader fReader;
    private SearchField fField;

    public SuggestionProvider(IndexReader reader, SearchField field) {
        this.fReader = reader;
        this.fField = field;
    }

    private IndexReader getIndexReader() {
        return this.fReader;
    }

    public SearchSuggestions getSuggestions(String searchText, int maxSuggestions) {
        try {
            Matcher m = FIND_LAST_WORD_PATTERN.matcher(searchText);
            if (m.find()) {
                String fullWords = m.group(1);
                String partialWord = m.group(2);
                return this.getSuggestionsForLastWord(fullWords, partialWord, maxSuggestions);
            }
            return this.getSuggestionsForSingleWord(searchText, maxSuggestions);
        }
        catch (IOException e) {
            return SearchSuggestions.emptySuggestions();
        }
    }

    private SearchSuggestions getSuggestionsForSingleWord(String prefix, int maxSuggestions) throws IOException {
        TextHighlighter highlighter = new TextHighlighter(TextHighlighter.HighlightRule.PREFIX, prefix);
        SuggestionsMap<Term> suggestedTerms = this.getSuggestedTerms(prefix, maxSuggestions);
        ArrayList<SearchHighlight> suggestedStrings = new ArrayList<SearchHighlight>();
        for (Term term : ((SuggestionsMap)suggestedTerms).values()) {
            suggestedStrings.add(highlighter.addHighlightsToString(term.text()));
        }
        return new SearchSuggestions(suggestedStrings, ((SuggestionsMap)suggestedTerms).getTotalFound());
    }

    private SearchSuggestions getSuggestionsForLastWord(String fullWords, String partialWord, int maxSuggestions) throws IOException {
        String[] splitFullWords = fullWords.split("\\s+");
        HashSet<String> fullWordSet = new HashSet<String>();
        fullWordSet.addAll(Arrays.asList(splitFullWords));
        SortedMap<Integer, DocsEnum> fullWordDocsEnumMap = this.getFullWordDocsEnum(splitFullWords);
        if (fullWordDocsEnumMap.firstKey() == 0) {
            return SearchSuggestions.emptySuggestions();
        }
        Collection<DocsEnum> fullWordDocsEnum = fullWordDocsEnumMap.values();
        SuggestionsMap<Term> partialWordTerms = this.getSuggestedTerms(partialWord, Integer.MAX_VALUE);
        SuggestionsMap suggestions = new SuggestionsMap(maxSuggestions);
        ArrayList<String> highlightKeywords = new ArrayList<String>(fullWordSet);
        highlightKeywords.add(partialWord);
        TextHighlighter highlighter = new TextHighlighter(TextHighlighter.HighlightRule.PREFIX, highlightKeywords);
        for (Term t : ((SuggestionsMap)partialWordTerms).values()) {
            if (fullWordSet.contains(t.text())) continue;
            int intersection = SuggestionProvider.intersectDocsEnum(fullWordDocsEnum, ((AtomicReaderContext)this.getIndexReader().leaves().get(0)).reader().termDocsEnum(t));
            if (intersection > 0) {
                String suggestionString = fullWords + t.text();
                suggestions.add(new Suggestion(suggestionString, intersection), highlighter.addHighlightsToString(suggestionString));
            }
            fullWordDocsEnum = this.getFullWordDocsEnum(splitFullWords).values();
        }
        return new SearchSuggestions(suggestions.values(), suggestions.getTotalFound());
    }

    private SortedMap<Integer, DocsEnum> getFullWordDocsEnum(String[] fullWords) throws IOException {
        TreeMap<Integer, DocsEnum> fullWordDocsEnum = new TreeMap<Integer, DocsEnum>();
        IndexReader reader = this.getIndexReader();
        for (String fullWord : fullWords) {
            Term fullWordTerm = new Term(this.fField.getFieldName(), fullWord);
            fullWordDocsEnum.put(reader.docFreq(fullWordTerm), ((AtomicReaderContext)this.getIndexReader().leaves().get(0)).reader().termDocsEnum(fullWordTerm));
        }
        return fullWordDocsEnum;
    }

    private SuggestionsMap<Term> getSuggestedTerms(String prefix, int maxSuggestions) throws IOException {
        BytesRef currentTerm;
        prefix = prefix.trim();
        SuggestionsMap<Term> suggestionTerms = new SuggestionsMap<Term>(maxSuggestions);
        String fieldName = this.fField.getFieldName();
        IndexReader indexReader = this.getIndexReader();
        Terms terms = ((AtomicReaderContext)indexReader.leaves().get(0)).reader().terms(fieldName);
        TermsEnum termsEnum = terms.iterator(null);
        boolean isMatching = false;
        while ((currentTerm = termsEnum.next()) != null) {
            if (!SuggestionProvider.shouldAcceptTerm(currentTerm, prefix)) {
                if (!isMatching) continue;
                break;
            }
            isMatching = true;
            Term term = new Term(fieldName, currentTerm.utf8ToString());
            Suggestion suggestion = new Suggestion(currentTerm.utf8ToString(), indexReader.docFreq(term));
            ((SuggestionsMap)suggestionTerms).add(suggestion, term);
        }
        return suggestionTerms;
    }

    private static boolean shouldAcceptTerm(BytesRef term, String prefix) {
        return term != null && term.utf8ToString().startsWith(prefix);
    }

    private static int intersectDocsEnum(Collection<DocsEnum> fullWordDocs, DocsEnum partialWordDocs) throws IOException {
        ArrayList<DocsEnum> td = new ArrayList<DocsEnum>(fullWordDocs);
        td.add(partialWordDocs);
        int intersect = 0;
        int nextDoc = SuggestionProvider.getNextCommonTermDoc(td, 0);
        while (nextDoc > -1) {
            ++intersect;
            nextDoc = SuggestionProvider.getNextCommonTermDoc(td, nextDoc + 1);
        }
        return intersect;
    }

    private static int getNextCommonTermDoc(Iterable<DocsEnum> td, int startFrom) throws IOException {
        int candidateDoc = SuggestionProvider.getInitialMatchCandidate(td, startFrom);
        boolean allMatch = false;
        while (!allMatch) {
            allMatch = true;
            Iterator<DocsEnum> iterator = td.iterator();
            while (iterator.hasNext() && allMatch) {
                DocsEnum t = iterator.next();
                int doc = t.docID();
                if (doc >= candidateDoc) continue;
                if (t.advance(candidateDoc) != Integer.MAX_VALUE) {
                    int newCandidate = t.docID();
                    allMatch = newCandidate == candidateDoc;
                    candidateDoc = newCandidate;
                    continue;
                }
                return -1;
            }
        }
        return candidateDoc;
    }

    private static int getInitialMatchCandidate(Iterable<DocsEnum> td, int startFrom) throws IOException {
        int candidateDoc = startFrom;
        for (DocsEnum t : td) {
            int potentialCandidate = t.docID();
            if (potentialCandidate <= candidateDoc) continue;
            candidateDoc = potentialCandidate;
        }
        return candidateDoc;
    }

    private static class Suggestion
    implements Comparable<Suggestion> {
        private final String iText;
        private final int iNumDocs;

        private Suggestion(String text, int numDocs) {
            this.iText = text;
            this.iNumDocs = numDocs;
        }

        private String getText() {
            return this.iText;
        }

        private int getNumDocs() {
            return this.iNumDocs;
        }

        @Override
        public int compareTo(Suggestion o) {
            if (this.getNumDocs() == o.getNumDocs()) {
                return this.getText().compareTo(o.getText());
            }
            return this.getNumDocs() < o.getNumDocs() ? 1 : -1;
        }

        public boolean equals(Object obj) {
            return obj instanceof Suggestion && this.iText.equals(((Suggestion)obj).iText);
        }

        public int hashCode() {
            return this.iText.hashCode();
        }
    }

    private static class SuggestionsMap<E> {
        private final int iMaxSize;
        private final SortedMap<Suggestion, E> iMap = new TreeMap<Suggestion, E>();
        private int iTotalFound = 0;

        private SuggestionsMap(int maxSize) {
            this.iMaxSize = maxSize;
        }

        private void add(Suggestion s, E value) {
            ++this.iTotalFound;
            this.iMap.put(s, value);
            if (this.iMap.size() > this.iMaxSize) {
                this.iMap.remove(this.iMap.lastKey());
            }
        }

        private Collection<E> values() {
            return this.iMap.values();
        }

        private int getTotalFound() {
            return this.iTotalFound;
        }
    }
}

