/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hadoop;

import java.io.Closeable;
import java.net.URI;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;

public class MWSequenceFileReader {
    private SequenceFile.Reader reader = null;
    private Writable key = null;
    private Writable value = null;
    private long fileSize = 0L;
    private long position = 0L;
    private String currentFile = null;
    private Configuration conf = null;
    private FileSystem fs = null;
    private FileStatus[] fstatus = null;
    private int findex = -1;

    public void addPaths(String files) throws Exception {
        if (files == null || files.trim().isEmpty()) {
            return;
        }
        this.findex = -1;
        this.fstatus = null;
        if (this.reader != null) {
            this.closeFile();
        }
        String[] paths = files.split(",");
        this.conf = new Configuration();
        this.conf.setClassLoader(Configuration.class.getClassLoader());
        this.conf.set("fs.file.impl", "org.apache.hadoop.fs.LocalFileSystem");
        this.conf.set("fs.hdfs.impl", "org.apache.hadoop.hdfs.DistributedFileSystem");
        this.conf.set("hadoop.security.group.mapping", "org.apache.hadoop.security.JniBasedUnixGroupsMappingWithFallback");
        this.fs = FileSystem.get((URI)URI.create(paths[0]), (Configuration)this.conf);
        this.addInputPaths(paths);
        if (this.fstatus != null) {
            this.findex = 0;
        }
        if (this.findex >= 0) {
            this.reader = new SequenceFile.Reader(this.fs, this.fstatus[this.findex].getPath(), this.conf);
            this.key = (Writable)ReflectionUtils.newInstance((Class)this.reader.getKeyClass(), (Configuration)this.conf);
            this.value = (Writable)ReflectionUtils.newInstance((Class)this.reader.getValueClass(), (Configuration)this.conf);
            this.fileSize = this.fstatus[this.findex].getLen();
            this.currentFile = this.fstatus[this.findex].getPath().toUri().toString();
        }
    }

    public boolean hasData() throws Exception {
        boolean ret = false;
        if (this.reader != null) {
            try {
                this.position = this.reader.getPosition();
                ret = this.reader.next(this.key, this.value);
            }
            catch (Exception e) {
                this.closeFile();
                throw e;
            }
            finally {
                if (!ret) {
                    this.closeFile();
                }
            }
        }
        return ret;
    }

    public boolean hasFile() throws Exception {
        if (this.findex >= 0 && this.findex < this.fstatus.length - 1) {
            ++this.findex;
            this.reader = new SequenceFile.Reader(this.fs, this.fstatus[this.findex].getPath(), this.conf);
            this.key = (Writable)ReflectionUtils.newInstance((Class)this.reader.getKeyClass(), (Configuration)this.conf);
            this.value = (Writable)ReflectionUtils.newInstance((Class)this.reader.getValueClass(), (Configuration)this.conf);
            this.fileSize = this.fstatus[this.findex].getLen();
            this.currentFile = this.fstatus[this.findex].getPath().toUri().toString();
        } else {
            this.findex = -1;
        }
        return this.findex > -1;
    }

    public Writable getKey() {
        return this.key;
    }

    public Writable getData() {
        return this.value;
    }

    public void closeFile() {
        if (this.reader != null) {
            IOUtils.closeStream((Closeable)this.reader);
            this.key = null;
            this.value = null;
            this.reader = null;
        }
    }

    public long getLength() {
        return this.fileSize;
    }

    public long getPosition() {
        return this.position;
    }

    public String getFilename() {
        return this.currentFile;
    }

    protected void finalize() {
        if (this.reader != null) {
            IOUtils.closeStream((Closeable)this.reader);
            this.reader = null;
        }
    }

    public void dispose() {
        if (this.reader != null) {
            IOUtils.closeStream((Closeable)this.reader);
            this.reader = null;
        }
    }

    private void addInputPaths(String[] paths) throws Exception {
        ArrayList<FileStatus> fileList = new ArrayList<FileStatus>();
        Path wd = this.fs.getWorkingDirectory();
        for (String str : paths) {
            Path path = new Path(wd, str);
            FileStatus[] flist = this.fs.globStatus(path);
            if (flist == null) continue;
            for (int i = 0; i < flist.length; ++i) {
                Path p = flist[i].getPath();
                if (flist[i].isDir()) {
                    FileStatus[] flist2 = this.fs.listStatus(p);
                    for (int j = 0; j < flist2.length; ++j) {
                        Path p2 = flist2[j].getPath();
                        if (flist2[j].isDir()) continue;
                        try {
                            SequenceFile.Reader tmpreader = new SequenceFile.Reader(this.fs, p2, this.conf);
                            fileList.add(flist2[j]);
                            continue;
                        }
                        catch (Exception e) {
                            if (e.getMessage().toLowerCase().contains("not a sequencefile")) continue;
                            throw e;
                        }
                    }
                    continue;
                }
                try {
                    SequenceFile.Reader tmpreader = new SequenceFile.Reader(this.fs, p, this.conf);
                    fileList.add(flist[i]);
                    continue;
                }
                catch (Exception e) {
                    if (e.getMessage().toLowerCase().contains("not a sequencefile")) continue;
                    throw e;
                }
            }
        }
        if (fileList.size() > 0) {
            this.fstatus = new FileStatus[fileList.size()];
            this.fstatus = fileList.toArray(this.fstatus);
        }
    }

    public void printFileList() {
        if (this.fstatus != null) {
            for (FileStatus it : this.fstatus) {
                System.out.println(it.getPath().toUri().toString());
            }
        }
    }
}

