/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.cmapeditor;

import com.mathworks.mwswing.SynchronousInvokeUtility;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import com.mathworks.page.cmapeditor.CMColorCell;
import com.mathworks.page.cmapeditor.CMColorMarker;
import com.mathworks.page.cmapeditor.CMED;
import com.mathworks.page.cmapeditor.CMEditModel;
import com.mathworks.page.cmapeditor.CMEditor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;

public class CMEditView
extends JComponent
implements Observer {
    private CMEditor editor;
    private Rectangle viewBounds = new Rectangle();
    MouseHandler mhandler;
    KeyHandler khandler;
    private boolean disposed = false;

    public boolean isDisposed() {
        return this.disposed;
    }

    void dispose() {
        this.disposed = true;
        this.removeListeners();
        this.getParent().remove(this);
        this.mhandler = null;
        this.khandler = null;
        this.editor = null;
    }

    public CMEditView(CMEditor cMEditor) {
        this.editor = cMEditor;
        Dimension dimension = new Dimension(64 * CMED.CELL_W + 2 * CMED.X0, CMED.CELL_H * 3);
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.mhandler = new MouseHandler();
        this.addMouseListener(this.mhandler);
        this.addMouseMotionListener(this.mhandler);
        this.khandler = new KeyHandler();
        this.addKeyListener(this.khandler);
    }

    private void removeListeners() {
        this.removeKeyListener(this.khandler);
        this.removeMouseListener(this.mhandler);
        this.removeMouseMotionListener(this.mhandler);
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object == null) {
            this.repaint();
        } else {
            Rectangle rectangle = (Rectangle)object;
            rectangle.setBounds(rectangle.x - 2, rectangle.y - 2, rectangle.width + 4, rectangle.height + 4);
            this.repaint(rectangle);
        }
    }

    public void updateViewSize(int n) {
        final Dimension dimension = new Dimension(n * CMED.CELL_W + 2 * CMED.X0, this.getHeight());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!CMEditView.this.isDisposed()) {
                    CMEditView.this.setPreferredSize(dimension);
                    CMEditView.this.setMinimumSize(dimension);
                    CMEditView.this.setSize(dimension);
                    CMEditView.this.scrollRectToVisible(new Rectangle(dimension));
                }
            }
        };
        SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)new SynchronousInvokeUtility.SynchronousEventAdapter(runnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void paint(Graphics graphics) {
        boolean bl;
        Object object;
        ListIterator listIterator;
        List list;
        List list2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(new Font("SansSerif", 0, 10));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        Color color = new Color(224, 224, 224);
        graphics2D.setPaint(color);
        this.viewBounds = this.getBounds(this.viewBounds);
        graphics2D.fillRect(this.viewBounds.x, this.viewBounds.y, this.getWidth() * 2, this.getHeight());
        if (this.editor.getModel().colorCellList != null) {
            list = list2 = this.editor.getModel().getColorCellList();
            synchronized (list) {
                listIterator = list2.listIterator();
                while (listIterator.hasNext()) {
                    try {
                        object = (CMColorCell)listIterator.next();
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        return;
                    }
                    graphics2D.setPaint(((CMColorCell)object).getColor());
                    graphics2D.fill(((CMColorCell)object).getShape());
                    graphics2D.setPaint(Color.black);
                    bl = ((CMColorCell)object).isSelected();
                    if (!bl) {
                        graphics2D.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f));
                    } else {
                        graphics2D.setStroke(new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{1.0f, 1.0f}, 0.0f));
                    }
                    graphics2D.draw(((CMColorCell)object).getShape());
                }
            }
        }
        if (this.editor.getModel().colorMarkerList != null) {
            list = list2 = this.editor.getModel().getColorMarkerList();
            synchronized (list) {
                listIterator = list2.listIterator();
                while (listIterator.hasNext()) {
                    object = (CMColorMarker)listIterator.next();
                    if (object == null) continue;
                    graphics2D.setPaint(((CMColorMarker)object).getColor());
                    graphics2D.fill(((CMColorMarker)object).getShape());
                    graphics2D.setPaint(Color.black);
                    bl = ((CMColorMarker)object).isSelected();
                    if (!bl) {
                        graphics2D.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f));
                    } else {
                        graphics2D.setStroke(new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{2.0f, 1.0f}, 0.0f));
                    }
                    graphics2D.draw(((CMColorMarker)object).getShape());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDatatipPoint(Point point) {
        double d = CMED.X0;
        double d2 = CMED.CCELL_Y;
        double d3 = CMED.CELL_W;
        double d4 = CMED.CELL_H;
        double d5 = point.getX();
        double d6 = point.getY();
        if (d6 >= d2 - 2.0 * d4 && d6 <= d2 + 2.0 * d4 && d5 >= d && d5 <= d + d3 * (double)this.editor.getModel().ccSize) {
            List list;
            double d7 = Math.floor((d5 - d) / d3);
            boolean bl = false;
            List list2 = list = this.editor.getModel().getColorCellList();
            synchronized (list2) {
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext() && !bl) {
                    CMColorCell cMColorCell = (CMColorCell)listIterator.next();
                    if (cMColorCell.getIndex() != (int)d7) continue;
                    double[][] dArray = new double[2][3];
                    float[] fArray = new float[4];
                    double[][] dArray2 = new double[2][3];
                    bl = true;
                    Color color = cMColorCell.getColor();
                    fArray = color.getComponents(fArray);
                    for (int i = 0; i < 3; ++i) {
                        dArray[0][i] = fArray[i];
                    }
                    double d8 = this.editor.getModel().getCDataAtColormapIndex((int)Math.floor(d7));
                    dArray2 = CMEditModel.cmedRGB2HSV(dArray, dArray2);
                    int n = (int)(dArray2[0][0] * 1000.0);
                    int n2 = (int)(dArray2[0][1] * 1000.0);
                    int n3 = (int)(dArray2[0][2] * 1000.0);
                    float f = (float)n / 1000.0f;
                    float f2 = (float)n2 / 1000.0f;
                    float f3 = (float)n3 / 1000.0f;
                    int n4 = (int)(dArray[0][0] * 1000.0);
                    int n5 = (int)(dArray[0][1] * 1000.0);
                    int n6 = (int)(dArray[0][2] * 1000.0);
                    float f4 = (float)n4 / 1000.0f;
                    float f5 = (float)n5 / 1000.0f;
                    float f6 = (float)n6 / 1000.0f;
                    this.editor.getFrame().setFeedbackText((int)(d7 + 1.0), d8, f4, f5, f6, f, f2, f3);
                }
            }
            if (!bl) {
                this.editor.getFrame().setFeedbackTextBlank();
            }
        } else {
            List list;
            List list3 = list = this.editor.getModel().getColorMarkerList();
            synchronized (list3) {
                ListIterator listIterator = list.listIterator();
                boolean bl = false;
                while (listIterator.hasNext()) {
                    CMColorMarker cMColorMarker = (CMColorMarker)listIterator.next();
                    if (!cMColorMarker.getShape().contains(point)) continue;
                    double[][] dArray = new double[2][3];
                    float[] fArray = new float[4];
                    double[][] dArray3 = new double[2][3];
                    bl = true;
                    Color color = cMColorMarker.getColor();
                    int n = cMColorMarker.getCellindex();
                    fArray = color.getComponents(fArray);
                    for (int i = 0; i < 3; ++i) {
                        dArray[0][i] = fArray[i];
                    }
                    double d9 = this.editor.getModel().getCDataAtColormapIndex(n);
                    dArray3 = CMEditModel.cmedRGB2HSV(dArray, dArray3);
                    int n7 = (int)(dArray3[0][0] * 1000.0);
                    int n8 = (int)(dArray3[0][1] * 1000.0);
                    int n9 = (int)(dArray3[0][2] * 1000.0);
                    float f = (float)n7 / 1000.0f;
                    float f7 = (float)n8 / 1000.0f;
                    float f8 = (float)n9 / 1000.0f;
                    int n10 = (int)(dArray[0][0] * 1000.0);
                    int n11 = (int)(dArray[0][1] * 1000.0);
                    int n12 = (int)(dArray[0][2] * 1000.0);
                    float f9 = (float)n10 / 1000.0f;
                    float f10 = (float)n11 / 1000.0f;
                    float f11 = (float)n12 / 1000.0f;
                    this.editor.getFrame().setFeedbackText(n + 1, d9, f9, f10, f11, f, f7, f8);
                }
                if (!bl) {
                    this.editor.getFrame().setFeedbackTextBlank();
                }
            }
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            List list = CMEditView.this.editor.getModel().getColorMarkerList();
            switch (n) {
                case 127: {
                    CMEditView.this.editor.getModel().deleteSelectedMarkers();
                    break;
                }
                case 37: {
                    int n2;
                    CMColorMarker cMColorMarker;
                    ListIterator listIterator;
                    boolean bl = true;
                    int n3 = 0;
                    List list2 = list;
                    synchronized (list2) {
                        listIterator = list.listIterator();
                        while (listIterator.hasNext() & bl) {
                            cMColorMarker = (CMColorMarker)listIterator.next();
                            if (cMColorMarker.isSelected()) {
                                if (listIterator.hasNext() && n3 > 0) {
                                    listIterator.previous();
                                    CMColorMarker cMColorMarker2 = (CMColorMarker)listIterator.previous();
                                    int n4 = cMColorMarker2.getCellindex();
                                    n2 = cMColorMarker.getCellindex();
                                    if (n2 == n4 + 1 && !cMColorMarker2.isSelected()) {
                                        bl = false;
                                    }
                                    listIterator.next();
                                    listIterator.next();
                                } else {
                                    bl = false;
                                }
                            }
                            ++n3;
                        }
                    }
                    if (!bl) break;
                    list2 = list;
                    synchronized (list2) {
                        listIterator = list.listIterator();
                        while (listIterator.hasNext()) {
                            cMColorMarker = (CMColorMarker)listIterator.next();
                            if (!cMColorMarker.isSelected()) continue;
                            n2 = cMColorMarker.getCellindex() - 1;
                            CMEditView.this.editor.getModel().setColorMarkerCellindex(cMColorMarker, n2);
                        }
                    }
                    CMEditView.this.editor.getModel().recalcCells();
                    break;
                }
                case 39: {
                    int n5;
                    CMColorMarker cMColorMarker;
                    ListIterator listIterator;
                    boolean bl = true;
                    int n6 = 0;
                    List list3 = list;
                    synchronized (list3) {
                        listIterator = list.listIterator();
                        while (listIterator.hasNext() & bl) {
                            cMColorMarker = (CMColorMarker)listIterator.next();
                            if (cMColorMarker.isSelected()) {
                                if (listIterator.hasNext() && n6 > 0) {
                                    CMColorMarker cMColorMarker3 = (CMColorMarker)listIterator.next();
                                    int n7 = cMColorMarker3.getCellindex();
                                    n5 = cMColorMarker.getCellindex();
                                    if (n5 == n7 - 1 && !cMColorMarker3.isSelected()) {
                                        bl = false;
                                    }
                                    listIterator.previous();
                                } else {
                                    bl = false;
                                }
                            }
                            ++n6;
                        }
                    }
                    if (!bl) break;
                    list3 = list;
                    synchronized (list3) {
                        listIterator = list.listIterator();
                        while (listIterator.hasNext()) {
                            cMColorMarker = (CMColorMarker)listIterator.next();
                            if (!cMColorMarker.isSelected()) continue;
                            n5 = cMColorMarker.getCellindex() + 1;
                            CMEditView.this.editor.getModel().setColorMarkerCellindex(cMColorMarker, n5);
                        }
                    }
                    CMEditView.this.editor.getModel().recalcCells();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    class MouseHandler
    extends MouseInputAdapter {
        private Point start;
        private Point last;
        private Graphics2D g2;

        MouseHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            CMEditView.this.requestFocus();
            int n = mouseEvent.getModifiers();
            if ((n & 0x10) != 0) {
                List list;
                if ((n & 1) != 0) {
                    List list2;
                    this.start = mouseEvent.getPoint();
                    CMEditView.this.editor.getView().processDatatipPoint(this.start);
                    List list3 = list2 = CMEditView.this.editor.getModel().getColorMarkerList();
                    synchronized (list3) {
                        ListIterator listIterator = list2.listIterator();
                        while (listIterator.hasNext()) {
                            CMColorMarker cMColorMarker = (CMColorMarker)listIterator.next();
                            if (!cMColorMarker.getShape().contains(this.start)) continue;
                            this.g2 = (Graphics2D)CMEditView.this.getGraphics();
                            this.g2.setPaintMode();
                            CMEditView.this.editor.getModel().setColorMarkerSelected(cMColorMarker, true);
                            CMColorMarker cMColorMarker2 = CMEditView.this.editor.getModel().getSelectedColorMarker();
                            if (cMColorMarker2 != null) {
                                int n2 = cMColorMarker.getCellindex();
                                int n3 = cMColorMarker2.getCellindex();
                                ListIterator listIterator2 = list2.listIterator();
                                while (listIterator2.hasNext()) {
                                    CMColorMarker cMColorMarker3;
                                    int n4;
                                    if (!(n2 > n3 & (n4 = (cMColorMarker3 = (CMColorMarker)listIterator2.next()).getCellindex()) < n2 & n4 > n3) && !(n3 > n2 & n4 < n3 & n4 > n2)) continue;
                                    CMEditView.this.editor.getModel().setColorMarkerSelected(cMColorMarker3, true);
                                }
                            }
                            CMEditView.this.editor.getModel().setSelectedColorMarker(cMColorMarker);
                            this.g2.dispose();
                            this.g2 = null;
                        }
                    }
                }
                if ((n & KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK) != 0) {
                    List list4;
                    this.start = mouseEvent.getPoint();
                    CMEditView.this.editor.getView().processDatatipPoint(this.start);
                    List list5 = list4 = CMEditView.this.editor.getModel().getColorMarkerList();
                    synchronized (list5) {
                        ListIterator listIterator = list4.listIterator();
                        while (listIterator.hasNext()) {
                            CMColorMarker cMColorMarker = (CMColorMarker)listIterator.next();
                            if (!cMColorMarker.getShape().contains(this.start)) continue;
                            this.g2 = (Graphics2D)CMEditView.this.getGraphics();
                            this.g2.setPaintMode();
                            CMEditView.this.editor.getModel().setColorMarkerSelected(cMColorMarker, true);
                            CMEditView.this.editor.getModel().setSelectedColorMarker(cMColorMarker);
                            this.g2.dispose();
                            this.g2 = null;
                        }
                    }
                }
                this.start = mouseEvent.getPoint();
                CMEditView.this.editor.getView().processDatatipPoint(this.start);
                List list6 = list = CMEditView.this.editor.getModel().getColorMarkerList();
                synchronized (list6) {
                    ListIterator listIterator = list.listIterator();
                    boolean bl = false;
                    CMEditView.this.editor.getModel().setSelectedColorMarker(null);
                    while (listIterator.hasNext()) {
                        CMColorMarker cMColorMarker = (CMColorMarker)listIterator.next();
                        if (cMColorMarker.getShape().contains(this.start)) {
                            bl = true;
                            this.g2 = (Graphics2D)CMEditView.this.getGraphics();
                            this.g2.setPaintMode();
                            CMEditView.this.editor.getModel().setColorMarkerSelected(cMColorMarker, true);
                            CMEditView.this.editor.getModel().setSelectedColorMarker(cMColorMarker);
                            this.g2.dispose();
                            this.g2 = null;
                            continue;
                        }
                        if (!cMColorMarker.isSelected()) continue;
                        this.g2 = (Graphics2D)CMEditView.this.getGraphics();
                        this.g2.setPaintMode();
                        CMEditView.this.editor.getModel().setColorMarkerSelected(cMColorMarker, false);
                        this.g2.dispose();
                        this.g2 = null;
                    }
                    if (!bl && this.start.x > CMED.X0 + CMED.CELL_W && this.start.x < CMED.X0 + (CMEditView.this.editor.getModel().getColorCellListSize() - 1) * CMED.CELL_W && this.start.y >= CMED.CMKR_Y && this.start.y <= CMED.CMKR_Y + CMED.MKR_H + 5) {
                        List list7;
                        int n5 = 0;
                        boolean bl2 = false;
                        int n6 = (this.start.x - CMED.X0) / CMED.CELL_W;
                        listIterator = list.listIterator();
                        List list8 = list7 = CMEditView.this.editor.getModel().getColorMarkerList();
                        synchronized (list8) {
                            while (listIterator.hasNext() && !bl2) {
                                CMColorMarker cMColorMarker = (CMColorMarker)listIterator.next();
                                int n7 = cMColorMarker.getCellindex();
                                if (n7 > n6) {
                                    CMColorCell cMColorCell = (CMColorCell)((CMEditView)CMEditView.this).editor.getModel().colorCellList.get(n6);
                                    Color color = cMColorCell.getColor();
                                    int n8 = CMED.X0 + n6 * CMED.CELL_W;
                                    int n9 = CMED.CMKR_Y;
                                    CMColorMarker cMColorMarker4 = new CMColorMarker(false, n8, n9, n6, color);
                                    CMEditView.this.editor.getModel().addColorMarker(n5, cMColorMarker4);
                                    CMEditView.this.editor.getModel().setColorMarkerSelected(cMColorMarker4, true);
                                    CMEditView.this.editor.getModel().setSelectedColorMarker(cMColorMarker4);
                                    bl2 = true;
                                }
                                ++n5;
                            }
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getModifiers();
            if ((n & 0x10) != 0) {
                List list;
                this.last = mouseEvent.getPoint();
                CMEditView.this.editor.getView().processDatatipPoint(this.last);
                CMColorMarker cMColorMarker = null;
                CMColorMarker cMColorMarker2 = null;
                int n2 = 0;
                boolean bl = false;
                List list2 = list = CMEditView.this.editor.getModel().getColorMarkerList();
                synchronized (list2) {
                    ListIterator listIterator = list.listIterator();
                    while (listIterator.hasNext() && !bl) {
                        if (n2 > 0) {
                            cMColorMarker = new CMColorMarker(cMColorMarker2);
                        }
                        if ((cMColorMarker2 = (CMColorMarker)listIterator.next()).isSelected() && n2 > 0 && listIterator.hasNext()) {
                            CMColorMarker cMColorMarker3 = (CMColorMarker)listIterator.next();
                            int n3 = cMColorMarker == null ? 0 : cMColorMarker.getCellindex();
                            int n4 = cMColorMarker3.getCellindex();
                            int n5 = (this.last.x - CMED.X0) / CMED.CELL_W;
                            if (n5 <= n3) {
                                n5 = n3 + 1;
                            } else if (n5 >= n4) {
                                n5 = n4 - 1;
                            }
                            int n6 = cMColorMarker2.getCellindex();
                            if (n5 != n6) {
                                this.g2 = (Graphics2D)CMEditView.this.getGraphics();
                                this.g2.setXORMode(CMEditView.this.getBackground());
                                CMEditView.this.editor.getModel().setColorMarkerCellindex(cMColorMarker2, n5);
                                this.g2.setPaintMode();
                                CMEditView.this.editor.getModel().updateColorCellsBetweenMarkers(cMColorMarker, cMColorMarker2, false);
                                CMEditView.this.editor.getModel().updateColorCellsBetweenMarkers(cMColorMarker2, cMColorMarker3, true);
                                this.g2.dispose();
                                this.g2 = null;
                                bl = true;
                            }
                        }
                        ++n2;
                    }
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            CMEditView.this.editor.getView().processDatatipPoint(point);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            CMEditView.this.editor.getFrame().setFeedbackTextBlank();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            int n = mouseEvent.getModifiers();
            if ((n & 0x10) != 0) {
                if (this.g2 != null) {
                    this.g2.dispose();
                    this.g2 = null;
                }
                this.last = null;
                this.start = null;
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getClickCount();
            int n2 = mouseEvent.getModifiers();
            if (n >= 2 && (n2 & 0x10) != 0) {
                this.start = mouseEvent.getPoint();
                CMColorMarker cMColorMarker = CMEditView.this.editor.getModel().getSelectedColorMarker();
                int n3 = CMEditView.this.editor.getModel().getSelectedColorMarkerIndex();
                if (cMColorMarker != null && n3 >= 0 && cMColorMarker.getShape().contains(this.start)) {
                    CMEditView.this.editor.getModel().chooseSelectedMarkerColor();
                }
            }
        }
    }
}

