/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.cmapeditor;

import com.mathworks.mwswing.SynchronousInvokeUtility;
import com.mathworks.page.cmapeditor.CMEditFrame;
import com.mathworks.page.cmapeditor.CMEditModel;
import com.mathworks.page.cmapeditor.CMEditView;
import com.mathworks.page.cmapeditor.MLQue;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class CMEditor {
    private CMEditModel model;
    private CMEditView view;
    private MLQue mlq;
    private Object figure;
    private Object currentObject;
    private CMEditFrame win;
    private JScrollPane spane;
    private boolean autoUpdate = true;
    private volatile boolean fHGUsingMATLABClasses = false;
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.page.cmapeditor.resources.RES_CMEdit");
    private boolean disposed = false;

    public static void main(String[] stringArray) {
        CMEditor cMEditor = new CMEditor();
        cMEditor.init();
        cMEditor.setVisible();
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    void dispose() {
        this.disposed = true;
        this.win.dispose();
        this.win = null;
        this.spane.remove(this.view);
        this.spane = null;
        this.view.dispose();
        this.view = null;
        this.model.dispose();
        this.model = null;
        this.mlq = null;
    }

    public void init() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!CMEditor.this.isDisposed()) {
                    CMEditor.this.doInit();
                }
            }
        };
        SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)new SynchronousInvokeUtility.SynchronousEventAdapter(runnable));
    }

    private void doInit() {
        this.win = new CMEditFrame(sRes.getString("cmedit.cmapeditor"), this);
        this.win.setName("cmedit.cmapeditor");
        this.model = new CMEditModel(this);
        this.view = new CMEditView(this);
        this.model.addObserver(this.view);
        this.mlq = new MLQue();
        this.spane = new JScrollPane(this.view);
        this.win.getContentPane().add((Component)this.spane, "Center");
        InputMap inputMap = this.spane.getInputMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(39, 0);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(37, 0);
        inputMap.remove(keyStroke);
        inputMap.remove(keyStroke2);
        this.spane.setInputMap(1, inputMap);
        this.spane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.win.focusOnOk();
        this.win.setMinimumSize();
        this.win.pack();
    }

    public Object getFigure() {
        return this.figure;
    }

    public void setFigure(Object object) {
        this.figure = object;
    }

    public Object getCurrentObject() {
        return this.currentObject;
    }

    public void setCurrentObject(Object object) {
        this.currentObject = object;
    }

    public void removeObject(Object object) {
        this.getModel().deleteCacheFor(object);
    }

    public boolean isHGUsingMATLABClasses() {
        return this.fHGUsingMATLABClasses;
    }

    public void setVisible() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!CMEditor.this.isDisposed()) {
                    CMEditor.this.win.setVisible(true);
                }
            }
        };
        SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)new SynchronousInvokeUtility.SynchronousEventAdapter(runnable));
    }

    public CMEditFrame getFrame() {
        return this.win;
    }

    public void setFrame(CMEditFrame cMEditFrame) {
        this.win = cMEditFrame;
    }

    public CMEditModel getModel() {
        return this.model;
    }

    public CMEditView getView() {
        return this.view;
    }

    public JScrollPane getScrollPane() {
        return this.spane;
    }

    public MLQue getMatlabQue() {
        return this.mlq;
    }

    public void setAutoUpdate(boolean bl) {
        this.autoUpdate = bl;
    }

    public boolean getAutoUpdate() {
        return this.autoUpdate;
    }

    public void close() {
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.isDisposed()) {
                this.win.setVisible(false);
                this.dispose();
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!CMEditor.this.isDisposed()) {
                        CMEditor.this.win.setVisible(false);
                        CMEditor.this.dispose();
                    }
                }
            });
        }
    }

    public void bringToFront() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.getFrame().requestFocus();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CMEditor.this.getFrame().requestFocus();
                }
            });
        }
    }

    public void printstring(String string) {
        System.out.println(string);
    }

    public void setCurrentItemLabel(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.getFrame().setCurrentItemLabel(string);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CMEditor.this.getFrame().setCurrentItemLabel(string);
                }
            });
        }
    }

    public String getCurrentItemLabel() {
        return this.getFrame().getCurrentItemLabel();
    }

    public void enableResetAxes(final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.getFrame().enableResetAxes(bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CMEditor.this.getFrame().enableResetAxes(bl);
                }
            });
        }
    }

    public void setHGUsingMATLABClasses(boolean bl) {
        this.fHGUsingMATLABClasses = bl;
    }
}

