/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool.plotbrowser;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.page.plottool.PlotBrowser;
import com.mathworks.page.plottool.plotbrowser.ChartObjectProxyFactory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.WritableRaster;

public class LegendIcon
extends MJPanel {
    public static int ICON_WIDTH = 20;
    private static int ICON_HEIGHT = 16;
    private Image fMarkerPlus;
    private Image fMarkerCircle;
    private Image fMarkerAsterisk;
    private Image fMarkerPoint;
    private Image fMarkerX;
    private Image fMarkerSquare;
    private Image fMarkerDiamond;
    private Image fMarkerTriangle;
    private Image fMarkerPyramid;
    private Image fMarkerRight;
    private Image fMarkerLeft;
    private Image fMarkerPentoid;
    private Image fMarkerHexoid;
    public ChartObjectProxyFactory.SeriesProxy fSeriesProxy;
    public Image fMarkerImg = null;
    private static final float[] DOTTED_LINE_DASH_PATTERN = new float[]{1.0f, 3.0f};
    private static final float[] DASHED_LINE_DASH_PATTERN = new float[]{8.0f, 4.0f};
    private static final float[] DASHDOT_LINE_DASH_PATTERN = new float[]{6.0f, 4.0f, 1.0f, 4.0f};

    public LegendIcon(PlotBrowser plotBrowser) {
        this.init();
    }

    public LegendIcon() {
        this.init();
    }

    private void init() {
        this.setPreferredSize(new Dimension(ICON_WIDTH, ICON_HEIGHT));
        this.setOpaque(false);
        this.fMarkerPlus = PlotBrowser.createMarkerImage("marker-plus.gif");
        this.fMarkerCircle = PlotBrowser.createMarkerImage("marker-circle.gif");
        this.fMarkerAsterisk = PlotBrowser.createMarkerImage("marker-asterisk.gif");
        this.fMarkerPoint = PlotBrowser.createMarkerImage("marker-point.gif");
        this.fMarkerX = PlotBrowser.createMarkerImage("marker-x.gif");
        this.fMarkerSquare = PlotBrowser.createMarkerImage("marker-square.gif");
        this.fMarkerDiamond = PlotBrowser.createMarkerImage("marker-diamond.gif");
        this.fMarkerTriangle = PlotBrowser.createMarkerImage("marker-triangle.gif");
        this.fMarkerPyramid = PlotBrowser.createMarkerImage("marker-pyramid.gif");
        this.fMarkerRight = PlotBrowser.createMarkerImage("marker-right.gif");
        this.fMarkerLeft = PlotBrowser.createMarkerImage("marker-left.gif");
        this.fMarkerPentoid = PlotBrowser.createMarkerImage("marker-pentoid.gif");
        this.fMarkerHexoid = PlotBrowser.createMarkerImage("marker-hexoid.gif");
    }

    public void setSeriesProxy(ChartObjectProxyFactory.SeriesProxy seriesProxy) {
        this.fSeriesProxy = seriesProxy;
        this.updateFromProxy();
    }

    public void updateFromProxy() {
        if (this.fSeriesProxy instanceof ChartObjectProxyFactory.OneDimSeriesProxy) {
            ChartObjectProxyFactory.OneDimSeriesProxy oneDimSeriesProxy = (ChartObjectProxyFactory.OneDimSeriesProxy)this.fSeriesProxy;
            Object object = oneDimSeriesProxy.getMarker();
            if (object instanceof String) {
                switch ((String)object) {
                    case "+": {
                        this.fMarkerImg = this.fMarkerPlus;
                        break;
                    }
                    case "o": {
                        this.fMarkerImg = this.fMarkerCircle;
                        break;
                    }
                    case "*": {
                        this.fMarkerImg = this.fMarkerAsterisk;
                        break;
                    }
                    case ".": {
                        this.fMarkerImg = this.fMarkerPoint;
                        break;
                    }
                    case "x": {
                        this.fMarkerImg = this.fMarkerX;
                        break;
                    }
                    case "square": {
                        this.fMarkerImg = this.fMarkerSquare;
                        break;
                    }
                    case "diamond": {
                        this.fMarkerImg = this.fMarkerDiamond;
                        break;
                    }
                    case "v": {
                        this.fMarkerImg = this.fMarkerTriangle;
                        break;
                    }
                    case "^": {
                        this.fMarkerImg = this.fMarkerPyramid;
                        break;
                    }
                    case ">": {
                        this.fMarkerImg = this.fMarkerRight;
                        break;
                    }
                    case "<": {
                        this.fMarkerImg = this.fMarkerLeft;
                        break;
                    }
                    case "pentagram": {
                        this.fMarkerImg = this.fMarkerPentoid;
                        break;
                    }
                    case "hexagram": {
                        this.fMarkerImg = this.fMarkerHexoid;
                        break;
                    }
                }
            } else {
                switch ((Integer)object) {
                    case 0: {
                        this.fMarkerImg = this.fMarkerPlus;
                        break;
                    }
                    case 1: {
                        this.fMarkerImg = this.fMarkerCircle;
                        break;
                    }
                    case 2: {
                        this.fMarkerImg = this.fMarkerAsterisk;
                        break;
                    }
                    case 3: {
                        this.fMarkerImg = this.fMarkerPoint;
                        break;
                    }
                    case 4: {
                        this.fMarkerImg = this.fMarkerX;
                        break;
                    }
                    case 5: {
                        this.fMarkerImg = this.fMarkerSquare;
                        break;
                    }
                    case 6: {
                        this.fMarkerImg = this.fMarkerDiamond;
                        break;
                    }
                    case 7: {
                        this.fMarkerImg = this.fMarkerTriangle;
                        break;
                    }
                    case 8: {
                        this.fMarkerImg = this.fMarkerPyramid;
                        break;
                    }
                    case 9: {
                        this.fMarkerImg = this.fMarkerRight;
                        break;
                    }
                    case 10: {
                        this.fMarkerImg = this.fMarkerLeft;
                        break;
                    }
                    case 11: {
                        this.fMarkerImg = this.fMarkerPentoid;
                        break;
                    }
                    case 12: {
                        this.fMarkerImg = this.fMarkerHexoid;
                        break;
                    }
                    default: {
                        this.fMarkerImg = null;
                    }
                }
            }
            if (this.fMarkerImg == null) {
                return;
            }
            Object object2 = oneDimSeriesProxy.getMarkerFaceColor();
            Color color = oneDimSeriesProxy.getMarkerEdgeColor();
            if (Color.white.equals(color) && Color.white.equals(object2)) {
                color = Color.black;
            }
            int n = this.fMarkerImg.getHeight((ImageObserver)((Object)this));
            int n2 = this.fMarkerImg.getWidth((ImageObserver)((Object)this));
            BufferedImage bufferedImage = new BufferedImage(n2, n, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(this.fMarkerImg, 0, 0, (ImageObserver)((Object)this));
            WritableRaster writableRaster = bufferedImage.getRaster();
            int[] nArray = new int[4];
            int[] nArray2 = new int[4];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    writableRaster.getPixel(i, j, nArray);
                    if (nArray[3] == 0) continue;
                    if (nArray[0] == 0 && nArray[1] == 0 && nArray[2] == 0) {
                        if (color == null) {
                            nArray2[3] = 0;
                        } else {
                            nArray2[0] = color.getRed();
                            nArray2[1] = color.getGreen();
                            nArray2[2] = color.getBlue();
                            nArray2[3] = 255;
                        }
                    } else if (nArray[0] == 255 && nArray[1] == 255 && nArray[2] == 255) {
                        if (object2 == null) {
                            nArray2[3] = 0;
                        } else {
                            nArray2[0] = ((Color)object2).getRed();
                            nArray2[1] = ((Color)object2).getGreen();
                            nArray2[2] = ((Color)object2).getBlue();
                            nArray2[3] = 255;
                        }
                    }
                    writableRaster.setPixel(i, j, nArray2);
                }
            }
            this.fMarkerImg = bufferedImage;
        }
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.fSeriesProxy instanceof ChartObjectProxyFactory.BarAreaSeriesProxy) {
            this.delegatePaint(graphics2D, (ChartObjectProxyFactory.BarAreaSeriesProxy)this.fSeriesProxy);
        } else if (this.fSeriesProxy instanceof ChartObjectProxyFactory.ContourSeriesProxy) {
            this.delegatePaint(graphics2D, (ChartObjectProxyFactory.ContourSeriesProxy)this.fSeriesProxy);
        } else if (this.fSeriesProxy instanceof ChartObjectProxyFactory.QuiverSeriesProxy) {
            this.delegatePaint(graphics2D, (ChartObjectProxyFactory.QuiverSeriesProxy)this.fSeriesProxy);
        } else if (this.fSeriesProxy instanceof ChartObjectProxyFactory.PatchProxy) {
            this.delegatePaint(graphics2D, (ChartObjectProxyFactory.PatchProxy)this.fSeriesProxy);
        } else if (this.fSeriesProxy instanceof ChartObjectProxyFactory.SurfaceProxy) {
            this.delegatePaint(graphics2D, (ChartObjectProxyFactory.SurfaceProxy)this.fSeriesProxy);
        } else if (this.fSeriesProxy instanceof ChartObjectProxyFactory.ImageProxy) {
            this.delegatePaint(graphics2D, (ChartObjectProxyFactory.ImageProxy)this.fSeriesProxy);
        } else if (this.fSeriesProxy instanceof ChartObjectProxyFactory.OneDimSeriesProxy) {
            this.delegatePaint(graphics2D, (ChartObjectProxyFactory.OneDimSeriesProxy)this.fSeriesProxy);
        }
    }

    protected void delegatePaint(Graphics2D graphics2D, ChartObjectProxyFactory.BarAreaSeriesProxy barAreaSeriesProxy) {
        graphics2D.setPaint(SystemColor.text);
        graphics2D.drawRect(0, 3, ICON_WIDTH - 1, 9);
        Color color = barAreaSeriesProxy.getFaceColor();
        if (!barAreaSeriesProxy.getVisible().booleanValue()) {
            color = Color.white;
        }
        graphics2D.setPaint(color);
        graphics2D.fillRect(1, 4, ICON_WIDTH - 3, 7);
        graphics2D.setPaint(barAreaSeriesProxy.getEdgeColor());
        graphics2D.drawRect(1, 4, ICON_WIDTH - 3, 7);
    }

    protected void delegatePaint(Graphics2D graphics2D, ChartObjectProxyFactory.ContourSeriesProxy contourSeriesProxy) {
        graphics2D.setPaint(SystemColor.text);
        graphics2D.drawRect(1, 0, ICON_WIDTH - 3, ICON_HEIGHT - 3);
        graphics2D.setPaint(contourSeriesProxy.getOuterColor());
        graphics2D.drawRect(2, 1, ICON_WIDTH - 5, ICON_HEIGHT - 5);
        graphics2D.setPaint(contourSeriesProxy.getInnerColor());
        graphics2D.drawRect(6, 4, ICON_WIDTH - 13, ICON_HEIGHT - 11);
    }

    protected void delegatePaint(Graphics2D graphics2D, ChartObjectProxyFactory.QuiverSeriesProxy quiverSeriesProxy) {
        this.delegatePaint(graphics2D, (ChartObjectProxyFactory.OneDimSeriesProxy)quiverSeriesProxy);
        float f = Math.max((float)quiverSeriesProxy.getLineWidth(), 0.0f);
        graphics2D.setStroke(new BasicStroke(f));
        graphics2D.drawLine(ICON_WIDTH - 1, ICON_HEIGHT / 2, ICON_WIDTH - 6, ICON_HEIGHT / 2 - 3);
        graphics2D.drawLine(ICON_WIDTH - 1, ICON_HEIGHT / 2, ICON_WIDTH - 6, ICON_HEIGHT / 2 + 3);
    }

    protected void delegatePaint(Graphics2D graphics2D, ChartObjectProxyFactory.PatchProxy patchProxy) {
        graphics2D.setPaint(SystemColor.text);
        graphics2D.drawRect(0, 3, ICON_WIDTH - 1, 9);
        Color color = patchProxy.getFaceColor();
        if (!patchProxy.getVisible().booleanValue()) {
            color = Color.white;
        }
        Color color2 = patchProxy.getEdgeColor();
        if (Color.white.equals(color) && Color.white.equals(color2)) {
            color2 = Color.black;
        }
        graphics2D.setPaint(color);
        graphics2D.fillRect(1, 4, ICON_WIDTH - 3, 7);
        graphics2D.setPaint(color2);
        graphics2D.drawRect(1, 4, ICON_WIDTH - 3, 7);
    }

    protected void delegatePaint(Graphics2D graphics2D, ChartObjectProxyFactory.SurfaceProxy surfaceProxy) {
        int[] nArray = new int[]{2, 11, 20, 10};
        int[] nArray2 = new int[]{5, 1, 5, 10};
        Color color = surfaceProxy.getFaceColor();
        if (!surfaceProxy.getVisible().booleanValue()) {
            color = Color.white;
        }
        Color color2 = surfaceProxy.getEdgeColor();
        if (Color.white.equals(color) && Color.white.equals(color2)) {
            color2 = Color.black;
        }
        graphics2D.setColor(color);
        graphics2D.fillPolygon(nArray, nArray2, 4);
        graphics2D.setColor(color2);
        graphics2D.drawPolygon(nArray, nArray2, 4);
    }

    protected void delegatePaint(Graphics2D graphics2D, ChartObjectProxyFactory.ImageProxy imageProxy) {
        graphics2D.setPaint(SystemColor.text);
        graphics2D.drawRect(2, 2, ICON_WIDTH - 5, ICON_HEIGHT - 5);
        graphics2D.setPaint(Color.black);
        graphics2D.drawRect(3, 3, ICON_WIDTH - 7, ICON_HEIGHT - 7);
        int n = 2;
        int n2 = ICON_HEIGHT - 8;
        graphics2D.setPaint(imageProxy.getColor1());
        graphics2D.fillRect(4, 4, n, n2);
        graphics2D.setPaint(imageProxy.getColor2());
        graphics2D.fillRect(4 + n, 4, n, n2);
        graphics2D.setPaint(imageProxy.getColor3());
        graphics2D.fillRect(4 + 2 * n, 4, n, n2);
        graphics2D.setPaint(imageProxy.getColor4());
        graphics2D.fillRect(4 + 3 * n, 4, n, n2);
        graphics2D.setPaint(imageProxy.getColor5());
        graphics2D.fillRect(4 + 4 * n, 4, n, n2);
        graphics2D.setPaint(imageProxy.getColor6());
        graphics2D.fillRect(4 + 5 * n, 4, n, n2);
    }

    protected void delegatePaint(Graphics2D graphics2D, ChartObjectProxyFactory.OneDimSeriesProxy oneDimSeriesProxy) {
        graphics2D.setPaint(oneDimSeriesProxy.getLineColor());
        float f = Math.max((float)oneDimSeriesProxy.getLineWidth(), 0.0f);
        BasicStroke basicStroke = null;
        Object object = oneDimSeriesProxy.getLineStyle();
        if ("-".equals(object) || object.equals(0)) {
            basicStroke = new BasicStroke(f);
        } else {
            float[] fArray = LegendIcon.getLineStyleDashPattern(oneDimSeriesProxy, object);
            if (fArray != null) {
                basicStroke = new BasicStroke(f, 0, 2, 1.0f, fArray, 0.0f);
            }
        }
        if (basicStroke != null) {
            graphics2D.setStroke(basicStroke);
            int n = oneDimSeriesProxy instanceof ChartObjectProxyFactory.StemSeriesProxy && this.fMarkerImg != null ? ICON_WIDTH - this.fMarkerImg.getWidth((ImageObserver)((Object)this)) / 2 - 2 : ICON_WIDTH;
            graphics2D.drawLine(0, ICON_HEIGHT / 2, n, ICON_HEIGHT / 2);
        }
        if (!oneDimSeriesProxy.getMarker().equals(13)) {
            if (oneDimSeriesProxy instanceof ChartObjectProxyFactory.StemSeriesProxy) {
                this.paintMarkerEnd(graphics2D);
            } else {
                this.paintMarkerCenter(graphics2D);
            }
        }
    }

    private static float[] getLineStyleDashPattern(ChartObjectProxyFactory.OneDimSeriesProxy oneDimSeriesProxy, Object object) {
        float[] fArray = null;
        if (object instanceof String) {
            switch ((String)oneDimSeriesProxy.getLineStyle()) {
                case ":": {
                    fArray = DOTTED_LINE_DASH_PATTERN;
                    break;
                }
                case "--": {
                    fArray = DASHED_LINE_DASH_PATTERN;
                    break;
                }
                case "-.": {
                    fArray = DASHDOT_LINE_DASH_PATTERN;
                }
            }
        } else {
            switch ((Integer)object) {
                case 2: {
                    fArray = DOTTED_LINE_DASH_PATTERN;
                    break;
                }
                case 1: {
                    fArray = DASHED_LINE_DASH_PATTERN;
                    break;
                }
                case 3: {
                    fArray = DASHDOT_LINE_DASH_PATTERN;
                }
            }
        }
        return fArray;
    }

    protected void paintMarkerEnd(Graphics2D graphics2D) {
        if (this.fMarkerImg == null) {
            return;
        }
        graphics2D.drawImage(this.fMarkerImg, ICON_WIDTH - this.fMarkerImg.getWidth((ImageObserver)((Object)this)), ICON_HEIGHT / 2 - this.fMarkerImg.getHeight((ImageObserver)((Object)this)) / 2, (ImageObserver)((Object)this));
    }

    protected void paintMarkerCenter(Graphics2D graphics2D) {
        if (this.fMarkerImg == null) {
            return;
        }
        graphics2D.drawImage(this.fMarkerImg, ICON_WIDTH / 2 - this.fMarkerImg.getWidth((ImageObserver)((Object)this)) / 2, ICON_HEIGHT / 2 - this.fMarkerImg.getHeight((ImageObserver)((Object)this)) / 2, (ImageObserver)((Object)this));
    }
}

