/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.io.IOException;
import java.util.Map;
import javax.xml.transform.Source;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageLoader;
import org.apache.xmlgraphics.image.loader.impl.ImageLoaderFactoryRaw;
import org.apache.xmlgraphics.image.loader.impl.ImageRawStream;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;

public class ImageLoaderRaw
extends AbstractImageLoader {
    private String mime;
    private ImageFlavor targetFlavor;

    public ImageLoaderRaw(ImageFlavor imageFlavor) {
        this.targetFlavor = imageFlavor;
        this.mime = ImageLoaderFactoryRaw.getMimeForRawFlavor(imageFlavor);
    }

    public ImageFlavor getTargetFlavor() {
        return this.targetFlavor;
    }

    public Image loadImage(ImageInfo imageInfo, Map map, ImageSessionContext imageSessionContext) throws ImageException, IOException {
        if (!this.mime.equals(imageInfo.getMimeType())) {
            throw new IllegalArgumentException("ImageInfo must be from a image with MIME type: " + this.mime);
        }
        Source source = imageSessionContext.needSource(imageInfo.getOriginalURI());
        ImageRawStream imageRawStream = new ImageRawStream(imageInfo, this.getTargetFlavor(), ImageUtil.needInputStream(source));
        return imageRawStream;
    }
}

