/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps.dsc;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.ps.DSCConstants;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.dsc.DSCCommentFactory;
import org.apache.xmlgraphics.ps.dsc.DSCException;
import org.apache.xmlgraphics.ps.dsc.DSCFilter;
import org.apache.xmlgraphics.ps.dsc.DSCHandler;
import org.apache.xmlgraphics.ps.dsc.DSCListener;
import org.apache.xmlgraphics.ps.dsc.DSCParserConstants;
import org.apache.xmlgraphics.ps.dsc.FilteringEventListener;
import org.apache.xmlgraphics.ps.dsc.NestedDocumentHandler;
import org.apache.xmlgraphics.ps.dsc.events.DSCAtend;
import org.apache.xmlgraphics.ps.dsc.events.DSCComment;
import org.apache.xmlgraphics.ps.dsc.events.DSCEvent;
import org.apache.xmlgraphics.ps.dsc.events.DSCHeaderComment;
import org.apache.xmlgraphics.ps.dsc.events.PostScriptComment;
import org.apache.xmlgraphics.ps.dsc.events.PostScriptLine;
import org.apache.xmlgraphics.ps.dsc.events.UnparsedDSCComment;
import org.apache.xmlgraphics.ps.dsc.tools.DSCTools;

public class DSCParser
implements DSCParserConstants {
    private static final Log LOG = LogFactory.getLog(DSCParser.class);
    private InputStream in;
    private BufferedReader reader;
    private boolean eofFound = false;
    private boolean checkEOF = true;
    private DSCEvent currentEvent;
    private DSCEvent nextEvent;
    private DSCListener nestedDocumentHandler;
    private DSCListener filterListener;
    private List listeners;
    private boolean listenersDisabled = false;

    public DSCParser(InputStream inputStream) throws IOException, DSCException {
        this.in = inputStream.markSupported() ? inputStream : new BufferedInputStream(this.in);
        String string = "US-ASCII";
        try {
            this.reader = new BufferedReader(new InputStreamReader(this.in, string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Incompatible VM! " + unsupportedEncodingException.getMessage());
        }
        this.parseNext();
    }

    public InputStream getInputStream() {
        return this.in;
    }

    protected void warn(String string) {
        LOG.warn((Object)string);
    }

    protected String readLine() throws IOException, DSCException {
        String string = this.reader.readLine();
        this.checkLine(string);
        return string;
    }

    private void checkLine(String string) throws DSCException {
        if (string == null) {
            if (!this.eofFound) {
                throw new DSCException("%%EOF not found. File is not well-formed.");
            }
        } else if (string.length() > 255) {
            this.warn("Line longer than 255 characters. This file is not fully PostScript conforming.");
        }
    }

    private boolean isWhitespace(char c) {
        return c == ' ' || c == '\t';
    }

    private DSCComment parseDSCLine(String string) throws IOException, DSCException {
        String string2;
        int n = string.indexOf(58);
        String string3 = "";
        if (n > 0) {
            string2 = string.substring(2, n);
            int n2 = n + 1;
            if (n2 < string.length()) {
                if (this.isWhitespace(string.charAt(n2))) {
                    ++n2;
                }
                if ((string3 = string.substring(n2).trim()).equals(DSCConstants.ATEND.toString())) {
                    return new DSCAtend(string2);
                }
            }
            while (true) {
                this.reader.mark(512);
                String string4 = this.readLine();
                if (string4 == null || !string4.startsWith("%%+")) break;
                string3 = string3 + string4.substring(3);
            }
            this.reader.reset();
        } else {
            string2 = string.substring(2);
            string3 = null;
        }
        return this.parseDSCComment(string2, string3);
    }

    private DSCComment parseDSCComment(String string, String string2) {
        DSCComment dSCComment = DSCCommentFactory.createDSCCommentFor(string);
        if (dSCComment != null) {
            try {
                dSCComment.parseValue(string2);
                return dSCComment;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        UnparsedDSCComment unparsedDSCComment = new UnparsedDSCComment(string);
        unparsedDSCComment.parseValue(string2);
        return unparsedDSCComment;
    }

    public void parse(DSCHandler dSCHandler) throws IOException, DSCException {
        DSCHeaderComment dSCHeaderComment = DSCTools.checkAndSkipDSC30Header(this);
        dSCHandler.startDocument("%!" + dSCHeaderComment.getComment());
        block7: while (this.hasNext()) {
            DSCEvent dSCEvent = this.nextEvent();
            switch (dSCEvent.getEventType()) {
                case 0: {
                    dSCHandler.startDocument("%!" + ((DSCHeaderComment)dSCEvent).getComment());
                    continue block7;
                }
                case 1: {
                    dSCHandler.handleDSCComment(dSCEvent.asDSCComment());
                    continue block7;
                }
                case 2: {
                    dSCHandler.comment(((PostScriptComment)dSCEvent).getComment());
                    continue block7;
                }
                case 3: {
                    dSCHandler.line(this.getLine());
                    continue block7;
                }
                case 4: {
                    if (this.isCheckEOF()) {
                        this.eofFound = true;
                    }
                    dSCHandler.endDocument();
                    continue block7;
                }
            }
            throw new IllegalStateException("Illegal event type: " + dSCEvent.getEventType());
        }
    }

    public boolean hasNext() {
        return this.nextEvent != null;
    }

    public int next() throws IOException, DSCException {
        if (this.hasNext()) {
            this.currentEvent = this.nextEvent;
            this.parseNext();
            this.processListeners();
            return this.currentEvent.getEventType();
        }
        throw new NoSuchElementException("There are no more events");
    }

    private void processListeners() throws IOException, DSCException {
        if (this.isListenersDisabled()) {
            return;
        }
        if (this.filterListener != null) {
            this.filterListener.processEvent(this.currentEvent, this);
        }
        if (this.listeners != null) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((DSCListener)iterator.next()).processEvent(this.currentEvent, this);
            }
        }
    }

    public DSCEvent nextEvent() throws IOException, DSCException {
        this.next();
        return this.getCurrentEvent();
    }

    public DSCEvent getCurrentEvent() {
        return this.currentEvent;
    }

    public DSCEvent peek() {
        return this.nextEvent;
    }

    protected void parseNext() throws IOException, DSCException {
        String string = this.readLine();
        if (string != null) {
            if (this.eofFound && string.length() > 0) {
                throw new DSCException("Content found after EOF");
            }
            if (string.startsWith("%%")) {
                DSCComment dSCComment = this.parseDSCLine(string);
                if (dSCComment.getEventType() == 4 && this.isCheckEOF()) {
                    this.eofFound = true;
                }
                this.nextEvent = dSCComment;
            } else {
                this.nextEvent = string.startsWith("%!") ? new DSCHeaderComment(string.substring(2)) : (string.startsWith("%") ? new PostScriptComment(string.substring(1)) : new PostScriptLine(string));
            }
        } else {
            this.nextEvent = null;
        }
    }

    public String getLine() {
        if (this.currentEvent.getEventType() == 3) {
            return ((PostScriptLine)this.currentEvent).getLine();
        }
        throw new IllegalStateException("Current event is not a PostScript line");
    }

    public DSCComment nextDSCComment(String string) throws IOException, DSCException {
        return this.nextDSCComment(string, null);
    }

    public DSCComment nextDSCComment(String string, PSGenerator pSGenerator) throws IOException, DSCException {
        while (this.hasNext()) {
            DSCComment dSCComment;
            DSCEvent dSCEvent = this.nextEvent();
            if (dSCEvent.isDSCComment() && string.equals((dSCComment = dSCEvent.asDSCComment()).getName())) {
                return dSCComment;
            }
            if (pSGenerator == null) continue;
            dSCEvent.generate(pSGenerator);
        }
        return null;
    }

    public PostScriptComment nextPSComment(String string, PSGenerator pSGenerator) throws IOException, DSCException {
        while (this.hasNext()) {
            PostScriptComment postScriptComment;
            DSCEvent dSCEvent = this.nextEvent();
            if (dSCEvent.isComment() && (postScriptComment = (PostScriptComment)dSCEvent).getComment().startsWith(string)) {
                return postScriptComment;
            }
            if (pSGenerator == null) continue;
            dSCEvent.generate(pSGenerator);
        }
        return null;
    }

    public void setFilter(DSCFilter dSCFilter) {
        this.filterListener = dSCFilter != null ? new FilteringEventListener(dSCFilter) : null;
    }

    public void addListener(DSCListener dSCListener) {
        if (dSCListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(dSCListener);
    }

    public void removeListener(DSCListener dSCListener) {
        if (this.listeners != null) {
            this.listeners.remove(dSCListener);
        }
    }

    public void setListenersDisabled(boolean bl) {
        this.listenersDisabled = bl;
    }

    public boolean isListenersDisabled() {
        return this.listenersDisabled;
    }

    public void setNestedDocumentHandler(final NestedDocumentHandler nestedDocumentHandler) {
        if (nestedDocumentHandler == null) {
            this.removeListener(this.nestedDocumentHandler);
        } else {
            this.addListener(new DSCListener(){

                public void processEvent(DSCEvent dSCEvent, DSCParser dSCParser) throws IOException, DSCException {
                    nestedDocumentHandler.handle(dSCEvent, dSCParser);
                }
            });
        }
    }

    public void setCheckEOF(boolean bl) {
        this.checkEOF = bl;
    }

    public boolean isCheckEOF() {
        return this.checkEOF;
    }
}

